/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.checkin;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.api.storage.IRetryRequest;
import com.ibm.team.filesystem.client.internal.checkin.CheckinUploadHandler;
import com.ibm.team.filesystem.client.internal.checkin.DeletedPredecessorUploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.EncodingUploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.LineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.UploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.UploadHandler;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;

public class CheckinUploadData {
    private Map<UUID, Map<UUID, Long>> localContentSize = new HashMap<UUID, Map<UUID, Long>>();
    private Map<UUID, Map<UUID, ContentHash>> localHashCode = new HashMap<UUID, Map<UUID, ContentHash>>();
    private Map<UUID, Map<UUID, FileContent>> uploadContent = new HashMap<UUID, Map<UUID, FileContent>>();
    private Map<UUID, Map<UUID, String>> uploadContentType = new HashMap<UUID, Map<UUID, String>>();
    private Map<UUID, Map<UUID, IShareable>> uploadShareables = new HashMap<UUID, Map<UUID, IShareable>>();
    private List<UploadHandler> filesNeedingConversion = new ArrayList<UploadHandler>();
    private Map<UUID, Map<UUID, Long>> modTimes = new HashMap<UUID, Map<UUID, Long>>();
    private Map<UUID, List<LineDelimiterUploadFailure>> lineDelimiterFailures = new HashMap<UUID, List<LineDelimiterUploadFailure>>();
    private Map<UUID, List<EncodingUploadFailure>> encodingFailures = new HashMap<UUID, List<EncodingUploadFailure>>();
    private Map<UUID, List<DeletedPredecessorUploadFailure>> deletedPredecessorFailures = new HashMap<UUID, List<DeletedPredecessorUploadFailure>>();
    private Map<UUID, Map<UUID, UploadFailure>> uploadFailures = new HashMap<UUID, Map<UUID, UploadFailure>>();
    private Map<UUID, Map<UUID, UploadFailure>> skippedUploads = new HashMap<UUID, Map<UUID, UploadFailure>>();
    private LinkedList<RetryRequest> uploadsRequiringRetry = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUploadInfo(UploadHandler uploadHandler, Long localSizeForChangeTracking, ContentHash localHashCodeForChangeTracking, FileContent uploadedContent, String uploadedContentType, IShareable shareable, boolean needsConversion) {
        UUID componentId = uploadHandler.getComponent().getItemId();
        UUID itemId = uploadHandler.getVersionable().getItemId();
        Map<UUID, Map<UUID, Long>> map = this.localContentSize;
        synchronized (map) {
            Map<UUID, Long> localContentSizeByComponent = this.localContentSize.get(componentId);
            if (localContentSizeByComponent == null) {
                localContentSizeByComponent = new HashMap<UUID, Long>();
                this.localContentSize.put(componentId, localContentSizeByComponent);
            }
            localContentSizeByComponent.put(itemId, localSizeForChangeTracking);
            Map<UUID, ContentHash> localHashCodeByComponent = this.localHashCode.get(componentId);
            if (localHashCodeByComponent == null) {
                localHashCodeByComponent = new HashMap<UUID, ContentHash>();
                this.localHashCode.put(componentId, localHashCodeByComponent);
            }
            localHashCodeByComponent.put(itemId, localHashCodeForChangeTracking);
            Map<UUID, FileContent> uploadContentByComponent = this.uploadContent.get(componentId);
            if (uploadContentByComponent == null) {
                uploadContentByComponent = new HashMap<UUID, FileContent>();
                this.uploadContent.put(componentId, uploadContentByComponent);
            }
            uploadContentByComponent.put(itemId, uploadedContent);
            Map<UUID, String> uploadDeterminedContentTypeByComponent = this.uploadContentType.get(componentId);
            if (uploadDeterminedContentTypeByComponent == null) {
                uploadDeterminedContentTypeByComponent = new HashMap<UUID, String>();
                this.uploadContentType.put(componentId, uploadDeterminedContentTypeByComponent);
            }
            uploadDeterminedContentTypeByComponent.put(itemId, uploadedContentType);
            Map<UUID, IShareable> uploadShareableByComponent = this.uploadShareables.get(componentId);
            if (uploadShareableByComponent == null) {
                uploadShareableByComponent = new HashMap<UUID, IShareable>();
                this.uploadShareables.put(componentId, uploadShareableByComponent);
            }
            uploadShareableByComponent.put(itemId, shareable);
            if (needsConversion) {
                this.filesNeedingConversion.add(uploadHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModTime(IComponentHandle component, UUID itemId, Long modStamp) {
        Map<UUID, Map<UUID, Long>> map = this.modTimes;
        synchronized (map) {
            Map<UUID, Long> modTimesByComponent = this.modTimes.get(component.getItemId());
            if (modTimesByComponent == null) {
                modTimesByComponent = new HashMap<UUID, Long>();
                this.modTimes.put(component.getItemId(), modTimesByComponent);
            }
            modTimesByComponent.put(itemId, modStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConvertInfo(IComponentHandle component, UUID itemId, long size, ContentHash hashcode, long modificationStamp) {
        UUID componentId = component.getItemId();
        Map<UUID, Map<UUID, Long>> map = this.localContentSize;
        synchronized (map) {
            Map<UUID, Long> uploadContentSizeByComponent = this.localContentSize.get(componentId);
            if (uploadContentSizeByComponent == null) {
                uploadContentSizeByComponent = new HashMap<UUID, Long>();
                this.localContentSize.put(componentId, uploadContentSizeByComponent);
            }
            uploadContentSizeByComponent.put(itemId, size);
            Map<UUID, ContentHash> uploadHashCodeByComponent = this.localHashCode.get(componentId);
            if (uploadHashCodeByComponent == null) {
                uploadHashCodeByComponent = new HashMap<UUID, ContentHash>();
                this.localHashCode.put(componentId, uploadHashCodeByComponent);
            }
            uploadHashCodeByComponent.put(itemId, hashcode);
        }
        map = this.modTimes;
        synchronized (map) {
            Map<UUID, Long> modTimesByComponent = this.modTimes.get(componentId);
            if (modTimesByComponent == null) {
                modTimesByComponent = new HashMap<UUID, Long>();
                this.modTimes.put(componentId, modTimesByComponent);
            }
            modTimesByComponent.put(itemId, modificationStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineDelimiterFailure(LineDelimiterUploadFailure failedUpload) {
        UUID componentId = failedUpload.getUploadHandler().getComponent().getItemId();
        Map<UUID, List<LineDelimiterUploadFailure>> map = this.lineDelimiterFailures;
        synchronized (map) {
            List<LineDelimiterUploadFailure> lineDelimiterFailuresByComponent = this.lineDelimiterFailures.get(componentId);
            if (lineDelimiterFailuresByComponent == null) {
                lineDelimiterFailuresByComponent = new ArrayList<LineDelimiterUploadFailure>();
                this.lineDelimiterFailures.put(componentId, lineDelimiterFailuresByComponent);
            }
            lineDelimiterFailuresByComponent.add(failedUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodingUploadFailure(EncodingUploadFailure failedUpload) {
        UUID componentId = failedUpload.getUploadHandler().getComponent().getItemId();
        Map<UUID, List<EncodingUploadFailure>> map = this.encodingFailures;
        synchronized (map) {
            List<EncodingUploadFailure> encodingFailuresByComponent = this.encodingFailures.get(componentId);
            if (encodingFailuresByComponent == null) {
                encodingFailuresByComponent = new ArrayList<EncodingUploadFailure>();
                this.encodingFailures.put(componentId, encodingFailuresByComponent);
            }
            encodingFailuresByComponent.add(failedUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void predecessorDeletedFailure(DeletedPredecessorUploadFailure failedUpload) {
        UUID componentId = failedUpload.getUploadHandler().getComponent().getItemId();
        Map<UUID, List<DeletedPredecessorUploadFailure>> map = this.deletedPredecessorFailures;
        synchronized (map) {
            List<DeletedPredecessorUploadFailure> deletedPredecessorByComponent = this.deletedPredecessorFailures.get(componentId);
            if (deletedPredecessorByComponent == null) {
                deletedPredecessorByComponent = new ArrayList<DeletedPredecessorUploadFailure>();
                this.deletedPredecessorFailures.put(componentId, deletedPredecessorByComponent);
            }
            deletedPredecessorByComponent.add(failedUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFailure(UploadFailure failedUpload) {
        UUID componentId = failedUpload.getUploadHandler().getComponent().getItemId();
        UUID itemId = failedUpload.getUploadHandler().getVersionable().getItemId();
        Map<UUID, Map<UUID, UploadFailure>> map = this.uploadFailures;
        synchronized (map) {
            Map<UUID, UploadFailure> failuresByComponent = this.uploadFailures.get(componentId);
            if (failuresByComponent == null) {
                failuresByComponent = new HashMap<UUID, UploadFailure>();
                this.uploadFailures.put(componentId, failuresByComponent);
            }
            failuresByComponent.put(itemId, failedUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LineDelimiterUploadFailure> clearLineDelimiterFailures() {
        Map<UUID, List<LineDelimiterUploadFailure>> map = this.lineDelimiterFailures;
        synchronized (map) {
            ArrayList<LineDelimiterUploadFailure> allLineDelimiterFailures = new ArrayList<LineDelimiterUploadFailure>();
            for (List<LineDelimiterUploadFailure> failures : this.lineDelimiterFailures.values()) {
                allLineDelimiterFailures.addAll(failures);
            }
            this.lineDelimiterFailures.clear();
            return allLineDelimiterFailures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EncodingUploadFailure> clearEncodingFailures() {
        Map<UUID, List<EncodingUploadFailure>> map = this.encodingFailures;
        synchronized (map) {
            ArrayList<EncodingUploadFailure> allEncodingFailures = new ArrayList<EncodingUploadFailure>();
            for (List<EncodingUploadFailure> failures : this.encodingFailures.values()) {
                allEncodingFailures.addAll(failures);
            }
            this.encodingFailures.clear();
            return allEncodingFailures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DeletedPredecessorUploadFailure> clearDeletedPrecessorFailures() {
        Map<UUID, List<DeletedPredecessorUploadFailure>> map = this.deletedPredecessorFailures;
        synchronized (map) {
            ArrayList<DeletedPredecessorUploadFailure> allDeletedPredecessorFailures = new ArrayList<DeletedPredecessorUploadFailure>();
            for (List<DeletedPredecessorUploadFailure> failures : this.deletedPredecessorFailures.values()) {
                allDeletedPredecessorFailures.addAll(failures);
            }
            this.deletedPredecessorFailures.clear();
            return allDeletedPredecessorFailures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus[] getUploadFailureStatuses() {
        Map<UUID, Map<UUID, UploadFailure>> map = this.uploadFailures;
        synchronized (map) {
            ArrayList<IStatus> allFailureStatuses = new ArrayList<IStatus>();
            for (Map<UUID, UploadFailure> failedFileUploads : this.uploadFailures.values()) {
                for (UploadFailure failure : failedFileUploads.values()) {
                    allFailureStatuses.add(failure.getStatus());
                }
            }
            return allFailureStatuses.toArray(new IStatus[allFailureStatuses.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CheckinUploadHandler> clearFilesNeedingConversion() {
        List<UploadHandler> list = this.filesNeedingConversion;
        synchronized (list) {
            ArrayList<UploadHandler> result = new ArrayList<UploadHandler>(this.filesNeedingConversion);
            this.filesNeedingConversion.clear();
            return result;
        }
    }

    public boolean isUploadFailed(IComponentHandle component, IVersionableHandle target) {
        if (this.uploadFailures.isEmpty()) {
            return false;
        }
        Map<UUID, UploadFailure> uploadFailuresByComponent = this.uploadFailures.get(component.getItemId());
        return uploadFailuresByComponent != null && uploadFailuresByComponent.containsKey(target.getItemId());
    }

    public FileContent getContent(IComponentHandle component, IVersionableHandle versionable) {
        FileContent content = null;
        Map<UUID, FileContent> contentbyComponent = this.uploadContent.get(component.getItemId());
        if (contentbyComponent != null) {
            content = contentbyComponent.get(versionable.getItemId());
        }
        return content;
    }

    public String getContentType(IComponentHandle component, IVersionableHandle versionable) {
        String contentType = null;
        Map<UUID, String> contentTypeByComponent = this.uploadContentType.get(component.getItemId());
        if (contentTypeByComponent != null) {
            contentType = contentTypeByComponent.get(versionable.getItemId());
        }
        return contentType;
    }

    public IShareable getShareable(IComponentHandle component, IVersionableHandle versionable) {
        IShareable shareable = null;
        Map<UUID, IShareable> shareables = this.uploadShareables.get(component.getItemId());
        if (shareables != null) {
            shareable = shareables.get(versionable.getItemId());
        }
        return shareable;
    }

    public Long getLocalContentSize(IComponentHandle component, IVersionableHandle versionable) {
        Long contentSize = null;
        Map<UUID, Long> contentSizeByComponent = this.localContentSize.get(component.getItemId());
        if (contentSizeByComponent != null) {
            contentSize = contentSizeByComponent.get(versionable.getItemId());
        }
        return contentSize;
    }

    public ContentHash getLocalHashCode(IComponentHandle component, IVersionableHandle versionable) {
        ContentHash hash = null;
        Map<UUID, ContentHash> hashCodeByComponent = this.localHashCode.get(component.getItemId());
        if (hashCodeByComponent != null) {
            hash = hashCodeByComponent.get(versionable.getItemId());
        }
        return hash;
    }

    public Long getModTime(IComponentHandle component, IVersionableHandle versionable) {
        Long modTime = null;
        Map<UUID, Long> modTimeByComponent = this.modTimes.get(component.getItemId());
        if (modTimeByComponent != null) {
            modTime = modTimeByComponent.get(versionable.getItemId());
        }
        return modTime;
    }

    public void clearUploadInfo() {
        this.localContentSize.clear();
        this.localHashCode.clear();
        this.uploadContent.clear();
        this.uploadContentType.clear();
        this.uploadShareables.clear();
        this.modTimes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRetryRequest(IRetryRequest before, UploadHandler uh) {
        LinkedList<RetryRequest> linkedList = this.uploadsRequiringRetry;
        synchronized (linkedList) {
            this.uploadsRequiringRetry.add(new RetryRequest(before, uh));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RetryRequest> getAndResetRetryRequests() {
        LinkedList<RetryRequest> linkedList = this.uploadsRequiringRetry;
        synchronized (linkedList) {
            LinkedList<RetryRequest> toReturn = this.uploadsRequiringRetry;
            this.uploadsRequiringRetry = new LinkedList();
            return toReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipped(UploadFailure uploadSkipped) {
        UUID componentId = uploadSkipped.getUploadHandler().getComponent().getItemId();
        UUID itemId = uploadSkipped.getUploadHandler().getVersionable().getItemId();
        Map<UUID, Map<UUID, UploadFailure>> map = this.skippedUploads;
        synchronized (map) {
            Map<UUID, UploadFailure> failuresByComponent = this.skippedUploads.get(componentId);
            if (failuresByComponent == null) {
                failuresByComponent = new HashMap<UUID, UploadFailure>();
                this.skippedUploads.put(componentId, failuresByComponent);
            }
            failuresByComponent.put(itemId, uploadSkipped);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasSkipped(IComponentHandle comp, IVersionableHandle item) {
        Map<UUID, Map<UUID, UploadFailure>> map = this.skippedUploads;
        synchronized (map) {
            Map<UUID, UploadFailure> map2;
            block4: {
                map2 = this.skippedUploads.get(comp.getItemId());
                if (map2 != null) break block4;
                return false;
            }
            return map2.containsKey(item.getItemId());
        }
    }

    public static class RetryRequest {
        private final IRetryRequest beforeRetry;
        private final UploadHandler upload;

        RetryRequest(IRetryRequest before, UploadHandler upload) {
            this.beforeRetry = before;
            this.upload = upload;
        }

        public IRetryRequest getBeforeRetry() {
            return this.beforeRetry;
        }

        public UploadHandler getUpload() {
            return this.upload;
        }
    }
}

