/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.checkin;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.checkin.UploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.UploadHandler;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.repository.common.util.NLS;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.runtime.IStatus;

public class EncodingUploadFailure
extends UploadFailure
implements IEncodingUploadFailure {
    private boolean unknownEncoding;
    private boolean malformed;
    private String encodingUsed;
    private String predecessorEncoding;
    private String alternativeEncoding;
    private IStatus status;
    private boolean ignoreEncoding;

    public EncodingUploadFailure(IShareable shareable, String encoding, String predecessorEncoding, boolean unknownEncoding, boolean malformed, UploadHandler uploadHandler, Throwable e) {
        super(shareable, uploadHandler, e);
        this.unknownEncoding = unknownEncoding;
        this.malformed = malformed;
        this.encodingUsed = encoding;
        this.predecessorEncoding = predecessorEncoding;
        this.alternativeEncoding = encoding;
        this.ignoreEncoding = false;
    }

    @Override
    public String getEncoding() {
        return this.encodingUsed;
    }

    @Override
    public String getOriginalEncoding() {
        return this.predecessorEncoding;
    }

    @Override
    public boolean isUnknownEncoding() {
        return this.unknownEncoding;
    }

    @Override
    public boolean isMalformedContent() {
        return this.malformed;
    }

    @Override
    public void setAlternativeEncoding(String alternativeEncoding) {
        if (alternativeEncoding == null) {
            throw new IllegalArgumentException("alternativeEncoding cannot be null");
        }
        if (!Charset.isSupported(alternativeEncoding)) {
            throw new UnsupportedCharsetException(alternativeEncoding);
        }
        this.alternativeEncoding = alternativeEncoding;
    }

    public String getAlternativeEncoding() {
        return this.alternativeEncoding;
    }

    public boolean isIgnoreEncoding() {
        return this.ignoreEncoding;
    }

    @Override
    public void setIgnoreEncoding(boolean ignoreEncoding) {
        this.ignoreEncoding = ignoreEncoding;
    }

    @Override
    public IStatus getStatus() {
        if (this.status == null) {
            this.status = this.unknownEncoding ? FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_12, (Object)this.getShareable().getLocalPath().toString(), (Object[])new Object[]{this.encodingUsed}), this.getRootCause()) : FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_13, (Object)this.getShareable().getLocalPath().toString(), (Object[])new Object[]{this.encodingUsed}), this.getRootCause());
        }
        return this.status;
    }

    @Override
    public boolean hasDirection() {
        return this.ignoreEncoding || !this.encodingUsed.equals(this.alternativeEncoding) && this.alternativeEncoding != null || super.isSkipFailure();
    }
}

