/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.operations.IgnoreFileAgeDBHM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class JazzIgnoreFile {
    public static final String PROP_IGNORE_LOCAL = "core.ignore";
    public static final String PROP_IGNORE_GLOBAL = "core.global.ignore";
    public static final String PROP_IGNORE_RECURSIVE = "core.ignore.recursive";
    public static final String IGNORE_GLOBAL_DEFAULT = "*.class";
    public static final String IGNORE_LOCAL_ROOT_DEFAULT = "bin";
    public static final String[] DEFAULT_PROP_IGNORE_LOCAL = new String[]{"bin"};
    public static final String[] DEFAULT_PROP_IGNORE_GLOBAL = new String[]{"*.class"};
    public static final long TIME_BETWEEN_STALENESS_CHECKS = 3000L;
    private final DefaultIgnoreProvider provider;
    private final IShareable file;
    private final IRelativeLocation root;
    private final SortedSet<IgnoreRule> rules;
    private final IgnoreFileAgeDBHM.DateStamp lastModified;
    private long lastStaleCheck = Long.MIN_VALUE;
    private final Object staleLock = new Object();
    private long size = -2L;

    public JazzIgnoreFile(DefaultIgnoreProvider p, IShareable ignoreFile, SortedSet<IgnoreRule> rules, IgnoreFileAgeDBHM.DateStamp ds, long size) {
        if (rules.comparator() == null || !(rules.comparator() instanceof IgnoreRuleComparator)) {
            throw new IllegalArgumentException("Must create a new ignore file with an ignore rule comparator.");
        }
        this.provider = p;
        this.file = ignoreFile;
        this.root = ignoreFile.getLocalPath().removeLastSegments(1);
        this.rules = rules;
        this.lastModified = ds;
        this.size = size;
        this.lastStaleCheck = System.currentTimeMillis();
    }

    public int hashCode() {
        return this.file.getLocalPath().hashCode();
    }

    private static boolean isGlobal(IRelativeLocation path) {
        return path.segmentCount() == 2;
    }

    public boolean isGlobal() {
        return JazzIgnoreFile.isGlobal(this.file.getLocalPath());
    }

    public SortedSet<IgnoreRule> getRules() {
        return this.rules;
    }

    public IgnoreFileAgeDBHM.DateStamp getLastModified() {
        return this.lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public IShareable getRootShareable() {
        return this.getParentFor(this.file);
    }

    public IRelativeLocation getRootPath() {
        return this.root;
    }

    public IShareable getFile() {
        return this.file;
    }

    private IShareable getParentFor(IShareable shareable) {
        return ((Shareable)shareable).getParent();
    }

    public Collection<IgnoreRule> computeComplement(Collection<IgnoreRule> others) {
        LinkedList<IgnoreRule> complement = new LinkedList<IgnoreRule>();
        for (IgnoreRule rule : others) {
            if (this.rules.contains(rule)) continue;
            complement.add(rule);
        }
        return complement;
    }

    public JazzIgnoreFile addRules(Collection<IgnoreRule> newRules, IProgressMonitor progress) throws FileSystemException {
        SortedSet<IgnoreRule> toWrite = this.copyRules();
        toWrite.addAll(newRules);
        return IgnoreFileLoader.getInstance().createNew(this.getFile(), this.getProvider(), toWrite, progress);
    }

    public JazzIgnoreFile removeRules(Collection<IgnoreRule> toRemove, IProgressMonitor progress) throws FileSystemException {
        SortedSet<IgnoreRule> toWrite = this.copyRules();
        for (IgnoreRule rule : toRemove) {
            toWrite.remove(rule);
        }
        return IgnoreFileLoader.getInstance().createNew(this.getFile(), this.getProvider(), toWrite, progress);
    }

    public SortedSet<IgnoreRule> copyRules() {
        TreeSet<IgnoreRule> toReturn = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        toReturn.addAll(this.rules);
        return toReturn;
    }

    public DefaultIgnoreProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IIgnoreProvider.IIgnoreRule> findIgnoreReasons(IRelativeLocation path) {
        ArrayList<IgnoreRule> reasons = null;
        JazzIgnoreFile jazzIgnoreFile = this;
        synchronized (jazzIgnoreFile) {
            for (IgnoreRule rule : this.rules) {
                if (!rule.shouldBeIgnored(path)) continue;
                if (reasons == null) {
                    reasons = new ArrayList<IgnoreRule>(this.rules.size());
                }
                reasons.add(rule);
            }
        }
        return reasons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        JazzIgnoreFile jazzIgnoreFile = this;
        synchronized (jazzIgnoreFile) {
            return "JazzIgnoreFile(" + this.file.getLocalPath().toString() + ", " + this.rules + ")";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStale(IProgressMonitor mon) throws FileSystemException {
        long now = System.currentTimeMillis();
        Object object = this.staleLock;
        synchronized (object) {
            if (now - this.lastStaleCheck > 3000L) {
                this.lastStaleCheck = now;
                IgnoreFileAgeDBHM.DateStamp fromFs = this.provider.getFilesystem().lastModified(this.file);
                return fromFs.fsTimeStamp != this.lastModified.fsTimeStamp || this.provider.getFilesystem().size(this.file, mon) != this.size;
            }
        }
        return false;
    }
}

