/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.linkdetection;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.linkdetection.AbstractLinkDetector;
import com.ibm.team.workitem.common.internal.util.NamedPattern;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemURI;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WorkItemTextLinkDetector
extends AbstractLinkDetector
implements TextLinkDetectorManager.IServerSensitiveLinkDetector {
    private static final String COMMENT_IDENTIFIER = "\\b(%s)( | ?#)?(?<commentId>\\d+)";
    private static final String OPTIONAL_COMMENT_IDENTIFIER = "(,? ?\\b(%s)( | ?#)?(?<commentId>\\d+))?";
    private static final String WORK_ITEM_IDENTIFIER = "(?<workItem>\\b(?<workItemType>%s)( | ?#)(?<workItemId>\\d+))";
    private static final String LINK_NAMED_PATTERN = "(?<all>\\b(%s)( | ?#)?(?<commentId>\\d+)|((?<workItem>\\b(?<workItemType>%s)( | ?#)(?<workItemId>\\d+))(,? ?\\b(%s)( | ?#)?(?<commentId>\\d+))?))";
    private static final NamedPattern NAMED_PATTERN = new NamedPattern("(?<all>\\b(%s)( | ?#)?(?<commentId>\\d+)|((?<workItem>\\b(?<workItemType>%s)( | ?#)(?<workItemId>\\d+))(,? ?\\b(%s)( | ?#)?(?<commentId>\\d+))?))");
    private static final int ALL_GROUP = NAMED_PATTERN.getGroupIndex("all");
    private static final int WORK_ITEM_GROUP = NAMED_PATTERN.getGroupIndex("workItem");
    private static final int WORK_ITEM_REFERENCE_GROUP = NAMED_PATTERN.getGroupIndex("workItemType");
    private static final int WORK_ITEM_ID_GROUP = NAMED_PATTERN.getGroupIndex("workItemId");
    private static final int COMMENT_ID_GROUP_STA = NAMED_PATTERN.getGroupIndex("commentId", 0);
    private static final int COMMENT_ID_GROUP = NAMED_PATTERN.getGroupIndex("commentId", 1);
    private static final Map<UUID, Pattern> fgPatternCache = new HashMap<UUID, Pattern>();
    private static ILinkDetectorHelper fgClientHelper;
    private static ILinkDetectorHelper fgServerHelper;
    private IAuditableCommon fAuditableCommon;
    private boolean fIsServer;
    private static List<WorkItemTextLinkDetector> fgUninitializedDetectors;
    private static Object fgInitializerLock;

    static {
        fgUninitializedDetectors = new ArrayList<WorkItemTextLinkDetector>();
        fgInitializerLock = new Object();
    }

    public DetectedTextLink createDetectedLink(Matcher matcher) {
        int referenceLength;
        int referenceOffset;
        ILinkDetectorHelper helper = WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer);
        if (helper == null) {
            return null;
        }
        IProjectAreaHandle projectArea = this.getContextProject();
        IAuditableCommon auditableCommon = this.getAuditableCommon(helper);
        if (auditableCommon == null && projectArea != null) {
            auditableCommon = helper.getAuditableCommon(projectArea);
        }
        if (auditableCommon == null && helper.getAuditableCommons().size() == 1) {
            auditableCommon = helper.getAuditableCommons().get(0);
        }
        Integer workItemId = this.parseInteger(matcher.group(WORK_ITEM_ID_GROUP));
        Integer commentId = this.parseInteger(matcher.group(COMMENT_ID_GROUP));
        if (commentId == null) {
            commentId = this.parseInteger(matcher.group(COMMENT_ID_GROUP_STA));
        }
        if (commentId != null && commentId == 0) {
            commentId = null;
        }
        String workItemName = matcher.group(WORK_ITEM_REFERENCE_GROUP);
        URI baseURI = this.getBaseURI();
        if (workItemName != null && workItemId != null) {
            referenceOffset = projectArea != null ? matcher.start(ALL_GROUP) : matcher.start(WORK_ITEM_GROUP);
            int end = commentId != null ? matcher.end(ALL_GROUP) : matcher.end(WORK_ITEM_GROUP);
            referenceLength = end - referenceOffset;
        } else {
            workItemId = null;
            if (commentId == null) {
                return null;
            }
            if (auditableCommon != null) {
                if (baseURI == null) {
                    return null;
                }
                IItemHandle handle = ItemURI.resolveLocation(auditableCommon, baseURI);
                if (!(handle instanceof IWorkItemHandle)) {
                    return null;
                }
            }
            referenceOffset = matcher.start(ALL_GROUP);
            referenceLength = matcher.end(ALL_GROUP) - referenceOffset;
        }
        return new DetectedWorkItemTextLink(referenceOffset, referenceLength, auditableCommon, helper.getAuditableCommons(), baseURI, workItemId, commentId);
    }

    private Integer parseInteger(String number) {
        if (number == null) {
            return null;
        }
        try {
            return new Integer(number);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Pattern getPattern() {
        return this.getPattern(this.getContextProject());
    }

    public Pattern getPattern(IProjectAreaHandle projectArea) {
        return this.internalGetPattern(projectArea);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pattern internalGetPattern(IProjectAreaHandle projectArea) {
        Map<UUID, Pattern> map = fgPatternCache;
        synchronized (map) {
            UUID projectAreaUUID = projectArea != null ? projectArea.getItemId() : null;
            Pattern pattern = fgPatternCache.get(projectAreaUUID);
            if (pattern == null) {
                ILinkDetectorHelper helper = WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer);
                if (helper == null) {
                    return null;
                }
                Collection<String> allTypeNames = helper.getAllTypeNames(projectArea);
                Collection<String> commentNames = helper.getComments(projectArea);
                if (allTypeNames.isEmpty() || commentNames.isEmpty()) {
                    return null;
                }
                String types = WorkItemTextLinkDetector.joinPattern('|', allTypeNames);
                String comments = WorkItemTextLinkDetector.joinPattern('|', commentNames);
                String patternString = String.format(NAMED_PATTERN.getPattern(), comments, types, comments);
                pattern = Pattern.compile(patternString, 66);
                if (helper.isManaged(projectArea)) {
                    fgPatternCache.put(projectAreaUUID, pattern);
                }
            }
            return pattern;
        }
    }

    public static ILinkDetectorHelper getLinkDetectorHelper(boolean isServer) {
        if (isServer) {
            return fgServerHelper;
        }
        return fgClientHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClientHelper(ILinkDetectorHelper clientHelper) {
        if (clientHelper == null || clientHelper == fgClientHelper) {
            return;
        }
        fgClientHelper = clientHelper;
        Object object = fgInitializerLock;
        synchronized (object) {
            if (!fgUninitializedDetectors.isEmpty()) {
                Iterator<WorkItemTextLinkDetector> it = fgUninitializedDetectors.iterator();
                while (it.hasNext()) {
                    WorkItemTextLinkDetector detector = it.next();
                    if (detector.fIsServer) continue;
                    detector.initialize();
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServerHelper(ILinkDetectorHelper serverHelper) {
        if (serverHelper == null || serverHelper == fgServerHelper) {
            return;
        }
        fgServerHelper = serverHelper;
        Object object = fgInitializerLock;
        synchronized (object) {
            if (!fgUninitializedDetectors.isEmpty()) {
                Iterator<WorkItemTextLinkDetector> it = fgUninitializedDetectors.iterator();
                while (it.hasNext()) {
                    WorkItemTextLinkDetector detector = it.next();
                    if (!detector.fIsServer) continue;
                    detector.initialize();
                    it.remove();
                }
            }
        }
    }

    public void setIsServer(boolean isServer) {
        this.fIsServer = isServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer) != null) {
            WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer).cleanUp(this);
        } else {
            Object object = fgInitializerLock;
            synchronized (object) {
                fgUninitializedDetectors.remove((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer) != null) {
            WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer).initialize(this);
        } else {
            Object object = fgInitializerLock;
            synchronized (object) {
                fgUninitializedDetectors.add(this);
            }
        }
    }

    private IAuditableCommon getAuditableCommon(ILinkDetectorHelper helper) {
        if (this.fAuditableCommon == null && this.getBaseURI() != null) {
            for (IAuditableCommon aud : helper.getAuditableCommons()) {
                try {
                    if (aud.getRepositoryURI() == null) continue;
                    String auditableRepo = aud.getRepositoryURI();
                    if (auditableRepo.endsWith("/")) {
                        auditableRepo = auditableRepo.substring(0, auditableRepo.length() - 1);
                    }
                    if (!auditableRepo.equals(Location.location((URI)this.getBaseURI()).getRepoUri())) continue;
                    this.fAuditableCommon = aud;
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
        }
        return this.fAuditableCommon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidatePattern() {
        Map<UUID, Pattern> map = fgPatternCache;
        synchronized (map) {
            fgPatternCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidatePattern(IProjectAreaHandle handle) {
        Map<UUID, Pattern> map = fgPatternCache;
        synchronized (map) {
            if (handle == null) {
                WorkItemTextLinkDetector.invalidatePattern();
            } else {
                fgPatternCache.remove(handle.getItemId());
                fgPatternCache.remove(null);
            }
        }
    }

    public static class DetectedWorkItemTextLink
    extends DetectedTextLink {
        private IAuditableCommon fAuditableCommon;
        private URI fBaseURI;
        private Integer fWorkItemId;
        private Integer fCommentId;
        private ArrayList<IAuditableCommon> fAllAuditableCommons;

        public DetectedWorkItemTextLink(int offset, int length, IAuditableCommon auditableCommon, List<IAuditableCommon> allAuditableCommons, URI baseUri, Integer workItemId, Integer commentId) {
            super(offset, length);
            this.fAuditableCommon = auditableCommon;
            this.fWorkItemId = workItemId;
            this.fCommentId = commentId;
            this.fBaseURI = baseUri;
            this.fAllAuditableCommons = allAuditableCommons == null ? new ArrayList() : new ArrayList<IAuditableCommon>(allAuditableCommons);
        }

        public List<URI> createURIs() {
            ArrayList<URI> uris = new ArrayList<URI>();
            if (this.fAuditableCommon == null) {
                for (IAuditableCommon aud : this.fAllAuditableCommons) {
                    URI uri = this.getURI(aud);
                    if (uri == null) continue;
                    uris.add(uri);
                }
            } else {
                URI uri = this.getURI(this.fAuditableCommon);
                if (uri != null) {
                    uris.add(uri);
                }
            }
            return uris;
        }

        private URI getURI(IAuditableCommon auditableCommon) {
            URI uri;
            if (this.fWorkItemId == null) {
                if (this.fBaseURI == null || this.fCommentId == null) {
                    return null;
                }
                IItemHandle handle = ItemURI.resolveLocation(auditableCommon, this.fBaseURI);
                uri = ItemURI.createWorkItemCommentURI(auditableCommon, (IWorkItemHandle)handle, this.fCommentId - 1);
            } else {
                uri = this.fCommentId != null ? ItemURI.createWorkItemCommentURI(auditableCommon, this.fWorkItemId, this.fCommentId - 1) : ItemURI.createWorkItemURI(auditableCommon, this.fWorkItemId);
            }
            return uri;
        }
    }

    public static interface ILinkDetectorHelper {
        public boolean isManaged(IProjectAreaHandle var1);

        public Collection<String> getAllTypeNames(IProjectAreaHandle var1);

        public Collection<String> getAttachmentNames(IProjectAreaHandle var1);

        public Collection<String> getComments(IProjectAreaHandle var1);

        public IAuditableCommon getAuditableCommon(IProjectAreaHandle var1);

        public List<IAuditableCommon> getAuditableCommons();

        public void cleanUp(TextLinkDetector var1);

        public void initialize(TextLinkDetector var1);
    }
}

