/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IQueryCommon;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.internal.query.QueryDescriptor;
import com.ibm.team.workitem.common.internal.setup.builders.AttributeExpressionBuilder;
import com.ibm.team.workitem.common.internal.setup.builders.ExpressionBuilder;
import com.ibm.team.workitem.common.internal.setup.builders.TermBuilder;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import java.util.Arrays;
import java.util.List;

public class QueryDescriptorBuilder
extends AbstractArtifactBuilder<IQueryDescriptor> {
    protected static final ValueKey<String> ID = new ValueKey(String.valueOf(QueryDescriptorBuilder.class.getName()) + ".id");
    protected static final ValueKey<String> NAME = new ValueKey(String.valueOf(QueryDescriptorBuilder.class.getName()) + ".name");
    protected static final ValueKey<Expression> EXPRESSION = new ValueKey(String.valueOf(QueryDescriptorBuilder.class.getName()) + ".expression");
    protected static final ValueKey<IProjectArea> PROJECT_AREA = new ValueKey(String.valueOf(QueryDescriptorBuilder.class.getName()) + ".projectArea");
    protected static final ValueKey<List<String>> TAGS = new ValueKey(String.valueOf(QueryDescriptorBuilder.class.getName()) + ".tags");

    public QueryDescriptorBuilder(IArtifactBuilderContext buildContext) {
        super(buildContext);
    }

    public QueryDescriptorBuilder id(String id) {
        this.setBuilderValue(ID, id);
        return this;
    }

    public QueryDescriptorBuilder name(String name) {
        this.setBuilderValue(NAME, name);
        return this;
    }

    public QueryDescriptorBuilder expression(Expression expression) {
        this.setBuilderValue(EXPRESSION, expression);
        return this;
    }

    public QueryDescriptorBuilder expression(ExpressionBuilder<?> expression) {
        this.addChildBuilder(new IArtifactBuilder[]{expression});
        return this;
    }

    public QueryDescriptorBuilder projectArea(IProjectArea projectArea) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        return this;
    }

    public QueryDescriptorBuilder tags(String ... tags) {
        this.setBuilderValue(TAGS, Arrays.asList(tags));
        return this;
    }

    protected IQueryDescriptor doSave(BuildContext context) throws TeamRepositoryException {
        if (!this.artifactExists() && !this.isBuilderValueSet(PROJECT_AREA)) {
            throw new TeamRepositoryException("Project Area is required to set");
        }
        if (this.isBuilderValueSet(PROJECT_AREA)) {
            context.setProperty(BuildContext.PROJECT_AREA, (Object)((IProjectArea)this.getBuilderValue(PROJECT_AREA)));
        }
        IQueryDescriptor queryDescriptor = this.setQueryDescriptorFields((QueryDescriptor)this.artifact(IQueryDescriptor.ITEM_TYPE));
        if (!this.isBuilderValueSet(EXPRESSION) && !this.getChildBuilders().isEmpty()) {
            queryDescriptor.setExpression(new TermBuilder(this.getContext()).expressions(this.createProjectAreaExpression(queryDescriptor), (ExpressionBuilder)((Object)this.getChildBuilders().get(0))).prepareSave(context));
        }
        return ((IQueryCommon)this.getContext().getLibrary(IQueryCommon.class)).save(queryDescriptor, null);
    }

    protected IQueryDescriptor doBuild(BuildContext context) {
        IQueryDescriptor queryDescriptor = this.setQueryDescriptorFields((QueryDescriptor)this.artifact(IQueryDescriptor.ITEM_TYPE));
        if (!this.isBuilderValueSet(EXPRESSION) && !this.getChildBuilders().isEmpty()) {
            queryDescriptor.setExpression((Expression)((ExpressionBuilder)((Object)this.getChildBuilders().get(0))).build(context));
        }
        return queryDescriptor;
    }

    private IQueryDescriptor setQueryDescriptorFields(QueryDescriptor queryDescriptor) {
        queryDescriptor.setContextId(IContext.PUBLIC);
        queryDescriptor.setQueryType("com.ibm.team.workitem.workItemType");
        queryDescriptor.setId((String)this.getBuilderValue(ID, UUID.generate().getUuidValue()));
        queryDescriptor.setName((String)this.getBuilderValue(NAME, UUID.generate().getUuidValue()));
        queryDescriptor.setProjectArea((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA));
        queryDescriptor.setExpression((Expression)this.getBuilderValue(EXPRESSION, new Term()));
        if (this.isBuilderValueSet(TAGS)) {
            List tags = (List)this.getBuilderValue(TAGS);
            SeparatedStringList stringList = new SeparatedStringList(tags);
            String tagsString = stringList.getSeparatedString();
            queryDescriptor.setTags(tagsString);
        }
        return queryDescriptor;
    }

    private AttributeExpressionBuilder createProjectAreaExpression(IQueryDescriptor queryDescriptor) {
        return new AttributeExpressionBuilder(this.getContext()).attribute(queryDescriptor.getProjectArea(), IWorkItem.PROJECT_AREA_PROPERTY).operation(AttributeOperation.EQUALS).value(queryDescriptor.getProjectArea());
    }
}

