/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ConfigurationWithContext;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IProviderContext;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ProviderType;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AttributesAdvisorHelper {
    private static final String WORK_ITEM = "workItem";
    private static final String CREATION = "creation";
    private static final String UUID_ATTR = "UUID";
    public static final String ATTRIBUTE = "attribute";
    public static final String RULE_ID = "ruleId";
    public static final String ID = "id";

    public static List<AttributeAdvisorConfiguration> getConfiguration(String rootNodeName, IProjectAreaHandle projectArea, IWorkItemCommon workItemCommon, IProcessConfigurationElement advisorConfiguration, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<AttributeAdvisorConfiguration> configurationList = new ArrayList<AttributeAdvisorConfiguration>();
        IProcessConfigurationElement[] iProcessConfigurationElementArray = advisorConfiguration.getChildren();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String providerId;
            IProcessConfigurationElement requiredAttributesElement = iProcessConfigurationElementArray[n2];
            if (rootNodeName.equals(requiredAttributesElement.getName()) && (providerId = requiredAttributesElement.getAttribute(RULE_ID)) != null && providerId.length() != 0) {
                ArrayList<String> attributes = new ArrayList<String>();
                ItemHandleAwareHashSet<IAttributeHandle> dependencies = new ItemHandleAwareHashSet<IAttributeHandle>();
                IConfiguration configuration = ((WorkItemCommon)workItemCommon).getProviderConfiguration(projectArea, ProviderType.CONDITION, providerId, monitor);
                IProcessConfigurationElement[] iProcessConfigurationElementArray2 = requiredAttributesElement.getChildren();
                int n3 = iProcessConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String internalAttributeId;
                    IAttribute attribute;
                    String attributeId;
                    IProcessConfigurationElement attributeElement = iProcessConfigurationElementArray2[n4];
                    if (ATTRIBUTE.equals(attributeElement.getName()) && (attributeId = attributeElement.getAttribute(ID)) != null && attributeId.length() != 0 && (attribute = workItemCommon.findAttribute(projectArea, internalAttributeId = WorkItemAttributes.getAttributeId(Identifier.create(IAttribute.class, attributeId)), monitor)) != null) {
                        attributes.add(internalAttributeId);
                        dependencies.addAll(attribute.getDependencies());
                    }
                    ++n4;
                }
                ArrayList<String> dependencyIds = new ArrayList<String>();
                if (!dependencies.isEmpty()) {
                    List<IAttribute> dependentAttributes = workItemCommon.getAuditableCommon().resolveAuditables(dependencies.toList(), IAttribute.SMALL_PROFILE, null);
                    for (IAttribute dependent : dependentAttributes) {
                        dependencyIds.add(dependent.getIdentifier());
                    }
                }
                configurationList.add(new AttributeAdvisorConfiguration(configuration, attributes, dependencyIds));
            }
            ++n2;
        }
        return configurationList;
    }

    public static Object getValue(IWorkItem workItem, IAttribute attribute) {
        Object value = workItem.getValue(attribute);
        if (AttributeTypes.STRING_TYPES.contains(attribute.getAttributeType()) && value instanceof String) {
            value = ((String)value).trim();
        } else if (AttributeTypes.HTML_TYPES.contains(attribute.getAttributeType()) && value instanceof String) {
            value = XMLString.createFromXMLText((String)((String)value)).getPlainText().trim();
        }
        return value;
    }

    public static boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        if (left instanceof List && right instanceof List) {
            return AttributesAdvisorHelper.equalLists((List)left, (List)right);
        }
        if (left instanceof String && right instanceof String) {
            return AttributesAdvisorHelper.equalsStrings((String)left, (String)right);
        }
        return left.equals(right);
    }

    private static boolean equalsStrings(String left, String right) {
        String l = left.replaceAll("\\r\\n", "\n");
        String r = right.replaceAll("\\r\\n", "\n");
        return l.equals(r);
    }

    private static boolean equalLists(List<?> left, List<?> right) {
        if (left.size() != right.size()) {
            return false;
        }
        ArrayList copy = new ArrayList(right);
        int i = 0;
        while (i < left.size()) {
            Object a = left.get(i);
            int index = AttributesAdvisorHelper.find(a, copy);
            if (index == -1) {
                return false;
            }
            copy.set(index, null);
            ++i;
        }
        for (Object curr : copy) {
            if (curr == null) continue;
            return false;
        }
        return true;
    }

    private static int find(Object a, List<?> list) {
        int k = 0;
        while (k < list.size()) {
            Object b = list.get(k);
            if (AttributesAdvisorHelper.equals(a, b)) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public static String createData(IWorkItem workItem, IAttribute attribute, String rootName) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)rootName);
        IMemento wi = memento.createChild(WORK_ITEM);
        wi.putString(UUID_ATTR, workItem.getItemId().getUuidValue());
        if (workItem.isNewItem()) {
            wi.putBoolean(CREATION, true);
        } else {
            wi.putInteger(ID, workItem.getId());
        }
        IMemento attr = memento.createChild(ATTRIBUTE);
        attr.putString(UUID_ATTR, attribute.getItemId().getUuidValue());
        attr.putString(ID, attribute.getIdentifier());
        try {
            return memento.asXMLString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static AdvisorData parseData(String data) throws CoreException {
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(data));
        IMemento workItem = memento.getChild(WORK_ITEM);
        Boolean isCreation = workItem.getBoolean(CREATION);
        Integer workItemId = null;
        UUID workItemItemId = UUID.valueOf((String)workItem.getString(UUID_ATTR));
        if (isCreation == null || !isCreation.booleanValue()) {
            isCreation = false;
            workItemId = workItem.getInteger(ID);
        }
        IMemento attr = memento.getChild(ATTRIBUTE);
        String attributeId = attr.getString(ID);
        UUID attributeUUID = UUID.valueOf((String)attr.getString(UUID_ATTR));
        return new AdvisorData(workItemId, workItemItemId, attributeId, attributeUUID, isCreation);
    }

    public static class AdvisorData {
        private final Integer fWorkItemId;
        private final UUID fWorkItemItemId;
        private final String fAttributeId;
        private final UUID fAttributeItemId;
        private final boolean fCreation;

        private AdvisorData(Integer workItemId, UUID workItemItemId, String attributeId, UUID attributeItemId, boolean isCreation) {
            this.fWorkItemId = workItemId;
            this.fWorkItemItemId = workItemItemId;
            this.fAttributeId = attributeId;
            this.fAttributeItemId = attributeItemId;
            this.fCreation = isCreation;
        }

        public Integer getWorkItemId() {
            return this.fWorkItemId;
        }

        public UUID getWorkItemItemId() {
            return this.fWorkItemItemId;
        }

        public String getAttributeId() {
            return this.fAttributeId;
        }

        public UUID getAttributeItemId() {
            return this.fAttributeItemId;
        }

        public boolean isCreation() {
            return this.fCreation;
        }
    }

    public static class AttributeAdvisorConfiguration {
        private final IConfiguration fConfiguration;
        private final List<String> fAttributeIdentifiers;
        private final Collection<String> fDependencies;

        public AttributeAdvisorConfiguration(IConfiguration configuration, List<String> attributeIdentifiers, Collection<String> dependencies) {
            this.fConfiguration = configuration;
            this.fAttributeIdentifiers = attributeIdentifiers;
            this.fDependencies = dependencies;
        }

        public IConfiguration getConfiguration(IProviderContext providerContext) {
            if (providerContext != null) {
                return new ConfigurationWithContext(this.fConfiguration, providerContext);
            }
            return this.fConfiguration;
        }

        public List<String> getAttributeIdentifiers() {
            return this.fAttributeIdentifiers;
        }

        public Collection<String> getDependencies() {
            return this.fDependencies;
        }
    }
}

