/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.transport.TeamContent;
import com.ibm.team.workitem.api.common.connectors.IDataConnector;
import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.internal.AttachmentDeleteRunnable;
import com.ibm.team.workitem.client.internal.AuditableClient;
import com.ibm.team.workitem.client.internal.AvailableTypesCache;
import com.ibm.team.workitem.client.internal.ClientAttributeValueLabelProviderFactory;
import com.ibm.team.workitem.client.internal.ClientServiceContext;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.client.internal.ModelPlugin;
import com.ibm.team.workitem.client.internal.QueryClient;
import com.ibm.team.workitem.client.internal.WorkItemDeleteRunnable;
import com.ibm.team.workitem.client.internal.WorkItemSaveRunnable;
import com.ibm.team.workitem.client.internal.WorkItemSaveTransport;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyRegistry;
import com.ibm.team.workitem.client.internal.util.EventDispatcher;
import com.ibm.team.workitem.client.internal.util.RemoteImages;
import com.ibm.team.workitem.common.ILinkConfigurationContext;
import com.ibm.team.workitem.common.internal.AuditableCache;
import com.ibm.team.workitem.common.internal.DeliverableWorkingCopy;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.IWorkItemHistoryService;
import com.ibm.team.workitem.common.internal.IWorkItemRepositoryService;
import com.ibm.team.workitem.common.internal.ResourceLocation;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.attributevaluelabelprovider.IAttributeValueLabelProvider;
import com.ibm.team.workitem.common.internal.model.IImageContentService;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemReferences;
import com.ibm.team.workitem.common.internal.rcp.dto.ChangeLogDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveParameterDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveResultDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.RcpFactory;
import com.ibm.team.workitem.common.internal.rcp.dto.StatusResultDTO;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class WorkItemClient
extends WorkItemCommon
implements IWorkItemClient {
    private static final ItemProfile<IAuditable> CUSTOM_ATTRIBUTE_PROFILE = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (Collection)IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES);
    private final IClientLibraryContext fContext;
    private final ITeamRepository fTeamRepository;
    private final IAuditableClient fAuditableClient;
    private final IQueryClient fQueryClient;
    private final ListenerList fListenerList = new ListenerList();
    private final WorkItemWorkingCopyRegistry fWorkingCopyRegistry;
    private final IWorkItemWorkingCopyManager fStandardManager;
    private final WorkItemSaveTransport fSaveTransport;
    private final EventDispatcher fBackgroundEventDispatcher = new EventDispatcher(Messages.WorkItemClient_EVENT_DISPATCHER, true, false);
    private final EventDispatcher fEventDispatcher = new EventDispatcher(true);
    private final AvailableTypesCache fAvailableTypesCache;

    public WorkItemClient(IClientLibraryContext context) {
        super((ICommonServiceContext)new ClientServiceContext(context));
        this.fContext = context;
        this.fTeamRepository = context.teamRepository();
        this.fAuditableClient = (IAuditableClient)this.fTeamRepository.getClientLibrary(IAuditableClient.class);
        ((AuditableClient)this.fAuditableClient).addItemTypeCache(IIteration.ITEM_TYPE, (AuditableCache.IItemTypeCache)new AuditableCache.PrimitiveCache());
        ((AuditableClient)this.fAuditableClient).addItemTypeCache(IDevelopmentLine.ITEM_TYPE, (AuditableCache.IItemTypeCache)new AuditableCache.PrimitiveCache());
        this.fAvailableTypesCache = new AvailableTypesCache(this.fAuditableClient);
        this.fWorkingCopyRegistry = new WorkItemWorkingCopyRegistry(this);
        this.fStandardManager = this.createWorkingCopyManager(Messages.WorkItemClient_SHARED_WORKING_COPY_MANAGER, true, true);
        this.fQueryClient = new QueryClient(context);
        this.fTeamRepository.itemManager().addItemChangeListener(IWorkItem.ITEM_TYPE, (ISharedItemChangeListener)new InternalListener());
        this.fTeamRepository.itemManager().addItemChangeListener(IAttribute.ITEM_TYPE, (ISharedItemChangeListener)new InternalListener());
        this.fTeamRepository.itemManager().addItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)new InternalListener());
        this.fTeamRepository.itemManager().addItemChangeListener(ITeamArea.ITEM_TYPE, (ISharedItemChangeListener)new InternalListener());
        this.fSaveTransport = new WorkItemSaveTransport(context);
    }

    @Override
    public IWorkItemWorkingCopyManager getWorkItemWorkingCopyManager() {
        return this.fStandardManager;
    }

    @Override
    public IWorkItemWorkingCopyManager createWorkingCopyManager(String owner, boolean writeable) {
        return this.createWorkingCopyManager(owner, writeable, false);
    }

    public IWorkItemWorkingCopyManager createWorkingCopyManager(String owner, boolean writeable, boolean shared) {
        return new WorkItemWorkingCopyManager(this.fWorkingCopyRegistry, owner, writeable, shared);
    }

    @Override
    public void addWorkItemListener(IWorkItemListener listener) {
        this.fListenerList.add((Object)listener);
    }

    @Override
    public void removeWorkItemListener(IWorkItemListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    private void fireWorkItemChanged(WorkItemChangeEvent event) {
        if (!this.fListenerList.isEmpty()) {
            this.fireWorkItemAttributeChange(this.fListenerList, event);
            if (event.getAffectedDependents().length > 0) {
                this.fireWorkItemAttributeDependencyChange(this.fListenerList, event);
            }
        }
    }

    private void fireWorkItemAttributeChange(final ListenerList listenerList, final WorkItemChangeEvent event) {
        Object[] listeners = listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IWorkItemListener listener = (IWorkItemListener)listeners[i];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.workItemAttributeChanged(event);
                }

                public void handleException(Throwable exception) {
                    listenerList.remove((Object)listener);
                }
            };
            this.fEventDispatcher.add(runnable);
            ++i;
        }
    }

    private void fireWorkItemAttributeDependencyChange(final ListenerList listenerList, final WorkItemChangeEvent event) {
        Object[] listeners = listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IWorkItemListener listener = (IWorkItemListener)listeners[i];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.workItemAttributeDependencyChanged(event);
                }

                public void handleException(Throwable exception) {
                    listenerList.remove((Object)listener);
                }
            };
            this.fEventDispatcher.add(runnable);
            ++i;
        }
    }

    @Override
    public IWorkItem resolveWorkItem(IWorkItemHandle handle, ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkItem)this.fAuditableClient.resolveAuditable((IAuditableHandle)handle, profile, monitor);
    }

    @Override
    public IWorkItem fetchCurrentWorkItem(IWorkItemHandle handle, ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkItem)this.fAuditableClient.fetchCurrentAuditable((IAuditableHandle)handle, profile, monitor);
    }

    public IWorkItemReferences resolveWorkItemReferences(IWorkItemHandle workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem instanceof IWorkItem && ((IWorkItem)workItem).isNewItem()) {
            return new WorkItemReferences((IWorkItem)workItem);
        }
        ILinkManager linkService = (ILinkManager)this.fTeamRepository.getClientLibrary(ILinkManager.class);
        IItemReference reference = linkService.referenceFactory().createReferenceToItem((IItemHandle)workItem);
        ILinkCollection newLinks = linkService.findLinks((IReference)reference, monitor).getAllLinksFromHereOn();
        return new WorkItemReferences((IWorkItem)this.getAuditableCommon().resolveAuditable((IAuditableHandle)workItem, IWorkItem.SMALL_PROFILE, null), (Collection)newLinks);
    }

    public String[] findDependents(IProjectAreaHandle projectArea, String attributeIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        List attributes = this.findCachedAttributes(projectArea);
        if (attributes == null || attributes.isEmpty()) {
            attributes = this.findAttributes(projectArea, monitor);
        }
        IAttribute attribute = null;
        for (IAttribute curr : attributes) {
            if (!curr.getIdentifier().equals(attributeIdentifier)) continue;
            attribute = curr;
            break;
        }
        HashSet<String> dependents = new HashSet<String>();
        if (attribute != null) {
            for (IAttribute curr : attributes) {
                List dependencies = curr.getDependencies();
                for (IAttributeHandle dep : dependencies) {
                    if (!dep.sameItemId((IItemHandle)attribute)) continue;
                    dependents.add(curr.getIdentifier());
                }
            }
        }
        return dependents.toArray(new String[dependents.size()]);
    }

    public IIteration saveInterval(IIteration interval, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processService = (IProcessItemService)this.fTeamRepository.getClientLibrary(IProcessItemService.class);
        return (IIteration)processService.save((IProcessItem)interval, monitor);
    }

    @Override
    public IDetailedStatus saveWorkItem(IWorkItem workItem, String workflowAction, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            WorkItemWorkingCopyImpl workingCopy = new WorkItemWorkingCopyImpl(workItem);
            if (workflowAction != null) {
                workingCopy.setWorkflowAction(workflowAction);
            }
            if (((Auditable)workItem).getWorkingCopyPredecessor() != null) {
                IAuditableHandle stateHandle = this.fAuditableClient.createAuditableHandle(IWorkItem.ITEM_TYPE, workItem.getItemId(), ((Auditable)workItem).getWorkingCopyPredecessor());
                Collection properties = ItemProfile.computeProfile((IAuditable)workItem).getProperties();
                IWorkItem baseState = (IWorkItem)this.getTeamRepository().itemManager().fetchPartialState(stateHandle, properties, monitor);
                workingCopy.setBaseState((IWorkItem)EMFHelper.copy((Object)baseState));
            }
            return this.fWorkingCopyRegistry.saveWorkItems(this.getWorkItemWorkingCopyManager(), Arrays.asList(workingCopy), this.getSaveTransport(), monitor)[0];
        }
        catch (MultiStaleDataException x) {
            throw new StaleDataException(x.getOrigin(), x.getMessage(), (Throwable)x);
        }
    }

    @Override
    public IDetailedStatus deleteWorkItem(IWorkItemHandle workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem == null) {
            return DetailedStatus.OK_STATUS;
        }
        return this.deleteWorkItems(Collections.singletonList(workItem), monitor).get(0);
    }

    @Override
    public List<IDetailedStatus> deleteWorkItems(List<IWorkItemHandle> workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItems == null || workItems.isEmpty()) {
            return Collections.singletonList(DetailedStatus.OK_STATUS);
        }
        List<IDetailedStatus> status = this.fWorkingCopyRegistry.delete(this.getWorkItemWorkingCopyManager(), workItems, monitor);
        ArrayList<IWorkItemHandle> deletedItems = new ArrayList<IWorkItemHandle>();
        int idx = 0;
        while (idx < status.size()) {
            IStatus cur = status.get(idx);
            if (cur.isOK()) {
                deletedItems.add(workItems.get(idx));
            }
            ++idx;
        }
        this.fTeamRepository.itemManager().applyItemDeletes(deletedItems);
        return status;
    }

    StatusResultDTO[] deleteWorkItems0(List<IWorkItemHandle> workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItems == null || workItems.isEmpty()) {
            StatusResultDTO okStatus = RcpFactory.eINSTANCE.createStatusResultDTO();
            okStatus.setSeverity(0);
            return new StatusResultDTO[]{okStatus};
        }
        WorkItemDeleteRunnable runnable = new WorkItemDeleteRunnable(workItems, this.fContext);
        IProcessClientService processClient = (IProcessClientService)this.fTeamRepository.getClientLibrary(IProcessClientService.class);
        try {
            processClient.execute((ProcessRunnable)runnable, Messages.WorkItemClient_DELETE_WORK_ITEMS, monitor);
            StatusResultDTO[] statusResultDTOArray = runnable.getStatus();
            return statusResultDTOArray;
        }
        finally {
            runnable.dispose();
        }
    }

    @Override
    public IAttachment createAttachment(IProjectAreaHandle projectArea, String name, String description, String contentType, String characterEncoding, InputStream inputStream, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttachment attachment = this.createAttachment(projectArea, monitor);
        attachment.setName(name);
        attachment.setDescription(description);
        IContent content = this.fTeamRepository.contentManager().storeContent(contentType, characterEncoding, inputStream, null, monitor);
        attachment.setContent(content);
        return this.saveAttachment(attachment, monitor);
    }

    public void deleteAttachment(IAttachmentHandle attachment, IProgressMonitor monitor) throws TeamRepositoryException {
        if (attachment != null) {
            this.deleteAttachments(Collections.singletonList(attachment), monitor);
        }
    }

    public void deleteAttachments(List<IAttachmentHandle> attachments, IProgressMonitor monitor) throws TeamRepositoryException {
        if (attachments != null && !attachments.isEmpty()) {
            AttachmentDeleteRunnable runnable = new AttachmentDeleteRunnable(attachments, this.fContext);
            IProcessClientService processClient = (IProcessClientService)this.fTeamRepository.getClientLibrary(IProcessClientService.class);
            try {
                processClient.execute((ProcessRunnable)runnable, Messages.WorkItemClient_DELETE_ATTACHMENTS, monitor);
            }
            finally {
                runnable.dispose();
            }
        }
    }

    protected MultiSaveResultDTO save(String operationName, MultiSaveParameterDTO multiSaveParameter, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.save(operationName, multiSaveParameter, this.getSaveTransport(), monitor);
    }

    MultiSaveResultDTO save(String operationName, MultiSaveParameterDTO multiSaveParameter, WorkItemSaveTransport transport, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessClientService processClient = (IProcessClientService)this.fTeamRepository.getClientLibrary(IProcessClientService.class);
        WorkItemSaveRunnable saveRunnable = new WorkItemSaveRunnable(this, multiSaveParameter, transport);
        try {
            processClient.execute((ProcessRunnable)saveRunnable, operationName, monitor);
            MultiSaveResultDTO multiSaveResultDTO = saveRunnable.getSaveResult();
            return multiSaveResultDTO;
        }
        finally {
            saveRunnable.dispose();
        }
    }

    public WorkItemSaveTransport getSaveTransport() {
        return this.fSaveTransport;
    }

    public List<ChangeLogDTO> computeWorkItemHistory(IWorkItemHandle workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.computeWorkItemHistory(workItem, false, monitor);
    }

    public List<ChangeLogDTO> computeWorkItemHistory(IWorkItemHandle workItem, boolean includeLinkHistory, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)workItem);
        IWorkItemHandle handle = workItem instanceof IWorkItem ? (IWorkItemHandle)((IWorkItem)workItem).getItemHandle() : workItem;
        ChangeLogDTO[] result = this.getService(IWorkItemHistoryService.class).computeHistory(handle, includeLinkHistory);
        return Arrays.asList(result);
    }

    public boolean isAutoLinkArchivingEnabled() throws TeamRepositoryException {
        return this.getService(IWorkItemHistoryService.class).isAutoLinkArchivingEnabled();
    }

    public List<ChangeLogDTO> computePartialWorkItemHistory(IWorkItemHandle workItem, UUID from, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)workItem);
        IWorkItemHandle handle = workItem instanceof IWorkItem ? (IWorkItemHandle)((IWorkItem)workItem).getItemHandle() : workItem;
        ChangeLogDTO[] result = this.getService(IWorkItemHistoryService.class).computePartialHistory(handle, from);
        return Arrays.asList(result);
    }

    @Override
    public TeamContent getImageContent(URI uri, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getImageContent(uri, false, monitor);
    }

    @Override
    public TeamContent getImageContent(final URI uri, final boolean decorated, IProgressMonitor monitor) throws TeamRepositoryException {
        return (TeamContent)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    String path = decorated && uri.getQuery() != null ? Location.location((URI)uri).toRelativeUri().toString() : ResourceLocation.getImageContentServicePath((URI)uri);
                    IImageContentService service = (IImageContentService)WorkItemClient.this.fContext.getServiceInterface(IImageContentService.class);
                    return service.get(URLEncoder.encode(path, "utf-8").replaceAll("%2F", "/"));
                }
                catch (IOException e) {
                    throw new TeamRepositoryException("Cannot retrieve image content", (Throwable)e);
                }
            }
        }, monitor);
    }

    public ICategoryHandle guessCategory(final IWorkItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ICategoryHandle)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return WorkItemClient.super.guessCategory(item, monitor);
            }
        }, monitor);
    }

    public String[] findAvailableWorkItemTypes(IProcessAreaHandle processArea, String oldWorkflowId, IProgressMonitor monitor) throws TeamRepositoryException {
        String[] availableTypes = this.fAvailableTypesCache.getValid(processArea, oldWorkflowId);
        if (availableTypes != null) {
            return availableTypes;
        }
        availableTypes = super.findAvailableWorkItemTypes(processArea, oldWorkflowId, monitor);
        this.fAvailableTypesCache.put(processArea, oldWorkflowId, availableTypes, monitor);
        return availableTypes;
    }

    public String[] findCachedAvailableWorkItemTypes(IProcessAreaHandle processArea) {
        return this.fAvailableTypesCache.getCached(processArea, null);
    }

    public DeliverableWorkingCopy resolveDeliverableWorkingCopy(IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return DeliverableWorkingCopy.resolveWorkingCopy((ICommonServiceContext)this.getServiceContext(), (IProjectAreaHandle)projectArea, (IProgressMonitor)monitor);
    }

    private void startSynchronizeConfiguration(final Collection<IProjectAreaHandle> projectAreas) {
        if (projectAreas.isEmpty()) {
            return;
        }
        FoundationJob job = new FoundationJob(Messages.WorkItemClient_SYNCHRONIZE_CONFIGURATION){

            protected IStatus runProtected(IProgressMonitor monitor) {
                try {
                    ItemProfile emtpyProfile = ItemProfile.createProfile((IItemType)IIteration.ITEM_TYPE, (Collection)Collections.EMPTY_LIST);
                    List cachedIntervals = WorkItemClient.this.fAuditableClient.findAllCachedAuditables(emtpyProfile);
                    WorkItemClient.this.fAuditableClient.fetchCurrentAuditables(cachedIntervals, emtpyProfile, monitor);
                    ItemProfile attributeProfile = ItemProfile.createProfile((IItemType)IAttribute.ITEM_TYPE, (Collection)Collections.EMPTY_LIST);
                    List cachedAttributes = WorkItemClient.this.fAuditableClient.findAllCachedAuditables(attributeProfile);
                    WorkItemClient.this.fAuditableClient.fetchCurrentAuditables(cachedAttributes, attributeProfile, monitor);
                    for (IProjectAreaHandle projectArea : projectAreas) {
                        WorkItemClient.this.getWorkItemTypeManager().invalidateCache(projectArea);
                    }
                }
                catch (NotLoggedInException notLoggedInException) {
                }
                catch (TeamRepositoryException x) {
                    ModelPlugin.log("Exception while synchronizing configuration", (Exception)((Object)x));
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public MultiSaveResultDTO updateWorkItemAttributes(final Collection<IWorkItemHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return (MultiSaveResultDTO)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<MultiSaveResultDTO>(){

            public MultiSaveResultDTO run(IProgressMonitor monitor) throws TeamRepositoryException {
                return WorkItemClient.this.getService(IWorkItemRepositoryService.class).updateWorkItemAttributes(handles.toArray(new IWorkItemHandle[handles.size()]));
            }
        }, monitor);
    }

    public URL resolveURL(URL url, IProgressMonitor monitor) throws TeamRepositoryException {
        if (ResourceLocation.isImageContentServiceURL((URL)url)) {
            try {
                URI uri = url.toURI();
                URL resolvedUrl = RemoteImages.getCachedImageContentServiceURL(uri);
                if (resolvedUrl == null) {
                    resolvedUrl = RemoteImages.resolveImageContent(this, uri, monitor);
                }
                return resolvedUrl;
            }
            catch (MalformedURLException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        return super.resolveURL(url, monitor);
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    @Override
    public IQueryClient getQueryClient() {
        return this.fQueryClient;
    }

    public <T> T getService(Class<T> serviceInterface) {
        return (T)this.fContext.getServiceInterface(serviceInterface);
    }

    public IDataConnector getDataConnector(String connectorId) {
        return null;
    }

    public IAttributeValueLabelProvider createLabelProvider(IAttribute attribute, IWorkflowInfo workflowInfo) {
        return ClientAttributeValueLabelProviderFactory.createLabelProvider(attribute, workflowInfo, this);
    }

    @Override
    public String getConfigurationUriForWorkItemByLinkType(final String projectAreaItemId, final String itemId, final String linkTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (String)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<String>(){

            public String run(IProgressMonitor monitor) throws TeamRepositoryException {
                return WorkItemClient.this.getService(IWorkItemRepositoryService.class).getConfigurationManagementUriByLinkType(projectAreaItemId, itemId, linkTypeId);
            }
        }, monitor);
    }

    @Override
    public Map<String, String> getConfigurationUrisForWorkItemForLinkTypes(final String projectAreaItemId, final String itemId, final Set<String> linkTypeIds, IProgressMonitor monitor) throws TeamRepositoryException {
        return (Map)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Map<String, String>>(){

            public Map<String, String> run(IProgressMonitor monitor) throws TeamRepositoryException {
                String[] linkTypeIdsAsArray = linkTypeIds.toArray(new String[linkTypeIds.size()]);
                String[] serviceResult = WorkItemClient.this.getService(IWorkItemRepositoryService.class).getConfigurationUrisForWorkItemForLinkTypes(projectAreaItemId, itemId, linkTypeIdsAsArray);
                HashMap<String, String> result = new HashMap<String, String>();
                int i = 0;
                while (i < serviceResult.length) {
                    result.put(linkTypeIdsAsArray[i], serviceResult[i]);
                    ++i;
                }
                return result;
            }
        }, monitor);
    }

    public ILinkConfigurationContext createLinkConfigurationContext(Map<String, String> oslcMappings) {
        return null;
    }

    @Override
    public boolean hasOSLCLinkTypeMappings(final IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return (Boolean)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Boolean>(){

            public Boolean run(IProgressMonitor monitor) throws TeamRepositoryException {
                return WorkItemClient.this.getService(IWorkItemRepositoryService.class).hasOSLCLinkTypeMappings(projectArea);
            }
        }, monitor);
    }

    private class InternalListener
    implements ISharedItemChangeListener {
        private InternalListener() {
        }

        public void itemsChanged(List events) {
            ItemHandleAwareHashSet projectAreas = new ItemHandleAwareHashSet();
            for (ISharedItemChangeEvent event : events) {
                if (event.getSharedItem() instanceof IWorkItem) {
                    this.workItemChanged(event);
                    continue;
                }
                if (!(event.getSharedItem() instanceof IProjectArea) || event.getBeforeState() == null || !this.equalContributors(event.getSharedItem().getModifiedBy(), WorkItemClient.this.fAuditableClient.getUser()) || !((IProjectArea)event.getSharedItem()).isInitialized()) continue;
                projectAreas.add((IProjectAreaHandle)event.getSharedItem().getItemHandle());
            }
            WorkItemClient.this.startSynchronizeConfiguration((Collection)projectAreas);
        }

        private void workItemChanged(ISharedItemChangeEvent event) {
            final IWorkItem beforeState = (IWorkItem)event.getBeforeState();
            final IWorkItem afterState = (IWorkItem)event.getAfterState();
            final IWorkItem sharedItem = (IWorkItem)event.getSharedItem();
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    InternalListener.this.workItemChanged(beforeState, afterState, sharedItem, WorkItemClient.this.fBackgroundEventDispatcher.getProgressMonitor());
                }

                public void handleException(Throwable exception) {
                }
            };
            WorkItemClient.this.fBackgroundEventDispatcher.add(runnable);
        }

        private void workItemChanged(IWorkItem beforeState, IWorkItem afterState, IWorkItem sharedItem, IProgressMonitor monitor) throws TeamRepositoryException {
            if (WorkItemClient.this.fListenerList.isEmpty()) {
                return;
            }
            if (afterState == null) {
                return;
            }
            IProjectAreaHandle afterProjectArea = this.getProjectArea(afterState, monitor);
            ItemHandleAwareHashSet afterHandles = new ItemHandleAwareHashSet();
            afterHandles.addAll(WorkItemClient.this.findBuiltInAttributes(afterProjectArea, monitor));
            if (CUSTOM_ATTRIBUTE_PROFILE.isMatched((IAuditable)afterState)) {
                afterHandles.addAll(afterState.getCustomAttributes());
            }
            ArrayList<IAttribute> afterAttributes = new ArrayList<IAttribute>(WorkItemClient.this.getAuditableCommon().resolveAuditablesPermissionAware(new ArrayList(afterHandles), IAttribute.FULL_PROFILE, monitor));
            WorkItemChangeEvent workItemEvent = new WorkItemChangeEvent(sharedItem);
            if (beforeState == null) {
                for (IAttribute afterAttribute : afterAttributes) {
                    if (!afterState.isAttributeSet(afterAttribute)) continue;
                    this.addChangeDetails(workItemEvent, afterProjectArea, afterAttribute.getIdentifier(), null, 3, monitor);
                }
            } else {
                String identifier;
                IProjectAreaHandle beforeProjectArea = this.getProjectArea(beforeState, monitor);
                ItemHandleAwareHashSet beforeHandles = new ItemHandleAwareHashSet();
                beforeHandles.addAll(WorkItemClient.this.findBuiltInAttributes(beforeProjectArea, monitor));
                if (CUSTOM_ATTRIBUTE_PROFILE.isMatched((IAuditable)beforeState)) {
                    beforeHandles.addAll(beforeState.getCustomAttributes());
                }
                List beforeAttributes = WorkItemClient.this.getAuditableCommon().resolveAuditablesPermissionAware(new ArrayList(beforeHandles), IAttribute.FULL_PROFILE, monitor);
                for (IAttribute beforeAttribute : beforeAttributes) {
                    ChangeDetails changeDetails;
                    identifier = beforeAttribute.getIdentifier();
                    IAttribute afterAttribute = this.findAttribute(afterAttributes, beforeAttribute);
                    if (afterAttribute != null) {
                        afterAttributes.remove(afterAttribute);
                    }
                    if ((changeDetails = this.createChangeDetails(identifier, beforeState, beforeAttribute, afterState, afterAttribute)) == null) continue;
                    this.addChangeDetails(workItemEvent, afterProjectArea, identifier, changeDetails, 2, monitor);
                }
                for (IAttribute afterAttribute : afterAttributes) {
                    identifier = afterAttribute.getIdentifier();
                    ChangeDetails changeDetails = this.createChangeDetails(identifier, beforeState, null, afterState, afterAttribute);
                    if (changeDetails == null) continue;
                    this.addChangeDetails(workItemEvent, afterProjectArea, identifier, changeDetails, 2, monitor);
                }
            }
            WorkItemClient.this.fireWorkItemChanged(workItemEvent);
        }

        private IProjectAreaHandle getProjectArea(IWorkItem state, IProgressMonitor monitor) throws TeamRepositoryException {
            if (state.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY)) {
                return state.getProjectArea();
            }
            IWorkItem resolved = (IWorkItem)WorkItemClient.this.getTeamRepository().itemManager().fetchPartialState((IAuditableHandle)state, Collections.singleton(IWorkItem.PROJECT_AREA_PROPERTY), monitor);
            IProjectAreaHandle projectArea = resolved.getProjectArea();
            boolean isImmutable = state.isImmutable();
            try {
                if (isImmutable) {
                    ((WorkItem)state).setImmutable(false);
                }
                ((WorkItem)state).setProjectArea(projectArea);
            }
            finally {
                if (isImmutable) {
                    ((WorkItem)state).setImmutable(true);
                }
            }
            return projectArea;
        }

        private IAttribute findAttribute(List<IAttribute> afterAttributes, IAttribute beforeAttribute) {
            for (IAttribute afterAttribute : afterAttributes) {
                if (!afterAttribute.getIdentifier().equals(beforeAttribute.getIdentifier()) || !afterAttribute.getAttributeType().equals(beforeAttribute.getAttributeType())) continue;
                return afterAttribute;
            }
            return null;
        }

        private void addChangeDetails(WorkItemChangeEvent workItemEvent, IProjectAreaHandle projectArea, String identifier, ChangeDetails changeDetails, int kind, IProgressMonitor monitor) throws TeamRepositoryException {
            String[] dependents = WorkItemClient.this.findDependents(projectArea, identifier, monitor);
            workItemEvent.addAttributeDetails(identifier, dependents, (IAdaptable)changeDetails, kind);
        }

        private ChangeDetails createChangeDetails(String identifier, IWorkItem beforeState, IAttribute beforeAttribute, IWorkItem afterState, IAttribute afterAttribute) {
            UUID stateId;
            IItem item;
            Object afterValue;
            Object beforeValue = beforeAttribute != null && beforeState.isAttributeSet(beforeAttribute) ? beforeState.getValue(beforeAttribute) : null;
            Object object = afterValue = afterAttribute != null && afterState.isAttributeSet(afterAttribute) ? afterState.getValue(afterAttribute) : null;
            if (beforeValue instanceof IItem) {
                item = (IItem)beforeValue;
                stateId = item.getStateId();
                beforeValue = item.getItemType().createItemHandle(item.getOrigin(), item.getItemId(), stateId);
            }
            if (afterValue instanceof IItem) {
                item = (IItem)afterValue;
                stateId = item.getStateId();
                afterValue = item.getItemType().createItemHandle(item.getOrigin(), item.getItemId(), stateId);
            }
            if (beforeAttribute != null && afterAttribute != null && this.equals(beforeValue, afterValue)) {
                return null;
            }
            return new ChangeDetails(beforeValue, afterValue);
        }

        private boolean equals(Object beforeValue, Object afterValue) {
            if (beforeValue == afterValue) {
                return true;
            }
            if (beforeValue == null) {
                return false;
            }
            if (beforeValue instanceof EObject && afterValue instanceof EObject) {
                return EcoreUtil.equals((EObject)((EObject)beforeValue), (EObject)((EObject)afterValue));
            }
            return beforeValue.equals(afterValue);
        }

        private boolean equalContributors(IContributorHandle left, IContributorHandle right) {
            if (left == right) {
                return true;
            }
            if (left == null) {
                return false;
            }
            return left.sameItemId((IItemHandle)right);
        }
    }
}

