/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.wink.common.internal.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLoader {
    private static final Logger logger = LoggerFactory.getLogger(FileLoader.class);

    protected FileLoader() {
    }

    public static URL loadFile(String fileName) throws FileNotFoundException {
        Enumeration<URL> resources;
        try {
            resources = FileLoader.loadFileUsingClassLoaders(fileName);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new FileNotFoundException(fileName);
        }
        if (!resources.hasMoreElements()) {
            throw new FileNotFoundException(fileName);
        }
        return resources.nextElement();
    }

    public static InputStream loadFileAsStream(String fileName) throws FileNotFoundException {
        Enumeration<URL> resources;
        if (fileName == null || fileName.trim().equals("")) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "fileName"));
        }
        logger.trace("Searching for {} in file system.", (Object)fileName);
        File file = new File(fileName);
        if (file.isFile()) {
            logger.trace("File {} found in file system.", (Object)fileName);
            return new FileInputStream(file);
        }
        try {
            resources = FileLoader.loadFileUsingClassLoaders(fileName);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new FileNotFoundException(fileName);
        }
        if (!resources.hasMoreElements()) {
            throw new FileNotFoundException(fileName);
        }
        URL url = resources.nextElement();
        try {
            return url.openStream();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new FileNotFoundException(fileName);
        }
    }

    public static Enumeration<URL> loadFileUsingClassLoaders(String filename) throws IOException {
        logger.trace("Searching for {} using thread context classloader.", (Object)filename);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = FileLoader.loadFileUsingClassLoader(classLoader, filename);
        if (resources.hasMoreElements()) {
            return resources;
        }
        logger.trace("Searching for {} using current classloader.", (Object)filename);
        classLoader = FileLoader.class.getClassLoader();
        resources = FileLoader.loadFileUsingClassLoader(classLoader, filename);
        if (resources.hasMoreElements()) {
            return resources;
        }
        logger.trace("Searching for {} using system classloader.", (Object)filename);
        return ClassLoader.getSystemResources(filename);
    }

    private static Enumeration<URL> loadFileUsingClassLoader(ClassLoader classLoader, String filename) throws IOException {
        Enumeration<URL> resources = null;
        if (classLoader != null) {
            resources = classLoader.getResources(filename);
        }
        return resources;
    }
}

