/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.util.List;
import java.util.Properties;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.RequestHandler;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateInvocationParametersHandler
implements RequestHandler {
    private static Logger logger = LoggerFactory.getLogger(CreateInvocationParametersHandler.class);

    public void handleRequest(MessageContext context, HandlersChain chain) throws Throwable {
        SearchResult result = context.getAttribute(SearchResult.class);
        List<Injectable> formal = result.getMethod().getMetadata().getFormalParameters();
        logger.trace("Formal Injectable parameters list is: {}", formal);
        Object[] parameters = InjectableFactory.getInstance().instantiate(formal, context);
        if (logger.isTraceEnabled()) {
            if (parameters == null) {
                logger.trace("Actual parameters list to inject is: null");
            } else {
                logger.trace("Actual parameters list to inject is: {}", parameters);
            }
        }
        result.setInvocationParameters(parameters);
        chain.doChain(context);
    }

    public void init(Properties props) {
    }
}

