/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IApplyAcceptedOperation;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IMarkAsMergedOperation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.checkin.NewCheckInOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.loadRules.SandboxExaminer;
import com.ibm.team.filesystem.client.internal.load.loadRules.SandboxExaminerDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.AbortPortsOperation;
import com.ibm.team.filesystem.client.internal.operations.ApplyAcceptedOperation;
import com.ibm.team.filesystem.client.internal.operations.AutoResolveOperation;
import com.ibm.team.filesystem.client.internal.operations.ChangeExtendedPropertiesOperation;
import com.ibm.team.filesystem.client.internal.operations.ChangePropertiesOperation;
import com.ibm.team.filesystem.client.internal.operations.CloseChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.CompleteCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.CreateBaselineOperation;
import com.ibm.team.filesystem.client.internal.operations.CreateCurrentPatchOperation;
import com.ibm.team.filesystem.client.internal.operations.CreateSnapshotOperation;
import com.ibm.team.filesystem.client.internal.operations.DeleteInRepositoryOperation;
import com.ibm.team.filesystem.client.internal.operations.DeliverOperation;
import com.ibm.team.filesystem.client.internal.operations.DiscardOperation;
import com.ibm.team.filesystem.client.internal.operations.IUpdateSubcomponentOperation;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.internal.operations.MarkAsMergedOperation;
import com.ibm.team.filesystem.client.internal.operations.MoveFoldersOperation;
import com.ibm.team.filesystem.client.internal.operations.ProcessPendingPortsOperation;
import com.ibm.team.filesystem.client.internal.operations.SuspendOperation;
import com.ibm.team.filesystem.client.internal.operations.SynchronizeOperation;
import com.ibm.team.filesystem.client.internal.operations.TransferLockOperation;
import com.ibm.team.filesystem.client.internal.operations.UnlockOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateSubcomponentOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.internal.share.ShareOperation;
import com.ibm.team.filesystem.client.internal.share.UnshareOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.AbortCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangeExtendedPropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CloseChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CompleteCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateSnapshotDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAbortCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IChangeExtendedPropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICloseChangeSetsOperation;
import com.ibm.team.filesystem.client.operations.ICompleteCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.ICreateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.ICreateSnapshotOperation;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.IMetadataRepairOperation;
import com.ibm.team.filesystem.client.operations.IMetadataSynchronizeOperation;
import com.ibm.team.filesystem.client.operations.IMetadataValidateOperation;
import com.ibm.team.filesystem.client.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.client.operations.IProcessAcceptQueueOperation;
import com.ibm.team.filesystem.client.operations.IResumeOperation;
import com.ibm.team.filesystem.client.operations.ISandboxExaminerOperation;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.ITransferLockOperation;
import com.ibm.team.filesystem.client.operations.IUnlockOperation;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MetadataRepairDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OperationOptions;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ProcessAcceptQueueDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ResumeDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OperationFactory
implements IOperationFactory {
    private static OperationFactory operationFactory;
    private OperationOptions options = new OperationOptions();

    public static IOperationFactory getInstance() {
        if (operationFactory == null) {
            operationFactory = new OperationFactory();
        }
        return operationFactory;
    }

    private OperationFactory() {
    }

    public void setOperationOptions(OperationOptions newOptions) {
        this.options = newOptions == null ? new OperationOptions() : newOptions;
    }

    @Override
    public OperationOptions getOperationOptions() {
        return this.options;
    }

    private <T extends IFileSystemOperation> T configure(T object) {
        if (this.options != null) {
            this.options.configureOperation(object);
        }
        return object;
    }

    @Override
    public IVerifyInSyncOperation getVerifyInSyncOperation(OutOfSyncDilemmaHandler dilemmaHandler) {
        return this.configure(new VerifySharesOperation(dilemmaHandler));
    }

    @Override
    public ILoadOperation getLoadOperation(LoadDilemmaHandler dilemmaHandler) {
        return this.configure(new LoadOperation(dilemmaHandler));
    }

    @Override
    public IShareOperation getShareOperation(ShareDilemmaHandler dilemmaHandler) {
        return this.configure(new ShareOperation(dilemmaHandler));
    }

    @Override
    public IUnshareOperation getUnshareOperation(UnshareDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        return this.configure(new UnshareOperation(dilemmaHandler, resolver));
    }

    @Override
    public ICheckinOperation getCheckinOperation(CommitDilemmaHandler problemHandler, IRepositoryResolver resolver) {
        return this.configure(new NewCheckInOperation(problemHandler, resolver));
    }

    @Override
    public IDeliverOperation getDeliverOperation(DeliverDilemmaHandler dilemmaHandler) {
        return this.configure(new DeliverOperation(dilemmaHandler));
    }

    @Override
    public IChangePropertiesOperation getChangePropertiesOperation(ChangePropertiesDilemmaHandler dilemmaHandler) {
        return this.configure(new ChangePropertiesOperation(dilemmaHandler));
    }

    @Override
    public IChangeExtendedPropertiesOperation getChangeExtendedPropertiesOperation(ChangeExtendedPropertiesDilemmaHandler dilemmaHandler) {
        return this.configure(new ChangeExtendedPropertiesOperation(dilemmaHandler));
    }

    @Override
    public ICreateBaselineOperation getCreateBaselineOperation(CreateBaselineDilemmaHandler dilemmaHandler) {
        return this.configure(new CreateBaselineOperation(dilemmaHandler));
    }

    @Override
    public ICreateSnapshotOperation getCreateSnapshotOperation(CreateSnapshotDilemmaHandler dilemmaHandler) {
        return this.configure(new CreateSnapshotOperation(dilemmaHandler));
    }

    @Override
    public IWorkspaceUpdateOperation getWorkspaceUpdateOperation(WorkspaceUpdateDilemmaHandler dilemmaHandler) {
        return this.configure(new WorkspaceUpdateOperation(dilemmaHandler));
    }

    @Override
    public IAutoResolveConflictsOperation getAutoResolveConflictsOperation(AutoResolveConflictsDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        return this.configure(new AutoResolveOperation(dilemmaHandler, resolver));
    }

    @Override
    public IApplyAcceptedOperation getApplyAcceptedOperation(ApplyAcceptedDilemmaHandler dilemmaHandler) {
        return this.configure(new ApplyAcceptedOperation(dilemmaHandler));
    }

    @Override
    public IMarkAsMergedOperation getMarkAsMergedOperation(MarkAsMergedDilemmaHandler dilemmaHandler) {
        return this.configure(new MarkAsMergedOperation(dilemmaHandler));
    }

    @Override
    public IMoveFoldersOperation getMoveFoldersOperation(MoveFoldersDilemmaHandler dilemmaHandler) {
        return this.configure(new MoveFoldersOperation(dilemmaHandler));
    }

    @Override
    public IDeleteFoldersOperation getDeleteFoldersOperation(CommitDilemmaHandler dilemmaHandler) {
        return this.configure(new DeleteInRepositoryOperation(dilemmaHandler));
    }

    @Override
    public ILockOperation getLockOperation(LockDilemmaHandler dilemmaHandler) {
        return this.configure(new LockOperation(dilemmaHandler));
    }

    @Override
    public ITransferLockOperation getTransferLockOperation(LockDilemmaHandler dilemmaHandler) {
        return this.configure(new TransferLockOperation(dilemmaHandler));
    }

    @Override
    public IUnlockOperation getUnlockOperation(LockDilemmaHandler dilemmaHandler) {
        return this.configure(new UnlockOperation(dilemmaHandler));
    }

    @Override
    public ISuspendOperation getSuspendOperation(SuspendDilemmaHandler dilemmaHandler) {
        return this.configure(new SuspendOperation(dilemmaHandler));
    }

    @Override
    public IResumeOperation getResumeOperation(ResumeDilemmaHandler dilemmaHandler) {
        final ResumeDilemmaHandler dh = dilemmaHandler == null ? ResumeDilemmaHandler.getDefault() : dilemmaHandler;
        return this.configure(new WorkspaceUpdateOperation(new WorkspaceUpdateDilemmaHandler(){

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return dh.getBackupDilemmaHandler();
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return dh.getCommitDilemmaHandler();
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return dh.getOutOfSyncDilemmaHandler();
            }

            @Override
            public UpdateCurrentPatchDilemmaHandler getUpdateCurrentPortDilemmaHandler() {
                return dh.getUpdateCurrentPortDilemmaHandler();
            }

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
                return dh.uncheckedInChanges(changes);
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return dh.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return dh.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return dh.siblingSharesToAdd(shareables);
            }

            @Override
            public int disconnectedComponents(Collection<ConfigurationFacade> configurations) {
                return 0;
            }

            @Override
            public int gap(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsWithGap, boolean handlingSuspended) {
                return dh.gap(workspace, changeSetsWithGap);
            }

            @Override
            public int portInProgress(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSets) {
                return dh.portInProgress(workspace, changeSets);
            }

            @Override
            public int activeChangeSetsOverlap(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> activeChangeSets) {
                return dh.activeChangeSetsOverlap(workspace, activeChangeSets);
            }

            @Override
            public void locksWereHeld(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                dh.locksWereHeld(locks);
            }

            @Override
            public Map<IStreamLockReport, IWorkspaceConnection> locksToAcquire(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                return dh.locksToAcquire(locks);
            }
        }));
    }

    @Override
    public IDiscardOperation getDiscardOperation(DiscardDilemmaHandler dilemmaHandler) {
        return this.configure(new DiscardOperation(dilemmaHandler));
    }

    @Override
    public IMetadataRepairOperation getMetadataRepairOperation(ILocation root, MetadataRepairDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        return this.configure(CopyFileAreaManager.instance.getMetadataRepairOperation(root, dilemmaHandler, resolver));
    }

    @Override
    public IMetadataSynchronizeOperation getMetadataSynchronizeOperation(IRepositoryResolver resolver) {
        return this.configure(new SynchronizeOperation(resolver));
    }

    @Override
    public IMetadataValidateOperation getMetadataValidateOperation(ILocation root) {
        return this.configure(CopyFileAreaManager.instance.getMetadataValidateOperation(root));
    }

    @Override
    public ISandboxExaminerOperation getSandboxExaminerOperation(SandboxExaminerDilemmaHandler dilemmaHandler) {
        return new SandboxExaminer(dilemmaHandler);
    }

    @Override
    public IAbortCurrentPatchOperation getAbortCurrentPatchOperation(AbortCurrentPatchDilemmaHandler dilemmaHandler) {
        return this.configure(new AbortPortsOperation(dilemmaHandler));
    }

    @Override
    public IUpdateCurrentPatchOperation getUpdateCurrentPortOperation(UpdateCurrentPatchDilemmaHandler dilemmaHandler) {
        return this.configure(new UpdateCurrentPortOperation(dilemmaHandler));
    }

    @Override
    public ICompleteCurrentPatchOperation getCompleteCurrentPatchOperation(CompleteCurrentPatchDilemmaHandler dilemmaHandler) {
        return this.configure(new CompleteCurrentPortOperation(dilemmaHandler));
    }

    @Override
    public IProcessAcceptQueueOperation getProcessAcceptQueueOperation(ProcessAcceptQueueDilemmaHandler dilemmaHandler) {
        return this.configure(new ProcessPendingPortsOperation(dilemmaHandler));
    }

    @Override
    public ICloseChangeSetsOperation getCloseChangeSetsOperation(CloseChangeSetsDilemmaHandler dilemmaHandler) {
        return this.configure(new CloseChangeSetsOperation(dilemmaHandler));
    }

    @Override
    public ICreateCurrentPatchOperation getCreateCurrentPatchOperation(CreateCurrentPatchDilemmaHandler dilemmaHandler) {
        return this.configure(new CreateCurrentPatchOperation(dilemmaHandler));
    }

    @Override
    public IUpdateSubcomponentOperation getUpdateSubcomponentOperation(UpdateDilemmaHandler dilemmaHandler) {
        return this.configure(new UpdateSubcomponentOperation(dilemmaHandler));
    }
}

