/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.IUnmodifiedInfo;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.ISandboxListener;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.client.internal.IStorageManager;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.RestoreVersionableOperation;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.StorageManager;
import com.ibm.team.filesystem.client.internal.UnmodifiedInfo;
import com.ibm.team.filesystem.client.internal.api.storage.IBackupHandler;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.operations.ILoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.operations.IUpdateMutator;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class SharingManager
implements ISharingManager {
    public static final int NONE = 0;
    public static final int OVERWRITE = 1;
    public static final int UPDATE = 2;
    public static final int LOAD_CHANGES = 4;
    private static final ThreadLocal changeMonitoring = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };
    protected static volatile SharingManager instance;
    public static final String PT_SHARING_MANAGER = "sharingManager";
    public static final String PT_CONTENT_EXAMINER = "contentExaminer";
    public static final String PT_STORAGE_MANAGER = "storageManager";
    private Map<String, IStorageManager> storageManagers = null;
    private final Set<ISandboxListener> listeners = Collections.synchronizedSet(new HashSet());
    private final Set<ILocation> sandboxesWithListener = Collections.synchronizedSet(new HashSet());
    private Object sandboxListeningEnabledLock = new Object();
    private volatile boolean sandboxListeningEnabled = false;

    private static SharingManager doGetInstance() {
        IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_SHARING_MANAGER);
        if (configs.length > 1) {
            throw new IllegalStateException("Only one sharing manager implementation can be registered");
        }
        if (configs.length == 1) {
            try {
                return (SharingManager)configs[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                LoggingHelper.log(e);
            }
        }
        return new SharingManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharingManager getInstance() {
        SharingManager sm = instance;
        if (sm != null) return sm;
        Class<SharingManager> clazz = SharingManager.class;
        synchronized (SharingManager.class) {
            sm = instance;
            if (sm != null) return sm;
            instance = sm = SharingManager.doGetInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sm;
        }
    }

    protected SharingManager() {
    }

    @Override
    public final void addListener(ICopyFileAreaListener listener) {
        ICopyFileAreaManager.instance.addListener(listener);
    }

    @Override
    public final void removeListener(ICopyFileAreaListener listener) {
        ICopyFileAreaManager.instance.removeListener(listener);
    }

    public final Map<String, ILoadEvaluator> getLoadEvaluators(Collection<ISandbox> sandboxes) {
        Map<String, ILoadEvaluator> result = null;
        if (sandboxes.size() == 1) {
            ISandbox entry = sandboxes.iterator().next();
            result = Collections.singletonMap(entry.getRoot().getStorageId(), this.getStorageManager(entry.getRoot()).getLoadEvaluator());
        } else {
            result = new HashMap<String, ILoadEvaluator>();
            for (ISandbox entry : sandboxes) {
                String storageId = entry.getRoot().getStorageId();
                if (result.containsKey(storageId)) continue;
                result.put(storageId, this.getStorageManager(entry.getRoot()).getLoadEvaluator());
            }
        }
        return result;
    }

    public final ILoadMutator getLoadMutator(ISandbox sandbox, LoadDilemmaHandler loadProblemHandler) {
        return this.getStorageManager(sandbox.getRoot()).getLoadMutator(sandbox, loadProblemHandler);
    }

    public final IShare[] allShares(ILocation copyFileAreaRoot, IProgressMonitor monitor) throws FileSystemException {
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (cfaMgr.copyFileAreaExists(copyFileAreaRoot, 1)) {
            AbstractLock lock = CFALockUtil.createAndLockForReading(copyFileAreaRoot, true, (IProgressMonitor)progress.newChild(1));
            try {
                Collection<IShare> shares = cfaMgr.getExistingCopyFileArea(copyFileAreaRoot).allShares();
                IShare[] iShareArray = shares.toArray(new IShare[shares.size()]);
                return iShareArray;
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                progress.done();
            }
        }
        progress.done();
        return new IShare[0];
    }

    @Override
    public final IShare[] allShares(IProgressMonitor monitor) throws FileSystemException {
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        Collection<ICopyFileArea> copyFileAreas = cfaMgr.getAllCopyFileAreas();
        ArrayList<IShare> shares = new ArrayList<IShare>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(2);
            AbstractLock lock = CFALockUtil.lockExistingForRead(cfa.getRoot(), (IProgressMonitor)subProgress.newChild(1));
            if (lock == null) continue;
            try {
                shares.addAll(ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot()).allShares());
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)subProgress.newChild(1));
            }
        }
        return shares.toArray(new IShare[shares.size()]);
    }

    public final IShare[] allShares(ILocation copyFileAreaRoot, IContextHandle context, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (cfaMgr.copyFileAreaExists(copyFileAreaRoot, 1)) {
            AbstractLock lock = CFALockUtil.createAndLockForReading(copyFileAreaRoot, true, (IProgressMonitor)progress.newChild(1));
            try {
                Collection<IShare> shares = cfaMgr.getExistingCopyFileArea(copyFileAreaRoot).allShares(context, component, (IProgressMonitor)progress.newChild(98));
                IShare[] iShareArray = shares.toArray(new IShare[shares.size()]);
                return iShareArray;
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                progress.done();
            }
        }
        progress.done();
        return new IShare[0];
    }

    public final IShare[] allShares(ILocation copyFileAreaRoot, IContextHandle context, IProgressMonitor monitor) throws FileSystemException {
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        if (context == null) {
            throw new IllegalArgumentException();
        }
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (cfaMgr.copyFileAreaExists(copyFileAreaRoot, 1)) {
            AbstractLock lock = CFALockUtil.createAndLockForReading(copyFileAreaRoot, true, (IProgressMonitor)progress.newChild(1));
            try {
                Collection<IShare> shares = cfaMgr.getExistingCopyFileArea(copyFileAreaRoot).allShares();
                ArrayList<IShare> filtered = new ArrayList<IShare>();
                for (IShare share : shares) {
                    if (!context.sameItemId((IItemHandle)share.getSharingDescriptor().getConnectionHandle())) continue;
                    filtered.add(share);
                }
                IShare[] iShareArray = filtered.toArray(new IShare[filtered.size()]);
                return iShareArray;
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                progress.done();
            }
        }
        progress.done();
        return new IShare[0];
    }

    public final Shareable findShareable(ISandbox sandbox, IRelativeLocation path, ResourceType resourceTypeHint) {
        return new Shareable(sandbox, path, resourceTypeHint);
    }

    public final IShareable findShareable(ILocation copyFileAreaRoot, IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (cfaMgr.copyFileAreaExists(copyFileAreaRoot, 1)) {
            AbstractLock lock = CFALockUtil.createAndLockForUpdate(copyFileAreaRoot, connection, component, (IProgressMonitor)progress.newChild(1));
            try {
                ICopyFileArea cfa = cfaMgr.getExistingCopyFileArea(copyFileAreaRoot);
                IRelativeLocation path = cfa.getLocalPathFor(connection, component, versionable, (IProgressMonitor)progress.newChild(98));
                if (path != null) {
                    Shareable shareable = new Shareable(copyFileAreaRoot, path, ResourceType.getResourceType(versionable));
                    return shareable;
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                progress.done();
            }
        }
        progress.done();
        return null;
    }

    @Override
    public final Collection<IShareable> findShareables(IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor progress) throws FileSystemException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ArrayList<IShareable> result = new ArrayList<IShareable>();
        Collection<ICopyFileArea> allCopyFileAreas = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)allCopyFileAreas.size());
        for (ICopyFileArea cfa : allCopyFileAreas) {
            SubMonitor subProgress = monitor.newChild(1);
            subProgress.setWorkRemaining(100);
            AbstractLock lock = CFALockUtil.lockExistingForUpdate(cfa.getRoot(), connection, component, (IProgressMonitor)subProgress.newChild(1));
            if (lock == null) continue;
            try {
                cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot());
                IRelativeLocation path = cfa.getLocalPathFor(connection, component, versionable, (IProgressMonitor)subProgress.newChild(98));
                if (path == null) continue;
                result.add(new Shareable(cfa.getRoot(), path, ResourceType.getResourceType(versionable)));
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)subProgress.newChild(1));
            }
        }
        return result;
    }

    @Override
    public final IShareable findShareable(ILocation fullPath, ResourceType resourceTypeHint) {
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(fullPath);
        if (cfa != null) {
            ILocation cfaPath = cfa.getRoot();
            IRelativeLocation relativePath = fullPath.getLocationRelativeTo(cfaPath);
            return new Shareable(cfaPath, relativePath, resourceTypeHint);
        }
        return null;
    }

    public final IShare getShare(ILocation cfaRoot, IRelativeLocation path, IProgressMonitor monitor) throws FileSystemException {
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(cfaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            progress.done();
            return null;
        }
        try {
            ICopyFileArea cfa = cfaMgr.getExistingCopyFileArea(cfaRoot);
            IShare result = cfa.getShare(path);
            progress.worked(98);
            IShare iShare = result;
            return iShare;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public final IShare getShare(ILocation cfaRoot, IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(cfaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            progress.done();
            return null;
        }
        try {
            IShare result;
            ICopyFileArea cfa = cfaMgr.getExistingCopyFileArea(cfaRoot);
            IShare iShare = result = cfa.getShare(connection, component, versionable, (IProgressMonitor)progress.newChild(98));
            return iShare;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IShare share(IShareableInternal shareable, ISharingDescriptor descriptor, FileItemInfo fileItemInfo, MetadataProperties properties, int options, IProgressMonitor monitor) throws FileSystemException {
        IFileStorage fileStorage;
        boolean caseSensitive;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IRelativeLocation sharePath = shareable.getLocalPath();
        if (!descriptor.getRootVersionable().hasStateId()) {
            throw new IllegalArgumentException(sharePath + " cannot be shared. Root has no state id");
        }
        int cfaOptions = 0;
        if ((options & 1) == 1) {
            cfaOptions |= 1;
        } else if ((options & 2) == 2) {
            cfaOptions |= 2;
        }
        ICopyFileArea.PropertyUpdate direction = properties == null ? ICopyFileArea.PropertyUpdate.PRESERVE : ICopyFileArea.PropertyUpdate.REPLACE;
        ILocation cfaRoot = shareable.getSandbox().getRoot();
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, true, (IProgressMonitor)progress.newChild(1));
        try {
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            cfaRoot = copyFileArea.getRoot();
            copyFileArea.share(shareable.getLocalPath(), descriptor, fileItemInfo, direction, properties, cfaOptions, (IProgressMonitor)progress.newChild(13));
            caseSensitive = copyFileArea.isCaseSensitive();
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
        Share share = new Share(cfaRoot, sharePath, caseSensitive, descriptor);
        if ((options & 4) == 4 && this.isChangeMonitoringEnabled()) {
            LocalChangeManager.getInstance().loadChanges(share, (IProgressMonitor)progress.newChild(70));
        }
        if ((fileStorage = shareable.getFileStorage()) != null) {
            fileStorage.registerRepositorProvider((IProgressMonitor)progress.newChild(15));
        }
        ISandboxListener listener = this.getSandboxListener(cfaRoot);
        Set<ILocation> set = this.sandboxesWithListener;
        synchronized (set) {
            if (listener != null && this.sandboxesWithListener.contains(cfaRoot)) {
                try {
                    listener.addShare(share.getSandbox().getRoot(), share.getPath());
                }
                catch (CoreException e) {
                    LoggingHelper.log(e);
                }
            }
        }
        progress.done();
        return share;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISandboxListener getSandboxListener(ILocation cfaRoot) {
        IStorageManager stgManager = this.getStorageManager(cfaRoot);
        ISandboxListener listener = stgManager.getSandboxListener();
        if (listener == null) {
            return null;
        }
        Set<ISandboxListener> set = this.listeners;
        synchronized (set) {
            block10: {
                if (!this.listeners.contains(listener)) {
                    try {
                        try {
                            listener.init();
                        }
                        catch (CoreException e) {
                            LoggingHelper.log(e);
                            this.listeners.add(listener);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        this.listeners.add(listener);
                        throw throwable;
                    }
                    this.listeners.add(listener);
                }
            }
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutDown() throws FileSystemException {
        Set<ILocation> set = this.sandboxesWithListener;
        synchronized (set) {
            Set<ISandboxListener> set2 = this.listeners;
            synchronized (set2) {
                for (ISandboxListener listener : this.listeners) {
                    try {
                        listener.dispose();
                    }
                    catch (CoreException e) {
                        LoggingHelper.log(e);
                    }
                }
                this.listeners.clear();
            }
            this.sandboxesWithListener.clear();
        }
    }

    public static void conditionalShutDown() throws FileSystemException {
        SharingManager sm = instance;
        if (sm != null) {
            sm.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forget(IShareableInternal shareable, IProgressMonitor monitor) throws FileSystemException {
        boolean unshare;
        SubMonitor progress;
        block12: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            AbstractLock lock = CFALockUtil.createAndLockForUpdate(shareable.getSandbox().getRoot(), shareable.getLocalPath(), true, (IProgressMonitor)progress.newChild(1));
            if (lock == null) {
                return;
            }
            try {
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
                shareable.getShare((IProgressMonitor)progress.newChild(10));
                unshare = cfa.forget(shareable.getLocalPath(), (IProgressMonitor)progress.newChild(60));
                if (!unshare) break block12;
                ILocation cfaRoot = cfa.getRoot();
                ISandboxListener listener = this.getSandboxListener(cfaRoot);
                Set<ILocation> set = this.sandboxesWithListener;
                synchronized (set) {
                    if (listener != null && this.sandboxesWithListener.contains(cfaRoot)) {
                        Collection<IRelativeLocation> allSharePaths = ((CopyFileArea)cfa).allSharePaths(shareable.getLocalPath());
                        ArrayList<IRelativeLocation> allShareRoots = new ArrayList<IRelativeLocation>();
                        allShareRoots.addAll(allSharePaths);
                        Collections.sort(allShareRoots, new Comparator<IRelativeLocation>(){

                            @Override
                            public int compare(IRelativeLocation location1, IRelativeLocation location2) {
                                return location2.segmentCount() - location1.segmentCount();
                            }
                        });
                        for (IRelativeLocation location : allShareRoots) {
                            IShare localShare = cfa.getShare(location);
                            IShareable shareable2 = localShare.getShareable();
                            ResourceType type = shareable2.getResourceType((IProgressMonitor)progress.newChild(4));
                            if (type != ResourceType.FOLDER) continue;
                            try {
                                listener.removeShare(shareable2.getSandbox().getRoot(), localShare.getPath());
                            }
                            catch (CoreException e) {
                                LoggingHelper.log(e);
                            }
                        }
                    }
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
        if (unshare) {
            IFileStorage fileStorage = shareable.getFileStorage();
            fileStorage.deregisterRepositoryProvider((IProgressMonitor)progress.newChild(25));
        }
        progress.done();
    }

    public final boolean isConnectionShared(ILocation copyFileAreaRoot, IContextHandle connection, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(copyFileAreaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            progress.done();
            return false;
        }
        try {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            boolean result = cfa.isConnectionShared(connection);
            progress.worked(98);
            boolean bl = result;
            return bl;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public final void disableChangeMonitoring() {
        changeMonitoring.set(new Integer((Integer)changeMonitoring.get() + 1));
    }

    public final void enableChangeMonitoring() {
        int level = (Integer)changeMonitoring.get();
        if (level == 0) {
            throw new IllegalStateException();
        }
        changeMonitoring.set(new Integer(level - 1));
    }

    public final boolean isChangeMonitoringEnabled() {
        return (Integer)changeMonitoring.get() == 0;
    }

    @Override
    public final ILocalChangeManager getLocalChangeManager() {
        return LocalChangeManager.getInstance();
    }

    public final ILocalChange getChange(Shareable shareable, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        if (shareable.shouldBeIgnored((IProgressMonitor)monitor.newChild(1))) {
            monitor.done();
            return null;
        }
        ILocalChange pendingChange = LocalChangeManager.getInstance().getPendingChange(shareable, (IProgressMonitor)monitor.newChild(1));
        return pendingChange == null ? NoOpChange.NO_OP : pendingChange;
    }

    public final void doSilentChange(FileSystemRunnable runnable) throws TeamRepositoryException {
        SharingManager.getInstance().disableChangeMonitoring();
        try {
            runnable.run();
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    public final void doSilentChange(FileSystemAccessor runnable) throws FileSystemException {
        SharingManager.getInstance().disableChangeMonitoring();
        try {
            runnable.run();
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    @Override
    public final Collection<IShareable> findShareables(IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        Collection<ICopyFileArea> copyFileAreas = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(100);
            AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate(cfa.getRoot(), (IProgressMonitor)subProgress.newChild(1));
            if (lock == null) continue;
            try {
                cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot());
                Collection<IRelativeLocation> paths = cfa.getLocalPathsFor(versionable, (IProgressMonitor)progress.newChild(97));
                shareables.addAll(this.getShareablesForPaths(cfa.getRoot(), paths, versionable, (IProgressMonitor)progress.newChild(1)));
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)subProgress.newChild(1));
            }
        }
        progress.done();
        return shareables;
    }

    @Override
    public final Collection<IShareable> findShareables(IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        Collection<ICopyFileArea> copyFileAreas = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(100);
            AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate(cfa.getRoot(), (IProgressMonitor)subProgress.newChild(1));
            if (lock == null) continue;
            try {
                cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot());
                Collection<IRelativeLocation> paths = cfa.getLocalPathsFor(component, versionable, (IProgressMonitor)subProgress.newChild(97));
                shareables.addAll(this.getShareablesForPaths(cfa.getRoot(), paths, versionable, (IProgressMonitor)progress.newChild(1)));
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)subProgress.newChild(1));
            }
        }
        progress.done();
        return shareables;
    }

    private List getShareablesForPaths(ILocation copyFileAreaRoot, Collection<IRelativeLocation> paths, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)paths.size());
        ArrayList<Shareable> shareables = new ArrayList<Shareable>(paths.size());
        ResourceType type = ResourceType.getResourceType(item);
        for (IRelativeLocation path : paths) {
            Shareable shareable = new Shareable(copyFileAreaRoot, path, type);
            IFileStorage storage = shareable.getFileStorage();
            if (storage.getResourceType((IProgressMonitor)progress.newChild(1)) != type) continue;
            shareables.add(shareable);
        }
        return shareables;
    }

    public final IUpdateMutator[] getUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport2 updates, Collection<IItemUpdateReport> rawUpdates, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler dilemmaHandler, IDownloadListener downloadMonitor) {
        if (copyFileAreasToUpdate.size() == 1) {
            ICopyFileArea cfa = copyFileAreasToUpdate.iterator().next();
            IStorageManager stgManger = this.getStorageManager(cfa.getRoot());
            return new IUpdateMutator[]{stgManger.getUpdateMutator(connection, componentStatesBefore, componentStatesAfter, updates, rawUpdates, copyFileAreasToUpdate, dilemmaHandler, downloadMonitor)};
        }
        ArrayList<IUpdateMutator> mutators = new ArrayList<IUpdateMutator>(2);
        HashMap<String, ArrayList<ICopyFileArea>> storageTypes = new HashMap<String, ArrayList<ICopyFileArea>>();
        for (ICopyFileArea iCopyFileArea : copyFileAreasToUpdate) {
            ArrayList<ICopyFileArea> cfas = (ArrayList<ICopyFileArea>)storageTypes.get(iCopyFileArea.getRoot().getStorageId());
            if (cfas == null) {
                cfas = new ArrayList<ICopyFileArea>();
                storageTypes.put(iCopyFileArea.getRoot().getStorageId(), cfas);
            }
            cfas.add(iCopyFileArea);
        }
        for (Map.Entry entry : storageTypes.entrySet()) {
            mutators.add(this.getStorageManager((String)entry.getKey()).getUpdateMutator(connection, componentStatesBefore, componentStatesAfter, updates, rawUpdates, (Collection)entry.getValue(), dilemmaHandler, downloadMonitor));
        }
        return mutators.toArray(new IUpdateMutator[mutators.size()]);
    }

    public final IIgnoreManager getIgnoreManager() {
        return IgnoreManager.getInstance();
    }

    public void addListener(ICorruptCopyFileAreaListener listener) {
        ICopyFileAreaManager.instance.addCorruptionListener(listener);
    }

    public void removeListener(ICorruptCopyFileAreaListener listener) {
        ICopyFileAreaManager.instance.removeCorruptionListener(listener);
    }

    public ISchedulingRule getTrackingRule(ILocation path) {
        return null;
    }

    public void runWithinFileSystemLock(IRunnableWithProgress runnableWithProgress, ISchedulingRule IDErule, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        runnableWithProgress.run(monitor);
    }

    public List<IRelativeLocation> getPathRelativeToShares(ILocation copyFileAreaRoot, IContextHandle context, IComponentHandle component, List<List<INameItemPair>> ancestorReports, IProgressMonitor progress) throws FileSystemException {
        Collection<IShare> shares;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IRelativeLocation> result = new ArrayList<IRelativeLocation>(ancestorReports.size());
        AbstractLock lock = CFALockUtil.lockExistingForRead(copyFileAreaRoot, (IProgressMonitor)monitor.newChild(1));
        if (lock == null) {
            monitor.done();
            Iterator<List<INameItemPair>> iterator = ancestorReports.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                result.add(null);
            }
            return result;
        }
        try {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            shares = cfa.allShares();
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
        }
        HashMap<UUID, IRelativeLocation> shareRoots = new HashMap<UUID, IRelativeLocation>();
        for (IShare iShare : shares) {
            ISharingDescriptor descriptor = iShare.getSharingDescriptor();
            if (!descriptor.getConnectionHandle().sameItemId((IItemHandle)context) || !descriptor.getComponent().sameItemId((IItemHandle)component)) continue;
            IRelativeLocation sharePath = iShare.getPath();
            shareRoots.put(descriptor.getRootVersionable().getItemId(), sharePath);
        }
        for (List list : ancestorReports) {
            boolean shareRootFound = false;
            IRelativeLocation path = null;
            if (!shareRoots.isEmpty()) {
                for (INameItemPair pair : list) {
                    if (shareRootFound) {
                        path = path.append(pair.getName());
                        continue;
                    }
                    IRelativeLocation sharePath = (IRelativeLocation)shareRoots.get(pair.getItem().getItemId());
                    if (sharePath == null) continue;
                    shareRootFound = true;
                    path = sharePath;
                }
            }
            result.add(path);
        }
        monitor.done();
        return result;
    }

    @Override
    public void restoreFile(IShareable file, InputStream in, FileLineDelimiter lineDelimeterExpected, String encodingExpected, Map<String, String> properties, IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemException, IOException {
        RestoreVersionableOperation.restoreFile(file, in, new FileOptions(false, lineDelimeterExpected, encodingExpected, properties), handle, monitor);
    }

    @Override
    public void restoreFolder(IShareable folder, Map<String, String> properties, IFolderHandle handle, IProgressMonitor monitor) throws FileSystemException {
        RestoreVersionableOperation.restoreFolder(folder, properties, handle, monitor);
    }

    @Override
    public void restoreLink(IShareable shareable, String target, boolean isDirectory, Map<String, String> properties, ISymbolicLinkHandle handle, IProgressMonitor monitor) throws FileSystemException {
        RestoreVersionableOperation.restoreLink(shareable, target, isDirectory, properties, handle, monitor);
    }

    public ILocation getIDEWorkAreaRoot() {
        return null;
    }

    @Override
    public Collection<ISandbox> getRegisteredSandboxes() {
        Collection<ICopyFileArea> allCFA = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        ArrayList<ISandbox> result = new ArrayList<ISandbox>(allCFA.size());
        for (ICopyFileArea cfa : allCFA) {
            result.add(new Sandbox(cfa));
        }
        return result;
    }

    @Override
    public boolean isConnectionShared(IContextHandle connection) throws FileSystemException {
        return ICopyFileAreaManager.instance.isConnectionShared(connection);
    }

    public boolean isConfigurationShared(ISandbox sandbox, ConfigurationFacade configuration, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(sandbox.getRoot(), (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            return false;
        }
        try {
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(sandbox.getRoot());
            boolean bl = copyFileArea.isConfigurationShared(configuration.getConnectionHandle(), configuration.getComponentHandle(), (IProgressMonitor)progress.newChild(98));
            return bl;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
    }

    public final void resolveFileStorage(FileStorageWrapper storage, ResourceType resourceTypeHint) {
        ISandbox sandbox = storage.getShareable().getSandbox();
        this.getStorageManager(sandbox.getRoot()).resolveFileStorage(storage, resourceTypeHint);
    }

    public final IFileStorage getLocalFileStorage(ISandbox sandbox, IRelativeLocation localPath, ResourceType resourceTypeHint) {
        Shareable shareable = new Shareable(sandbox, localPath, resourceTypeHint);
        IFileStorage storage = shareable.getFileStorage();
        LocalFileStorage.resolveLocalFileStorage((FileStorageWrapper)storage, resourceTypeHint);
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(ILocation copyFileAreaRoot, IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle item, IProgressMonitor progress) throws FileSystemException {
        IFileStorage fileStorage;
        boolean unshared;
        IShareable shareable;
        SubMonitor monitor;
        block10: {
            monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            AbstractLock lock = CFALockUtil.createAndLockForUpdate(copyFileAreaRoot, connectionHandle, component, (IProgressMonitor)monitor.newChild(1));
            try {
                ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
                shareable = this.findShareable(copyFileAreaRoot, connectionHandle, component, item, (IProgressMonitor)monitor.newChild(80));
                IShare share = shareable != null ? shareable.getShare((IProgressMonitor)monitor.newChild(10)) : null;
                unshared = copyFileArea.forget(connectionHandle, component, item, (IProgressMonitor)monitor);
                if (!unshared || shareable == null || !shareable.isShare((IProgressMonitor)monitor.newChild(2))) break block10;
                ISandboxListener listener = this.getSandboxListener(copyFileAreaRoot);
                Set<ILocation> set = this.sandboxesWithListener;
                synchronized (set) {
                    ResourceType type;
                    if (listener != null && this.sandboxesWithListener.contains(copyFileAreaRoot) && (type = shareable.getResourceType((IProgressMonitor)monitor.newChild(1))) == ResourceType.FOLDER) {
                        try {
                            listener.removeShare(copyFileAreaRoot, share.getPath());
                        }
                        catch (CoreException e) {
                            LoggingHelper.log(e);
                        }
                    }
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
            }
        }
        if (unshared && shareable != null && (fileStorage = ((Shareable)shareable).getFileStorage()) != null) {
            fileStorage.deregisterRepositoryProvider((IProgressMonitor)monitor.newChild(5));
        }
    }

    @Override
    public int getNumShares(IContextHandle workspace, IComponentHandle component, IProgressMonitor progress) throws FileSystemException {
        return ICopyFileAreaManager.instance.getNumShares(workspace, component, progress);
    }

    @Override
    public ISandbox getSandbox(ILocation copyFileAreaRoot, boolean registered) {
        if (registered && !ICopyFileAreaManager.instance.copyFileAreaExists(copyFileAreaRoot, 0)) {
            return null;
        }
        return new Sandbox(copyFileAreaRoot);
    }

    @Override
    public Collection<ISandbox> getSandboxes(ConfigurationFacade configuration, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<ISandbox> result = new ArrayList<ISandbox>();
        Collection<ICopyFileArea> copyFileAreas = ICopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configuration, monitor);
        for (ICopyFileArea cfa : copyFileAreas) {
            result.add(new Sandbox(cfa));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableSandboxListening(IProgressMonitor monitor) throws FileSystemException {
        Object object = this.sandboxListeningEnabledLock;
        synchronized (object) {
            if (!this.sandboxListeningEnabled) {
                return;
            }
            this.sandboxListeningEnabled = false;
            ArrayList<ISandbox> sandboxesToDisableListening = new ArrayList<ISandbox>();
            Set<ILocation> set = this.sandboxesWithListener;
            synchronized (set) {
                for (ILocation sandboxLoc : this.sandboxesWithListener) {
                    sandboxesToDisableListening.add(new Sandbox(sandboxLoc));
                }
            }
            this.disableSandboxListeners(sandboxesToDisableListening, monitor);
            ICopyFileAreaManager.instance.sendSandboxListeningEvent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableSandboxListening(IProgressMonitor monitor) throws FileSystemException {
        Object object = this.sandboxListeningEnabledLock;
        synchronized (object) {
            if (this.sandboxListeningEnabled) {
                return;
            }
            this.sandboxListeningEnabled = true;
            Collection<ICopyFileArea> cfas = ICopyFileAreaManager.instance.getAllCopyFileAreas();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)cfas.size());
            for (ICopyFileArea cfa : cfas) {
                Sandbox sandbox = new Sandbox(cfa);
                this.initSandboxListening(sandbox, cfa, progress.newChild(1));
            }
            ICopyFileAreaManager.instance.sendSandboxListeningEvent(true);
        }
    }

    @Override
    public boolean isSandboxListeningEnabled() {
        return this.sandboxListeningEnabled;
    }

    @Override
    public void register(ISandbox sandbox, boolean mustExist, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
        ILocation root = sandbox.getRoot();
        if (mustExist && !ICopyFileAreaManager.instance.copyFileAreaExists(root, 1)) {
            throw new FileSystemException(NLS.bind((String)Messages.SharingManager_InvalidSandbox, (Object)root.toOSString(), (Object[])new Object[0]));
        }
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(root);
        if (cfa == null) {
            cfa = ICopyFileAreaManager.instance.createCopyFileArea(root, (IProgressMonitor)progress.newChild(10));
        }
        if (cfa != null) {
            this.initSandboxListening(sandbox, cfa, progress.newChild(100));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSandboxListening(ISandbox sandbox, ICopyFileArea cfa, SubMonitor progress) throws FileSystemException {
        if (!this.sandboxListeningEnabled) {
            return;
        }
        IShare[] shares = sandbox.allShares((IProgressMonitor)progress.newChild(1));
        Set<ILocation> set = this.sandboxesWithListener;
        synchronized (set) {
            if (this.sandboxesWithListener.contains(sandbox.getRoot())) {
                return;
            }
            ILocation root = sandbox.getRoot();
            ISandboxListener listener = this.getSandboxListener(root);
            IStorageManager stgManager = this.getStorageManager(root);
            stgManager.createSandboxStorage(sandbox.getRoot());
            if (listener == null) {
                return;
            }
            this.sandboxesWithListener.add(root);
            Date lastSandboxListenerEvent = null;
            try {
                lastSandboxListenerEvent = cfa.getLastSandboxListenerEvent();
            }
            catch (FileSystemException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, e.getMessage(), (Throwable)((Object)e)));
            }
            try {
                listener.addSandbox(root);
                if (lastSandboxListenerEvent == null) {
                    return;
                }
                IShare[] iShareArray = shares;
                int n = shares.length;
                int n2 = 0;
                while (n2 < n) {
                    IShare share = iShareArray[n2];
                    listener.addShare(sandbox.getRoot(), share.getPath());
                    ++n2;
                }
                IShare[] sharesToRecompute = stgManager.findSharesToRefresh(lastSandboxListenerEvent, shares, (IProgressMonitor)progress.newChild(99));
                cfa.markSandboxListenerEvent(new Date());
                if (sharesToRecompute.length > 0) {
                    LocalChangeManager.getInstance().refreshChangesAsync(sharesToRecompute, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN);
                }
            }
            catch (CoreException e) {
                LoggingHelper.log(e);
            }
        }
    }

    @Override
    public void register(List<ISandbox> sandboxes, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + 10 * sandboxes.size()));
        ArrayList<ILocation> paths = new ArrayList<ILocation>(sandboxes.size());
        for (ISandbox sandbox : sandboxes) {
            paths.add(sandbox.getRoot());
        }
        ICopyFileAreaManager.instance.createCopyFileAreas(paths, (IProgressMonitor)monitor.newChild(10));
        for (ISandbox sandbox : sandboxes) {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(sandbox.getRoot());
            this.initSandboxListening(sandbox, cfa, monitor.newChild(10));
        }
    }

    @Override
    public void deregister(ISandbox sandbox, IProgressMonitor monitor) throws FileSystemException {
        this.deregister(sandbox, false, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(ISandbox sandbox, boolean delete, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ILocation cfaRoot = sandbox.getRoot();
        ISandboxListener listener = this.getSandboxListener(cfaRoot);
        IShare[] shares = null;
        if (listener != null) {
            try {
                shares = sandbox.allShares((IProgressMonitor)progress.newChild(1));
            }
            catch (FileSystemException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            }
            Set<ILocation> set = this.sandboxesWithListener;
            synchronized (set) {
                if (this.sandboxesWithListener.contains(cfaRoot)) {
                    try {
                        if (shares != null) {
                            IShare[] iShareArray = shares;
                            int n = shares.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IShare share = iShareArray[n2];
                                listener.removeShare(cfaRoot, share.getPath());
                                ++n2;
                            }
                        }
                        listener.removeSandbox(cfaRoot);
                        this.sandboxesWithListener.remove(cfaRoot);
                    }
                    catch (CoreException e) {
                        LoggingHelper.log(e);
                    }
                }
            }
        }
        ICopyFileAreaManager.instance.deregister(sandbox.getRoot(), delete, (IProgressMonitor)progress.newChild(1));
    }

    @Override
    public void eraseSandboxMetadata(ISandbox sandbox, IProgressMonitor monitor) throws FileSystemException {
        this.deregister(sandbox, true, monitor);
    }

    @Override
    public ISchedulingRule makeSchedulingRuleForIDE() {
        return null;
    }

    @Override
    public ISchedulingRule makeSchedulingRuleForIDE(Collection<IShareable> shareables) {
        return null;
    }

    @Override
    public ISchedulingRule makeSchedulingRuleForIDE(Collection<IShareable> shareables, ISharingManager.RuleKind kind) {
        return null;
    }

    public boolean isExistingCopyFileArea(ILocation copyFileAreaRoot, boolean known) {
        int options = known ? 0 : 1;
        return ICopyFileAreaManager.instance.copyFileAreaExists(copyFileAreaRoot, options);
    }

    @Override
    public final synchronized IContentExaminer getContentExaminer(IShareable shareable) {
        IStorageManager storageManager = this.getStorageManager(shareable.getFullPath());
        return storageManager.getContentExaminer(shareable);
    }

    private final IStorageManager getStorageManager(ILocation location) {
        return this.getStorageManager(location.getStorageId());
    }

    public final IStorageManager getStorageManager(String storageId) {
        this.loadStorageManagers();
        IStorageManager result = this.storageManagers.get(storageId);
        if (result == null) {
            throw new IllegalStateException("Unsupported storage type " + storageId);
        }
        return result;
    }

    public final Set<String> getStorageManagerIds() {
        this.loadStorageManagers();
        return Collections.unmodifiableSet(this.storageManagers.keySet());
    }

    protected final synchronized void loadStorageManagers() {
        if (this.storageManagers == null) {
            IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_STORAGE_MANAGER);
            this.storageManagers = new HashMap<String, IStorageManager>(configs.length);
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    IStorageManager storageManager = (IStorageManager)config.createExecutableExtension("class");
                    String id = config.getAttribute("storageId");
                    if (this.storageManagers.containsKey(id)) {
                        throw new IllegalStateException("Only one of a particular type of storage manager can be registered: " + id);
                    }
                    this.storageManagers.put(id, storageManager);
                }
                catch (CoreException e) {
                    LoggingHelper.log(e);
                }
                ++n2;
            }
            if (this.storageManagers.get("com.ibm.team.filesystem.hfs") == null) {
                this.storageManagers.put("com.ibm.team.filesystem.hfs", StorageManager.getInstance());
            }
        }
    }

    public IFileContentMerger getFileContentMerger() {
        return new IFileContentMerger(){

            @Override
            public IStatus performAutoMerge(ITeamRepository repository, IFileItem commonAncestorItem, IFileItem proposedItem, IShareable shareable, String contentTypeForMerge, Shed backupShed, IProgressMonitor progress) throws FileSystemException, IOException, TeamRepositoryException {
                return new Status(4, "com.ibm.team.filesystem.client", 1001, Messages.SharingManager_0, null);
            }
        };
    }

    public Collection<IShare> getShares(IConnection connection, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IShare> shares = new ArrayList<IShare>();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        Collection<ICopyFileArea> copyFileAreas = cfaMgr.getCopyFileAreasForConnection(connection, (IProgressMonitor)monitor.newChild(1));
        monitor.setWorkRemaining(copyFileAreas.size() + 1);
        for (ICopyFileArea cfa : copyFileAreas) {
            AbstractLock lock = CFALockUtil.lockExistingForRead(cfa.getRoot(), (IProgressMonitor)monitor.newChild(1));
            if (lock == null) continue;
            try {
                Collection<IShare> allShares = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot()).allShares();
                for (IShare share : allShares) {
                    if (!share.getSharingDescriptor().isAssociatedWithConnection(connection)) continue;
                    shares.add(share);
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
            }
        }
        return shares;
    }

    public Collection<IShare> getShares(ConfigurationFacade configuration, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IShare> shares = new ArrayList<IShare>();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        Collection<ICopyFileArea> copyFileAreas = cfaMgr.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)monitor.newChild(1));
        monitor.setWorkRemaining(copyFileAreas.size() + 1);
        for (ICopyFileArea cfa : copyFileAreas) {
            AbstractLock lock = CFALockUtil.lockExistingForRead(cfa.getRoot(), (IProgressMonitor)monitor.newChild(1));
            if (lock == null) continue;
            try {
                Collection<IShare> allShares = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot()).allShares();
                for (IShare share : allShares) {
                    ISharingDescriptor descriptor = share.getSharingDescriptor();
                    if (!descriptor.getConnectionHandle().sameItemId((IItemHandle)configuration.getConnectionHandle()) || !descriptor.getComponent().sameItemId((IItemHandle)configuration.getComponentHandle())) continue;
                    shares.add(share);
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
            }
        }
        return shares;
    }

    public boolean isCorruptedCopyFileArea(ILocation copyFileAreaRoot, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(copyFileAreaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            return false;
        }
        try {
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            boolean bl = copyFileArea.isCorrupted();
            return bl;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
    }

    public Collection<LoadedConfigurationDescriptor> allLoadedConfigurations(ILocation copyFileAreaRoot, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(copyFileAreaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            Collection<LoadedConfigurationDescriptor> collection = copyFileArea.allLoadedConfigurations((IProgressMonitor)progress.newChild(98));
            return collection;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
    }

    public final boolean hasEFSSupport(ILocation location) {
        return this.getStorageManager(location).hasEFSSupport();
    }

    public IBackupHandler getShed(ISandbox sandbox, BackupDilemmaHandler backupDilemmaHandler) {
        return this.getStorageManager(sandbox.getRoot()).getBackupHandler(sandbox, backupDilemmaHandler);
    }

    public final boolean transformsContentsSet(ISandbox sandbox) {
        return this.getStorageManager(sandbox.getRoot()).transformsContentsSet();
    }

    public void beginAvoidSandboxListening(ISandbox sandbox, IComponentHandle component) {
        ILocation cfaRoot = sandbox.getRoot();
        ISandboxListener listener = this.getSandboxListener(cfaRoot);
        if (listener != null) {
            listener.beginAvoidNotify(cfaRoot, component);
        }
    }

    public void endAvoidSandboxListening(ISandbox sandbox, IComponentHandle component) {
        ILocation cfaRoot = sandbox.getRoot();
        ISandboxListener listener = this.getSandboxListener(cfaRoot);
        if (listener != null) {
            listener.endAvoidNotify(cfaRoot, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remindSandboxListener(IShare share) {
        Set<ILocation> set = this.sandboxesWithListener;
        synchronized (set) {
            ILocation sandboxRoot = share.getSandbox().getRoot();
            if (!this.sandboxesWithListener.contains(sandboxRoot)) {
                return;
            }
            ISandboxListener listener = this.getSandboxListener(sandboxRoot);
            if (listener != null) {
                try {
                    listener.addShare(sandboxRoot, share.getPath());
                }
                catch (CoreException e) {
                    LoggingHelper.log(e);
                }
            }
        }
    }

    @Override
    public boolean hasSandboxListener(ISandbox sandbox) {
        ILocation sandboxRoot = sandbox.getRoot();
        return this.sandboxesWithListener.contains(sandboxRoot);
    }

    @Override
    public boolean canSupportSandboxListener(ISandbox sandbox) {
        IStorageManager stgManager = this.getStorageManager(sandbox.getRoot());
        return stgManager.getSandboxListener() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableSandboxListeners(Collection<ISandbox> sandboxes, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(sandboxes.size() * 2));
        for (ISandbox sandbox : sandboxes) {
            ILocation cfaRoot = sandbox.getRoot();
            IStorageManager mgr = this.getStorageManager(cfaRoot);
            ISandboxListener listener = mgr.getSandboxListener();
            try {
                if (listener == null) continue;
                IShare[] shares = sandbox.allShares((IProgressMonitor)progress.newChild(1));
                Set<ILocation> set = this.sandboxesWithListener;
                synchronized (set) {
                    IShare[] iShareArray = shares;
                    int n = shares.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IShare share = iShareArray[n2];
                        listener.removeShare(cfaRoot, share.getPath());
                        ++n2;
                    }
                    listener.removeSandbox(cfaRoot);
                    this.sandboxesWithListener.remove(cfaRoot);
                }
            }
            catch (CoreException e) {
                LoggingHelper.log(e);
            }
        }
    }

    @Override
    public Collection<IUnmodifiedInfo> findUnmodifiedInfoFor(IContextHandle ctx, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor progress) throws FileSystemException {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        Collection<ICopyFileArea> copyFileAreas = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        ArrayList<IUnmodifiedInfo> toReturn = new ArrayList<IUnmodifiedInfo>(copyFileAreas.size());
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(copyFileAreas.size() * 3));
        for (ICopyFileArea cfa : copyFileAreas) {
            AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate(cfa.getRoot(), (IProgressMonitor)monitor.newChild(1));
            if (lock == null) continue;
            try {
                cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot());
                InverseFileItemInfo info = cfa.getItemInfo(versionable, component, ctx, false);
                if (info == null) continue;
                toReturn.add(new UnmodifiedInfo(new Sandbox(cfa), ctx, component, info));
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
            }
        }
        monitor.done();
        return toReturn;
    }

    public IUnmodifiedInfo findUnmodifiedInfoForChild(IShareable parent, String childName, IProgressMonitor progress) throws FileSystemException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (String)NLS.bind((String)"Finding metadata for {0}", (Object)childName, (Object[])new Object[0]), (int)4);
        IShare share = parent.getShare((IProgressMonitor)mon.newChild(1));
        if (share == null) {
            Shareable childShareable = this.findShareable(parent.getSandbox(), parent.getLocalPath().append(childName), ResourceType.FILE);
            share = childShareable.getShare(null);
            if (share == null) {
                return null;
            }
            ISharingDescriptor desc = share.getSharingDescriptor();
            IComponentHandle comp = desc.getComponent();
            IContextHandle ctx = desc.getConnectionHandle();
            IVersionableHandle rootVersionable = desc.getRootVersionable();
            if (rootVersionable == null) {
                return null;
            }
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(share.getShareable().getFullPath());
            if (cfa == null) {
                return null;
            }
            AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate(cfa.getRoot(), (IProgressMonitor)mon.newChild(1));
            if (lock == null) {
                return null;
            }
            try {
                InverseFileItemInfo parentInfo = cfa.getItemInfo(rootVersionable, comp, ctx, false);
                UnmodifiedInfo unmodifiedInfo = new UnmodifiedInfo(new Sandbox(cfa), ctx, comp, parentInfo);
                return unmodifiedInfo;
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)mon.newChild(1));
            }
        }
        ISharingDescriptor desc = share.getSharingDescriptor();
        IComponentHandle comp = desc.getComponent();
        IContextHandle ctx = desc.getConnectionHandle();
        IVersionableHandle parentRemote = parent.getRemote((IProgressMonitor)mon.newChild(1));
        if (parentRemote == null) {
            return null;
        }
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(share.getShareable().getFullPath());
        if (cfa == null) {
            return null;
        }
        AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate(cfa.getRoot(), (IProgressMonitor)mon.newChild(1));
        if (lock == null) {
            return null;
        }
        try {
            InverseFileItemInfo parentInfo = cfa.getItemInfo(parentRemote, comp, ctx, false);
            if (parentInfo == null) {
                return null;
            }
            IVersionableHandle childVersionable = parentInfo.getRemoteChild(childName);
            if (childVersionable == null) {
                return null;
            }
            InverseFileItemInfo childInfo = cfa.getItemInfo(childVersionable, comp, ctx, false);
            UnmodifiedInfo unmodifiedInfo = new UnmodifiedInfo(new Sandbox(cfa), ctx, comp, childInfo);
            return unmodifiedInfo;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)mon.newChild(1));
        }
    }

    public static interface FileSystemAccessor {
        public void run() throws FileSystemException;
    }

    public static interface FileSystemRunnable {
        public void run() throws TeamRepositoryException;
    }
}

