/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.ISandboxListener;
import com.ibm.team.filesystem.client.internal.LocalFileBackup;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.PlatformDetector;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.api.storage.AbstractStorageManager;
import com.ibm.team.filesystem.client.internal.api.storage.IBackupHandler;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.core.SharingMetadataFactory;
import com.ibm.team.filesystem.client.internal.listen.LocalFilesystemListener;
import com.ibm.team.filesystem.client.internal.load.HierarchicalLoadEvaluator;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemUpdateMutator;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer;
import com.ibm.team.filesystem.client.internal.operations.ILoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.operations.IUpdateMutator;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class StorageManager
extends AbstractStorageManager {
    private static final long QUICK_TIMEOUT = 500L;
    private static final long LONG_TIMEOUT = 3000L;
    private static final int EVENT_QUEUE_LIMIT = 15000;
    private static final int EVENT_QUEUE_REDUCTION = 1000;
    private static final Object filesystemEventsLock = new Object();
    private static List<FilesystemEvent> filesystemEvents = new ArrayList<FilesystemEvent>();
    private static Job listenerEventHandler = new ListenerEventHandler();
    private static final Object LOCKED_COMPONENTS_LOCK = new Object();
    private static Set<ComponentState> LOCKED_COMPONENTS = Collections.emptySet();
    private static volatile long cumulativeListenerCallbackTime = 0L;
    private IContentExaminer contentExaminer;
    protected static volatile StorageManager instance;
    private static volatile ISandboxListener LISTENER;
    private static boolean listenerInitialized;

    static {
        LISTENER = new Listener();
        listenerInitialized = false;
    }

    private static StorageManager doGetInstance() {
        return new StorageManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StorageManager getInstance() {
        StorageManager sm = instance;
        if (sm != null) return sm;
        Class<StorageManager> clazz = StorageManager.class;
        synchronized (StorageManager.class) {
            sm = instance;
            if (sm != null) return sm;
            instance = sm = StorageManager.doGetInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sm;
        }
    }

    @Override
    public void resolveFileStorage(FileStorageWrapper storage, ResourceType resourceTypeHint) {
        LocalFileStorage.resolveLocalFileStorage(storage, resourceTypeHint);
    }

    @Override
    public IUpdateMutator getUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport2 updates, Collection<IItemUpdateReport> rawUpdates, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler dilemmaHandler, IDownloadListener downloadMonitor) {
        return new LocalFileSystemUpdateMutator(connection, componentStatesBefore, componentStatesAfter, updates, rawUpdates, copyFileAreasToUpdate, dilemmaHandler, downloadMonitor);
    }

    @Override
    public ILoadMutator getLoadMutator(ISandbox sandbox, LoadDilemmaHandler loadProblemHandler) {
        return new MergeLoadMutator(sandbox, loadProblemHandler);
    }

    @Override
    public boolean hasEFSSupport() {
        return true;
    }

    @Override
    public boolean canCreateEclipseProjects() {
        return true;
    }

    @Override
    public IContentExaminer getContentExaminer(IShareable shareable) {
        if (this.contentExaminer == null) {
            String id;
            IConfigurationElement config;
            IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", "contentExaminer");
            String platform = LocalFileStorage.ZOS_SIMULATION_ENABLED ? PlatformDetector.Platform.Z.toString() : PlatformDetector.getPlatform().toString();
            IConfigurationElement choice = null;
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                config = iConfigurationElementArray[n2];
                id = config.getAttribute("platform");
                if (id != null && id.equals(platform)) {
                    if (choice == null) {
                        choice = config;
                    } else {
                        throw new IllegalStateException("Only one content examiner implementation can be registered for platform " + platform);
                    }
                }
                ++n2;
            }
            if (choice == null) {
                iConfigurationElementArray = configs;
                n = configs.length;
                n2 = 0;
                while (n2 < n) {
                    config = iConfigurationElementArray[n2];
                    id = config.getAttribute("platform");
                    if (id == null || id.equals("")) {
                        if (choice == null) {
                            choice = config;
                        } else {
                            throw new IllegalStateException("Only one content examiner implementation can be registered for platform " + platform);
                        }
                    }
                    ++n2;
                }
            }
            if (choice != null) {
                try {
                    this.contentExaminer = (IContentExaminer)choice.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    this.contentExaminer = LocalContentExaminer.getInstance();
                    LoggingHelper.log(e);
                }
            } else {
                this.contentExaminer = LocalContentExaminer.getInstance();
            }
        }
        return this.contentExaminer;
    }

    @Override
    public ILoadEvaluator getLoadEvaluator() {
        return new HierarchicalLoadEvaluator();
    }

    @Override
    public IBackupHandler getBackupHandler(ISandbox sandbox, BackupDilemmaHandler backupDilemmaHandler) {
        return new LocalFileBackup(sandbox, backupDilemmaHandler);
    }

    @Override
    public ILocation createLocation(String location) {
        return new PathLocation(location);
    }

    @Override
    public final boolean transformsContentsSet() {
        return LocalFileStorage.getFileAccessExtension().transformsContents();
    }

    private static final synchronized void initSandboxListener() {
        if (!listenerInitialized) {
            if (System.getProperty("com.ibm.team.filesystem.client.disable.fslistener") == null) {
                try {
                    System.loadLibrary("fslistener");
                }
                catch (Throwable throwable) {
                    LISTENER = null;
                }
            } else {
                LISTENER = null;
            }
            listenerInitialized = true;
        }
    }

    @Override
    public ISandboxListener getSandboxListener() {
        StorageManager.initSandboxListener();
        return LISTENER;
    }

    @Override
    public final IShare[] findSharesToRefresh(Date lastKnownModification, IShare[] shares, IProgressMonitor monitor) throws FileSystemException {
        if (shares == null) {
            return new IShare[0];
        }
        if (shares.length == 0) {
            return shares;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(shares.length * 10));
        ILocation sandboxLocation = shares[0].getSandbox().getRoot();
        ArrayList<IShare> sharesToRecompute = new ArrayList<IShare>();
        try {
            long currentTime = System.currentTimeMillis();
            IShare[] iShareArray = shares;
            int n = shares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                progress.setTaskName(NLS.bind((String)Messages.StorageManager_1, (Object)share.getShareable().getFullPath()));
                ILocation location = sandboxLocation.append(share.getPath());
                IFileStore file = EFS.getLocalFileSystem().getStore((IPath)new Path(location.toString()));
                IFileInfo info = file.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
                if (this.isModifiedAfter(file, info, location, lastKnownModification.getTime(), (IProgressMonitor)progress.newChild(9))) {
                    sharesToRecompute.add(share);
                }
                ++n2;
            }
            LocalChangeManager.traceLocalChangeInfo("Finished sandbox scan in " + (int)((System.currentTimeMillis() - currentTime) / 1000L) + " seconds.");
            if (!sharesToRecompute.isEmpty()) {
                LocalChangeManager.traceLocalChangeInfo("Recomputing " + sharesToRecompute.size() + " shares because files modified after " + lastKnownModification);
            }
        }
        catch (CoreException e) {
            throw new FileSystemException(e);
        }
        return sharesToRecompute.toArray(new IShare[0]);
    }

    private boolean isModifiedAfter(IFileStore file, IFileInfo info, ILocation location, long modStamp, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (info.getLastModified() > modStamp) {
            return true;
        }
        if (info.isDirectory() && !info.getAttribute(32)) {
            IFileStore[] childStores = file.childStores(0, (IProgressMonitor)progress.newChild(1));
            SubMonitor progress2 = SubMonitor.convert((IProgressMonitor)progress, (int)(10 * childStores.length));
            IFileStore[] iFileStoreArray = childStores;
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                IFileInfo childInfo = child.fetchInfo(0, (IProgressMonitor)progress2.newChild(1));
                if (this.isModifiedAfter(child, childInfo, location.append(child.getName()), modStamp, (IProgressMonitor)progress2.newChild(10))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void createSandboxStorage(ILocation sandbox) throws FileSystemException {
        File localSandbox = new File(sandbox.toOSString());
        if (!localSandbox.exists() && !localSandbox.mkdirs()) {
            throw new FileSystemException(NLS.bind((String)Messages.StorageManager_0, (Object)localSandbox.toString()));
        }
    }

    private static final class ComponentState {
        private final UUID componentId;
        private final ILocation cfaLocation;

        public ComponentState(ILocation sandbox, IComponentHandle handle) {
            this.componentId = handle.getItemId();
            this.cfaLocation = sandbox;
        }

        public int hashCode() {
            return this.componentId.hashCode() + 7 * this.cfaLocation.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComponentState)) {
                return false;
            }
            ComponentState otherState = (ComponentState)o;
            return otherState.componentId.equals((Object)this.componentId) && otherState.cfaLocation.equals(this.cfaLocation);
        }
    }

    private static final class FilesystemEvent {
        private final Set<ComponentState> lockedComponents;
        private IPath filesystemPath;

        public FilesystemEvent(IPath fspath, Set<ComponentState> lockedComponents) {
            this.lockedComponents = lockedComponents;
            this.filesystemPath = fspath;
        }

        public boolean componentWasLocked(ISandbox sandbox, IShare share) {
            return this.lockedComponents.contains(new ComponentState(sandbox.getRoot(), share.getSharingDescriptor().getComponent()));
        }

        public IShareable fetchSimpleShareable() {
            return SharingManager.getInstance().findShareable(new PathLocation(this.filesystemPath), ResourceType.FILE);
        }

        public IShareable fetchPreciseShareable() {
            IFileStore store = EFS.getLocalFileSystem().getStore(this.filesystemPath);
            IFileInfo info = null;
            try {
                info = store.fetchInfo(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e1) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e1));
                return null;
            }
            ResourceType resourceType = null;
            resourceType = info.getAttribute(32) ? ResourceType.SYMBOLIC_LINK : (info.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
            return SharingManager.getInstance().findShareable(new PathLocation(this.filesystemPath), resourceType);
        }

        public boolean retractToExistingParent() {
            boolean retracted = false;
            while (!this.filesystemPath.toFile().exists()) {
                retracted = true;
                this.filesystemPath = this.filesystemPath.removeLastSegments(1);
            }
            return retracted;
        }

        public void makeCanonical() throws IOException {
            this.filesystemPath = new Path(this.filesystemPath.toFile().getCanonicalPath());
        }
    }

    public static final class Listener
    implements ISandboxListener {
        private volatile boolean started = false;
        private volatile boolean disposed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init() throws CoreException {
            Listener listener = this;
            synchronized (listener) {
                if (this.started) {
                    if (this.disposed) {
                        throw new CoreException(FileSystemStatusUtil.getStatusFor(4, Messages.StorageManager_3));
                    }
                    throw new CoreException(FileSystemStatusUtil.getStatusFor(4, Messages.StorageManager_4));
                }
                this.started = true;
            }
            try {
                LocalFilesystemListener.init();
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block14: {
                            try {
                                try {
                                    LocalFilesystemListener.enterEventLoop();
                                }
                                catch (CoreException e) {
                                    LoggingHelper.log(e);
                                    Listener listener = Listener.this;
                                    synchronized (listener) {
                                        Listener.this.started = false;
                                        Listener.this.disposed = false;
                                        break block14;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Listener listener = Listener.this;
                                synchronized (listener) {
                                    Listener.this.started = false;
                                    Listener.this.disposed = false;
                                }
                                throw throwable;
                            }
                            Listener listener = Listener.this;
                            synchronized (listener) {
                                Listener.this.started = false;
                                Listener.this.disposed = false;
                            }
                        }
                    }
                });
                t.setDaemon(true);
                t.start();
            }
            catch (CoreException e) {
                this.started = false;
                throw e;
            }
            catch (RuntimeException e) {
                this.started = false;
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() throws CoreException {
            Listener listener = this;
            synchronized (listener) {
                if (this.disposed) {
                    throw new CoreException(FileSystemStatusUtil.getStatusFor(4, Messages.StorageManager_5));
                }
                this.disposed = true;
            }
            LocalFilesystemListener.dispose();
        }

        @Override
        public synchronized void addSandbox(ILocation sandbox) throws CoreException {
            LocalFilesystemListener.addDirectory(sandbox.toOSString());
        }

        @Override
        public synchronized void removeSandbox(ILocation sandbox) throws CoreException {
            LocalFilesystemListener.removeDirectory(sandbox.toOSString());
        }

        @Override
        public synchronized void addShare(ILocation sandbox, IRelativeLocation share) throws CoreException {
            LocalFilesystemListener.addInterestingPath(sandbox.append(share).toOSString());
        }

        @Override
        public synchronized void removeShare(ILocation sandbox, IRelativeLocation share) throws CoreException {
            LocalFilesystemListener.removeInterestingPath(sandbox.append(share).toOSString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beginAvoidNotify(ILocation sandbox, IComponentHandle component) {
            Object object = LOCKED_COMPONENTS_LOCK;
            synchronized (object) {
                HashSet<ComponentState> newLockedComponents = new HashSet<ComponentState>(LOCKED_COMPONENTS.size() + 1);
                newLockedComponents.addAll(LOCKED_COMPONENTS);
                newLockedComponents.add(new ComponentState(sandbox, component));
                LOCKED_COMPONENTS = newLockedComponents;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endAvoidNotify(ILocation sandbox, IComponentHandle component) {
            Object object = LOCKED_COMPONENTS_LOCK;
            synchronized (object) {
                LOCKED_COMPONENTS = new HashSet(LOCKED_COMPONENTS);
                LOCKED_COMPONENTS.remove(new ComponentState(sandbox, component));
                if (LOCKED_COMPONENTS.isEmpty()) {
                    LOCKED_COMPONENTS = Collections.emptySet();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void newEvents(String[] paths) {
            if (FileSystemCore.isShutDown() || paths == null || paths.length == 0) {
                return;
            }
            Set lockedComponentsSnapshot = null;
            Object object = LOCKED_COMPONENTS_LOCK;
            synchronized (object) {
                lockedComponentsSnapshot = LOCKED_COMPONENTS;
            }
            object = filesystemEventsLock;
            synchronized (object) {
                boolean newEventsAdded = false;
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    Path p = new Path(path);
                    if (!Listener.isFiltered((IPath)p)) {
                        FilesystemEvent event = new FilesystemEvent((IPath)p, lockedComponentsSnapshot);
                        filesystemEvents.add(event);
                        newEventsAdded = true;
                    }
                    ++n2;
                }
                if (!newEventsAdded) {
                    return;
                }
                int state = listenerEventHandler.getState();
                if (state == 0 || state == 4) {
                    listenerEventHandler.schedule(500L);
                }
            }
        }

        private static boolean isFiltered(IPath path) {
            String[] stringArray = path.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (".jazzShed".equals(segment)) {
                    return true;
                }
                String[] stringArray2 = SharingMetadataFactory.SUPPORTED_METADATA_FOLDERS;
                int n3 = SharingMetadataFactory.SUPPORTED_METADATA_FOLDERS.length;
                int n4 = 0;
                while (n4 < n3) {
                    String metadataFolder = stringArray2[n4];
                    if (metadataFolder.equals(segment)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
            return false;
        }
    }

    private static final class ListenerEventHandler
    extends Job {
        public ListenerEventHandler() {
            super(Messages.StorageManager_2);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            long currentTime = System.currentTimeMillis();
            ArrayList eventsSnapshot = null;
            Object object = filesystemEventsLock;
            synchronized (object) {
                eventsSnapshot = filesystemEvents;
                filesystemEvents = new ArrayList();
            }
            boolean deletes = this.adjustEventsForDeletions(eventsSnapshot);
            if (deletes) {
                if (eventsSnapshot.size() < 15000) {
                    Object object2 = filesystemEventsLock;
                    synchronized (object2) {
                        eventsSnapshot.addAll(filesystemEvents);
                        filesystemEvents = eventsSnapshot;
                        LocalChangeManager.traceLocalChangeInfo("Filesystem event processing deferred because of deletes...");
                        this.schedule(3000L);
                    }
                    return Status.OK_STATUS;
                }
                ArrayList eventsToProcess = new ArrayList(eventsSnapshot.subList(0, 1000));
                ArrayList eventsToRequeue = new ArrayList(eventsSnapshot.subList(1001, eventsSnapshot.size() - 1));
                eventsSnapshot = null;
                Object object3 = filesystemEventsLock;
                synchronized (object3) {
                    eventsToRequeue.addAll(filesystemEvents);
                    filesystemEvents = eventsToRequeue;
                    LocalChangeManager.traceLocalChangeInfo("Filesystem event buffer exceeded. Proceeding to refresh the first batch...");
                    this.schedule(500L);
                }
                eventsSnapshot = eventsToProcess;
            }
            this.canonicalizePaths(eventsSnapshot);
            ArrayList<IShareable> shareables = new ArrayList<IShareable>();
            HashSet<ISandbox> sandboxes = new HashSet<ISandbox>();
            for (FilesystemEvent event : eventsSnapshot) {
                IShareable shareable = event.fetchSimpleShareable();
                if (shareable == null) continue;
                try {
                    ISandbox sandbox;
                    boolean corruptedSandbox;
                    IShare share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
                    if (share == null || (corruptedSandbox = (sandbox = share.getSandbox()).isCorrupted((IProgressMonitor)new NullProgressMonitor()))) continue;
                    sandboxes.add(sandbox);
                    if (event.componentWasLocked(sandbox, share) || shareable.shouldBeIgnored((IProgressMonitor)new NullProgressMonitor()) || (shareable = event.fetchPreciseShareable()) == null) continue;
                    shareables.add(shareable);
                }
                catch (FileSystemException e) {
                    LoggingHelper.log("com.ibm.team.filesystem.client", e);
                }
            }
            long timeDifference = System.currentTimeMillis() - currentTime;
            if (timeDifference > 0L) {
                cumulativeListenerCallbackTime = cumulativeListenerCallbackTime + timeDifference;
                LocalChangeManager.traceLocalChangeInfo("Cumulative filesystem listener time: " + cumulativeListenerCallbackTime);
            }
            if (!shareables.isEmpty()) {
                try {
                    LocalChangeManager.traceLocalChangeInfo("Shareables sent to be refreshed: " + shareables.size());
                    LocalChangeManager.getInstance().refreshChangesAsync(shareables, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN);
                }
                catch (FileSystemException e) {
                    LoggingHelper.log("com.ibm.team.filesystem.client", e);
                }
            } else {
                LocalChangeManager.traceLocalChangeInfo("All shareables ignored. None sent to be refreshed.");
            }
            Date now = new Date();
            for (ISandbox sandbox : sandboxes) {
                ICopyFileArea cfa = CopyFileAreaManager.instance.getCopyFileAreaForPath(sandbox.getRoot());
                try {
                    cfa.markSandboxListenerEvent(now);
                }
                catch (FileSystemException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                }
            }
            return Status.OK_STATUS;
        }

        private boolean adjustEventsForDeletions(List<FilesystemEvent> events) {
            boolean retractions = false;
            for (FilesystemEvent event : events) {
                if (!event.retractToExistingParent()) continue;
                retractions = true;
            }
            return retractions;
        }

        private void canonicalizePaths(List<FilesystemEvent> events) {
            ListIterator<FilesystemEvent> iter = events.listIterator();
            while (iter.hasNext()) {
                try {
                    FilesystemEvent event = iter.next();
                    event.makeCanonical();
                    if (PlatformDetector.getPlatform() != PlatformDetector.Platform.WINDOWS) continue;
                    event.retractToExistingParent();
                }
                catch (IOException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                    iter.remove();
                }
            }
        }
    }
}

