/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.checkin;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.checkin.NewCheckInOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RationalizingTree;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;

public class ShareableCheckinRequest
extends NewCheckInOperation.ComponentCheckInRequest {
    private final IShareable[] shareables;
    ILocalChange[] changes = null;

    public ShareableCheckinRequest(IWorkspaceConnection workspace, IComponentHandle component, ISandbox sandbox, IShareable[] shareables, IChangeSetHandle csHandle, String commentForNewChangeSet) {
        super(sandbox, workspace, component, csHandle, commentForNewChangeSet);
        this.shareables = shareables;
    }

    @Override
    public ILocalChange[] getChanges(boolean refreshChanges, IProgressMonitor monitor) throws FileSystemException {
        if (this.changes == null) {
            this.changes = this.internalGetChanges(refreshChanges, monitor);
        }
        return this.changes;
    }

    private ILocalChange[] internalGetChanges(boolean refreshChanges, IProgressMonitor progress) throws FileSystemException {
        if (!CFALockUtil.isLockedForUpdate(this.sandbox.getRoot(), this.component, this.workspace.getContextHandle())) {
            return new ILocalChange[0];
        }
        LocalChangeManager lcm = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        if (refreshChanges) {
            RationalizingTree<String, IShareable> tree = new RationalizingTree<String, IShareable>();
            IShareable[] iShareableArray = this.shareables;
            int n = this.shareables.length;
            int n2 = 0;
            while (n2 < n) {
                IShareable shareable = iShareableArray[n2];
                tree.put(shareable.getLocalPath().segments(), shareable);
                ++n2;
            }
            monitor.setWorkRemaining(tree.size() * 4);
            for (IShareable shareable : tree) {
                ((Shareable)shareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            for (IShareable shareable : tree) {
                lcm.refreshChanges(shareable, (IProgressMonitor)monitor.newChild(1));
            }
            monitor.setWorkRemaining(2);
        }
        lcm.syncPendingChanges((IContextHandle)this.workspace.getResolvedWorkspace(), this.component, this.sandbox, (IProgressMonitor)monitor.newChild(1));
        return this.cleanChanges(lcm.getPendingChanges(this.shareables, (IProgressMonitor)monitor.newChild(1)));
    }

    private ILocalChange[] cleanChanges(ILocalChange[] candidates) {
        ArrayList<ILocalChange> clean = new ArrayList<ILocalChange>(candidates.length);
        ILocalChange[] iLocalChangeArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            if (this.component.sameItemId((IItemHandle)change.getComponent()) && this.workspace.getContextHandle().sameItemId((IItemHandle)change.getConnection()) && PathUtils.samePath(this.sandbox.getRoot(), this.sandbox.isCaseSensitive(), ((LocalChange)change).getCfaRoot(), this.sandbox.isCaseSensitive())) {
                clean.add(change);
            }
            ++n2;
        }
        return clean.toArray(new ILocalChange[clean.size()]);
    }

    @Override
    public void validate(IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.shareables.length);
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", -1, "Errors validating checkin request", null);
        IShareable[] iShareableArray = this.shareables;
        int n = this.shareables.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share;
            IShareable shareable = iShareableArray[n2];
            if (!shareable.getSandbox().equals(this.sandbox)) {
                multi.add(FileSystemStatusUtil.getStatusFor(4, "Wrong sandbox for " + shareable.getLocalPath().toString(), null));
            }
            if ((share = shareable.getShare((IProgressMonitor)monitor.newChild(1))) != null) {
                ISharingDescriptor desc = share.getSharingDescriptor();
                if (!desc.getConnectionHandle().sameItemId((IItemHandle)this.workspace.getContextHandle())) {
                    multi.add(FileSystemStatusUtil.getStatusFor(4, "Wrong connection for " + shareable.getLocalPath().toString(), null));
                }
                if (!desc.getComponent().sameItemId((IItemHandle)this.component)) {
                    multi.add(FileSystemStatusUtil.getStatusFor(4, "Wrong component for " + shareable.getLocalPath().toString(), null));
                }
            }
            ++n2;
        }
        if (multi.getChildren().length > 0) {
            throw new FileSystemStatusException((IStatus)multi);
        }
    }
}

