/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraContext;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class WorkspaceNamespace
extends ItemNamespace {
    private UUID workspaceId;
    private UUID componentId;
    private ITeamRepository repo;

    private WorkspaceNamespace(ITeamRepository repository, UUID workspaceId, UUID componentId) {
        this.workspaceId = workspaceId;
        this.componentId = componentId;
        this.repo = repository;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repo;
    }

    public ItemId<IComponent> getComponentId() {
        return new ItemId(IComponent.ITEM_TYPE, this.componentId);
    }

    public ItemId<IWorkspace> getWorkspaceId() {
        return new ItemId(IWorkspace.ITEM_TYPE, this.workspaceId);
    }

    @Override
    public ItemId<IComponent> fetchComponentId(IProgressMonitor monitor) {
        return this.getComponentId();
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getWorkspaceConnection(monitor);
    }

    public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return ConnectionUtil.getConnection(this.getRepository(), (IWorkspaceHandle)this.getWorkspaceId().toHandle(), monitor);
    }

    @Override
    public IContextHandle getContextHandle() {
        return (IContextHandle)IWorkspace.ITEM_TYPE.createItemHandle(this.workspaceId, null);
    }

    @Override
    public IItemContext createContext(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            WorkspaceId snapshotId = WorkspaceId.create(this.getRepository(), (IWorkspaceHandle)this.getWorkspaceId().toHandle());
            ISnapshot snapshot = snapshotId.getSnapshot((IProgressMonitor)progress.newChild(34));
            return snapshot.getContextFor(this.getComponentId(), (IProgressMonitor)progress.newChild(66));
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return new EraContext(EraDescriptor.createEmptyEra(this.repo, this.getComponentId()), Messages.WorkspaceNamespace_0);
        }
    }

    @Override
    public boolean hasConnection() {
        return true;
    }

    @Override
    public boolean hasVersionableTree() {
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.componentId == null ? 0 : this.componentId.hashCode());
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        result = 31 * result + (this.workspaceId == null ? 0 : this.workspaceId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceNamespace other = (WorkspaceNamespace)obj;
        if (this.componentId == null ? other.componentId != null : !this.componentId.equals((Object)other.componentId)) {
            return false;
        }
        if (this.repo == null ? other.repo != null : !this.repo.equals(other.repo)) {
            return false;
        }
        return !(this.workspaceId == null ? other.workspaceId != null : !this.workspaceId.equals((Object)other.workspaceId));
    }

    @Override
    public boolean handlesAuditables() {
        return false;
    }

    @Override
    public boolean handlesSimpleItems() {
        return false;
    }

    @Override
    public boolean handlesVersionables() {
        return true;
    }

    public static WorkspaceNamespace create(ITeamRepository repository, UUID workspaceId, UUID componentId) {
        return (WorkspaceNamespace)ItemNamespace.commonNamespace(new WorkspaceNamespace(repository, workspaceId, componentId));
    }

    public static WorkspaceNamespace create(ITeamRepository repo, ItemId<IWorkspace> workspace, ItemId<IComponent> component) {
        if (repo == null || workspace == null || component == null) {
            throw new NullPointerException();
        }
        return (WorkspaceNamespace)ItemNamespace.commonNamespace(new WorkspaceNamespace(repo, workspace.getItemUUID(), component.getItemUUID()));
    }

    public static WorkspaceNamespace create(IWorkspaceConnection workspace, IComponentHandle component) {
        if (workspace == null || component == null) {
            throw new NullPointerException();
        }
        return (WorkspaceNamespace)ItemNamespace.commonNamespace(WorkspaceNamespace.create(workspace.teamRepository(), (ItemId<IWorkspace>)new ItemId((IItemHandle)workspace.getResolvedWorkspace()), (ItemId<IComponent>)new ItemId((IItemHandle)component)));
    }

    public static ItemNamespace create(IWorkspaceHandle workspace, IComponentHandle component) {
        return WorkspaceNamespace.create(ClientRepositoryUtil.getRepository((IItemHandle)workspace), workspace, component);
    }

    public static ItemNamespace create(ITeamRepository repository, IWorkspaceHandle workspace, IComponentHandle component) {
        if (workspace == null || component == null || repository == null) {
            throw new NullPointerException();
        }
        return ItemNamespace.commonNamespace(new WorkspaceNamespace(repository, workspace.getItemId(), component.getItemId()));
    }
}

