/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.common.IScmProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ChangePropertiesOperation
extends FileSystemOperation
implements IChangePropertiesOperation {
    private ChangePropertiesDilemmaHandler dilemmaHandler;
    private HashMap<IRelativeLocation, ChangePropertiesRequest> changeProperties;
    private Shed shed;
    private boolean reportedSupportedCharSets;
    private boolean refreshBeforeRun = false;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter;

    public ChangePropertiesOperation(ChangePropertiesDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? ChangePropertiesDilemmaHandler.getDefault() : dilemmaHandler);
        this.dilemmaHandler = dilemmaHandler == null ? ChangePropertiesDilemmaHandler.getDefault() : dilemmaHandler;
        this.shed = new Shed(this.dilemmaHandler.getBackupDilemmaHandler());
        this.changeProperties = new HashMap();
        this.reportedSupportedCharSets = false;
    }

    @Override
    public void setLineDelimiter(IShareable shareableFile, FileLineDelimiter lineDelimiter) {
        if (shareableFile == null) {
            throw new IllegalArgumentException();
        }
        if (lineDelimiter == null) {
            throw new IllegalArgumentException();
        }
        IRelativeLocation path = shareableFile.getLocalPath();
        ChangePropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangePropertiesRequest((Shareable)shareableFile, lineDelimiter));
        } else {
            existingRequest.lineDelimiter = lineDelimiter;
        }
    }

    @Override
    public void setExecutable(IShareable shareableFile, boolean executableValue) {
        if (shareableFile == null) {
            throw new IllegalArgumentException();
        }
        IRelativeLocation path = shareableFile.getLocalPath();
        ChangePropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangePropertiesRequest((Shareable)shareableFile, (Boolean)executableValue));
        } else {
            existingRequest.executableType = true;
            existingRequest.executable = executableValue;
        }
    }

    @Override
    public void setContentType(IShareable shareableFile, String contentType) {
        if (shareableFile == null) {
            throw new IllegalArgumentException();
        }
        if (contentType == null) {
            throw new IllegalArgumentException();
        }
        IRelativeLocation path = shareableFile.getLocalPath();
        ChangePropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangePropertiesRequest((Shareable)shareableFile, contentType));
        } else {
            existingRequest.contentType = contentType;
        }
    }

    @Override
    public void setProperties(IShareable shareable, Map<String, String> properties) {
        if (shareable == null) {
            throw new IllegalArgumentException();
        }
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        IRelativeLocation path = shareable.getLocalPath();
        ChangePropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangePropertiesRequest((Shareable)shareable, properties));
        } else {
            existingRequest.setPropertyUpdates(properties);
        }
    }

    public Map<String, IStatus> validateProperties(Map<String, String> updatedProperties) {
        HashMap<String, IStatus> invalidProperties = new HashMap<String, IStatus>();
        for (Map.Entry<String, String> entry : updatedProperties.entrySet()) {
            String propertyValue;
            String propertyName = entry.getKey();
            IStatus status = this.validateProperty(propertyName, propertyValue = entry.getValue());
            if (status.isOK()) continue;
            invalidProperties.put(propertyName, status);
        }
        return invalidProperties;
    }

    @Override
    public IStatus validateProperty(String propertyName, String propertyValue) {
        IStatus status = this.validatePropertyName(propertyName);
        if (!status.isOK()) {
            return status;
        }
        status = this.validatePropertyValue(propertyName, propertyValue);
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validateContentType(String contentType) {
        if (!ChangePropertiesOperation.validMimeType(contentType)) {
            return FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangePropertiesOperation_11, (Object[])new String[]{contentType}, (Object[])new Object[0]));
        }
        return Status.OK_STATUS;
    }

    private IStatus validatePropertyValue(String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.ChangePropertiesOperation_5, (Object)propertyName, (Object[])new Object[0]));
        }
        if (propertyValue.length() > 250) {
            return new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.ChangePropertiesOperation_9, (Object)propertyName, (Object[])new Object[]{250}));
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validatePropertyName(String propertyName) {
        if (propertyName == null) {
            return new Status(4, "com.ibm.team.filesystem.client", Messages.ChangePropertiesOperation_2);
        }
        if (propertyName.trim().length() != propertyName.length()) {
            return new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.ChangePropertiesOperation_6, (Object)propertyName, (Object[])new Object[0]));
        }
        if (propertyName.length() > 128) {
            return new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.ChangePropertiesOperation_7, (Object)propertyName, (Object[])new Object[]{128}));
        }
        if (propertyName.length() == 0) {
            return new Status(4, "com.ibm.team.filesystem.client", Messages.ChangePropertiesOperation_8);
        }
        for (String nameSpace : IScmProperties.reservedNamespaces) {
            if (!propertyName.startsWith(nameSpace)) continue;
            return new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.ChangePropertiesOperation_3, (Object)propertyName, (Object[])new Object[]{nameSpace}));
        }
        if (propertyName.equals("contentType") || propertyName.equals("fileTimestamp")) {
            return new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.ChangePropertiesOperation_4, (Object)propertyName, (Object[])new Object[0]));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.changeProperties.isEmpty()) {
            return;
        }
        ISchedulingRule rule = this.makeSchedulingRule((IProgressMonitor)progress.newChild(10));
        final List<IShareable> allShareables = this.getAffectedShareables();
        IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 + 8 * ChangePropertiesOperation.this.changeProperties.size()));
                try {
                    if (ChangePropertiesOperation.this.getRefreshBeforeRun()) {
                        int shareableSize = allShareables.size();
                        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)(shareableSize * 2));
                        monitor.setTaskName(Messages.ChangeHistoryChangeSetsOperation_REFRESHING_FILESYSTEM);
                        List<IShareable> shareables = ChangeSetRefreshUtils.rationalizeRefreshTree(allShareables);
                        for (IShareable shareable : shareables) {
                            ((Shareable)shareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)subProgress.newChild(1));
                        }
                        LocalChangeManager.getInstance().refreshChanges(shareables, (IProgressMonitor)subProgress.newChild(shareableSize));
                    }
                }
                catch (FileSystemException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
                ICopyFileAreaManager.ICopyFileAreaLockRequestFactory factory = ICopyFileAreaManager.instance.lockRequestFactory();
                ICopyFileAreaLockRequest lockToObtain = factory.getLockRequest(allShareables);
                try {
                    ICopyFileAreasLock copyFileAreaRule = ICopyFileAreaManager.instance.lock(Collections.singleton(lockToObtain), (IProgressMonitor)subMonitor.newChild(1));
                    try {
                        ChangePropertiesOperation.this.updateProperties((IProgressMonitor)subMonitor.newChild(8 * ChangePropertiesOperation.this.changeProperties.size()));
                    }
                    finally {
                        copyFileAreaRule.release((IProgressMonitor)subMonitor.newChild(1));
                    }
                }
                catch (FileSystemException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
            }
        };
        this.runWithinFileSystemLock(workspaceOp, "Change Properties", rule, (IProgressMonitor)progress.newChild(90));
    }

    private List<IShareable> getAffectedShareables() {
        ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        for (ChangePropertiesRequest request : this.changeProperties.values()) {
            shareables.add(request.shareable);
        }
        return shareables;
    }

    private ISchedulingRule makeSchedulingRule(IProgressMonitor monitor) throws FileSystemException {
        List<IShareable> affected = this.getAffectedShareables();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)affected.size());
        HashSet<IShareable> shares = new HashSet<IShareable>();
        for (IShareable shareable : affected) {
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) continue;
            shares.add(share.getShareable());
        }
        return SharingManager.getInstance().makeSchedulingRuleForIDE(shares);
    }

    private void updateProperties(IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.changeProperties.size() * 2 + 12));
        ArrayList<ChangePropertiesRequest> inconsistentDelimiters = new ArrayList<ChangePropertiesRequest>();
        ArrayList<ChangePropertiesRequest> invalidProperties = new ArrayList<ChangePropertiesRequest>();
        ArrayList<ChangePropertiesRequest> invalidContentTypes = new ArrayList<ChangePropertiesRequest>();
        ArrayList<ChangePropertiesRequest> executableFailures = new ArrayList<ChangePropertiesRequest>();
        for (ChangePropertiesRequest request : this.changeProperties.values()) {
            this.checkCancelled((IProgressMonitor)progress);
            this.convert(request, inconsistentDelimiters, invalidProperties, invalidContentTypes, executableFailures, (IProgressMonitor)progress.newChild(1));
        }
        if (!invalidContentTypes.isEmpty()) {
            int result = this.dilemmaHandler.invalidContentTypes(invalidContentTypes, (IProgressMonitor)progress.newChild(1));
            if (result == 0) {
                progress.setWorkRemaining(invalidContentTypes.size());
                for (ChangePropertiesRequest request : invalidContentTypes) {
                    if (!request.isChangeContentTypeRequest()) continue;
                    this.changeContentProperties(request, null, null, null, null, (IProgressMonitor)progress.newChild(1));
                }
            } else if (result != 1) {
                this.collectStatus(this.createInvalidContentTypeErrorStatus(invalidContentTypes));
                if (!invalidProperties.isEmpty()) {
                    this.collectStatus(this.createInvalidPropertiesErrorStatus(invalidProperties));
                }
                if (!inconsistentDelimiters.isEmpty()) {
                    this.collectStatus(this.createInconsistentErrorStatus(inconsistentDelimiters));
                }
                if (!executableFailures.isEmpty()) {
                    this.collectStatus(this.createExecutableFailureErrorStatus(executableFailures));
                }
                this.reportErrorsAsException(this.getErrors());
            } else {
                throw new OperationCanceledException();
            }
        }
        if (!invalidProperties.isEmpty()) {
            int result = this.dilemmaHandler.invalidProperties(invalidProperties, (IProgressMonitor)progress.newChild(1));
            if (result == 0) {
                for (ChangePropertiesRequest request : invalidProperties) {
                    Map<String, IStatus> invalid = request.getInvalidProperties();
                    for (String propertyName : invalid.keySet()) {
                        request.propertyUpdates.remove(propertyName);
                    }
                    this.changeUserProperties(request, null, null, null, null, (IProgressMonitor)progress.newChild(1));
                }
            } else if (result != 1) {
                this.collectStatus(this.createInvalidPropertiesErrorStatus(invalidProperties));
                if (!inconsistentDelimiters.isEmpty()) {
                    this.collectStatus(this.createInconsistentErrorStatus(inconsistentDelimiters));
                }
                if (!executableFailures.isEmpty()) {
                    this.collectStatus(this.createExecutableFailureErrorStatus(executableFailures));
                }
                this.reportErrorsAsException(this.getErrors());
            } else {
                throw new OperationCanceledException();
            }
        }
        if (!inconsistentDelimiters.isEmpty()) {
            int result = this.dilemmaHandler.inconsistentLineDelimiters(Collections.unmodifiableList(inconsistentDelimiters), (IProgressMonitor)progress.newChild(1));
            if (result == 0) {
                progress.setWorkRemaining(inconsistentDelimiters.size());
                for (ChangePropertiesRequest request : inconsistentDelimiters) {
                    if (!request.isChangeLineDelimiterRequest() || !request.isForceLineDelimiterChange()) continue;
                    this.changeContentProperties(request, null, null, null, null, (IProgressMonitor)progress.newChild(1));
                }
            } else if (result != 1) {
                if (!executableFailures.isEmpty()) {
                    this.collectStatus(this.createExecutableFailureErrorStatus(executableFailures));
                }
                this.collectStatus(this.createInconsistentErrorStatus(inconsistentDelimiters));
                this.reportErrorsAsException(this.getErrors());
            } else {
                throw new OperationCanceledException();
            }
        }
        if (!executableFailures.isEmpty()) {
            this.dilemmaHandler.executableFailures(Collections.unmodifiableList(executableFailures), (IProgressMonitor)progress.newChild(1));
        }
    }

    private IStatus createInvalidContentTypeErrorStatus(ArrayList<ChangePropertiesRequest> invalidContentTypes) {
        IStatus[] reportedInvalidContentTypes = new IStatus[invalidContentTypes.size()];
        int i = 0;
        for (IChangePropertiesRequest iChangePropertiesRequest : invalidContentTypes) {
            reportedInvalidContentTypes[i] = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_13, (Object)iChangePropertiesRequest.getShareableToChange().getLocalPath(), (Object[])new Object[0]));
            ++i;
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, reportedInvalidContentTypes, Messages.ChangeFilePropertiesOperation_14, null);
        return multiStatus;
    }

    private IStatus createInvalidPropertiesErrorStatus(ArrayList<ChangePropertiesRequest> invalidProperties) {
        IStatus[] reportedBadProperties = new IStatus[invalidProperties.size()];
        int i = 0;
        for (IChangePropertiesRequest iChangePropertiesRequest : invalidProperties) {
            reportedBadProperties[i] = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangePropertiesOperation_0, (Object)iChangePropertiesRequest.getShareableToChange().getLocalPath(), (Object[])new Object[0]));
            ++i;
        }
        return new MultiStatus("com.ibm.team.filesystem.client", 0, reportedBadProperties, Messages.ChangePropertiesOperation_1, null);
    }

    private IStatus createInconsistentErrorStatus(ArrayList<ChangePropertiesRequest> inconsistentDelimiters) {
        IStatus[] reportedInconsistencies = new IStatus[inconsistentDelimiters.size()];
        int i = 0;
        for (IChangePropertiesRequest iChangePropertiesRequest : inconsistentDelimiters) {
            reportedInconsistencies[i] = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_2, (Object)iChangePropertiesRequest.getShareableToChange().getLocalPath(), (Object[])new Object[0]));
            ++i;
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, reportedInconsistencies, Messages.ChangeFilePropertiesOperation_3, null);
        return multiStatus;
    }

    private IStatus createExecutableFailureErrorStatus(ArrayList<ChangePropertiesRequest> executableFailures) {
        IStatus[] reportedExecutableFailures = new IStatus[executableFailures.size()];
        int i = 0;
        for (IChangePropertiesRequest iChangePropertiesRequest : executableFailures) {
            reportedExecutableFailures[i] = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_15, (Object)iChangePropertiesRequest.getShareableToChange().getLocalPath(), (Object[])new Object[0]));
            ++i;
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, reportedExecutableFailures, Messages.ChangeFilePropertiesOperation_16, null);
        return multiStatus;
    }

    private void convert(ChangePropertiesRequest request, ArrayList<ChangePropertiesRequest> inconsistentDelimiters, ArrayList<ChangePropertiesRequest> invalidProperties, ArrayList<ChangePropertiesRequest> invalidContentTypes, ArrayList<ChangePropertiesRequest> executableFailures, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)22);
        try {
            ResourceType type = request.getShareableToChange().getResourceType((IProgressMonitor)progress.newChild(1));
            if (type == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_11, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                return;
            }
            IShare share = request.getShareableToChange().getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_9, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                return;
            }
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(request.shareable.getSandbox().getRoot());
            FileItemInfo oldInfo = copyFileArea.getItemInfo(request.shareable.getLocalPath());
            if (oldInfo == null) {
                String msg = NLS.bind((String)Messages.ChangeFilePropertiesOperation_1, (Object)request.getShareableToChange().getLocalPath().toString(), (Object[])new Object[0]);
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, msg, (Throwable)((Object)new FileSystemException(msg))));
                return;
            }
            progress.setTaskName(NLS.bind((String)Messages.ChangeFilePropertiesOperation_0, (Object)request.shareable.getLocalPath().toString(), (Object[])new Object[0]));
            if (request.isChangePropertiesRequest()) {
                this.changeUserProperties(request, invalidProperties, copyFileArea, share, oldInfo, (IProgressMonitor)progress.newChild(10));
            }
            if (request.isChangeContentTypeRequest() || request.isChangeLineDelimiterRequest()) {
                if (type != ResourceType.FILE) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_12, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[]{type.name()}), null));
                    return;
                }
                this.changeContentProperties(request, inconsistentDelimiters, invalidContentTypes, copyFileArea, oldInfo, (IProgressMonitor)progress.newChild(10));
            }
            if (request.isChangeLinkTypeRequest()) {
                this.changeLinkProperties(request, copyFileArea, oldInfo, share, (IProgressMonitor)progress.newChild(10));
            }
            if (request.isExecutableRequest() && !this.changeExecutableProperty(request, (IProgressMonitor)progress.newChild(10)) && executableFailures != null) {
                executableFailures.add(request);
            }
        }
        catch (FileSystemException e) {
            IStatus status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_8, (Object)request.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)((Object)e));
            this.collectStatus(status);
        }
    }

    private boolean changeExecutableProperty(ChangePropertiesRequest request, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IFileStorage storage = request.shareable.getFileStorage();
        return storage.setExecutable(request.executable, (IProgressMonitor)progress.newChild(1));
    }

    private void changeLinkProperties(ChangePropertiesRequest request, ICopyFileArea copyFileArea, FileItemInfo oldInfo, IShare share, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage storage = request.shareable.getFileStorage();
        LinkInfo targetInfo = storage.getLinkInfo((IProgressMonitor)progress.newChild(1));
        storage.setTarget(new Shed(null), targetInfo.getTarget(), request.isDirectoryLink, (IProgressMonitor)progress.newChild(1));
        if (copyFileArea == null) {
            copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(request.shareable.getSandbox().getRoot());
            oldInfo = copyFileArea.getItemInfo(request.shareable.getLocalPath());
            if (oldInfo == null) {
                String msg = NLS.bind((String)Messages.ChangeFilePropertiesOperation_1, (Object)request.getShareableToChange().getLocalPath().toString(), (Object[])new Object[0]);
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, msg, (Throwable)((Object)new FileSystemException(msg))));
                return;
            }
            share = request.getShareableToChange().getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_9, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                return;
            }
        }
        FileItemInfoProxy newInfo = new FileItemInfoProxy(oldInfo);
        newInfo.setDirectoryLink(request.isDirectoryLink);
        copyFileArea.setItemMetaData(request.shareable.getLocalPath(), newInfo.getFileItemInfo(), ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(50));
    }

    /*
     * Unable to fully structure code
     */
    private void changeContentProperties(ChangePropertiesRequest request, ArrayList<ChangePropertiesRequest> inconsistentDelimiters, ArrayList<ChangePropertiesRequest> invalidContentTypes, ICopyFileArea copyFileArea, FileItemInfo oldInfo, IProgressMonitor monitor) throws FileSystemException {
        block47: {
            block51: {
                block49: {
                    block50: {
                        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        if (copyFileArea == null && (oldInfo = (copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(ChangePropertiesRequest.access$4(request).getSandbox().getRoot())).getItemInfo(ChangePropertiesRequest.access$4(request).getLocalPath())) == null) {
                            msg = NLS.bind((String)Messages.ChangeFilePropertiesOperation_1, (Object)request.getShareableToChange().getLocalPath().toString(), (Object[])new Object[0]);
                            this.collectStatus(FileSystemStatusUtil.getStatusFor(4, msg, (Throwable)new FileSystemException(msg)));
                            return;
                        }
                        lineDelimiter = request.isChangeLineDelimiterRequest() != false ? ChangePropertiesRequest.access$8(request) : oldInfo.getLineDelimiter();
                        if (request.isChangeContentTypeRequest()) {
                            contentType = ChangePropertiesRequest.access$9(request);
                            if (invalidContentTypes != null && !ChangePropertiesOperation.validMimeType(contentType)) {
                                contentType = oldInfo.getContentType();
                                invalidContentTypes.add(request);
                            }
                        } else {
                            contentType = oldInfo.getContentType();
                        }
                        newInfo = new FileItemInfoProxy(oldInfo);
                        newInfo.changeProperties(oldInfo.isContentChanged(), oldInfo.getLastContentChangeCheckStamp(), lineDelimiter, contentType, oldInfo.isExecutable());
                        copyFileArea.setItemMetaData(ChangePropertiesRequest.access$4(request).getLocalPath(), newInfo.getFileItemInfo(), ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(10));
                        try {
                            if (!request.isChangeLineDelimiterRequest() || lineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE) break block47;
                            convertingStream = null;
                            inputStream = null;
                            file = ChangePropertiesRequest.access$4(request).getFileStorage();
                            contentSet = false;
                            try {
                                encoding = SharingManager.getInstance().getContentExaminer(ChangePropertiesRequest.access$4(request)).getEncoding(ChangePropertiesRequest.access$4(request), (IProgressMonitor)progress.newChild(20));
                                options = new FileOptions(false, lineDelimiter, encoding, ChangePropertiesRequest.access$4(request).getMetadataProperties((IProgressMonitor)progress.newChild(1)).getCurrentProperties());
                                if (request.isForceLineDelimiterChange()) {
                                    convertingStream = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)file.getContents(options), (String)encoding, (FileLineDelimiter)lineDelimiter));
                                } else {
                                    block8 : switch (ChangePropertiesOperation.$SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter()[lineDelimiter.ordinal()]) {
                                        case 2: {
                                            convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(file.getContents(options), encoding));
                                            break;
                                        }
                                        case 4: {
                                            convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(file.getContents(options), encoding));
                                            break;
                                        }
                                        case 3: {
                                            convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(file.getContents(options), encoding));
                                            break;
                                        }
                                        case 5: {
                                            switch (ChangePropertiesOperation.$SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter()[FileLineDelimiter.getPlatformDelimiter().ordinal()]) {
                                                case 4: {
                                                    convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(file.getContents(options), encoding));
                                                    break block8;
                                                }
                                                case 2: {
                                                    convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(file.getContents(options), encoding));
                                                    break block8;
                                                }
                                                case 3: {
                                                    convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(file.getContents(options), encoding));
                                                    break block8;
                                                }
                                            }
                                            throw new IllegalStateException();
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                }
                                provider = TemporaryOutputStream.createLocalBuffer((InputStream)convertingStream, (IProgressMonitor)progress.newChild(10));
                                try {
                                    inputStream = provider.getInputStream((IProgressMonitor)progress.newChild(10));
                                    try {
                                        file.setContents(options, inputStream, this.shed, (IProgressMonitor)progress.newChild(40));
                                        contentSet = true;
                                    }
                                    finally {
                                        inputStream.close();
                                    }
                                }
                                finally {
                                    provider.dispose();
                                }
                            }
                            catch (Throwable var20_32) {
                                try {
                                    if (convertingStream != null) {
                                        convertingStream.close();
                                    }
                                }
                                catch (IOException v0) {}
                                try {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                catch (IOException v1) {}
                                if (!contentSet) {
                                    copyFileArea.setItemMetaData(ChangePropertiesRequest.access$4(request).getLocalPath(), oldInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(10));
                                }
                                throw var20_32;
                            }
                            try {
                                if (convertingStream != null) {
                                    convertingStream.close();
                                }
                            }
                            catch (IOException v2) {}
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException v3) {}
                            if (!contentSet) {
                                copyFileArea.setItemMetaData(ChangePropertiesRequest.access$4(request).getLocalPath(), oldInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)progress.newChild(10));
                            }
                            break block47;
                        }
                        catch (ContentLineDelimiterError e) {
                            if (inconsistentDelimiters != null) {
                                inconsistentDelimiters.add(request);
                            } else {
                                status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_7, (Object)ChangePropertiesRequest.access$4(request).getLocalPath().toString(), (Object[])new Object[0]), e);
                                this.collectStatus(status);
                            }
                            break block47;
                        }
                        catch (TeamRepositoryException e) {
                            status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_8, (Object)ChangePropertiesRequest.access$4(request).getLocalPath().toString(), (Object[])new Object[0]), e);
                            this.collectStatus(status);
                            break block47;
                        }
                        catch (UnsupportedCharsetException e) {
                            status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_4, (Object)ChangePropertiesRequest.access$4(request).getLocalPath().toString(), (Object[])new Object[0]), e);
                            this.collectStatus(status);
                            break block47;
                        }
                        catch (IOException e) {
                            if (!(e instanceof UnsupportedEncodingException)) break block49;
                            if (this.reportedSupportedCharSets) break block50;
                            charSetsAvailable = new StringBuffer();
                            ** for (charsetName : Charset.availableCharsets().keySet())
                        }
lbl-1000:
                        // 1 sources

                        {
                            charSetsAvailable.append(charsetName).append(' ');
                            continue;
                        }
lbl119:
                        // 1 sources

                        infoStatus = FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.ChangeFilePropertiesOperation_10, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                        this.collectStatus(infoStatus);
                        this.reportedSupportedCharSets = true;
                    }
                    status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_5, (Object)ChangePropertiesRequest.access$4(request).getLocalPath().toString(), (Object[])new Object[0]), e);
                    break block51;
                }
                status = e instanceof CharacterCodingException != false || e instanceof UnmappableCharacterException != false ? FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_6, (Object)ChangePropertiesRequest.access$4(request).getLocalPath().toString(), (Object[])new Object[0]), e) : FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_7, (Object)ChangePropertiesRequest.access$4(request).getLocalPath().toString(), (Object[])new Object[0]), e);
            }
            this.collectStatus(status);
        }
    }

    private void changeUserProperties(ChangePropertiesRequest request, ArrayList<ChangePropertiesRequest> invalidProperties, ICopyFileArea copyFileArea, IShare share, FileItemInfo oldInfo, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (copyFileArea == null) {
            copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(request.shareable.getSandbox().getRoot());
            oldInfo = copyFileArea.getItemInfo(request.shareable.getLocalPath());
            if (oldInfo == null) {
                String msg = NLS.bind((String)Messages.ChangeFilePropertiesOperation_1, (Object)request.getShareableToChange().getLocalPath().toString(), (Object[])new Object[0]);
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, msg, (Throwable)((Object)new FileSystemException(msg))));
                return;
            }
            share = request.getShareableToChange().getShare((IProgressMonitor)monitor.newChild(1));
            if (share == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_9, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                return;
            }
        }
        if (!request.getInvalidProperties().isEmpty()) {
            if (invalidProperties != null) {
                invalidProperties.add(request);
            } else {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ChangePropertiesOperation_0, (Object)request.getShareableToChange().getLocalPath(), (Object[])new Object[0])));
            }
        } else {
            InverseFileItemInfo inverseInfo = copyFileArea.getItemInfo(oldInfo.getVersionableHandle(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle(), true);
            copyFileArea.setProperties(share.getSharingDescriptor().getConnectionHandle(), share.getSharingDescriptor().getComponent(), oldInfo.getVersionableHandle(), new MetadataProperties(inverseInfo.getOriginalProperties(), request.propertyUpdates), (IProgressMonitor)monitor.newChild(99));
            request.propertyUpdates = null;
        }
    }

    @Override
    public void setIsDirectoryLink(IShareable target, boolean isDirectory) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        IRelativeLocation path = target.getLocalPath();
        ChangePropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangePropertiesRequest((Shareable)target, isDirectory));
        } else {
            existingRequest.changeLinkType = true;
            existingRequest.isDirectoryLink = isDirectory;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean validMimeType(String mime) {
        block20: {
            block14: {
                length = mime.length();
                indexOfSlash = mime.indexOf(47);
                if (indexOfSlash == -1 || indexOfSlash == length - 1) {
                    return false;
                }
                semicolonIndex = mime.indexOf(59);
                end = length;
                if (semicolonIndex != -1) {
                    if (semicolonIndex < indexOfSlash) {
                        return false;
                    }
                    end = semicolonIndex;
                }
                index = 0;
                while (index < end) {
                    c = mime.charAt(index);
                    if (index != indexOfSlash) {
                        if (Character.isWhitespace(c)) break;
                        if (!ChangePropertiesOperation.isMimeTypeTokenPart(c)) {
                            return false;
                        }
                    }
                    ++index;
                }
                if (semicolonIndex == -1) break block14;
                if ((index = ChangePropertiesOperation.skipAllWhiteSpaceCharacters(mime, index)) != semicolonIndex) {
                    return false;
                }
                currentChar = mime.charAt(index);
                while (currentChar == ';' && index < length) {
                    block15: {
                        block16: {
                            block17: {
                                block18: {
                                    block19: {
                                        if ((index = ChangePropertiesOperation.skipAllWhiteSpaceCharacters(mime, index + 1)) >= length) break block15;
                                        while (index < length && ChangePropertiesOperation.isMimeTypeTokenPart(currentChar = mime.charAt(index))) {
                                            ++index;
                                        }
                                        if ((index = ChangePropertiesOperation.skipAllWhiteSpaceCharacters(mime, index)) >= length) break block16;
                                        currentChar = mime.charAt(index);
                                        if (currentChar != '=') break block17;
                                        if ((index = ChangePropertiesOperation.skipAllWhiteSpaceCharacters(mime, index + 1)) >= length) break block18;
                                        currentChar = mime.charAt(index);
                                        if (currentChar != '\"') ** GOTO lbl44
                                        ++index;
                                        while (index < length && (currentChar = mime.charAt(index)) != '\"') {
                                            ++index;
                                        }
                                        if (index == length) {
                                            return false;
                                        }
                                        ++index;
                                        break block19;
lbl-1000:
                                        // 1 sources

                                        {
                                            ++index;
lbl44:
                                            // 2 sources

                                            ** while (index < length && ChangePropertiesOperation.isMimeTypeTokenPart((char)(currentChar = mime.charAt((int)index))))
                                        }
                                    }
                                    index = ChangePropertiesOperation.skipAllWhiteSpaceCharacters(mime, index);
                                    if (index < length) {
                                        currentChar = mime.charAt(index);
                                        continue;
                                    }
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        return false;
                    }
                    return false;
                }
                break block20;
            }
            if (index != length) {
                return false;
            }
        }
        return true;
    }

    private static boolean isMimeTypeTokenPart(char c) {
        if (c > ' ' && c < ':') {
            switch (c) {
                case '\"': 
                case '(': 
                case ')': 
                case ',': 
                case '/': {
                    return false;
                }
            }
        } else if (c > '@' && c < '\u007f') {
            switch (c) {
                case '[': 
                case '\\': 
                case ']': {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private static int skipAllWhiteSpaceCharacters(String mime, int index) {
        while (index < mime.length()) {
            if (!Character.isWhitespace(mime.charAt(index))) break;
            ++index;
        }
        return index;
    }

    @Override
    public void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    @Override
    public boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter() {
        if ($SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter != null) {
            return $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter;
        }
        int[] nArray = new int[FileLineDelimiter.values().length];
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_CR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_CRLF.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_LF.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_PLATFORM.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter = nArray;
        return nArray;
    }

    private class ChangePropertiesRequest
    implements IChangePropertiesRequest {
        private final Shareable shareable;
        private FileLineDelimiter lineDelimiter;
        private String contentType;
        private boolean forceLineDelimiterConversion;
        private boolean changeLinkType = false;
        private boolean executableType = false;
        private Map<String, String> propertyUpdates;
        private boolean isDirectoryLink;
        private boolean executable;

        public ChangePropertiesRequest(Shareable shareableFile, FileLineDelimiter lineDelimiter) {
            this.shareable = shareableFile;
            this.lineDelimiter = lineDelimiter;
            this.forceLineDelimiterConversion = false;
            this.propertyUpdates = null;
        }

        public ChangePropertiesRequest(Shareable shareableFile, String contentType) {
            this.shareable = shareableFile;
            this.contentType = contentType;
            this.forceLineDelimiterConversion = false;
            this.propertyUpdates = null;
        }

        public ChangePropertiesRequest(Shareable shareableFile, Boolean executable) {
            this.shareable = shareableFile;
            this.contentType = null;
            this.forceLineDelimiterConversion = false;
            this.propertyUpdates = null;
            this.executable = executable;
            this.executableType = true;
        }

        public ChangePropertiesRequest(Shareable shareableLink, boolean isDirectory) {
            this.shareable = shareableLink;
            this.changeLinkType = true;
            this.isDirectoryLink = isDirectory;
        }

        public ChangePropertiesRequest(Shareable shareable, Map<String, String> properties) {
            this.shareable = shareable;
            this.propertyUpdates = new HashMap<String, String>(properties);
        }

        @Override
        public IShareable getShareableToChange() {
            return this.shareable;
        }

        @Override
        public FileLineDelimiter getLineDelimiter(IProgressMonitor progress) throws FileSystemException {
            if (this.isChangeLineDelimiterRequest()) {
                return this.lineDelimiter;
            }
            return this.shareable.getLineDelimiter(progress);
        }

        @Override
        public String getContentType(IProgressMonitor monitor) throws FileSystemException {
            if (this.isChangeContentTypeRequest()) {
                return this.contentType;
            }
            return this.shareable.getContentType(monitor);
        }

        public boolean isChangeLinkTypeRequest() {
            return this.changeLinkType;
        }

        @Override
        public boolean isChangeLineDelimiterRequest() {
            return this.lineDelimiter != null;
        }

        @Override
        public boolean isChangeContentTypeRequest() {
            return this.contentType != null;
        }

        @Override
        public boolean isChangePropertiesRequest() {
            return this.propertyUpdates != null;
        }

        public boolean isExecutableRequest() {
            return this.executableType;
        }

        @Override
        public void setForceLineDelimiterConversion(boolean forceConversion) {
            if (!this.isChangeLineDelimiterRequest()) {
                throw new IllegalStateException();
            }
            this.forceLineDelimiterConversion = forceConversion;
        }

        @Override
        public boolean isForceLineDelimiterChange() {
            return this.forceLineDelimiterConversion;
        }

        @Override
        public Map<String, IStatus> getInvalidProperties() {
            if (this.propertyUpdates == null || this.propertyUpdates.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            return ChangePropertiesOperation.this.validateProperties(this.propertyUpdates);
        }

        public void setPropertyUpdates(Map<String, String> properties) {
            this.propertyUpdates = new HashMap<String, String>(properties);
        }

        @Override
        public void setContentType(String contentType) {
            if (!this.isChangeContentTypeRequest()) {
                throw new IllegalStateException();
            }
            this.contentType = contentType;
        }

        static /* synthetic */ FileLineDelimiter access$8(ChangePropertiesRequest changePropertiesRequest) {
            return changePropertiesRequest.lineDelimiter;
        }

        static /* synthetic */ String access$9(ChangePropertiesRequest changePropertiesRequest) {
            return changePropertiesRequest.contentType;
        }
    }
}

