/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.AbstractLockOperation;
import com.ibm.team.filesystem.client.operations.IUnlockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class UnlockOperation
extends AbstractLockOperation
implements IUnlockOperation {
    private boolean force = false;

    public UnlockOperation(LockDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    @Override
    protected void execute(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        int result = this.checkLockOwners((IProgressMonitor)monitor.newChild(25));
        switch (result) {
            case 1: {
                throw new OperationCanceledException();
            }
            case 2: {
                throw new FileSystemException(Messages.UnlockOperation_0);
            }
            case 0: {
                this.force = true;
                break;
            }
            case 3: {
                this.force = false;
            }
        }
        super.execute((IProgressMonitor)monitor.newChild(75));
    }

    @Override
    protected IWorkspaceManager.IVersionableLockOperation getLockOperation(IWorkspaceManager.IVersionableLockOperationFactory lockOperationFactory, LockEntry lockEntry, IWorkspaceConnection connection) {
        return lockOperationFactory.release(lockEntry.getVersionable(), connection, lockEntry.getComponent(), this.force);
    }

    @Override
    public void unlock(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        this.add(workspaceConnection, componentHandle, versionableHandle, contributorHandle);
    }

    @Override
    public void unlock(IWorkspaceConnection sourceWorkspaceConnection, IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        this.add(sourceWorkspaceConnection, workspaceConnection, componentHandle, versionableHandle, contributorHandle);
    }
}

