/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class ConfigurationFacade
extends ConnectionFacade
implements IConfigurationDescriptor {
    private final IComponentHandle componentHandle;
    private IConfiguration configuration;

    public ConfigurationFacade(ITeamRepository repo, ISharingDescriptor sharingDesc) {
        super(repo, sharingDesc.getConnectionHandle());
        this.componentHandle = sharingDesc.getComponent();
    }

    public ConfigurationFacade(IConnection connection, IComponentHandle component) {
        super(connection);
        this.componentHandle = component;
    }

    public ConfigurationFacade(IBaselineConnection connection) {
        super((IConnection)connection);
        this.componentHandle = connection.getComponent();
        this.configuration = connection.configuration();
    }

    public ConfigurationFacade(ITeamRepository repo, IContextHandle connection, IComponentHandle component) {
        super(repo, connection);
        this.componentHandle = component;
    }

    public IConfiguration getConfiguration(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.configuration == null) {
            IConnection ourConnection = this.getConnection(monitor);
            if (ourConnection instanceof IWorkspaceConnection) {
                this.configuration = ((IWorkspaceConnection)ourConnection).configuration(this.componentHandle);
            } else if (ourConnection instanceof IBaselineConnection) {
                this.configuration = ((IBaselineConnection)ourConnection).configuration();
            }
        }
        return this.configuration;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.componentHandle == null ? 0 : this.componentHandle.getItemId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationFacade other = (ConfigurationFacade)((Object)obj);
        return !(this.componentHandle == null ? other.componentHandle != null : !this.componentHandle.sameItemId((IItemHandle)other.componentHandle));
    }

    public IComponentHandle getComponentHandle() {
        return this.componentHandle;
    }

    public UUID getRepositoryId() {
        return this.id;
    }

    public IContextHandle getConnectionHandle() {
        return this.connectionHandle;
    }
}

