/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ParmsWorkspace
implements IValidatingParameterWrapper {
    public String repositoryUrl;
    public String workspaceItemId;

    public ParmsWorkspace() {
    }

    public ParmsWorkspace(ITeamRepository repo, IWorkspaceHandle workspaceHandle) {
        this.repositoryUrl = repo.getRepositoryURI();
        this.workspaceItemId = workspaceHandle.getItemId().getUuidValue();
    }

    public ParmsWorkspace(IWorkspaceConnection workspaceConnection) {
        this.repositoryUrl = workspaceConnection.teamRepository().getRepositoryURI();
        this.workspaceItemId = workspaceConnection.getResolvedWorkspace().getItemId().getUuidValue();
    }

    public ParmsWorkspace(String repositoryUrl, String workspaceItemId) {
        this.repositoryUrl = repositoryUrl;
        this.workspaceItemId = workspaceItemId;
    }

    @Override
    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.repositoryUrl, requestName, parameterName, "repositoryUrl");
        ParmValidation.requiredValue(this.workspaceItemId, requestName, parameterName, "workspaceItemId");
    }

    public ITeamRepository getTeamRepository() throws TeamRepositoryException {
        return CommonUtil.getTeamRepository(this.repositoryUrl);
    }

    public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor progress) throws TeamRepositoryException {
        ITeamRepository repo = this.getTeamRepository();
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.workspaceItemId), null);
        return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspaceHandle, progress);
    }

    public IWorkspaceHandle getWorkspaceHandle() throws TeamRepositoryException {
        ITeamRepository repo = CommonUtil.getTeamRepository(this.repositoryUrl);
        return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.workspaceItemId), null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.repositoryUrl == null ? 0 : this.repositoryUrl.hashCode());
        result = 31 * result + (this.workspaceItemId == null ? 0 : this.workspaceItemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParmsWorkspace other = (ParmsWorkspace)obj;
        if (this.repositoryUrl == null ? other.repositoryUrl != null : !this.repositoryUrl.equals(other.repositoryUrl)) {
            return false;
        }
        return !(this.workspaceItemId == null ? other.workspaceItemId != null : !this.workspaceItemId.equals(other.workspaceItemId));
    }
}

