/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.ControllableResourceImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaselineControlledFolder;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoConfiguration;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoFileItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLink;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.common.util.LineDelimiterVerifier;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ContentStorageException;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.util.VersionedContentManagerByteArrayInputStreamPovider;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.VersionedContentDeleted;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

public class JzRepoControllableResource
extends JzRepoResource {
    private static final String TEXT = "text";
    private static final String XML = "xml";
    private static final String HTML = "html";
    public static final List<PropertyNameList.PropertyName<?>> LATEST_VERSION_PROPERTIES = new ArrayList<PropertyNameList.PropertyName>(Arrays.asList(Resource.CONTENT_TYPE, Resource.CONTENT_CHARACTER_SET, Resource.CONTENT_LENGTH, Resource.IS_EXECUTABLE, InteropUtilities.PN_LINE_SEPARATOR, InteropUtilities.PN_SHA_256));
    private static final byte[] emptyContentByteArray = new byte[0];

    public JzRepoControllableResource(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    private JzRepoVersion getVersionProxy(IVersionableHandle versionHandle, SrvcFeedback f) throws WvcmException {
        if (versionHandle == null) {
            return null;
        }
        JzRepoComponent comp = this.getJzRepoComponent(f);
        JzLocation versionLoc = comp.location().createVersionLocation(JzRepoControllableResource.getItemStateDisplayName(versionHandle));
        JzRepoVersion result = JzRepoVersion.createAppropriateProxy(this.provider(), versionLoc, (IItemHandle)versionHandle, f);
        return result;
    }

    protected Object convertPropValueToClient(WorkspaceProvider provider, Object value, boolean isResourceList, PropertyRequestItem.PropertyRequest propertyRequest, SrvcResource configuration, SrvcFeedback sfb) throws WvcmException {
        if (value instanceof JzRepoVersion) {
            JzRepoVersion ver = (JzRepoVersion)((Object)value);
            Set props = propertyRequest.toMap().keySet();
            if (props.contains(Version.ACTIVITY) || props.contains(Version.COMMENT) || props.contains(Resource.CREATION_DATE) || props.contains(Version.PREDECESSOR_LIST)) {
                try {
                    IChangeSetSearchCriteria criteria = IChangeSetSearchCriteria.FACTORY.newInstance();
                    IVersionableHandle myHandle = (IVersionableHandle)this.getItemHandle(sfb);
                    criteria.setItem(myHandle);
                    criteria.setSearchIntermediatesForItem(false);
                    criteria.setContext(this.getWorkspaceConnection(sfb).getContextHandle());
                    IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.provider().getRepo());
                    List queryResults = manager.findChangeSets(criteria, 1, JzProvider.getMonitor(sfb, 10));
                    List items = this.provider().getRepo().itemManager().fetchCompleteItems(queryResults, 0, JzProvider.getMonitor(sfb, 20));
                    if (items.size() > 0) {
                        boolean hasRightVersion = false;
                        for (IChange ch : ((IChangeSet)items.get(0)).changes()) {
                            hasRightVersion |= ver.getItemHandle(sfb).sameStateId((IItemHandle)ch.afterState());
                        }
                        if (hasRightVersion) {
                            ver.setActivityValue(JzRepoChangeSet.create(this.provider(), (IChangeSetHandle)items.get(0), sfb));
                            if (props.contains(Version.PREDECESSOR_LIST)) {
                                for (IChange ch : ((IChangeSet)items.get(0)).changes()) {
                                    IVersionableHandle version = ch.afterState();
                                    IVersionableHandle predVersion = ch.beforeState();
                                    Iterator mergesIter = ch.mergeStates().iterator();
                                    if (predVersion == null || !version.getStateId().equals((Object)predVersion.getStateId())) {
                                        JzRepoVersion predVersionProxy = this.getVersionProxy(predVersion, sfb);
                                        if (predVersion == null) {
                                            ver.setPredecessorListValue(new ArrayList<JzRepoVersion>());
                                        } else {
                                            ver.addPredecessorValue(predVersionProxy, false);
                                        }
                                    }
                                    while (mergesIter.hasNext()) {
                                        IVersionableHandle pred = (IVersionableHandle)mergesIter.next();
                                        JzRepoVersion predVersionProxy = this.getVersionProxy(pred, sfb);
                                        if (pred == null) {
                                            ver.setPredecessorListValue(new ArrayList<JzRepoVersion>());
                                            continue;
                                        }
                                        ver.addPredecessorValue(predVersionProxy, true);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (TeamRepositoryException tre) {
                    throw JzProvider.wrapException(tre);
                }
            }
        }
        return super.convertPropValueToClient(provider, value, isResourceList, propertyRequest, configuration, sfb);
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getResourceIdentifier(feedback);
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            return this.getVersionHistory(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.CHECKED_IN)) {
            return this.latestVersion(false, feedback);
        }
        if (propertyName.equals((Object)ControllableResource.WORKSPACE)) {
            return this.getWvcmWorkspace(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.CONFIGURATION)) {
            return this.getWvcmConfiguration(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.IS_VERSION_CONTROLLED)) {
            return true;
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.getPathnameLocation(feedback);
        }
        if (LATEST_VERSION_PROPERTIES.contains(propertyName)) {
            return this.latestVersion(true, feedback).getThisProperty(propertyName, configuration, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private JzLocation.Kind getKind() {
        JzLocation.Kind kind = JzLocation.Kind.ControllableResource;
        if (this instanceof JzRepoSymbolicLink) {
            kind = JzLocation.Kind.SymbolicLink;
        } else if (this instanceof JzRepoControllableFolder) {
            kind = JzLocation.Kind.ControllableFolder;
        }
        return kind;
    }

    protected String getResourceIdentifier(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace(feedback.nest(50));
        JzRepoComponent comp = ws.getJzRepoComponent(this.location().getComponentLocation(), null);
        JzLocation riLoc = JzLocation.createCrLoc(JzRepoControllableResource.getCurrentStateDisplayName(this.getItemHandle(feedback)), ws.location(), comp.location(), this.getKind());
        return riLoc.string();
    }

    private JzLocation getVersionHistoryLocation(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace(feedback.nest(30));
        JzLocation compLoc = ws.getUriComponentLocation(this.location().getComponentLocation(), feedback.nest(60));
        JzLocation result = compLoc.createVersionHistoryLocation(JzRepoControllableResource.getCurrentStateDisplayName(this.getItemHandle(feedback)));
        return result;
    }

    public static JzLocation doAddItemToParent(JzProvider provider, JzLocation location, IVersionable addMe, SrvcFeedback feedback) throws WvcmException {
        JzRepoControllableFolder parent = JzRepoControllableResource.getParent(provider, location, feedback.nest(20));
        JzLocation result = parent.doAddItem(location.lastSegment(), addMe, feedback);
        return result;
    }

    private static JzRepoControllableFolder getParent(JzProvider provider, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        JzLocation parentLocation = location.parent();
        JzRepoResource possibleParent = provider.get((Location)parentLocation, feedback);
        if (!(possibleParent instanceof JzRepoControllableFolder)) {
            throw new WvcmException(NLS.bind((String)Messages.ERROR_NOT_A_CONTROLLABLE_FOLDER0, (Object)((Object)parentLocation), (Object[])new Object[0]), WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        JzRepoControllableFolder parent = (JzRepoControllableFolder)possibleParent;
        return parent;
    }

    public static JzRepoControllableResource doCreateControllableResource(JzProvider provider, JzLocation pnLoc, SrvcFeedback feedback) throws WvcmException {
        IFileItem addMe = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        addMe.setContent(JzRepoControllableResource.createEmptyContent(provider, feedback));
        addMe.setContentType("application/unknown");
        addMe.setFileTimestamp(new Date(System.currentTimeMillis()));
        JzRepoControllableResource.doAddItemToParent(provider, pnLoc, (IVersionable)addMe, feedback);
        JzRepoControllableResource result = new JzRepoControllableResource(provider, (Location)pnLoc);
        return result;
    }

    @Override
    public IItemHandle computeItemHandle(SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableResource.getItemHandleForControllableResource(this.provider(), this.location(), feedback);
    }

    public static IItemHandle getItemHandleForControllableResource(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        if (myLoc.hasComponentLocation() && !myLoc.kind().equals((Object)JzLocation.Kind.BaselineControlledFolder)) {
            JzRepoBaselineControlledFolder bcf = JzRepoControllableResource.getBCF(provider, myLoc, feedback);
            return bcf.getVersionableHandle(myLoc.getPath(), feedback);
        }
        return JzRepoControllableResource.getItemHandle(provider, myLoc);
    }

    private static JzRepoBaselineControlledFolder getBCF(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        JzRepoBaselineControlledFolder result = (JzRepoBaselineControlledFolder)provider.lookup((Location)myLoc.getBcfLocation(), feedback);
        if (result == null) {
            String msg = NLS.bind((String)Messages.JzRepoControllableResource_MSG_BCF_NOT_FOUND, (Object)((Object)myLoc), (Object[])new Object[0]);
            throw new WvcmException(msg, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public static JzRepoControllableResource lookup(JzProvider provider, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        JzRepoControllableResource result = null;
        JzLocation.Kind kind = loc.kind();
        switch (kind) {
            case BaselineControlledFolder: {
                result = new JzRepoBaselineControlledFolder(provider, (Location)loc);
                break;
            }
            case ControllableFolder: 
            case ControllableResource: 
            case NewControllableFolder: 
            case SymbolicLink: {
                result = JzRepoControllableResource.lookupCR(provider, loc, kind, feedback);
                break;
            }
            case FileSysPath: {
                result = JzRepoControllableResource.lookupFSP(provider, loc, feedback);
                break;
            }
            default: {
                try {
                    IVersionableHandle vH = (IVersionableHandle)JzRepoControllableResource.lookupItemHandle(provider, loc);
                    if (vH == null) break;
                    result = JzRepoControllableResource.createFromVersionable(provider, loc, vH);
                    break;
                }
                catch (WvcmException e) {
                    if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                        throw e;
                    }
                    provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoControllableResource.lookup", (Exception)((Object)e));
                    result = null;
                }
            }
        }
        return result;
    }

    private static JzRepoControllableResource lookupCR(JzProvider provider, JzLocation loc, JzLocation.Kind kind, SrvcFeedback feedback) throws WvcmException {
        IVersionableHandle vH;
        JzRepoWorkspace ws;
        JzRepoControllableResource result = null;
        JzLocation wsLoc = loc.lookupContextLocation(JzLocation.Kind.Workspace);
        JzLocation compLoc = loc.lookupContextLocation(JzLocation.Kind.Component);
        URI versionHistoryUri = loc.lookupURI();
        JzRepoWorkspace jzRepoWorkspace = ws = wsLoc == null ? null : JzRepoWorkspace.lookup(provider, wsLoc, feedback.nest(50));
        if (ws != null && compLoc != null && versionHistoryUri != null && (vH = ws.lookupVersionableHandle(compLoc, versionHistoryUri, feedback)) != null) {
            switch (kind) {
                case NewControllableFolder: {
                    result = new JzRepoControllableFolder(provider, (Location)loc);
                    break;
                }
                case ControllableResource: {
                    result = new JzRepoControllableResource(provider, (Location)loc);
                    break;
                }
                case SymbolicLink: {
                    result = new JzRepoSymbolicLink(provider, (Location)loc);
                    break;
                }
                default: {
                    result = new JzRepoControllableResource(provider, (Location)loc);
                }
            }
            result.setItemHandle((IItemHandle)vH);
        }
        feedback.notifyPercentComplete(100);
        return result;
    }

    private static JzRepoControllableResource lookupFSP(JzProvider provider, JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        IVersionableHandle itemHandle;
        JzRepoConfiguration config = JzRepoConfiguration.lookup(provider, loc, feedback.nest(10));
        if (config != null) {
            provider.applyDeferredContentCommits(config, loc, feedback.nest(20));
        }
        JzRepoControllableResource result = (itemHandle = (IVersionableHandle)JzRepoControllableResource.getItemHandleForControllableResource(provider, loc, feedback)) == null ? null : JzRepoControllableResource.createFromVersionable(provider, loc, itemHandle);
        return result;
    }

    public void doCheckout(ControllableResource.CheckoutFlag[] flags, SrvcFeedback feedback) throws WvcmException {
    }

    public void doCheckin(ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback);
    }

    public void doReadContent(OutputStream content, Resource accept, SrvcFeedback feedback) throws WvcmException {
        JzRepoFileItem fileItem = (JzRepoFileItem)this.latestVersion(true, feedback);
        fileItem.doReadContent(content, accept, feedback);
    }

    public void doVersionControl(SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits(feedback);
    }

    protected void applyDeferredContentCommits(SrvcFeedback feedback) throws WvcmException {
        this.provider().applyDeferredContentCommits(this.getWvcmConfiguration(feedback), feedback);
    }

    private void doWriteLineDelimiter(Object ls, SrvcFeedback feedback) throws WvcmException {
        JzRepoFileItem fileItem = (JzRepoFileItem)this.latestVersion(true, feedback);
        IFileItem item = (IFileItem)fileItem.fetchCompleteState(feedback.nest(20));
        IFileContentManager contentManager = FileSystemCore.getContentManager((ITeamRepository)this.provider().getRepo());
        InputStream input = null;
        IFileContent content = item.getContent();
        String characterEncoding = content.getCharacterEncoding();
        try {
            input = contentManager.retrieveContentStream((IFileItemHandle)item, content, characterEncoding, JzProvider.getLineDelimiter(InteropUtilities.LineSeparator.valueOf((String)ls.toString())), null);
        }
        catch (TeamRepositoryException tre) {
            throw JzProvider.wrapException(tre);
        }
        HashMap updates = new HashMap();
        updates.put(InteropUtilities.PN_LINE_SEPARATOR, new PropValue(InteropUtilities.PN_LINE_SEPARATOR, ls));
        updates.put(Resource.CONTENT_CHARACTER_SET, new PropValue(Resource.CONTENT_CHARACTER_SET, (Object)characterEncoding));
        ArrayList updated = new ArrayList();
        IFileContent newContent = this.createContent(item.getContentType(), input, updates, updated, content, feedback);
        IWorkspaceConnection.IConfigurationOp saveOp = JzRepoControllableResource.createNewFileItem(this.getWvcmWorkspace(feedback.nest(50)), item, null, newContent, null, null, feedback.nest(80));
        this.commit(saveOp, this.location(), feedback);
    }

    private void doWriteIsExecutable(boolean newIsExecutable, SrvcFeedback feedback) throws WvcmException {
        JzRepoFileItem fileItem = (JzRepoFileItem)this.latestVersion(true, feedback);
        IWorkspaceConnection.IConfigurationOp saveOp = JzRepoControllableResource.createNewFileItem(this.getWvcmWorkspace(feedback.nest(10)), (IFileItem)fileItem.fetchCompleteState(feedback.nest(20)), null, null, newIsExecutable, null, feedback.nest(30));
        this.commit(saveOp, this.location(), feedback);
    }

    public void doWriteContent(InputStream input, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        this.doWriteContentProperties(updates, updated, feedback.nest(20));
        JzRepoFileItem fileItem = (JzRepoFileItem)this.latestVersion(false, feedback.nest(40));
        IWorkspaceConnection.IConfigurationOp saveOp = this.doWriteContent((IFileItem)fileItem.fetchCompleteState(feedback.nest(45)), input, contentIdentifier, updates, updated, feedback.nest(60));
        this.deferOrCommitOperation(saveOp, feedback);
    }

    private void deferOrCommitOperation(IWorkspaceConnection.IConfigurationOp saveOp, SrvcFeedback feedback) throws WvcmException {
        JzRepoControllableResource.deferOrCommitOperation(this.provider(), this.location(), saveOp, feedback);
    }

    protected static void deferOrCommitOperation(JzProvider provider, JzLocation myLoc, IWorkspaceConnection.IConfigurationOp operation, SrvcFeedback feedback) throws WvcmException {
        if (operation != null) {
            JzRepoConfiguration config = JzRepoControllableResource.getWvcmConfiguration(provider, myLoc, feedback);
            if (provider.areContentCommitsDeferred()) {
                provider.deferOrCommitContentOp(config, operation, myLoc, feedback);
            } else {
                JzRepoControllableResource.commit(config, operation, myLoc, feedback);
            }
        }
    }

    private void doWriteContentProperties(Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        Map<PropertyNameList.PropertyName<?>, PropValue> supportedUpdates = JzRepoControllableResource.computeLatestVersionSupportedProperties(updates);
        this.doWriteProperties(supportedUpdates, updated, feedback);
    }

    private static Map<PropertyNameList.PropertyName<?>, PropValue> computeLatestVersionSupportedProperties(Map<PropertyNameList.PropertyName<?>, PropValue> updates) {
        HashMap supportedUpdates = new HashMap(updates);
        for (PropertyNameList.PropertyName<?> propertyName : LATEST_VERSION_PROPERTIES) {
            if (!supportedUpdates.containsKey(propertyName)) continue;
            supportedUpdates.remove(propertyName);
        }
        return supportedUpdates;
    }

    protected void commit(IVersionable saveMe, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection wsConn = this.getWorkspaceConnection(feedback.nest(20));
        this.commit((IWorkspaceConnection.IConfigurationOp)wsConn.configurationOpFactory().save(saveMe), location, feedback);
    }

    protected void commit(IWorkspaceConnection.IConfigurationOp configOp, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        JzRepoControllableResource.commit(this.getWvcmConfiguration(feedback), configOp, location, feedback);
    }

    static void commit(JzRepoConfiguration config, IWorkspaceConnection.IConfigurationOp configOp, JzLocation location, SrvcFeedback feedback) throws WvcmException {
        config.commit(configOp, location, feedback);
    }

    public IWorkspaceConnection.IConfigurationOp doWriteContent(IFileItem fileRepo, InputStream input, String contentIdentifierIgnored, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection.IConfigurationOp result = null;
        try {
            boolean newPropertiesAreSame;
            boolean encodingsMatch;
            Boolean newIsExecutable = JzRepoControllableResource.getIsExecutable(updates);
            boolean isExecutablesMatch = newIsExecutable == null || newIsExecutable.booleanValue() == fileRepo.isExecutable();
            IFileContent repoContent = fileRepo.getContent();
            String newContentType = JzRepoControllableResource.decideContentTypeToUse(fileRepo, updates, updated);
            IFileContent newContent = this.createContent(newContentType, input, updates, updated, repoContent, feedback);
            String repoEncoding = repoContent.getCharacterEncoding();
            String newEncoding = newContent.getCharacterEncoding();
            long repoLength = repoContent.getRawLength();
            long newLength = newContent.getRawLength();
            ContentHash repoHash = repoContent.getHash();
            ContentHash newHash = newContent.getHash();
            boolean typesMatch = fileRepo.getContentType().equals(newContentType);
            boolean bl = encodingsMatch = repoEncoding == null && newEncoding == null || repoEncoding != null && repoEncoding.equals(newEncoding);
            boolean ifNotTextLengthsMatch = repoEncoding == null && newEncoding == null ? repoLength == newLength : true;
            boolean bl2 = newPropertiesAreSame = isExecutablesMatch && typesMatch && encodingsMatch && ifNotTextLengthsMatch && repoHash.equals((Object)newHash);
            if (newPropertiesAreSame) {
                if (feedback != null) {
                    feedback.notifyActive(Messages.JzRepoFileItem_WARNING_DUPLICATE_CONTENT_WRITTEN);
                }
            } else {
                result = JzRepoControllableResource.createNewFileItem(this.getWvcmWorkspace(feedback.nest(40)), fileRepo, newContentType, newContent, newIsExecutable, updated, feedback);
            }
            return result;
        }
        catch (Exception e) {
            throw JzProvider.wrapException(e);
        }
    }

    private static String decideContentTypeToUse(IFileItem predFile, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated) throws WvcmException {
        String contentTypeToUse;
        String requestedContentType = JzRepoControllableResource.computeContentType(updates);
        String string = contentTypeToUse = requestedContentType != null ? requestedContentType : predFile.getContentType();
        if (requestedContentType != null) {
            updated.add(Resource.CONTENT_TYPE);
        }
        return contentTypeToUse;
    }

    private static IWorkspaceConnection.IConfigurationOp createNewFileItem(JzRepoWorkspace ws, IFileItem fileRepo, String newContentType, IFileContent newContent, Boolean newIsExecutable, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection.ISaveOp result = null;
        if (newContent != null || newIsExecutable != null) {
            IFileItem fileWorkingCopy = (IFileItem)fileRepo.getWorkingCopy();
            if (newContentType != null) {
                fileWorkingCopy.setContentType(newContentType);
            }
            if (newContent != null) {
                fileWorkingCopy.setContent(newContent);
            }
            fileWorkingCopy.setFileTimestamp(new Date(System.currentTimeMillis()));
            if (newIsExecutable != null) {
                fileWorkingCopy.setExecutable(newIsExecutable.booleanValue());
            }
            result = ws.getConnection(feedback).configurationOpFactory().save((IVersionable)fileWorkingCopy);
            if (newIsExecutable != null && updated != null) {
                updated.add(Resource.IS_EXECUTABLE);
            }
        }
        return result;
    }

    protected void checkWhetherPropertyCanBeSet(PropertyNameList.PropertyName<?> propertyName, Object value) throws WvcmException {
        if (propertyName.equals((Object)Resource.IS_EXECUTABLE)) {
            return;
        }
        super.checkWhetherPropertyCanBeSet(propertyName, value);
    }

    private static Boolean getIsExecutable(Map<PropertyNameList.PropertyName<?>, PropValue> updates) throws WvcmException {
        PropValue pv = updates.get(Resource.IS_EXECUTABLE);
        Boolean result = pv == null ? null : (Boolean)pv.get_value();
        return result;
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableResourceImpl.class;
    }

    public JzRepoVersionHistory getVersionHistory(SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory result = new JzRepoVersionHistory(this.provider(), (Location)this.getVersionHistoryLocation(feedback));
        result.setItemHandle(this.getItemHandle(feedback));
        return result;
    }

    protected JzRepoVersion latestVersion(boolean applyDeferredContentCommits, SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory myVersionable = this.getVersionHistory(feedback.nest(30));
        if (applyDeferredContentCommits) {
            this.applyDeferredContentCommits(feedback.nest(60));
        }
        JzRepoVersion result = myVersionable.getVersion(this.getConfiguration(feedback.nest(80)), feedback);
        return result;
    }

    public JzRepoConfiguration getWvcmConfiguration(SrvcFeedback feedback) throws WvcmException {
        return JzRepoControllableResource.getWvcmConfiguration(this.provider(), this.location(), feedback);
    }

    private static JzRepoConfiguration getWvcmConfiguration(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        JzLocation bcfLoc = myLoc.getBcfLocation();
        JzLocation resultLoc = bcfLoc.createConfigurationLoc();
        return (JzRepoConfiguration)provider.get((Location)resultLoc, feedback);
    }

    public JzLocation getComponentLocation() throws WvcmException {
        return this.location().getComponentLocation();
    }

    protected void readProperties(ResourceImpl resource, SrvcResource configuration, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        this.readThisProperty(resource, Resource.PATHNAME_LOCATION, null, configuration, feedback);
        super.readProperties(resource, configuration, propertyRequest, feedback);
    }

    @Override
    public Location getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        String[] segments;
        JzRepoComponent comp = this.getJzRepoComponent(feedback.nest(10));
        JzLocation result = this.getWvcmWorkspace(feedback.nest(20)).getPathnameLocation(feedback.nest(30));
        result = result.child(comp.getName(feedback));
        if (this.location().kind().equals((Object)JzLocation.Kind.BaselineControlledFolder)) {
            return result;
        }
        String[] stringArray = segments = this.location().getPath();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result = result.child(name);
            ++n2;
        }
        return result;
    }

    public JzRepoComponent getJzRepoComponent(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace(feedback);
        JzRepoComponent result = ws.getJzRepoComponent(this.location().getComponentLocation(), feedback);
        return result;
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.CONTENT_TYPE)) {
            return;
        }
        if (propertyName.equals((Object)Resource.CONTENT_CHARACTER_SET)) {
            return;
        }
        if (propertyName.equals((Object)Resource.IS_EXECUTABLE)) {
            Boolean xBit = (Boolean)value;
            this.doWriteIsExecutable(xBit, feedback);
        } else if (propertyName.equals((Object)InteropUtilities.PN_LINE_SEPARATOR)) {
            this.doWriteLineDelimiter(value, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    private boolean isPlainText(String contentType) {
        String type = contentType.trim().toLowerCase();
        return type.startsWith(TEXT) || type.endsWith(HTML) || type.endsWith(XML);
    }

    public IFileContent createContent(String contentType, InputStream input, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, IFileContent predContent, SrvcFeedback feedback) throws WvcmException {
        String requestedCharacterEncoding = JzRepoControllableResource.computeEncoding(updates);
        FileLineDelimiter requestedLineDelimiter = JzRepoControllableResource.computeLineDelimiter(updates);
        if (requestedCharacterEncoding == null && requestedLineDelimiter != null && !FileLineDelimiter.LINE_DELIMITER_NONE.equals((Object)requestedLineDelimiter)) {
            throw new IllegalArgumentException("contentEncoding must not be null when lineDelimiter is not null: " + requestedLineDelimiter.toString());
        }
        if (predContent == null && (contentType == null || requestedLineDelimiter == null)) {
            throw new IllegalArgumentException("updates must specify contentType, Encoding, LineDelimiter when predContent is null");
        }
        String contentEncodingToUse = requestedCharacterEncoding != null ? requestedCharacterEncoding : (predContent == null ? null : predContent.getCharacterEncoding());
        FileLineDelimiter lineDelimiterToUse = requestedLineDelimiter != null ? requestedLineDelimiter : predContent.getLineDelimiter();
        InputStream inputToUse = input;
        ContentHash predContentHash = predContent == null ? null : predContent.getHash();
        try {
            boolean convertVS;
            if (JzProvider.testingThrownException("com.ibm.team.connector.scm.client.forceContentUploadException")) {
                throw new ContentStorageException("Testing: simulate failed content upload");
            }
            if (this.isPlainText(contentType) && !FileLineDelimiter.LINE_DELIMITER_NONE.equals((Object)lineDelimiterToUse)) {
                LineDelimiterVerifier conversionStream = LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)input, (String)contentEncodingToUse, (FileLineDelimiter)lineDelimiterToUse);
                inputToUse = new ReaderToInputStream((InputStreamReader)conversionStream);
            }
            if ((convertVS = ((String)this.provider().initArgs().get("com.ibm.team.connector.scm.PROCESS_VISUAL_STUDIO_FILES")).equals("true")) && JzProvider.isVSFile((Location)this.location())) {
                inputToUse = JzProvider.convertSCPInVsFileToJazz((Location)this.location(), inputToUse, contentEncodingToUse, lineDelimiterToUse);
            }
            IFileContent newContent = JzRepoControllableResource.uploadContent(this.provider().getRepo(), contentEncodingToUse, lineDelimiterToUse, predContentHash, inputToUse, JzProvider.getMonitor(feedback, 80));
            if (requestedCharacterEncoding != null) {
                updated.add(Resource.CONTENT_CHARACTER_SET);
            }
            if (requestedLineDelimiter != null) {
                updated.add(InteropUtilities.PN_LINE_SEPARATOR);
            }
            return newContent;
        }
        catch (Exception e) {
            String friendlyPathname = this.getWorkspaceRelativePathname(feedback.nest(90));
            String msg = NLS.bind((String)Messages.JzRepoControllableResource_ERROR_CANT_CREATE_CONTENT_WITH_LOCATION, (Object)friendlyPathname, (Object[])new Object[0]);
            throw new WvcmException(msg, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static IFileContent uploadContent(ITeamRepository repo, String contentEncodingToUse, FileLineDelimiter lineDelimiterToUse, ContentHash predContentHash, InputStream inputStream, IProgressMonitor monitor) throws Exception {
        DisposableInputStreamProvider isProvider = TemporaryOutputStream.createLocalBuffer((InputStream)inputStream, (IProgressMonitor)monitor);
        IFileContent newContent = null;
        try {
            newContent = JzRepoControllableResource.uploadContentPrivate(repo, contentEncodingToUse, lineDelimiterToUse, predContentHash, isProvider, monitor);
        }
        catch (VersionedContentDeleted versionedContentDeleted) {
            newContent = JzRepoControllableResource.uploadContentPrivate(repo, contentEncodingToUse, lineDelimiterToUse, null, isProvider, monitor);
        }
        return newContent;
    }

    private static IFileContent uploadContentPrivate(ITeamRepository repo, String contentEncodingToUse, FileLineDelimiter lineDelimiterToUse, ContentHash predContentHash, final DisposableInputStreamProvider inputStreamProvider, IProgressMonitor monitor) throws TeamRepositoryException {
        IFileContent newContent = FileSystemCore.getContentManager((ITeamRepository)repo).storeContent(contentEncodingToUse, lineDelimiterToUse, new AbstractVersionedContentManagerInputStreamProvider(){

            public void dispose() throws IOException, TeamRepositoryException {
                inputStreamProvider.dispose();
            }

            public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                return inputStreamProvider.getInputStream(null);
            }

            public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                return in;
            }
        }, predContentHash, monitor);
        return newContent;
    }

    public String getWorkspaceRelativePathname(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = this.getJzRepoComponent(feedback);
        String[] pathSegments = this.location().getPath();
        String[] segments = new String[1 + pathSegments.length];
        segments[0] = comp.getName(feedback);
        System.arraycopy(pathSegments, 0, segments, 1, pathSegments.length);
        String friendlyPathnameForExceptionMsg = JzProvider.myToString(JzProvider.FWDSLASH, segments);
        return friendlyPathnameForExceptionMsg;
    }

    private static String computeContentType(Map<PropertyNameList.PropertyName<?>, PropValue> updates) throws WvcmException {
        PropValue contentTypePVal = updates.get(Resource.CONTENT_TYPE);
        String contentType = contentTypePVal != null ? (String)contentTypePVal.get_value() : null;
        return contentType;
    }

    private static String computeEncoding(Map<PropertyNameList.PropertyName<?>, PropValue> updates) throws WvcmException {
        PropValue contentEncodingPVal = updates.get(Resource.CONTENT_CHARACTER_SET);
        String contentEncoding = contentEncodingPVal != null ? (String)contentEncodingPVal.get_value() : null;
        return contentEncoding;
    }

    private static FileLineDelimiter computeLineDelimiter(Map<PropertyNameList.PropertyName<?>, PropValue> updates) throws WvcmException {
        PropValue lineSeparatorPVal = updates.get(InteropUtilities.PN_LINE_SEPARATOR);
        FileLineDelimiter lineDelimiter = null;
        if (lineSeparatorPVal != null) {
            String lsName = (String)lineSeparatorPVal.get_value();
            InteropUtilities.LineSeparator ls = lsName != null ? InteropUtilities.LineSeparator.valueOf((String)lsName) : InteropUtilities.LineSeparator.UNSPECIFIED;
            lineDelimiter = JzProvider.getLineDelimiter(ls);
        }
        return lineDelimiter;
    }

    protected static IFileContent createEmptyContent(JzProvider provider, SrvcFeedback feedback) throws WvcmException {
        try {
            IFileContent newContent = FileSystemCore.getContentManager((ITeamRepository)provider.getRepo()).storeContent(null, FileLineDelimiter.LINE_DELIMITER_NONE, (AbstractVersionedContentManagerInputStreamProvider)new VersionedContentManagerByteArrayInputStreamPovider(emptyContentByteArray), null, JzProvider.getMonitor(feedback, 100));
            return newContent;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public static JzRepoResource doCreateResourceWithContent(JzProvider provider, JzLocation myLoc, InputStream input, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        Map<PropertyNameList.PropertyName<?>, PropValue> supportedUpdates = JzRepoControllableResource.computeLatestVersionSupportedProperties(updates);
        if (supportedUpdates.keySet().size() > 0) {
            throw new IllegalArgumentException("cannot set non-content properties when writing to a new Versionable");
        }
        JzRepoControllableFolder parent = JzRepoControllableResource.getParent(provider, myLoc, feedback.nest(10));
        String bindingName = myLoc.lastSegment();
        myLoc = parent.location().child(bindingName);
        IFileItem addMe = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        addMe.setName(bindingName);
        addMe.setParent((IFolderHandle)parent.getItemHandle(feedback.nest(20)));
        JzRepoControllableResource result = new JzRepoControllableResource(provider, (Location)myLoc);
        try {
            String newContentType = JzRepoControllableResource.decideContentTypeToUse(addMe, updates, updated);
            IFileContent newContent = result.createContent(newContentType, input, updates, updated, null, feedback.nest(25));
            IWorkspaceConnection.IConfigurationOp op = JzRepoControllableResource.createNewFileItem(JzRepoControllableResource.getWvcmWorkspace(provider, myLoc, feedback.nest(30)), addMe, newContentType, newContent, JzRepoControllableResource.getIsExecutable(updates), updated, feedback.nest(60));
            JzRepoControllableResource.deferOrCommitOperation(provider, myLoc, op, feedback);
            return result;
        }
        catch (Exception e) {
            throw JzProvider.wrapException(e);
        }
    }
}

