/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util.tar;

import com.ibm.team.repository.common.internal.content.util.tar.TarEntry;
import com.ibm.team.repository.common.internal.content.util.tar.TarException;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.UnsynchronizedBufferedInputStream;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TarInputStream
extends FilterInputStream {
    static final int RECORD_SIZE = 512;
    static final int HDR_NAME_OFF = 0;
    static final int HDR_MODE_OFF = 100;
    static final int HDR_UID_OFF = 108;
    static final int HDR_GID_OFF = 116;
    static final int HDR_SIZE_OFF = 124;
    static final int HDR_MTIME_OFF = 136;
    static final int HDR_CKSUM_OFF = 148;
    static final int HDR_TYPEFLG_OFF = 156;
    static final int HDR_LINKNAME_OFF = 157;
    static final int HDR_MAGIC_OFF = 257;
    static final int HDR_VERSION_OFF = 263;
    static final int HDR_UNAME_OFF = 265;
    static final int HDR_GNAME_OFF = 297;
    static final int HDR_DEVMAJOR_OFF = 329;
    static final int HDR_DEVMINOR_OFF = 337;
    static final int HDR_PREFIX_OFF = 345;
    static final int HDR_GNUATIME_OFF = 345;
    static final int HDR_GNUCTIME_OFF = 357;
    static final int HDR_GNUOFFSET_OFF = 369;
    static final int HDR_GNULONGNAMES_OFF = 381;
    static final int HDR_GNUSPARSE_OFF = 386;
    static final int HDR_GNUISEXTENDED_OFF = 482;
    static final int HDR_GNUREALSIZE_OFF = 483;
    private TarEntry entry;
    private long readOffset;
    private long readSinceMark;
    private boolean markInCurrentEntry;
    private long nextEntryOffset;
    private final byte[] headerRec = new byte[512];
    private final byte[] byteBuf = new byte[1];
    private ExtendedAttributes attr;
    private ExtendedAttributes defaultAttr;

    public TarInputStream(InputStream in) {
        super(in);
    }

    public TarEntry getNextEntry() throws IOException {
        this.entry = null;
        this.readSinceMark = 0L;
        this.markInCurrentEntry = false;
        block3: while (true) {
            this.skipFully(this.nextEntryOffset - this.readOffset);
            this.readEntry();
            if (this.entry == null) {
                return null;
            }
            switch (this.entry.getTypeFlag()) {
                case 75: 
                case 76: 
                case 78: 
                case 86: 
                case 103: 
                case 120: {
                    continue block3;
                }
            }
            break;
        }
        return this.entry;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)super.available(), this.bytesRemainingInCurrentRecord());
    }

    public void closeEntry() throws IOException {
        this.entry = null;
        this.readSinceMark = 0L;
        this.markInCurrentEntry = false;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.entry = null;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark((int)Math.min((long)readlimit, this.bytesRemainingInCurrentRecord()));
        this.markInCurrentEntry = true;
        this.readSinceMark = 0L;
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.bytesRemainingInCurrentRecord() < 1L) {
            return -1;
        }
        do {
            if ((result = this.internalRead(this.byteBuf, 0, 1)) != -1) continue;
            throw new IOException(Messages.getServerString("TarInputStream.ErrorEOF"));
        } while (result == 0);
        return this.byteBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytesRemainingInCurrentRecord() < 1L) {
            return -1;
        }
        int result = this.internalRead(b, off, (int)Math.min((long)len, this.bytesRemainingInCurrentRecord()));
        if (result == -1) {
            throw new IOException(Messages.getServerString("TarInputStream.ErrorEOF"));
        }
        return result;
    }

    @Override
    public void reset() throws IOException {
        if (!this.markInCurrentEntry) {
            throw new IOException(Messages.getServerString("TarInputStream.ErrorResetUnsupported"));
        }
        this.in.reset();
        this.readOffset -= this.readSinceMark;
        this.readSinceMark = 0L;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.internalSkip(Math.min(n, this.bytesRemainingInCurrentRecord()));
    }

    private long bytesRemainingInCurrentRecord() {
        if (this.entry == null) {
            return 0L;
        }
        if (!TarInputStream.hasContent(this.entry)) {
            return 0L;
        }
        return this.entry.getOffset() + this.entry.getSize() - this.readOffset;
    }

    static boolean hasContent(TarEntry entry) {
        if (entry.getName().charAt(entry.getName().length() - 1) == '/') {
            return false;
        }
        switch (entry.getTypeFlag()) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return false;
            }
        }
        return true;
    }

    private void readEntry() throws IOException {
        this.readFully(this.headerRec);
        if (this.isZeroRec()) {
            return;
        }
        TarInputStream.verifyChecksum(this.headerRec);
        if (this.isPosixHeader()) {
            this.parsePosixHeader();
        } else if (this.isPrePosixHeader()) {
            this.parsePrePosixHeader();
        } else {
            this.parseV7Header();
        }
        switch (this.entry.getTypeFlag()) {
            case 103: {
                this.computeNextEntryOffset();
                this.defaultAttr = ExtendedAttributes.fromPax(null, this.defaultAttr, this);
                break;
            }
            case 120: {
                this.computeNextEntryOffset();
                this.attr = ExtendedAttributes.fromPax(this.attr, this.defaultAttr, this);
                break;
            }
            case 75: {
                this.computeNextEntryOffset();
                this.attr = ExtendedAttributes.fromGnuLongLink(this.attr, this.defaultAttr, this);
                break;
            }
            case 76: {
                this.computeNextEntryOffset();
                this.attr = ExtendedAttributes.fromGnuLongPath(this.attr, this.defaultAttr, this);
                break;
            }
            default: {
                this.populateExtendedAttributes();
                this.computeNextEntryOffset();
            }
        }
    }

    private void computeNextEntryOffset() {
        long entrySize;
        switch (this.entry.getTypeFlag()) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                entrySize = 0L;
                break;
            }
            default: {
                entrySize = this.entry.getSize();
            }
        }
        this.nextEntryOffset = this.entry.getOffset() + entrySize;
        if (this.nextEntryOffset % 512L != 0L) {
            this.nextEntryOffset += 512L - this.nextEntryOffset % 512L;
        }
    }

    private void populateExtendedAttributes() {
        if (this.attr == null) {
            return;
        }
        if (this.attr.atime != null) {
            this.entry.setAtime(this.attr.atime.longValue());
        }
        if (this.attr.ctime != null) {
            this.entry.setCtime(this.attr.ctime.longValue());
        }
        if (this.attr.mtime != null) {
            this.entry.setMtime(this.attr.mtime.longValue());
        }
        if (this.attr.uid != null) {
            this.entry.setUid(this.attr.uid.longValue());
        }
        if (this.attr.gid != null) {
            this.entry.setGid(this.attr.gid.longValue());
        }
        if (this.attr.uname != null) {
            this.entry.setUserName(this.attr.uname);
        }
        if (this.attr.gname != null) {
            this.entry.setGroupName(this.attr.gname);
        }
        if (this.attr.linkpath != null) {
            this.entry.setLinkName(this.attr.linkpath);
        }
        if (this.attr.path != null) {
            this.entry.setName(this.attr.path);
        }
        if (this.attr.size != null) {
            this.entry.setSize(this.attr.size.longValue());
        }
        this.attr = null;
    }

    private boolean isZeroRec() {
        int i = 0;
        while (i < this.headerRec.length) {
            if (this.headerRec[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isPosixHeader() {
        return this.headerRec[257] == 117 && this.headerRec[258] == 115 && this.headerRec[259] == 116 && this.headerRec[260] == 97 && this.headerRec[261] == 114 && this.headerRec[262] == 0;
    }

    private void parsePosixHeader() throws TarException {
        this.parsePrePosixHeader();
        String pathPrefix = TarInputStream.readString(this.headerRec, 345, 155);
        if (pathPrefix.length() != 0) {
            this.entry.setName(String.valueOf(pathPrefix) + "/" + this.entry.getName());
        }
    }

    private boolean isPrePosixHeader() {
        return this.headerRec[257] == 117 && this.headerRec[258] == 115 && this.headerRec[259] == 116 && this.headerRec[260] == 97 && this.headerRec[261] == 114 && this.headerRec[262] == 32;
    }

    private void parsePrePosixHeader() throws TarException {
        this.parseV7Header();
        this.entry.setUserName(TarInputStream.readString(this.headerRec, 265, 32));
        this.entry.setGroupName(TarInputStream.readString(this.headerRec, 297, 32));
        this.entry.setDevMajor(TarInputStream.readLong(this.headerRec, 329, 8));
        this.entry.setDevMinor(TarInputStream.readLong(this.headerRec, 337, 8));
    }

    private void parseV7Header() throws TarException {
        String name = TarInputStream.readString(this.headerRec, 0, 100);
        long mode = TarInputStream.readLong(this.headerRec, 100, 8);
        long uid = TarInputStream.readLong(this.headerRec, 108, 8);
        long gid = TarInputStream.readLong(this.headerRec, 116, 8);
        long size = TarInputStream.readLong(this.headerRec, 124, 12);
        long mtime = TarInputStream.readLong(this.headerRec, 136, 12);
        byte type = this.headerRec[156];
        String linkName = TarInputStream.readString(this.headerRec, 157, 100);
        this.entry = new TarEntry(name, mode, uid, gid, size, mtime, type, linkName, "", "", 0L, 0L, mtime, mtime, this.readOffset);
    }

    private static void verifyChecksum(byte[] header) throws IOException {
        long unsignedCheckSum = 256L;
        long signedCheckSum = 256L;
        int i = 0;
        while (i < 148) {
            signedCheckSum += (long)header[i];
            unsignedCheckSum += (long)(header[i] & 0xFF);
            ++i;
        }
        i = 156;
        while (i < header.length) {
            signedCheckSum += (long)header[i];
            unsignedCheckSum += (long)(header[i] & 0xFF);
            ++i;
        }
        long storedCheckSum = TarInputStream.readLong(header, 148, 8);
        if (storedCheckSum != signedCheckSum && storedCheckSum != unsignedCheckSum) {
            throw new TarException(Messages.getServerString("TarInputStream.ErrorFailedChecksum"));
        }
    }

    private static String readString(byte[] b, int offset, int length) {
        int max = offset + length;
        int i = offset;
        while (i < max && b[i] != 0) {
            ++i;
        }
        return new String(b, offset, i - offset);
    }

    private static long readLong(byte[] b, int offset, int length) throws TarException {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        if ((b[offset] & 0x80) != 0) {
            return TarInputStream.readBase256(b, offset, length);
        }
        return TarInputStream.readOctal(b, offset, length);
    }

    private static long readOctal(byte[] b, int offset, int length) throws TarException {
        long val = 0L;
        int i = offset;
        int max = offset + length;
        while (i < max && b[i] == 32) {
            ++i;
        }
        while (i < max && TarInputStream.isOctal(b[i])) {
            val <<= 3;
            val += (long)(b[i] - 48);
            ++i;
        }
        while (i < max) {
            if (b[i] != 0 && b[i] != 32) {
                String msg = NLS.bind(Messages.getServerString("TarInputStream.ErrorIllegalOctalNumber"), String.valueOf((char)b[i]), new Object[0]);
                throw new TarException(msg);
            }
            ++i;
        }
        return val;
    }

    private static long readBase256(byte[] b, int offset, int length) {
        long val = b[offset] & 0x7F;
        int max = offset + length;
        int i = offset + 1;
        while (i < max) {
            val <<= 8;
            val += (long)(b[i] & 0xFF);
            ++i;
        }
        return val;
    }

    private static boolean isOctal(byte b) {
        switch (b) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isDecimal(byte b) {
        switch (b) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    private int internalRead(byte[] buffer, int offset, int length) throws IOException {
        try {
            int result = super.read(buffer, offset, length);
            if (result != -1) {
                this.readOffset += (long)result;
                this.readSinceMark += (long)result;
            }
            return result;
        }
        catch (InterruptedIOException e) {
            this.readOffset += (long)e.bytesTransferred;
            this.readSinceMark += (long)e.bytesTransferred;
            throw e;
        }
    }

    private long internalSkip(long n) throws IOException {
        try {
            long result = super.skip(n);
            this.readOffset += result;
            this.readSinceMark += result;
            return result;
        }
        catch (InterruptedIOException e) {
            this.readOffset += (long)e.bytesTransferred;
            this.readSinceMark += (long)e.bytesTransferred;
            throw e;
        }
    }

    private void readFully(byte[] buffer) throws IOException {
        int bytesRead = 0;
        while (bytesRead < buffer.length) {
            int result = this.internalRead(buffer, bytesRead, buffer.length - bytesRead);
            if (result == -1) {
                throw new EOFException(Messages.getServerString("TarInputStream.ErrorEOF"));
            }
            bytesRead += result;
        }
    }

    private void skipFully(long skip) throws IOException {
        long toSkip = skip;
        while (toSkip != 0L) {
            long skipped = this.internalSkip(toSkip);
            toSkip -= skipped;
        }
    }

    private static class ExtendedAttributes {
        BigDecimal atime;
        BigDecimal ctime;
        BigDecimal mtime;
        BigInteger uid;
        BigInteger gid;
        String uname;
        String gname;
        String linkpath;
        String path;
        BigInteger size;

        public ExtendedAttributes(ExtendedAttributes defaultAttr) {
            if (defaultAttr != null) {
                this.atime = defaultAttr.atime;
                this.ctime = defaultAttr.ctime;
                this.mtime = defaultAttr.mtime;
                this.uid = defaultAttr.uid;
                this.gid = defaultAttr.gid;
                this.uname = defaultAttr.uname;
                this.gname = defaultAttr.gname;
                this.linkpath = defaultAttr.linkpath;
                this.path = defaultAttr.path;
                this.size = defaultAttr.size;
            }
        }

        public static ExtendedAttributes fromPax(ExtendedAttributes extAttr, ExtendedAttributes defaultAttr, InputStream inStream) throws IOException {
            int dig;
            ExtendedAttributes attr = extAttr;
            InputStream in = inStream;
            if (attr == null) {
                attr = new ExtendedAttributes(defaultAttr);
            }
            in = new UnsynchronizedBufferedInputStream(in);
            while ((dig = in.read()) != -1) {
                int lineLength = 0;
                int bytesRead = 1;
                do {
                    if (!TarInputStream.isDecimal((byte)dig)) {
                        String msg = NLS.bind(Messages.getServerString("TarInputStream.ErrorPAXDigit"), dig, new Object[0]);
                        throw new TarException(msg);
                    }
                    lineLength = lineLength * 10 + dig - 48;
                    dig = in.read();
                    if (dig == -1) {
                        throw new TarException(Messages.getServerString("TarInputStream.ErrorPAXEOF"));
                    }
                    ++bytesRead;
                } while (dig != 32);
                if (lineLength <= bytesRead) {
                    throw new TarException(Messages.getServerString("TarInputStream.ErrorPAXLineLength"));
                }
                byte[] buf = new byte[lineLength - bytesRead];
                ExtendedAttributes.readFully(in, buf);
                String line = new String(buf, "UTF-8");
                if (line.charAt(line.length() - 1) != '\n') {
                    throw new TarException(Messages.getServerString("TarInputStream.ErrorPAXMissingLF"));
                }
                int split = (line = line.substring(0, line.length() - 1)).indexOf(61);
                if (split == -1) {
                    String msg = NLS.bind(Messages.getServerString("TarInputStream.ErrorPAXInvalidData"), line, new Object[0]);
                    throw new TarException(msg);
                }
                String key = line.substring(0, split);
                String value = line.substring(split + 1);
                if (key.equals("atime")) {
                    attr.atime = new BigDecimal(value);
                    continue;
                }
                if (key.equals("ctime")) {
                    attr.ctime = new BigDecimal(value);
                    continue;
                }
                if (key.equals("mtime")) {
                    attr.mtime = new BigDecimal(value);
                    continue;
                }
                if (key.equals("uname")) {
                    attr.uname = value;
                    continue;
                }
                if (key.equals("uid")) {
                    attr.uid = new BigInteger(value);
                    continue;
                }
                if (key.equals("gname")) {
                    attr.gname = value;
                    continue;
                }
                if (key.equals("gid")) {
                    attr.gid = new BigInteger(value);
                    continue;
                }
                if (key.equals("linkpath")) {
                    attr.linkpath = value;
                    continue;
                }
                if (key.equals("path")) {
                    attr.path = value;
                    continue;
                }
                if (!key.equals("size")) continue;
                attr.size = new BigInteger(value);
            }
            return attr;
        }

        public static ExtendedAttributes fromGnuLongLink(ExtendedAttributes extAttr, ExtendedAttributes defaultAttr, InputStream in) throws IOException {
            ExtendedAttributes attr = extAttr;
            if (attr == null) {
                attr = new ExtendedAttributes(defaultAttr);
            }
            attr.linkpath = ExtendedAttributes.readString(in);
            return attr;
        }

        public static ExtendedAttributes fromGnuLongPath(ExtendedAttributes extAttr, ExtendedAttributes defaultAttr, InputStream in) throws IOException {
            ExtendedAttributes attr = extAttr;
            if (attr == null) {
                attr = new ExtendedAttributes(defaultAttr);
            }
            attr.path = ExtendedAttributes.readString(in);
            return attr;
        }

        private static String readString(InputStream in) throws IOException {
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
            try {
                byte[] buf = new byte[8192];
                int result = in.read(buf);
                while (result != -1) {
                    out.write(buf, 0, result);
                    result = in.read(buf);
                }
                byte[] byteArray = out.toByteArray();
                int len = 0;
                while (len < byteArray.length && byteArray[len] != 0) {
                    ++len;
                }
                String string = new String(byteArray, 0, len);
                return string;
            }
            finally {
                out.close();
            }
        }

        private static void readFully(InputStream in, byte[] buffer) throws IOException {
            int bytesRead = 0;
            while (bytesRead < buffer.length) {
                int result = in.read(buffer, bytesRead, buffer.length - bytesRead);
                if (result == -1) {
                    throw new EOFException(Messages.getServerString("TarInputStream.ErrorEOF"));
                }
                bytesRead += result;
            }
        }
    }
}

