/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.content;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.content.AbstractDownloadHandler;
import com.ibm.team.scm.client.content.AbstractUploadHandler;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.BasicVersionedContentManager;
import com.ibm.team.scm.client.content.ProgressHandlingVersionedContentManagerSession;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IVersionedContent;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class BasicSynchronousVersionedContentManagerSession<StoreContext, RetrieveContext>
extends ProgressHandlingVersionedContentManagerSession<StoreContext, RetrieveContext> {
    protected final BasicVersionedContentManager<StoreContext, RetrieveContext, ?> manager;
    protected MultiStatus errorStatus = new MultiStatus("com.ibm.team.scm.client", 0, "", null);

    public BasicSynchronousVersionedContentManagerSession(String name, long totalWork, BasicVersionedContentManager<StoreContext, RetrieveContext, ?> cm, IProgressMonitor mon) {
        super(name, totalWork, true, mon);
        this.manager = cm;
    }

    public void join() {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected InputStream getInputStream(IVersionableHandle handle, IVersionedContent content, RetrieveContext context, IProgressMonitor mon) throws TeamRepositoryException {
        return this.manager.retrieveContentStream(handle, content, context, mon);
    }

    @Override
    protected void internalRetrieveContent(IVersionableHandle handle, IVersionedContent content, AbstractDownloadHandler<RetrieveContext> handler, RetrieveContext context) throws TeamRepositoryException {
        try {
            this.handleCancel(handle, content, context, handler);
            handler.downloadStart(handle, content, context);
            int work = 0;
            if (this.expectedTransfers > 0L) {
                long completed = this.getCompletedTransfers();
                int oldProgress = (int)(completed * 1000L / this.expectedTransfers);
                int expectedProgress = (int)((completed + 1L) * 1000L / this.expectedTransfers);
                work = expectedProgress - oldProgress;
            }
            InputStream in = this.getInputStream(handle, content, context, (IProgressMonitor)this.monitor.newChild(work));
            try {
                handler.downloadStreamAcquired(handle, content, context, in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            this.handleCancel(handle, content, context, handler);
            handler.downloadCompleted(handle, content, context);
            this.handleCancel(handle, content, context, handler);
        }
        catch (Exception e) {
            IStatus statusToReturn;
            block16: {
                statusToReturn = null;
                if (e instanceof OperationCanceledException) {
                    statusToReturn = Status.CANCEL_STATUS;
                } else if (e.getCause() instanceof CoreException) {
                    statusToReturn = new MultiStatus("com.ibm.team.scm.client", 0, Messages.AsyncVersionedContentManagerSession_0, (Throwable)e);
                    ((MultiStatus)statusToReturn).add(((CoreException)e.getCause()).getStatus());
                } else {
                    statusToReturn = new Status(4, "com.ibm.team.scm.client", 0, Messages.AsyncVersionedContentManagerSession_0, (Throwable)e);
                }
                try {
                    handler.downloadFailed(handle, content, context, e);
                }
                catch (Exception unexpectedFailure) {
                    Object anotherError = unexpectedFailure instanceof OperationCanceledException ? Status.CANCEL_STATUS : new Status(4, statusToReturn.getPlugin(), 0, e.getMessage(), (Throwable)e);
                    if (statusToReturn instanceof MultiStatus) {
                        ((MultiStatus)statusToReturn).add(anotherError);
                        break block16;
                    }
                    statusToReturn = new MultiStatus(statusToReturn.getPlugin(), 0, new IStatus[]{statusToReturn, anotherError}, statusToReturn.getMessage(), null);
                }
            }
            this.errorStatus.add(statusToReturn);
        }
    }

    protected IVersionedContent internalDoStoreContent(AbstractUploadHandler<StoreContext> handler, AbstractVersionedContentManagerInputStreamProvider provider, ContentHash predecessorHintHash, StoreContext ctx, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.manager.storeContent(provider, predecessorHintHash, ctx, monitor);
    }

    @Override
    protected void internalStoreContent(AbstractUploadHandler<StoreContext> handler) throws TeamRepositoryException {
        int work = 0;
        if (this.expectedTransfers > 0L) {
            long completed = this.getCompletedTransfers();
            int oldProgress = (int)(completed * 1000L / this.expectedTransfers);
            int expectedProgress = (int)((completed + 1L) * 1000L / this.expectedTransfers);
            work = expectedProgress - oldProgress;
        }
        SubMonitor progress = this.monitor.newChild(work).setWorkRemaining(100);
        try {
            this.handleCancel(handler);
            ContentHash predecessorHintHash = handler.getPredecessorHintHash();
            StoreContext ctx = handler.getContext();
            handler.uploadStart();
            IVersionedContent content = this.internalDoStoreContent(handler, handler.getStreamProvider(), predecessorHintHash, ctx, (IProgressMonitor)progress.newChild(99));
            this.handleCancel(handler);
            handler.uploadCompleted(content);
            this.handleCancel(handler);
        }
        catch (Exception e) {
            IStatus statusToReturn;
            block11: {
                if (e instanceof OperationCanceledException) {
                    statusToReturn = Status.CANCEL_STATUS;
                } else if (e.getCause() instanceof CoreException) {
                    statusToReturn = new MultiStatus("com.ibm.team.scm.client", 0, Messages.AsyncVersionedContentManagerSession_1, (Throwable)e);
                    ((MultiStatus)statusToReturn).add(((CoreException)e.getCause()).getStatus());
                } else {
                    statusToReturn = new Status(4, "com.ibm.team.scm.client", 0, Messages.AsyncVersionedContentManagerSession_1, (Throwable)e);
                }
                try {
                    progress.setWorkRemaining(101);
                    AbstractUploadHandler.UploadFailureDirection direction = handler.uploadFailed(e, (IProgressMonitor)progress.newChild(1));
                    if (direction == AbstractUploadHandler.UploadFailureDirection.CONTINUE) {
                        return;
                    }
                }
                catch (Exception unexpectedFailure) {
                    Object anotherError = unexpectedFailure instanceof OperationCanceledException ? Status.CANCEL_STATUS : new Status(4, statusToReturn.getPlugin(), 0, e.getMessage(), (Throwable)e);
                    if (statusToReturn instanceof MultiStatus) {
                        ((MultiStatus)statusToReturn).add(anotherError);
                        break block11;
                    }
                    statusToReturn = new MultiStatus(statusToReturn.getPlugin(), 0, new IStatus[]{statusToReturn, anotherError}, statusToReturn.getMessage(), null);
                }
            }
            this.errorStatus.add(statusToReturn);
        }
    }

    protected void handleCancel(IVersionableHandle handle, IVersionedContent content, RetrieveContext ctx, AbstractDownloadHandler<RetrieveContext> handler) throws TeamRepositoryException {
        if (this.isCanceled()) {
            handler.downloadCanceled(handle, content, ctx);
            throw new OperationCanceledException();
        }
    }

    protected void handleCancel(AbstractUploadHandler<StoreContext> handler) throws TeamRepositoryException {
        if (this.isCanceled()) {
            handler.uploadCanceled();
            throw new OperationCanceledException();
        }
    }

    protected IStatus[] getErrorStatus() {
        return this.errorStatus.getChildren();
    }
}

