/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.CertificateHostnameMismatchException;
import com.ibm.team.repository.transport.client.InterruptableSocketFactory;
import com.ibm.team.repository.transport.client.SSLUtils;
import com.ibm.team.repository.transport.client.ValidatingX509TrustManager;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;

public class SecureInterruptableSocketFactory
extends InterruptableSocketFactory
implements SecureProtocolSocketFactory {
    public static final String SSL_TLS = "SSL_TLS";
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    private static final Log LOG = LogFactory.getLog(SecureInterruptableSocketFactory.class);
    private static final ConcurrentMap<String, X509Certificate> hostnameToCertificate = new ConcurrentHashMap<String, X509Certificate>();
    protected volatile X509Certificate[] lastKnownServerCertPath;
    protected final HandshakeCompletedListener handshakeListener = new HandshakeCompletedListener(){

        @Override
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            try {
                Certificate[] certs = event.getPeerCertificates();
                if (certs == null || certs.length == 0) {
                    return;
                }
                if (certs instanceof X509Certificate[]) {
                    SecureInterruptableSocketFactory.this.lastKnownServerCertPath = (X509Certificate[])certs;
                    return;
                }
                X509Certificate[] certPath = new X509Certificate[certs.length];
                int i = certs.length - 1;
                while (i >= 0) {
                    if (!(certs[i] instanceof X509Certificate)) {
                        return;
                    }
                    certPath[i] = (X509Certificate)certs[i];
                    --i;
                }
                SecureInterruptableSocketFactory.this.lastKnownServerCertPath = certPath;
            }
            catch (SSLPeerUnverifiedException e) {
                LOG.trace((Object)e);
            }
        }
    };
    private final SSLContext sslContext;
    private final ICertificateValidator validator;

    public SecureInterruptableSocketFactory(TrustManager trustManager) {
        this(null, trustManager, null);
    }

    public SecureInterruptableSocketFactory(KeyManager[] keyManagers, TrustManager trustManager) {
        this(keyManagers, trustManager, null);
    }

    public SecureInterruptableSocketFactory(ICertificateValidator validator) {
        this(null, new ValidatingX509TrustManager(validator), validator);
    }

    public SecureInterruptableSocketFactory(KeyManager[] keyManager, ICertificateValidator validator) {
        this(keyManager, new ValidatingX509TrustManager(validator), validator);
    }

    private SecureInterruptableSocketFactory(KeyManager[] keyManagers, TrustManager trustManager, ICertificateValidator validator) {
        this.sslContext = SSLUtils.createSSLContext(keyManagers, trustManager);
        this.validator = validator;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.createEncryptedSocket(socket, host, port, autoClose);
    }

    private void handleCertificateHostnameMismatch(String host, int port, SSLSocket sslSocket, IOException exp) throws SSLPeerUnverifiedException, IOException {
        String hostnameKey;
        X509Certificate savedCertificate;
        X509Certificate certificate = null;
        Certificate[] certificates = sslSocket.getSession().getPeerCertificates();
        if (certificates != null && certificates.length > 0 && certificates[0] instanceof X509Certificate) {
            certificate = (X509Certificate)certificates[0];
        }
        if ((savedCertificate = (X509Certificate)hostnameToCertificate.get(hostnameKey = String.valueOf(host) + '-' + port)) != null && savedCertificate.equals(certificate)) {
            return;
        }
        if (this.isPermanentlyAccepted(hostnameKey, certificate)) {
            hostnameToCertificate.put(hostnameKey, certificate);
            return;
        }
        if (this.validator != null) {
            CertificateHostnameMismatchException exception = new CertificateHostnameMismatchException(NLS.bind((String)Messages.getClientString("SecureInterruptableSocketFactory.ServerCertifiateHostnameMismatch"), (Object)host, (Object[])new Object[0]));
            ICertificateValidator.Trust trust = this.validator.validate(certificate, (CertificateException)exception);
            switch (trust) {
                case ACCEPT_CONNECTION: {
                    break;
                }
                case ACCEPT_PERMANENT: {
                    this.storePermanentlyAccepted(hostnameKey, certificate);
                    break;
                }
                case ACCEPT_SESSION: {
                    hostnameToCertificate.put(hostnameKey, certificate);
                    break;
                }
                case REJECT: {
                    throw exp;
                }
            }
        }
    }

    private String getHostnameCertStoreDirectory() {
        String userHome = System.getProperty("user.home");
        return String.valueOf(userHome) + "/.jazzhostnamecerts";
    }

    private boolean isPermanentlyAccepted(String host, X509Certificate certificate) throws IOException {
        X509Certificate savedCertificate;
        String certFilename = (String.valueOf(this.getHostnameCertStoreDirectory()) + '/' + host).replace('/', File.separatorChar);
        File file = new File(certFilename);
        if (!file.exists()) {
            return false;
        }
        FileInputStream input = new FileInputStream(file);
        try {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                savedCertificate = (X509Certificate)cf.generateCertificate(input);
            }
            catch (CertificateException exp) {
                LOG.warn((Object)NLS.bind((String)"The certificate in file \"{0}\" could not be read.", (Object)file.getAbsolutePath(), (Object[])new Object[0]), (Throwable)exp);
                input.close();
                return false;
            }
        }
        finally {
            input.close();
        }
        return savedCertificate.equals(certificate);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storePermanentlyAccepted(String host, X509Certificate certificate) throws IOException {
        dirName = this.getHostnameCertStoreDirectory();
        dir = new File(dirName);
        if (!dir.exists() && !dir.mkdirs()) {
            SecureInterruptableSocketFactory.LOG.warn((Object)NLS.bind((String)"The directory \"{0}\" could not be created", (Object)dir.getAbsolutePath(), (Object[])new Object[0]));
            return;
        }
        file = new File(dir, host);
        output = new FileOutputStream(file, false);
        try {
            try {
                buffer = ByteBuffer.wrap(certificate.getEncoded());
                ** GOTO lbl16
            }
            catch (CertificateEncodingException e) {
                SecureInterruptableSocketFactory.LOG.warn((Object)NLS.bind((String)"A certificate could not be saved to file \"{0}\".", (Object)file.getAbsolutePath(), (Object[])new Object[0]), (Throwable)e);
                output.close();
                return;
lbl16:
                // 1 sources

                if (true) ** GOTO lbl23
            }
        }
        catch (Throwable var9_9) {
            output.close();
            throw var9_9;
        }
        do {
            output.getChannel().write(buffer);
lbl23:
            // 2 sources

        } while (buffer.hasRemaining());
        output.close();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket unencryptedSocket = super.createSocket(host, port, localAddress, localPort);
        return this.createEncryptedSocket(unencryptedSocket, host, port, true);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket unencryptedSocket = super.createSocket(host, port);
        return this.createEncryptedSocket(unencryptedSocket, host, port, true);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket unencryptedSocket = super.createSocket(host, port, localAddress, localPort, params);
        return this.createEncryptedSocket(unencryptedSocket, host, port, true);
    }

    private Socket createEncryptedSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket sslSocket = null;
        boolean socketFailure = true;
        try {
            sslSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
            ((SSLSocket)sslSocket).addHandshakeCompletedListener(this.handshakeListener);
            ((SSLSocket)sslSocket).startHandshake();
            BrowserCompatHostnameVerifier verifier = new BrowserCompatHostnameVerifier();
            try {
                verifier.verify(host, (SSLSocket)sslSocket);
            }
            catch (IOException exp) {
                this.handleCertificateHostnameMismatch(host, port, (SSLSocket)sslSocket, exp);
            }
            socketFailure = false;
            Socket socket2 = sslSocket;
            return socket2;
        }
        finally {
            if (socketFailure) {
                if (sslSocket != null) {
                    sslSocket.close();
                }
                socket.close();
            }
        }
    }

    public X509Certificate[] getLastKnownServerCertificatePath() {
        return this.lastKnownServerCertPath;
    }
}

