/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.ri.impl.ComponentImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.VersionHistory;
import javax.wvcm.WvcmException;

public class JzRepoComponent
extends JzRepoResource {
    private static Map<JzLocation, IFolderHandle> rootFoldersMap;

    static {
        JzRepoComponent.clearCache();
    }

    public JzRepoComponent(JzProvider provider, Location childLoc) {
        super(provider, childLoc);
    }

    public static JzRepoComponent lookup(JzProvider provider, JzLocation compLoc, SrvcFeedback feedback) throws WvcmException {
        IComponentHandle cH;
        JzRepoComponent result = null;
        if (compLoc.isUriLocation() && (cH = JzRepoComponent.lookupComponentItemHandle(provider, compLoc, feedback)) != null) {
            result = JzRepoComponent.create(cH, provider);
        }
        return result;
    }

    public IComponent lookupComponentItem(SrvcFeedback feedback) throws WvcmException {
        IComponent result = null;
        JzProvider provider = this.provider();
        IItemHandle compH = this.lookupItemHandle();
        if (compH != null) {
            try {
                result = (IComponent)provider.getRepo().itemManager().fetchCompleteItem(compH, 0, JzProvider.getMonitor(feedback, 100));
            }
            catch (ItemNotFoundException e) {
                this.logIgnoredExceptionAsNotAlwaysVisible("JzRepoComponent.lookupComponentItem", (Exception)((Object)e), null);
            }
            catch (TeamRepositoryException e) {
                throw JzProvider.wrapException(e);
            }
        }
        return result;
    }

    public IComponent getComponentItem(SrvcFeedback feedback) throws WvcmException {
        IComponent result = null;
        JzProvider provider = this.provider();
        try {
            result = (IComponent)provider.getRepo().itemManager().fetchCompleteItem(this.getItemHandle(feedback), 0, JzProvider.getMonitor(feedback, 100));
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
        return result;
    }

    public static IComponentHandle lookupComponentItemHandle(JzProvider provider, JzLocation compLoc, SrvcFeedback feedback) throws WvcmException {
        IComponentHandle result = (IComponentHandle)JzRepoComponent.lookupItemHandle(provider, compLoc);
        return result;
    }

    protected IComponentHandle getItemHandleByURI(SrvcFeedback feedback) throws WvcmException {
        return JzRepoComponent.getComponentItemHandle(this.provider(), this.location(), feedback);
    }

    public static IComponentHandle getComponentItemHandle(JzProvider provider, JzLocation compLoc, SrvcFeedback feedback) throws WvcmException {
        IComponentHandle result = JzRepoComponent.lookupComponentItemHandle(provider, compLoc, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoComponent_ERROR_COULD_NOT_GET_COMPONENT_GIVEN_LOC, (Object)compLoc.toString(), (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public static void clearCache() {
        rootFoldersMap = new HashMap<JzLocation, IFolderHandle>();
    }

    public IFolderHandle getRootFolderHandle(SrvcFeedback feedback) throws WvcmException {
        JzLocation myLoc = this.location();
        if (rootFoldersMap.containsKey((Object)myLoc)) {
            return rootFoldersMap.get((Object)myLoc);
        }
        JzProvider provider = this.provider();
        try {
            IComponent comp = (IComponent)provider.getRepo().itemManager().fetchPartialItem((IItemHandle)this.getComponentItemHandle(feedback), 0, Collections.singletonList(IComponent.ROOT_FOLDER_PROPERTY), JzProvider.getMonitor(feedback, 100));
            IFolderHandle rootFolder = comp.getRootFolder();
            rootFoldersMap.put(myLoc, rootFolder);
            return rootFolder;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)VersionHistory.ROOT_VERSION)) {
            return this.getRootVersion(feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getName(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropCore.PN_CLONE)) {
            this.storeInteropCloneValue((String)value, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    @Override
    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropCore.PN_CLONE)) {
            this.removeInteropCloneValue(feedback);
        } else {
            super.removePropertyFromClient(propertyName, feedback);
        }
    }

    public JzRepoBaseline getRootVersion(SrvcFeedback f) throws WvcmException {
        return JzRepoBaseline.create(this, this.getInitialBaselineHandle(f));
    }

    public void createBaselineIfNeeded(JzRepoWorkspace ws, boolean identOK, String optionalName, SrvcFeedback feedback) throws WvcmException {
        IBaselineHandle blH;
        JzLocation myLoc = this.location().getComponentLocation();
        IBaselineHandle oldBLH = null;
        if (!identOK) {
            oldBLH = this.lookupLatestBaselineHandle((IFlowNodeConnection)ws.getConnection(feedback), feedback);
        }
        if ((blH = ws.createBaselineIfNeeded(ws.getComponent(myLoc, null), optionalName, oldBLH, feedback)) != null) {
            JzLocation blLoc = myLoc.createBaselineLoc(JzRepoComponent.getCurrentStateDisplayName((IItemHandle)blH));
            this.logCreation("Baseline", blLoc);
        }
    }

    public JzRepoBaseline getLatestBaseline(IWorkspaceConnection connection, SrvcFeedback feedback) throws WvcmException {
        JzRepoBaseline result = this.lookupLatestBaseline((IFlowNodeConnection)connection, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoComponent_ERROR_NO_BL_FOR_COMP, (Object)this.location().toString(), (Object[])new Object[0]), WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public JzRepoBaseline lookupLatestBaseline(IFlowNodeConnection wsConn, SrvcFeedback feedback) throws WvcmException {
        IBaselineHandle latestBaselineHandle = this.lookupLatestBaselineHandle(wsConn, feedback);
        JzRepoBaseline result = null;
        if (latestBaselineHandle != null) {
            result = this.createBaselineProxy(latestBaselineHandle);
        }
        return result;
    }

    public JzRepoBaseline createBaselineProxy(IBaselineHandle latestBaselineHandle) throws WvcmException {
        JzLocation compLoc = this.location().getComponentLocation();
        String blPath = JzRepoComponent.getCurrentStateDisplayName((IItemHandle)latestBaselineHandle);
        JzLocation blLoc = compLoc.createBaselineLoc(blPath);
        this.logDebug("latest baseline: " + blPath);
        JzRepoBaseline result = new JzRepoBaseline(this.provider(), blLoc);
        return result;
    }

    private IBaselineHandle lookupLatestBaselineHandle(IFlowNodeConnection conn, SrvcFeedback feedback) throws WvcmException {
        try {
            return conn.getComponentInfo(this.getComponentItemHandle(feedback)).basis();
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public IComponentHandle getComponentItemHandle(SrvcFeedback feedback) throws WvcmException {
        return JzRepoComponent.getComponentItemHandle(this.provider(), this.location(), feedback);
    }

    public String getName(SrvcFeedback feedback) throws WvcmException {
        IComponent myItem = this.getComponentItem(feedback);
        String result = myItem.getName();
        return result;
    }

    public static JzRepoComponent create(IComponentHandle myHandle, JzProvider provider) {
        JzLocation myLoc = JzRepoComponent.createComponentLocation(myHandle);
        JzRepoComponent result = new JzRepoComponent(provider, (Location)myLoc);
        result.setItemHandle((IItemHandle)myHandle);
        return result;
    }

    public String getResourceIdentifier(SrvcFeedback feedback) throws WvcmException {
        String result = JzRepoComponent.createComponentLocation(this.getComponentItemHandle(feedback)).string();
        return result;
    }

    public static JzLocation createComponentLocation(IComponentHandle myHandle) {
        String displayName = JzRepoComponent.getCurrentStateDisplayName((IItemHandle)myHandle);
        JzLocation myLoc = JzLocation.createComponentUriLocation(displayName);
        return myLoc;
    }

    @Override
    public Class<?> get_proxyClass() {
        return ComponentImpl.class;
    }

    public static String lookupComponentNameStringLoc(JzLocation compLoc) {
        String result = null;
        String displayName = compLoc.getDisplayName();
        if (displayName.startsWith("name:")) {
            result = displayName.substring("name:".length());
        }
        return result;
    }

    public boolean isSameObject(JzRepoComponent rhs, SrvcFeedback feedback) throws WvcmException {
        return this.getResourceIdentifier(feedback).equals(rhs.getResourceIdentifier(feedback));
    }

    public List<SrvcResource> doFindNamedBaselines(String displayName, boolean all, SrvcFeedback feedback) throws WvcmException {
        JzProvider p = this.provider();
        IBaselineSearchCriteria crit = IBaselineSearchCriteria.FACTORY.newInstance().setComponentRequired(this.getComponentItemHandle(feedback.nest(10)));
        crit.setExactName(displayName);
        try {
            List baselines = SCMPlatform.getWorkspaceManager((ITeamRepository)p.getRepo()).findBaselines(crit, Integer.MAX_VALUE, JzProvider.getMonitor(feedback, 100));
            ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(baselines.size());
            for (IBaselineHandle handle : baselines) {
                results.add(JzRepoBaseline.create(this, handle));
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw JzProvider.wrapException(e);
        }
    }

    public IBaselineHandle getInitialBaselineHandle(SrvcFeedback f) throws WvcmException {
        IComponent comp = this.getComponentItem(f.nest(20));
        return comp.getInitialBaseline();
    }
}

