/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;

@BridgeMethodsAdded
public final class Paths {
    public static String cleanSeparators(String path) {
        return path.replace('\\', '/').replaceAll("/+", "/");
    }

    public static boolean isSafe(String path) {
        return Paths.isRelative(path) && !path.startsWith("../") && !path.endsWith("/..") && !path.contains("/../") && !path.equals("..");
    }

    public static boolean isRelative(String path) {
        return !Paths.isAbsoluteUnix(path) && !Paths.isAbsoluteWindows(path);
    }

    public static boolean isAbsoluteUnix(String path) {
        return path.length() > 0 && path.charAt(0) == '/';
    }

    public static boolean isAbsoluteWindows(String path) {
        boolean result = false;
        if (path.length() > 2) {
            char c0 = path.charAt(0);
            char c1 = path.charAt(1);
            char c2 = path.charAt(2);
            result = (c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z') && c1 == ':' && Paths.isSlash(c2) || Paths.isSlash(c0) && Paths.isSlash(c1);
        }
        return result;
    }

    private static boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private Paths() {
        throw new IllegalArgumentException();
    }
}

