/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.internal.rest.IScmRestService;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScmRestServiceUtil {
    public static <T extends IItem> List<String> getItemIdsAsStrings(Collection<ItemId<T>> itemIds) {
        ArrayList<String> result = new ArrayList<String>();
        for (ItemId<T> next : itemIds) {
            result.add(next.getItemUUID().getUuidValue());
        }
        return result;
    }

    public static <T extends IItem> List<ItemId<T>> createItemIds(String[] uuids, IItemType itemType) {
        ArrayList<ItemId<T>> result = new ArrayList<ItemId<T>>();
        int i = 0;
        while (i < uuids.length) {
            String next = uuids[i];
            UUID nextUUID = UUID.valueOf((String)next);
            result.add(new ItemId(itemType, nextUUID));
            ++i;
        }
        return result;
    }

    public static IItemHandle createContextHandle(String type, String itemId) {
        if (type == null || itemId == null) {
            return null;
        }
        UUID uuid = UUID.valueOf((String)itemId);
        if (type.equals("baseline")) {
            return IBaseline.ITEM_TYPE.createItemHandle(uuid, null);
        }
        if (type.equals("baselineset")) {
            return IBaselineSet.ITEM_TYPE.createItemHandle(uuid, null);
        }
        if (type.equals("workspace")) {
            return IWorkspace.ITEM_TYPE.createItemHandle(uuid, null);
        }
        return null;
    }

    public static IItemHandle createHandle(String itemId, String itemTypeName, String itemTypeNamespace) {
        if (itemId == null || itemTypeName == null || itemTypeNamespace == null) {
            return null;
        }
        UUID uuid = UUID.valueOf((String)itemId);
        IItemType type = IItemType.IRegistry.INSTANCE.getItemType(itemTypeName, itemTypeNamespace);
        if (type == null) {
            return null;
        }
        IItemHandle handle = type.createItemHandle(uuid, null);
        return handle;
    }

    public static IChangeSetSearchCriteria convertSearchCriteria(IScmRestService.ParmsChangeSetSearchCriteria input) {
        IItemHandle versionable;
        IItemHandle contextHandle;
        IChangeSetSearchCriteria crit = IChangeSetSearchCriteria.FACTORY.newInstance();
        if (input.authorContributorItemId != null) {
            crit.setAuthor((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)input.authorContributorItemId), null));
        }
        if (input.changeType != null) {
            int changeType = input.changeType;
            crit.setChangeType(changeType);
        }
        if (input.componentItemId != null) {
            crit.setComponent((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)input.componentItemId), null));
        }
        if ((contextHandle = ScmRestServiceUtil.createContextHandle(input.contextType, input.contextHandleItemId)) instanceof IContextHandle) {
            crit.setContext((IContextHandle)contextHandle);
        }
        if (input.modifiedAfterTimestamp != null) {
            crit.setModifiedAfter(new Timestamp(input.modifiedAfterTimestamp));
        }
        if (input.modifiedBeforeTimestamp != null) {
            crit.setModifiedBefore(new Timestamp(input.modifiedBeforeTimestamp));
        }
        if (input.name != null) {
            crit.setName(input.name);
        }
        if (input.suspendedByContributorItemId != null) {
            crit.setSuspendedBy((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)input.suspendedByContributorItemId), null));
        }
        if ((versionable = ScmRestServiceUtil.createHandle(input.versionableItemId, input.versionableItemType, input.versionableItemTypeNamespace)) instanceof IVersionableHandle) {
            crit.setItem((IVersionableHandle)versionable);
        }
        return crit;
    }

    public static ILockSearchCriteria convertSearchCriteria(IScmRestService.ParmsLockSearchCriteria searchCriteria) {
        String s;
        int n;
        int n2;
        String[] stringArray;
        ILockSearchCriteria crit = ILockSearchCriteria.FACTORY.newInstance();
        if (searchCriteria.streamItemIds != null) {
            stringArray = searchCriteria.streamItemIds;
            n2 = searchCriteria.streamItemIds.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                crit.getStreams().add((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)s), null));
                ++n;
            }
        }
        if (searchCriteria.componentItemIds != null) {
            stringArray = searchCriteria.componentItemIds;
            n2 = searchCriteria.componentItemIds.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                crit.getComponents().add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)s), null));
                ++n;
            }
        }
        if (searchCriteria.versionableItemId != null) {
            int i = 0;
            while (i < searchCriteria.versionableItemId.length) {
                crit.getVersionables().add((IVersionableHandle)ScmRestServiceUtil.createHandle(searchCriteria.versionableItemId[i], searchCriteria.versionableItemType[i], searchCriteria.versionableItemTypeNamespace[i]));
                ++i;
            }
        }
        if (searchCriteria.lockedByContributorId != null) {
            crit.setContributor((IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)searchCriteria.lockedByContributorId), null));
        }
        return crit;
    }
}

