/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.workitems.internal.process;

import com.ibm.team.filesystem.common.workitems.internal.process.Messages;
import com.ibm.team.filesystem.common.workitems.internal.process.RequireWorkItemProblemObject;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.providers.ItemProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RequireWorkItemAdvisor
implements IOperationAdvisor {
    private static String ELEMENT_REQUIRES = "requires";
    private static String ATTR_VALUE = "value";
    public static String VAL_WORKITEM = "workitem";
    public static String VAL_COMMENT = "comment";
    public static String VAL_WORKITEM_OR_COMMENT = "workitem-or-comment";
    public static String VAL_WORKITEM_AND_COMMENT = "workitem-and-comment";
    private static String ELEMENT_WORKITEM = "workitem";
    private static String ATTR_TARGET = "target";
    private static String ATTR_OWNER = "owner";
    private static String VAL_REQUIRED = "required";
    private static String VAL_OPTIONAL = "optional";
    private static String VAL_CURRENT_ITERATION = "current-iteration";
    private static String VAL_CURRENT_CONTRIBUTOR = "current-contributor";
    public static final String ID_REQUIRE_WORK_ITEM = "com.ibm.team.process.deliver.requireWorkItem";
    public static final String ID_CONFIGURATION_PROBLEM = "com.ibm.team.process.definitions.requireWorkItem.configurationProblem";
    private String fRequires = VAL_WORKITEM;
    private String fTarget = VAL_OPTIONAL;
    private String fOwner = VAL_OPTIONAL;
    private final ProviderFactory provider;
    private ItemProvider items;

    public RequireWorkItemAdvisor(ProviderFactory provider) {
        this.provider = provider;
        this.items = provider.getItemProvider();
    }

    private void initialize(IProcessConfigurationElement advisorConfiguration) {
        IProcessConfigurationElement[] children = advisorConfiguration.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            String childName = child.getName();
            if (ELEMENT_REQUIRES.equals(childName)) {
                this.fRequires = child.getAttribute(ATTR_VALUE);
                IProcessConfigurationElement[] grandChildren = child.getChildren();
                int j = 0;
                while (j < grandChildren.length) {
                    IProcessConfigurationElement grandChild = grandChildren[j];
                    String grandChildName = grandChild.getName();
                    if (ELEMENT_WORKITEM.equals(grandChildName)) {
                        this.fTarget = grandChild.getAttribute(ATTR_TARGET);
                        this.fOwner = grandChild.getAttribute(ATTR_OWNER);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object opData = operation.getOperationData();
        if (!(opData instanceof DeliverOperationData)) {
            return;
        }
        DeliverOperationData data = (DeliverOperationData)opData;
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.PROGRESS"), 1000);
        try {
            try {
                this.initialize(advisorConfiguration);
                IProcessArea processArea = operation.getProcessArea();
                IProjectAreaHandle projectArea = processArea.getProjectArea();
                if (data.getChangeSetHandles().size() > 0 || data.getAtomicUpdateParm() != null && data.getAtomicUpdateComment() == null) {
                    this.addProblems(data, processArea, projectArea, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
                }
            }
            catch (TeamRepositoryException e) {
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.getString("RequireWorkItemAdvisor.ERROR_MSG"), (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addProblems(DeliverOperationData data, IProcessArea processArea, IProjectAreaHandle projectArea, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        if (data.getChangeSetHandles().size() == 0) {
            monitor.beginTask("", 1000);
        } else {
            monitor.beginTask("", 1000 * data.getChangeSetHandles().size() + 1);
        }
        try {
            if (!this.isValidRequiresValue(this.fRequires)) {
                collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemAdvisor.INTERNAL_CONFIGURATION_ERROR"), NLS.bind((String)Messages.getString("RequireWorkItemAdvisor.3"), (Object[])new Object[]{VAL_WORKITEM, VAL_COMMENT, VAL_WORKITEM_OR_COMMENT, VAL_WORKITEM_AND_COMMENT}, (Object[])new Object[0]), ID_CONFIGURATION_PROBLEM));
                monitor.done();
                return;
            }
            if (!this.isValidTargetValue(this.fTarget)) {
                collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemAdvisor.INTERNAL_CONFIGURATION_ERROR"), NLS.bind((String)Messages.getString("RequireWorkItemAdvisor.5"), (Object[])new Object[]{VAL_OPTIONAL, VAL_REQUIRED, VAL_CURRENT_ITERATION}, (Object[])new Object[0]), ID_CONFIGURATION_PROBLEM));
            }
            if (!this.isValidOwnerValue(this.fOwner)) {
                collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemAdvisor.INTERNAL_CONFIGURATION_ERROR"), NLS.bind((String)Messages.getString("RequireWorkItemAdvisor.7"), (Object[])new Object[]{VAL_OPTIONAL, VAL_REQUIRED, VAL_CURRENT_CONTRIBUTOR}, (Object[])new Object[0]), ID_CONFIGURATION_PROBLEM));
            }
            if (data.getChangeSetHandles().size() == 0) {
                this.addProblem(data, data.getAtomicUpdateComment(), false, Collections.EMPTY_LIST, null, collector, projectArea, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            Map links = ChangeSetLinks.resolveLinks((ProviderFactory)this.provider, (List)data.getChangeSetHandles(), (String)"com.ibm.team.filesystem.workitems.change_set", (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            for (IChangeSet changeSet : links.keySet()) {
                boolean hasOslcLinks;
                String comment = null;
                ArrayList<IAuditable> workItemHandles = new ArrayList<IAuditable>();
                List oslcLinks = ChangeSetLinks.findLinks((ProviderFactory)this.provider, (IChangeSetHandle)changeSet, (String[])new String[]{"com.ibm.team.filesystem.oslc_cm.change_request.change_set"}, (IProgressMonitor)monitor);
                boolean bl = hasOslcLinks = !oslcLinks.isEmpty();
                if (changeSet != null) {
                    comment = changeSet.getComment();
                    List linkTargets = (List)links.get(changeSet);
                    for (IAuditable referencedItem : linkTargets) {
                        if (!(referencedItem instanceof IWorkItemHandle)) continue;
                        workItemHandles.add(referencedItem);
                    }
                }
                this.addProblem(data, comment, hasOslcLinks, workItemHandles, changeSet, collector, projectArea, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        }
        finally {
            monitor.done();
        }
    }

    private IAdvisorInfo createProblem(String summary, String description, IAdvisorInfoCollector collector, DeliverOperationData data, IChangeSet changeSet, List workItems, IProjectAreaHandle projectArea, boolean isNeedTarget, boolean isNeedOwner, boolean wantsWorkItem, boolean wantsComment) {
        RequireWorkItemProblemObject object = new RequireWorkItemProblemObject(data.getProcessProxy().getRepositoryRoot(), (IWorkspaceHandle)data.getSourceWorkspace(), changeSet.getComponent(), (IChangeSetHandle)changeSet, workItems, projectArea, this.fRequires, false, isNeedTarget, isNeedOwner, wantsWorkItem, wantsComment);
        IAdvisorInfo problem = collector.createProblemInfo(summary, description, "com.ibm.team.process.definitions.requireWorkItemProblem");
        problem.setProblemObject((Object)object);
        Throwable e = null;
        try {
            problem.setData(RequireWorkItemProblemObject.deflate(object, this.provider.getClientVersion().consumesAML()));
        }
        catch (TeamRepositoryException teamRepositoryException) {
            problem = collector.createExceptionInfo(Messages.getString("RequireWorkItemAdvisor.33"), e);
        }
        return problem;
    }

    private boolean isValidRequiresValue(String requiresValue) {
        return VAL_WORKITEM.equals(requiresValue) || VAL_COMMENT.equals(requiresValue) || VAL_WORKITEM_OR_COMMENT.equals(requiresValue) || VAL_WORKITEM_AND_COMMENT.equals(requiresValue);
    }

    private boolean isValidTargetValue(String targetValue) {
        return VAL_OPTIONAL.equals(targetValue) || VAL_REQUIRED.equals(targetValue) || VAL_CURRENT_ITERATION.equals(targetValue);
    }

    private boolean isValidOwnerValue(String ownerValue) {
        return VAL_OPTIONAL.equals(ownerValue) || VAL_REQUIRED.equals(ownerValue) || VAL_CURRENT_CONTRIBUTOR.equals(ownerValue);
    }

    private void addProblem(DeliverOperationData data, String comment, boolean hasOslcLinks, List workItems, IChangeSet changeSet, IAdvisorInfoCollector collector, IProjectAreaHandle projectArea, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.8"), 1000);
        try {
            int numWorkItems = workItems.size();
            boolean hasComments = comment != null && comment.trim().length() > 0;
            boolean hasWorkitems = workItems != null && numWorkItems > 0;
            boolean hasWorkitemsOrChangeRequest = hasOslcLinks || hasWorkitems;
            boolean wantsWorkItem = false;
            boolean wantsComment = false;
            String problemSummary = null;
            String problemDetail = null;
            if (!(!VAL_WORKITEM_AND_COMMENT.equals(this.fRequires) || hasComments && hasWorkitemsOrChangeRequest)) {
                problemSummary = Messages.getString("RequireWorkItemAdvisor.9");
                problemDetail = Messages.getString("RequireWorkItemAdvisor.10");
                wantsWorkItem = true;
                wantsComment = true;
            } else if (VAL_WORKITEM.equals(this.fRequires) && !hasWorkitemsOrChangeRequest) {
                problemSummary = Messages.getString("RequireWorkItemAdvisor.11");
                problemDetail = Messages.getString("RequireWorkItemAdvisor.12");
                wantsWorkItem = true;
                wantsComment = false;
            } else if (VAL_COMMENT.equals(this.fRequires) && !hasComments) {
                problemSummary = Messages.getString("RequireWorkItemAdvisor.13");
                problemDetail = Messages.getString("RequireWorkItemAdvisor.14");
                wantsWorkItem = false;
                wantsComment = true;
            } else if (VAL_WORKITEM_OR_COMMENT.equals(this.fRequires) && !hasComments && !hasWorkitemsOrChangeRequest) {
                problemSummary = Messages.getString("RequireWorkItemAdvisor.15");
                problemDetail = Messages.getString("RequireWorkItemAdvisor.16");
                wantsWorkItem = true;
                wantsComment = true;
            } else if (!(VAL_OPTIONAL.equals(this.fOwner) && VAL_OPTIONAL.equals(this.fTarget) || !VAL_WORKITEM.equals(this.fRequires) || hasWorkitems)) {
                problemSummary = Messages.getString("RequireWorkItemAdvisor.34");
                problemDetail = Messages.getString("RequireWorkItemAdvisor.MISSING_WORKITEM_ASSOCIATION");
                wantsWorkItem = true;
                wantsComment = false;
            }
            if (problemSummary != null) {
                collector.addInfo((IReportInfo)this.createProblem(problemSummary, problemDetail, collector, data, changeSet, workItems, projectArea, false, false, wantsWorkItem, wantsComment));
                String summary = Messages.getString("RequireWorkItemAdvisor.19");
                if (numWorkItems == 1) {
                    summary = Messages.getString("RequireWorkItemAdvisor.20");
                }
                IAdvisorInfo info = collector.createProblemInfo(summary, this.getTargetError(numWorkItems), "com.ibm.team.process.definitions.requireWorkItemProblem");
                collector.addInfo((IReportInfo)info);
                info = collector.createProblemInfo(summary, this.getOwnerError(numWorkItems), "com.ibm.team.process.definitions.requireWorkItemProblem");
                collector.addInfo((IReportInfo)info);
                return;
            }
            if (hasWorkitems) {
                IAdvisorInfo info;
                String summary;
                String description;
                workItems = this.items.fetchItems(workItems, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
                ListIterator iterator = workItems.listIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.getString("RequireWorkItemAdvisor.ERROR_MSG"), (Throwable)new TeamRepositoryException(Messages.getString("RequireWorkItemAdvisor.18"))));
                    iterator.remove();
                }
                if (this.checkTarget(workItems, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 300))) {
                    description = this.getTargetError(workItems.size());
                    summary = Messages.getString("RequireWorkItemAdvisor.19");
                    if (numWorkItems == 1) {
                        summary = Messages.getString("RequireWorkItemAdvisor.20");
                    }
                    info = this.createProblem(summary, description, collector, data, changeSet, workItems, projectArea, true, false, false, false);
                    collector.addInfo((IReportInfo)info);
                }
                if (this.checkOwner(workItems, (IProgressMonitor)new SubProgressMonitor(monitor, 300))) {
                    description = this.getOwnerError(workItems.size());
                    summary = Messages.getString("RequireWorkItemAdvisor.19");
                    if (numWorkItems == 1) {
                        summary = Messages.getString("RequireWorkItemAdvisor.20");
                    }
                    info = this.createProblem(summary, description, collector, data, changeSet, workItems, projectArea, false, true, false, false);
                    collector.addInfo((IReportInfo)info);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean checkTarget(List workItems, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        int numWorkItems = workItems.size();
        if (VAL_OPTIONAL.equals(this.fTarget) || numWorkItems == 0) {
            return false;
        }
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.21"), numWorkItems * 1000);
        try {
            for (IWorkItem workItem : workItems) {
                if (!this.hasRequiredTarget(workItem, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                return false;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    private String getTargetError(int numWorkItems) {
        if (VAL_REQUIRED.equals(this.fTarget)) {
            if (numWorkItems == 1) {
                return Messages.getString("RequireWorkItemAdvisor.22");
            }
            return Messages.getString("RequireWorkItemAdvisor.23");
        }
        if (numWorkItems == 1) {
            return Messages.getString("RequireWorkItemAdvisor.24");
        }
        return Messages.getString("RequireWorkItemAdvisor.25");
    }

    private boolean hasRequiredTarget(IWorkItem workItem, IProcessArea processArea, IProgressMonitor progress) throws TeamRepositoryException {
        return RequireWorkItemAdvisor.hasRequiredTarget(this.items, VAL_REQUIRED.equals(this.fTarget), workItem, processArea, progress);
    }

    public static boolean hasRequiredTarget(ItemProvider items, boolean required, IWorkItem workItem, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.26"), 10);
        try {
            IIterationHandle handle = workItem.getTarget();
            if (required) {
                boolean bl = handle != null;
                return bl;
            }
            if (handle == null) {
                return false;
            }
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            while (handle != null) {
                IDevelopmentLine devLine;
                IIterationHandle current;
                IIteration iteration = (IIteration)items.fetchItem((IManagedItemHandle)handle, (IProgressMonitor)mon.newChild(1));
                IDevelopmentLineHandle dl = iteration.getDevelopmentLine();
                if (dl != null && (current = (devLine = (IDevelopmentLine)items.fetchItem((IManagedItemHandle)dl, (IProgressMonitor)mon.newChild(1))).getCurrentIteration()) != null && current.sameItemId((IItemHandle)handle)) {
                    return true;
                }
                handle = iteration.getParent();
                mon.setWorkRemaining(10);
            }
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private boolean checkOwner(List workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        int numWorkItems = workItems.size();
        if (VAL_OPTIONAL.equals(this.fOwner) || numWorkItems == 0) {
            return false;
        }
        monitor.beginTask(Messages.getString("RequireWorkItemAdvisor.27"), numWorkItems * 1000);
        try {
            for (IWorkItem workItem : workItems) {
                if (!this.hasRequiredOwner(workItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                return false;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    private String getOwnerError(int numWorkItems) {
        if (VAL_REQUIRED.equals(this.fOwner)) {
            if (numWorkItems == 1) {
                return Messages.getString("RequireWorkItemAdvisor.28");
            }
            return Messages.getString("RequireWorkItemAdvisor.29");
        }
        if (numWorkItems == 1) {
            return Messages.getString("RequireWorkItemAdvisor.30");
        }
        return Messages.getString("RequireWorkItemAdvisor.31");
    }

    private boolean hasRequiredOwner(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle handle = workItem.getOwner();
        if (handle == null) {
            return false;
        }
        IContributor owner = (IContributor)this.items.fetchItem((IManagedItemHandle)handle, monitor);
        if (VAL_REQUIRED.equals(this.fOwner)) {
            return this.isValidOwner(owner);
        }
        return this.items.getLoggedInContributor().sameItemId((IItemHandle)owner);
    }

    private boolean isValidOwner(IContributor owner) {
        if (owner == null) {
            return false;
        }
        String userId = owner.getUserId();
        return userId != null && userId.trim().length() > 0 && !Messages.getString("RequireWorkItemAdvisor.32").equalsIgnoreCase(userId);
    }

    public String getRequires() {
        return this.fRequires;
    }

    public String getTarget() {
        return this.fTarget;
    }
}

