/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineConfiguration;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IDevelopmentLineState;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationConfiguration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IIterationState;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.service.ProcessDataValidationException;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.ProjectArea;
import com.ibm.team.process.internal.common.model.customization.IterationTypeConfiguration;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationModel;
import com.ibm.team.process.internal.common.model.settings.BehaviorElement;
import com.ibm.team.process.internal.common.model.settings.BehaviorRoleElement;
import com.ibm.team.process.internal.common.model.settings.ChangeEventConfiguration;
import com.ibm.team.process.internal.common.model.settings.IterationConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionsElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsRoleElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataDeltaElement;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.DataElement;
import com.ibm.team.process.internal.common.model.specification.DevelopmentLineConfiguration;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.TeamConfigurationElement;
import com.ibm.team.process.internal.common.model.state.IterationTypeDefinition;
import com.ibm.team.process.internal.common.model.state.ProcessStateModel;
import com.ibm.team.process.internal.common.util.Messages;
import java.util.HashSet;

public class ProcessValidationUtil {
    private static final int SMALL_STRING_SIZE = 125;

    public static void validateProcessDefinitionData(ProcessSpecificationModel model, String state, IRole[] roles) throws ProcessDataValidationException {
        ProcessStateModel stateModel = ProcessValidationUtil.validateProcessState(state);
        ProcessSpecificationModel specificationModel = ProcessValidationUtil.validateProcessSpecification(model, roles);
        if (stateModel != null && specificationModel != null) {
            IDevelopmentLineState[] developmentLineStates = stateModel.getDevelopmentLineStates();
            TeamConfigurationElement teamConfiguration = specificationModel.getTeamConfiguration();
            if (teamConfiguration != null) {
                DevelopmentLineConfiguration[] lineConfigs = teamConfiguration.getDevelopmentLineConfigurations();
                int i = 0;
                while (i < lineConfigs.length) {
                    ProcessValidationUtil.validateDevelopmentLineConfigurations(lineConfigs[i], developmentLineStates);
                    ++i;
                }
            }
        }
    }

    public static ProcessSpecificationModel validateProcessSpecification(ProcessSpecificationModel model, IRole[] roles) throws ProcessDataValidationException {
        ProcessValidationUtil.validateRoleDefinitions(model.getRoleDefinitions());
        ProcessValidationUtil.validateProjectConfiguration(model.getProjectConfiguration(), roles);
        ProcessValidationUtil.validateTeamConfiguration(model.getTeamConfiguration(), roles);
        return model;
    }

    public static ProcessStateModel validateProcessState(String state) throws ProcessDataValidationException {
        ProcessStateModel model = new ProcessStateModel();
        Exception exception = model.initialize(state);
        if (exception != null) {
            throw new ProcessDataValidationException(exception);
        }
        ProcessValidationUtil.validateStateDevelopmentLines(model.getDevelopmentLineStates());
        ProcessValidationUtil.validateStateIterationTypes(model.getIterationTypeDefinitions());
        return model;
    }

    public static TeamCustomizationModel validateTeamCustomization(String customization, IRole[] roles) throws ProcessDataValidationException {
        TeamCustomizationModel model = new TeamCustomizationModel();
        Exception exception = model.initialize(customization);
        if (exception != null) {
            throw new ProcessDataValidationException(exception);
        }
        ProcessValidationUtil.validateRoleDefinitions(model.getRoleDefinitions());
        ProcessValidationUtil.validatePermissions(model.getPermissions(), roles);
        ProcessValidationUtil.validateBehavior(model.getBehavior(), roles);
        ProcessValidationUtil.validateIterations(model.getIterationConfigurations(), roles);
        ProcessValidationUtil.validateIterationTypes(model.getIterationTypeConfigurations(), roles);
        return model;
    }

    private static void validateStateDevelopmentLines(IDevelopmentLineState[] states) throws ProcessDataValidationException {
        boolean hasProjectDevelopmentLine = false;
        HashSet<String> ids = new HashSet<String>();
        int i = 0;
        while (i < states.length) {
            String startDate;
            IDevelopmentLineState lineState = states[i];
            String lineId = lineState.getId();
            ProcessValidationUtil.assertNotNull(Messages.getCommonString("ProcessValidationUtil.0"), lineId);
            if (!ids.add(lineId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.1"), lineId));
            }
            String endDate = lineState.getEndDateData();
            if (endDate != null && (startDate = lineState.getStartDateData()) == null) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.40"), lineId));
            }
            boolean isProjectDevelopmentLine = lineState.isProjectDevelopmentLine();
            if (isProjectDevelopmentLine && hasProjectDevelopmentLine) {
                throw new ProcessDataValidationException(Messages.getCommonString("ProcessValidationUtil.41"));
            }
            hasProjectDevelopmentLine = hasProjectDevelopmentLine || isProjectDevelopmentLine;
            ProcessValidationUtil.validateIterationStates(lineState.getIterations(), lineState);
            ++i;
        }
    }

    private static void validateStateIterationTypes(IterationTypeDefinition[] definitions) throws ProcessDataValidationException {
    }

    private static boolean validateIterationStates(IIterationState[] iterationStates, IDevelopmentLineState lineState) throws ProcessDataValidationException {
        boolean hasCurrent = false;
        HashSet<String> ids = new HashSet<String>();
        int i = 0;
        while (i < iterationStates.length) {
            String startDate;
            IIterationState state = iterationStates[i];
            String iterationId = state.getId();
            ProcessValidationUtil.assertNotNull(Messages.getCommonString("ProcessValidationUtil.3"), iterationId);
            if (!ids.add(iterationId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.4"), iterationId));
            }
            String endDate = state.getEndDateData();
            if (endDate != null && (startDate = state.getStartDateData()) == null) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.5"), iterationId));
            }
            boolean isCurrent = state.isCurrent();
            if (isCurrent && hasCurrent) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.42"), lineState.getLabel()));
            }
            hasCurrent = hasCurrent || isCurrent;
            boolean childHasCurrent = ProcessValidationUtil.validateIterationStates(state.getChildIterations(), lineState);
            if (hasCurrent && childHasCurrent) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.43"), lineState.getLabel()));
            }
            hasCurrent = hasCurrent || childHasCurrent;
            ++i;
        }
        return hasCurrent;
    }

    private static void validateProjectConfiguration(ProjectConfigurationElement projectConfiguration, IRole[] roles) throws ProcessDataValidationException {
        if (projectConfiguration == null) {
            return;
        }
        ProcessValidationUtil.validatePermissions(projectConfiguration.getPermissions(), roles);
        ProcessValidationUtil.validateBehavior(projectConfiguration.getBehavior(), roles);
        ProcessValidationUtil.validateConfigurationDataAndDeltas(projectConfiguration.getData());
    }

    private static void validateTeamConfiguration(TeamConfigurationElement teamConfiguration, IRole[] roles) throws ProcessDataValidationException {
        if (teamConfiguration == null) {
            return;
        }
        ProcessValidationUtil.validatePermissions(teamConfiguration.getPermissions(), roles);
        ProcessValidationUtil.validateBehavior(teamConfiguration.getBehavior(), roles);
        ProcessValidationUtil.validateDevelopmentLines(teamConfiguration.getDevelopmentLineConfigurations(), roles);
        ProcessValidationUtil.validateIterationTypes(teamConfiguration.getIterationTypeConfigurations(), roles);
    }

    private static void validateIterationTypes(IterationTypeConfiguration[] configs, IRole[] roles) throws ProcessDataValidationException {
    }

    private static void validateDevelopmentLines(DevelopmentLineConfiguration[] configs, IRole[] roles) throws ProcessDataValidationException {
        HashSet<String> lineIds = new HashSet<String>();
        int i = 0;
        while (i < configs.length) {
            DevelopmentLineConfiguration config = configs[i];
            String lineId = config.getId();
            if (lineId == null) {
                throw new ProcessDataValidationException(Messages.getCommonString("ProcessValidationUtil.8"));
            }
            if (!lineIds.add(lineId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.9"), lineId));
            }
            ProcessValidationUtil.validatePermissions(config.getPermissions(), roles);
            ProcessValidationUtil.validateBehavior(config.getBehavior(), roles);
            ProcessValidationUtil.validateIterations(config.getIterations(), roles);
            ++i;
        }
    }

    private static void validateIterations(IIterationConfiguration[] iterations, IRole[] roles) throws ProcessDataValidationException {
        HashSet<String> iterationIds = new HashSet<String>();
        int i = 0;
        while (i < iterations.length) {
            IterationConfiguration config = (IterationConfiguration)iterations[i];
            String iterationId = config.getId();
            if (iterationId == null) {
                throw new ProcessDataValidationException(Messages.getCommonString("ProcessValidationUtil.10"));
            }
            if (!iterationIds.add(iterationId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.11"), iterationId));
            }
            ProcessValidationUtil.validatePermissions(config.getPermissions(), roles);
            ProcessValidationUtil.validateBehavior(config.getBehavior(), roles);
            ProcessValidationUtil.validateIterations(config.getChildIterations(), roles);
            ++i;
        }
    }

    private static void validatePermissions(PermissionsElement permissions, IRole[] roles) throws ProcessDataValidationException {
        if (permissions == null) {
            return;
        }
        PermissionsRoleElement[] roleElements = permissions.getRoleElements();
        HashSet<String> roleIds = new HashSet<String>();
        int i = 0;
        while (i < roleElements.length) {
            PermissionsRoleElement roleElement = roleElements[i];
            String roleId = roleElement.getId();
            ProcessValidationUtil.assertNotNull(Messages.getCommonString("ProcessValidationUtil.12"), roleId);
            if (!roleIds.add(roleId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.13"), roleId));
            }
            OperationPermissionsConfiguration[] operations = roleElement.getOperations();
            HashSet<String> operationIds = new HashSet<String>();
            int j = 0;
            while (j < operations.length) {
                OperationPermissionsConfiguration operation = operations[j];
                String operationId = operation.getId();
                ProcessValidationUtil.assertNotNull(Messages.getCommonString("ProcessValidationUtil.15"), operationId);
                if (!operationIds.add(operationId)) {
                    throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.16"), operationId));
                }
                ++j;
            }
            ++i;
        }
    }

    private static void validateBehavior(BehaviorElement behavior, IRole[] roles) throws ProcessDataValidationException {
        if (behavior == null) {
            return;
        }
        BehaviorRoleElement[] roleElements = behavior.getRoleElements();
        HashSet<String> roleIds = new HashSet<String>();
        int i = 0;
        while (i < roleElements.length) {
            BehaviorRoleElement roleElement = roleElements[i];
            String roleId = roleElement.getId();
            ProcessValidationUtil.assertNotNull(Messages.getCommonString("ProcessValidationUtil.17"), roleId);
            if (!roleIds.add(roleId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.18"), roleId));
            }
            OperationBehaviorConfiguration[] operations = roleElement.getOperations();
            HashSet<String> operationIds = new HashSet<String>();
            int j = 0;
            while (j < operations.length) {
                OperationBehaviorConfiguration operation = operations[j];
                String operationId = operation.getId();
                ProcessValidationUtil.assertNotNull(Messages.getCommonString("ProcessValidationUtil.20"), operationId);
                if (!operationIds.add(operationId)) {
                    throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.21"), operationId));
                }
                ++j;
            }
            ++i;
        }
        ChangeEventConfiguration[] eventElements = behavior.getChangeEventElements();
        HashSet<String> eventIds = new HashSet<String>();
        int i2 = 0;
        while (i2 < eventElements.length) {
            ChangeEventConfiguration eventElement = eventElements[i2];
            String eventId = eventElement.getId();
            ProcessValidationUtil.assertNotNull(Messages.getCommonString("ProcessValidationUtil.22"), eventId);
            if (!eventIds.add(eventId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.23"), eventId));
            }
            ++i2;
        }
    }

    private static void validateConfigurationDataAndDeltas(DataElement data) throws ProcessDataValidationException {
        if (data == null) {
            return;
        }
        ConfigurationDataElement[] configurationData = data.getConfigurationData();
        HashSet<String> ids = new HashSet<String>();
        int i = 0;
        while (i < configurationData.length) {
            ConfigurationDataElement configuration = configurationData[i];
            String configPointId = configuration.getId();
            ProcessValidationUtil.assertNotNull(Messages.getCommonString("ProcessValidationUtil.24"), configPointId);
            if (!ids.add(configPointId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.25"), configPointId));
            }
            ++i;
        }
        ConfigurationDataDeltaElement[] configurationDataDeltas = data.getConfigurationDataDeltas();
        HashSet<String> deltaIds = new HashSet<String>();
        ConfigurationDataDeltaElement[] configurationDataDeltaElementArray = configurationDataDeltas;
        int n = configurationDataDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationDataDeltaElement delta = configurationDataDeltaElementArray[n2];
            String configDataId = delta.getConfigurationDataId();
            if (ids.contains(configDataId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.49"), configDataId));
            }
            if (!deltaIds.add(configDataId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.48"), configDataId));
            }
            ++n2;
        }
    }

    private static void validateRoleDefinitions(IRole[] roles) throws ProcessDataValidationException {
        HashSet<String> ids = new HashSet<String>();
        int i = 0;
        while (i < roles.length) {
            IRole role = roles[i];
            String roleId = role.getId();
            ProcessValidationUtil.assertNotNull(Messages.getCommonString("ProcessValidationUtil.26"), roleId);
            if (!ids.add(roleId)) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.27"), roleId));
            }
            if (roleId.length() > 125) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.28"), new Object[]{125, roleId}));
            }
            ++i;
        }
    }

    private static void validateDevelopmentLineConfigurations(IDevelopmentLineConfiguration line, IDevelopmentLineState[] states) throws ProcessDataValidationException {
        String lineId = line.getId();
        boolean found = false;
        int i = 0;
        while (i < states.length) {
            IDevelopmentLineState lineState = states[i];
            if (lineId.equals(lineState.getId())) {
                found = true;
                ProcessValidationUtil.validateIterationConfigurations(line.getIterations(), lineState.getIterations());
            }
            ++i;
        }
        if (!found) {
            throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.29"), lineId));
        }
    }

    private static void validateIterationConfigurations(IIterationConfiguration[] iterationConfigs, IIterationState[] iterationStates) throws ProcessDataValidationException {
        int i = 0;
        while (i < iterationConfigs.length) {
            IIterationConfiguration iteration = iterationConfigs[i];
            String configurationId = iteration.getId();
            if (configurationId == null) {
                throw new ProcessDataValidationException(Messages.getCommonString("ProcessValidationUtil.30"));
            }
            IIterationState matchingState = null;
            int j = 0;
            while (j < iterationStates.length) {
                IIterationState state = iterationStates[j];
                if (configurationId.equals(state.getId())) {
                    matchingState = state;
                    break;
                }
                ++j;
            }
            if (matchingState == null) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.31"), configurationId));
            }
            ProcessValidationUtil.validateIterationConfigurations(iteration.getChildIterations(), matchingState.getChildIterations());
            ++i;
        }
    }

    public static ProcessSpecificationModel validateProcessSpecificationAgainstStructure(String specification, IProjectArea projectArea, ItemHandleAwareHashMap fullItems, IRole[] roles) throws ProcessDataValidationException {
        ProcessSpecificationModel model = new ProcessSpecificationModel();
        Exception exception = model.initialize(specification);
        if (exception != null) {
            throw new ProcessDataValidationException(exception);
        }
        TeamConfigurationElement teamConfiguration = model.getTeamConfiguration();
        if (teamConfiguration != null) {
            DevelopmentLineConfiguration[] lineConfigs = teamConfiguration.getDevelopmentLineConfigurations();
            IDevelopmentLineHandle[] lineHandles = projectArea.getDevelopmentLines();
            int i = 0;
            while (i < lineConfigs.length) {
                DevelopmentLineConfiguration lineConfig = lineConfigs[i];
                String id = lineConfig.getId();
                IDevelopmentLine matchingLine = null;
                int j = 0;
                while (j < lineHandles.length) {
                    IDevelopmentLine line = (IDevelopmentLine)fullItems.get(lineHandles[j]);
                    if (line == null) {
                        throw new RuntimeException(Messages.getCommonString("ProcessValidationUtil.32"));
                    }
                    if (line.getId().equals(id)) {
                        matchingLine = line;
                        break;
                    }
                    ++j;
                }
                if (matchingLine == null) {
                    throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.33"), id));
                }
                ProcessValidationUtil.validateIterations(lineConfig.getIterations(), matchingLine, null, fullItems, roles, Messages.getCommonString("ProcessValidationUtil.34"));
                ++i;
            }
        }
        return model;
    }

    public static TeamCustomizationModel validateTeamCustomizationAgainstStructure(String customization, ITeamArea teamArea, ItemHandleAwareHashMap fullItems, IRole[] roles) throws ProcessDataValidationException {
        TeamCustomizationModel model = new TeamCustomizationModel();
        Exception exception = model.initialize(customization);
        if (exception != null) {
            throw new ProcessDataValidationException(exception);
        }
        IProjectAreaHandle handle = teamArea.getProjectArea();
        IProjectArea projectArea = (IProjectArea)fullItems.get(handle);
        if (projectArea == null) {
            throw new RuntimeException(Messages.getCommonString("ProcessValidationUtil.35"));
        }
        IDevelopmentLineHandle lineHandle = projectArea.getTeamAreaHierarchySnapshot().getDevelopmentLine(teamArea);
        IDevelopmentLine line = (IDevelopmentLine)fullItems.get(lineHandle);
        if (line == null) {
            throw new RuntimeException(Messages.getCommonString("ProcessValidationUtil.36"));
        }
        ProcessValidationUtil.validateIterations(model.getIterationConfigurations(), line, null, fullItems, roles, Messages.getCommonString("ProcessValidationUtil.37"));
        return model;
    }

    private static void validateIterations(IIterationConfiguration[] iterations, IDevelopmentLine line, IIteration parent, ItemHandleAwareHashMap fullItems, IRole[] roles, String contentLabel) throws ProcessDataValidationException {
        IIterationHandle[] iterationHandles = parent != null ? parent.getChildren() : line.getIterations();
        int i = 0;
        while (i < iterations.length) {
            IIterationConfiguration iterationConfig = iterations[i];
            String id = iterationConfig.getId();
            IIteration matchingIteration = null;
            int j = 0;
            while (j < iterationHandles.length) {
                IIteration iteration = (IIteration)fullItems.get(iterationHandles[j]);
                if (iteration == null) {
                    throw new RuntimeException(Messages.getCommonString("ProcessValidationUtil.38"));
                }
                if (iteration.getId().equals(id)) {
                    matchingIteration = iteration;
                    break;
                }
                ++j;
            }
            if (matchingIteration == null) {
                throw new ProcessDataValidationException(NLS.bind(Messages.getCommonString("ProcessValidationUtil.39"), contentLabel, id));
            }
            ProcessValidationUtil.validateIterations(iterationConfig.getChildIterations(), null, matchingIteration, fullItems, roles, contentLabel);
            ++i;
        }
    }

    private static void assertNotNull(String message, String id) throws ProcessDataValidationException {
        if (id == null || id.trim().length() == 0) {
            throw new ProcessDataValidationException(message);
        }
    }

    public static void validateProcessProvider(IProjectArea newArea, String specification, boolean isNewProvider) throws ProcessDataValidationException {
        ProcessSpecificationModel model = new ProcessSpecificationModel();
        Exception exception = model.initialize(specification);
        if (exception != null) {
            throw new ProcessDataValidationException(exception);
        }
        TeamConfigurationElement teamConfiguration = model.getTeamConfiguration();
        if (teamConfiguration != null) {
            DevelopmentLineConfiguration[] developmentLineConfigurationArray = teamConfiguration.getDevelopmentLineConfigurations();
            int n = developmentLineConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                DevelopmentLineConfiguration timeline = developmentLineConfigurationArray[n2];
                DevelopmentLineConfiguration timelineImpl = timeline;
                if (ProcessValidationUtil.isConfigured(timelineImpl.getPermissions()) || ProcessValidationUtil.isConfigured(timelineImpl.getBehavior()) || ProcessValidationUtil.isConfigured(timeline.getIterations())) {
                    throw new ProcessDataValidationException(Messages.getCommonString(isNewProvider ? "ProcessValidationUtil.2" : "ProcessValidationUtil.6"));
                }
                ++n2;
            }
        }
        if (((ProjectArea)newArea).getProcessProvider() != null || ((ProjectArea)newArea).getRemoteProcessProvider() != null) {
            throw new ProcessDataValidationException(Messages.getCommonString("ProcessValidationUtil.7"));
        }
    }

    private static boolean isConfigured(IIterationConfiguration[] iterations) {
        IIterationConfiguration[] iIterationConfigurationArray = iterations;
        int n = iterations.length;
        int n2 = 0;
        while (n2 < n) {
            IIterationConfiguration iteration = iIterationConfigurationArray[n2];
            IterationConfiguration iterationImpl = (IterationConfiguration)iteration;
            if (ProcessValidationUtil.isConfigured(iterationImpl.getPermissions()) || ProcessValidationUtil.isConfigured(iterationImpl.getBehavior()) || ProcessValidationUtil.isConfigured(iteration.getChildIterations())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isConfigured(PermissionsElement permissions) {
        if (permissions == null) {
            return false;
        }
        PermissionsRoleElement[] permissionsRoleElementArray = permissions.getRoleElements();
        int n = permissionsRoleElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PermissionsRoleElement role = permissionsRoleElementArray[n2];
            if (role.getOperations().length > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isConfigured(BehaviorElement behavior) {
        if (behavior == null) {
            return false;
        }
        if (behavior.getChangeEventElements().length > 0) {
            return true;
        }
        BehaviorRoleElement[] behaviorRoleElementArray = behavior.getRoleElements();
        int n = behaviorRoleElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            BehaviorRoleElement role = behaviorRoleElementArray[n2];
            if (role.getOperations().length > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

