/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.helper;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildActivity;
import com.ibm.team.build.common.model.IBuildActivityId;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.helper.ItemHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.l10n.Messages;
import com.ibm.team.build.internal.common.model.BuildPackage;
import com.ibm.team.repository.common.IType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class BuildActivityHelper {
    public static List<IBuildActivityId> getRootActivities(Collection<IBuildActivity> activities) {
        ValidationHelper.validateNotNull("activities", activities);
        HashSet<String> rootActivityIds = new HashSet<String>();
        HashSet<String> childActivityIds = new HashSet<String>();
        for (IBuildActivity activity : activities) {
            rootActivityIds.add(activity.getUniqueId());
            for (IBuildActivityId childActivityId : activity.getChildActivityIds()) {
                childActivityIds.add(childActivityId.getId());
            }
        }
        for (String childActivityId : childActivityIds) {
            rootActivityIds.remove(childActivityId);
        }
        LinkedList<IBuildActivityId> rootActivities = new LinkedList<IBuildActivityId>();
        for (IBuildActivity activity : activities) {
            if (!rootActivityIds.contains(activity.getUniqueId())) continue;
            IBuildActivityId activityId = BuildItemFactory.createBuildActivityId();
            activityId.setId(activity.getUniqueId());
            rootActivities.add(activityId);
        }
        return rootActivities;
    }

    public static List<IBuildActivity> getCurrentActivities(Collection<IBuildActivity> activities) {
        ValidationHelper.validateNotNull("activities", activities);
        LinkedList<IBuildActivity> inProgressActivities = new LinkedList<IBuildActivity>();
        Map<String, IBuildActivity> activitiesMap = BuildActivityHelper.mapActivities(activities);
        for (IBuildActivity activity : activities) {
            if (activity.isComplete() || BuildActivityHelper.hasCurrentChildren(activity, activitiesMap)) continue;
            inProgressActivities.add(activity);
        }
        return inProgressActivities;
    }

    protected static boolean hasCurrentChildren(IBuildActivity activity, Map<String, IBuildActivity> activitiesMap) {
        for (IBuildActivityId childId : activity.getChildActivityIds()) {
            IBuildActivity childActivity = activitiesMap.get(childId.getId());
            if (childActivity.isComplete() && !BuildActivityHelper.hasCurrentChildren(childActivity, activitiesMap)) continue;
            return true;
        }
        return false;
    }

    public static String getCurrentActivityText(Collection<IBuildActivity> currentActivities) {
        ValidationHelper.validateNotNull("currentActivities", currentActivities);
        if (currentActivities.size() == 0) {
            return "";
        }
        if (currentActivities.size() == 1) {
            return currentActivities.iterator().next().getLabel();
        }
        return NLS.bind((String)Messages.getCommonString("BuildActivityHelper.0"), (Object)currentActivities.size());
    }

    public static IBuildActivity copyBuildActivity(IBuildActivity activity) {
        ValidationHelper.validateNotNull("activity", activity);
        IBuildActivity buildActivity = BuildItemFactory.createBuildActivity();
        buildActivity.setUniqueId(activity.getUniqueId());
        buildActivity.setLabel(activity.getLabel());
        buildActivity.setStartTime(activity.getStartTime());
        buildActivity.setAutoComplete(activity.isAutoComplete());
        if (activity.getTimeTaken() != 0L) {
            buildActivity.setTimeTaken(activity.getTimeTaken());
        }
        for (IBuildActivityId id : activity.getChildActivityIds()) {
            IBuildActivityId newId = BuildItemFactory.createBuildActivityId();
            newId.setId(id.getId());
            buildActivity.getChildActivityIds().add(newId);
        }
        return buildActivity;
    }

    public static Map<String, IBuildActivity> mapActivities(Collection<IBuildActivity> activities) {
        Hashtable<String, IBuildActivity> activityMap = new Hashtable<String, IBuildActivity>();
        for (IBuildActivity activity : activities) {
            activityMap.put(activity.getUniqueId(), activity);
        }
        return activityMap;
    }

    public static boolean autoCompleteBuildActivities(long buildTimeElapsed, Collection<IBuildActivityId> buildActivityIds, Map<String, IBuildActivity> buildActivities) {
        ValidationHelper.validateNotNull("buildActivityIds", buildActivityIds);
        ValidationHelper.validateNotNull("buildActivities", buildActivities);
        boolean completed = false;
        for (IBuildActivityId activityId : buildActivityIds) {
            completed |= BuildActivityHelper.doAutoCompleteBuildActivities(buildTimeElapsed, buildActivities.get(activityId.getId()), buildActivities);
        }
        return completed;
    }

    private static boolean doAutoCompleteBuildActivities(long buildTimeElapsed, IBuildActivity activity, Map<String, IBuildActivity> buildActivities) {
        if (activity.isComplete()) {
            return false;
        }
        boolean completed = false;
        if (activity.isAutoComplete()) {
            long timeTaken = Math.max(1L, buildTimeElapsed - activity.getStartTime());
            activity.setTimeTaken(timeTaken);
            completed = true;
            for (IBuildActivityId childId : activity.getChildActivityIds()) {
                IBuildActivity loopActivity = buildActivities.get(childId.getId());
                BuildActivityHelper.doAutoCompleteBuildActivities(buildTimeElapsed, loopActivity, buildActivities);
            }
        }
        return completed;
    }

    public static String validateBuildActivityLabelLength(String label) {
        return ItemHelper.validateStringAttributeLength(label, (IType)IBuildResult.ITEM_TYPE, BuildPackage.eINSTANCE.getBuildActivity_Label().getName());
    }
}

