/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.sql;

import com.urbancode.sql.ConnectionWrapper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XADataSourceAdapter
implements DataSource {
    private static final Logger log = LoggerFactory.getLogger(XADataSourceAdapter.class);
    private static final Map<Transaction, XAConnection> xaConnMap = new ConcurrentHashMap<Transaction, XAConnection>();
    private XADataSource xaDataSource;
    private TransactionManager transactionManager;

    public XADataSourceAdapter() {
    }

    public XADataSourceAdapter(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public XADataSource getXaDataSource() {
        return this.xaDataSource;
    }

    public void setXaDataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager txm) {
        this.transactionManager = txm;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection conn = null;
        TransactionManager txm = this.getTransactionManager();
        try {
            Transaction tx;
            XAConnection xaConn;
            if (txm.getStatus() == 6) {
                txm.begin();
            }
            if ((xaConn = xaConnMap.get(tx = txm.getTransaction())) == null) {
                xaConn = username == null && password == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(username, password);
                if (xaConn == null) {
                    throw new SQLException("Unable to get XAConnection from Datasource!");
                }
                conn = this.enlist(tx, xaConn);
                xaConnMap.put(tx, xaConn);
            } else {
                conn = xaConn.getConnection();
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            SQLException ex = new SQLException(e.toString());
            ex.initCause(e);
            throw ex;
        }
        return conn;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.xaDataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.xaDataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.xaDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.xaDataSource.setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (iface.isAssignableFrom(this.xaDataSource.getClass())) {
            return (T)this.xaDataSource;
        }
        throw new SQLException("Unable to find a wrapped object which implements that interface.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        return iface.isAssignableFrom(this.xaDataSource.getClass());
    }

    private Connection enlist(Transaction tx, XAConnection xaConnection) throws SQLException {
        ConnectionWrapper result;
        try {
            CleanupSynchronization sync = new CleanupSynchronization(tx);
            XAResource xaRes = xaConnection.getXAResource();
            if (!tx.enlistResource(xaRes)) {
                throw new SQLException("XA enlistment failed");
            }
            tx.registerSynchronization((Synchronization)sync);
            result = new ConnectionWrapper(xaConnection);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            SQLException se = new SQLException();
            se.initCause(e);
            throw se;
        }
        return result;
    }

    private static final class CleanupSynchronization
    implements Synchronization {
        final Transaction tx;

        CleanupSynchronization(Transaction tx) throws SQLException {
            this.tx = tx;
        }

        public void afterCompletion(int status) {
            block6: {
                try {
                    XAConnection xaConn = (XAConnection)xaConnMap.remove(this.tx);
                    if (xaConn == null) {
                        if (log.isWarnEnabled()) {
                            log.warn("Unable to find XAConnection for Transaction.");
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Closing XAConnection");
                        }
                        xaConn.close();
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }

        public void beforeCompletion() {
        }
    }
}

