/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.repository.client.ILoginHandler2;
import com.ibm.team.repository.client.ILoginInfo2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.login.KerberosLoginInfo;
import com.ibm.team.repository.client.login.SSLCertificateLoginInfo;
import com.ibm.team.repository.client.login.SmartCardLoginInfo;
import com.ibm.team.repository.client.login.UsernameAndPasswordLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;

public class LoginUtil {
    private static final String KERBEROS_REALM_PROP = "java.security.krb5.realm";
    private static final String KERBEROS_KDC_PROP = "java.security.krb5.kdc";
    private static final String KERBEROS_CONFIG_PROP = "java.security.krb5.conf";

    private static abstract class AbstractLoginHandler {
        private ILoginInfo2 loginInfo;

        protected AbstractLoginHandler(ILoginInfo2 loginInfo) {
            this.setLoginInfo(loginInfo);
        }

        protected final ILoginInfo2 getLoginInfo() {
            return this.loginInfo;
        }

        private void setLoginInfo(ILoginInfo2 loginInfo) {
            this.loginInfo = loginInfo;
        }
    }

    private static abstract class AbstractLoginHandler2
    extends AbstractLoginHandler
    implements ILoginHandler2 {
        int count = 0;

        protected AbstractLoginHandler2(ILoginInfo2 loginInfo) {
            super(loginInfo);
        }

        public ILoginInfo2 challenge(ITeamRepository repository) {
            if (this.count > 0 && repository.getErrorState() == 2) {
                return null;
            }
            ++this.count;
            return this.getLoginInfo();
        }
    }

    public static class CertificateLoginHandler
    extends AbstractLoginHandler2 {
        public CertificateLoginHandler(String certificateFile, String password) {
            super((ILoginInfo2)new SSLCertificateLoginInfo(certificateFile, password));
        }
    }

    public static class KerberosLoginHandler
    extends AbstractLoginHandler2 {
        public static KerberosLoginHandler create(String kerberosConfigPath, String kerberosKdc, String kerberosRealm) {
            KerberosLoginInfo kerberosLoginInfo = new KerberosLoginInfo();
            if (kerberosConfigPath != null && kerberosConfigPath.trim().length() > 0) {
                System.setProperty(LoginUtil.KERBEROS_CONFIG_PROP, kerberosConfigPath);
            }
            if (kerberosKdc != null && kerberosKdc.trim().length() > 0) {
                System.setProperty(LoginUtil.KERBEROS_KDC_PROP, kerberosKdc);
            }
            if (kerberosRealm != null && kerberosRealm.trim().length() > 0) {
                System.setProperty(LoginUtil.KERBEROS_REALM_PROP, kerberosRealm);
            }
            return new KerberosLoginHandler(kerberosLoginInfo);
        }

        private KerberosLoginHandler(KerberosLoginInfo kerberosLoginInfo) {
            super((ILoginInfo2)kerberosLoginInfo);
        }

        public KerberosLoginHandler() {
            this(new KerberosLoginInfo());
        }
    }

    public static class LoginHandler
    extends AbstractLoginHandler
    implements ITeamRepository.ILoginHandler,
    ITeamRepository.ILoginHandler.ILoginInfo {
        int count = 0;

        public LoginHandler(String username, String password) {
            super((ILoginInfo2)new UsernameAndPasswordLoginInfo(username, password));
        }

        public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repository) {
            if (this.count > 0 && repository.getErrorState() == 2) {
                return null;
            }
            ++this.count;
            return this;
        }

        public String getPassword() {
            try {
                return this.getUsernameAndPasswordLoginInfo().getPassword();
            }
            catch (SavedPasswordNotObtainedException savedPasswordNotObtainedException) {
                return null;
            }
        }

        public String getUserId() {
            return this.getUsernameAndPasswordLoginInfo().getUsername();
        }

        private UsernameAndPasswordLoginInfo getUsernameAndPasswordLoginInfo() {
            return (UsernameAndPasswordLoginInfo)this.getLoginInfo();
        }
    }

    public static class SmartCardLoginHandler
    extends AbstractLoginHandler2 {
        private static SmartCardLoginInfo createSmartCardLoginInfo(String requestedAlias, byte[] publicKey) throws TeamRepositoryException {
            if (publicKey == null || publicKey.length == 0) {
                return new SmartCardLoginInfo(requestedAlias);
            }
            return new SmartCardLoginInfo(publicKey);
        }

        private static SmartCardLoginInfo createSmartCardLoginInfo(String requestedAlias) {
            return new SmartCardLoginInfo(requestedAlias);
        }

        public SmartCardLoginHandler(String alias, byte[] publicKey) throws TeamRepositoryException {
            super((ILoginInfo2)SmartCardLoginHandler.createSmartCardLoginInfo(alias, publicKey));
        }

        public SmartCardLoginHandler(String alias) {
            super((ILoginInfo2)SmartCardLoginHandler.createSmartCardLoginInfo(alias));
        }
    }
}

