/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.era.EraSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SnapshotSyncReportFragment {
    private SetDiff<ItemId<IComponent>> componentChanges;
    private Map<ItemId<IComponent>, ComponentSyncReportFragment> syncReports;
    private Map<ItemId<IComponent>, ItemId<IBaseline>> basis;
    private ITeamRepository repo;
    private static SnapshotSyncReportFragment emptyReport = new SnapshotSyncReportFragment();

    private SnapshotSyncReportFragment() {
        this.componentChanges = SetDiff.emptyDiff();
        this.syncReports = Collections.emptyMap();
        this.basis = Collections.emptyMap();
        this.repo = null;
    }

    public SnapshotSyncReportFragment(SetDiff<ItemId<IComponent>> componentChanges, Map<ItemId<IComponent>, ComponentSyncReportFragment> syncReports, Map<ItemId<IComponent>, ItemId<IBaseline>> basis, ITeamRepository repo) {
        this.componentChanges = componentChanges;
        this.syncReports = syncReports;
        this.basis = basis;
        this.repo = repo;
    }

    public static SnapshotSyncReportFragment createFromChangeSets(List<IChangeSet> changeSets) {
        HashMap incomingChangeSetsByComponent = NewCollection.hashMap();
        for (IChangeSet changeSet : changeSets) {
            if (changeSet == null) continue;
            CollectionUtil.addToMapOfLists((Map)incomingChangeSetsByComponent, (Object)ChangeSetUtil.getComponent((IChangeSet)changeSet), (Object)changeSet);
        }
        HashMap incomingReportsByComponent = NewCollection.hashMap();
        for (Map.Entry next : incomingChangeSetsByComponent.entrySet()) {
            List<ItemId<IBaseline>> baselines = Collections.emptyList();
            List nextChangeSets = ItemLists.handlesToIds((Collection)((Collection)next.getValue()));
            incomingReportsByComponent.put((ItemId)next.getKey(), new ComponentSyncReportFragment(baselines, (ItemId<IBaseline>)ItemId.getNullItem((IItemType)IBaseline.ITEM_TYPE), new EraSyncReportFragment(nextChangeSets), nextChangeSets));
        }
        SetDiff diff = SetDiff.emptyDiff();
        SnapshotSyncReportFragment incomingReport = new SnapshotSyncReportFragment((SetDiff<ItemId<IComponent>>)diff, incomingReportsByComponent, Collections.EMPTY_MAP, null);
        return incomingReport;
    }

    public static SnapshotSyncReportFragment createFromChangeSets(Map<IComponentHandle, List<IChangeSetHandle>> incomingChangeSetsByComponent) {
        HashMap incomingReportsByComponent = NewCollection.hashMap();
        for (Map.Entry<IComponentHandle, List<IChangeSetHandle>> entry : incomingChangeSetsByComponent.entrySet()) {
            IComponentHandle componentHandle = entry.getKey();
            List<IChangeSetHandle> changeSetHandles = entry.getValue();
            ItemId componentId = ItemId.create((IItemHandle)componentHandle);
            List changeSetIds = ItemLists.handlesToIds(changeSetHandles);
            List<ItemId<IBaseline>> baselines = Collections.emptyList();
            incomingReportsByComponent.put(componentId, new ComponentSyncReportFragment(baselines, (ItemId<IBaseline>)ItemId.getNullItem((IItemType)IBaseline.ITEM_TYPE), new EraSyncReportFragment(changeSetIds), changeSetIds));
        }
        SetDiff diff = SetDiff.emptyDiff();
        SnapshotSyncReportFragment incomingReport = new SnapshotSyncReportFragment((SetDiff<ItemId<IComponent>>)diff, incomingReportsByComponent, Collections.EMPTY_MAP, null);
        return incomingReport;
    }

    public static SnapshotSyncReportFragment singleComponentReport(ItemId<IComponent> component, ItemId<IBaseline> basis, ComponentSyncReportFragment syncReport) {
        SetDiff diff = SetDiff.emptyDiff();
        return new SnapshotSyncReportFragment((SetDiff<ItemId<IComponent>>)diff, Collections.singletonMap(component, syncReport), Collections.singletonMap(component, basis), null);
    }

    public static SnapshotSyncReportFragment emptyReport() {
        return emptyReport;
    }

    public SetDiff<ItemId<IComponent>> getComponentChanges() {
        return this.componentChanges;
    }

    public Map<ItemId<IComponent>, ComponentSyncReportFragment> getComponentModifications() {
        return this.syncReports;
    }

    public Map<ItemId<IComponent>, ItemId<IBaseline>> getBasis() {
        return this.basis;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.basis == null ? 0 : this.basis.hashCode());
        result = 31 * result + (this.componentChanges == null ? 0 : this.componentChanges.hashCode());
        result = 31 * result + (this.syncReports == null ? 0 : this.syncReports.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotSyncReportFragment other = (SnapshotSyncReportFragment)obj;
        if (this.basis == null ? other.basis != null : !this.basis.equals(other.basis)) {
            return false;
        }
        if (this.componentChanges == null ? other.componentChanges != null : !this.componentChanges.equals(other.componentChanges)) {
            return false;
        }
        return !(this.syncReports == null ? other.syncReports != null : !this.syncReports.equals(other.syncReports));
    }

    public Collection<ItemId<IComponent>> getAffectedComponents() {
        HashSet result = NewCollection.hashSet();
        result.addAll(this.componentChanges.getAdditions());
        result.addAll(this.componentChanges.getRemovals());
        for (ItemId<IComponent> next : this.syncReports.keySet()) {
            ComponentSyncReportFragment nextFragment = this.syncReports.get(next);
            if (nextFragment == null || nextFragment.isEmpty()) continue;
            result.add(next);
        }
        return result;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public boolean isEmpty() {
        return !this.hasModifications() && this.getComponentChanges().isEmpty();
    }

    public boolean hasModifications() {
        boolean found = false;
        for (ComponentSyncReportFragment nextFragment : this.syncReports.values()) {
            if (nextFragment.isEmpty()) continue;
            found = true;
        }
        return found;
    }
}

