/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.internal.core.TeamPlugin;

public class CopyFileAreaUtil {
    public static Collection<IShare> getNestedShares(IShareable shareable) throws FileSystemException {
        return CopyFileAreaUtil.getNestedShares(shareable, shareable.getLocalPath());
    }

    public static Collection<IShare> getNestedShares(IShareable shareable, IRelativeLocation relativeLocation) throws FileSystemException {
        AbstractLock lock = CFALockUtil.createAndLockForReading(shareable.getSandbox().getRoot(), true, (IProgressMonitor)new NullProgressMonitor());
        if (lock == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
            ArrayList<IShare> result = new ArrayList<IShare>();
            for (IRelativeLocation relative : cfa.allSharePaths(relativeLocation)) {
                Share share = cfa.getShare(relative);
                if (share == null) continue;
                result.add(share);
            }
            ArrayList<IShare> arrayList = result;
            return arrayList;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static boolean isNestedShare(IShareable shareable) throws FileSystemException {
        IRelativeLocation shareableLocation = shareable.getLocalPath();
        AbstractLock lock = CFALockUtil.createAndLockForReading(shareable.getSandbox().getRoot(), true, (IProgressMonitor)new NullProgressMonitor());
        if (lock == null) {
            return false;
        }
        try {
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
            IRelativeLocation[] allSharePaths = cfa.allSharePaths();
            Arrays.sort(allSharePaths, new Comparator<IRelativeLocation>(){

                @Override
                public int compare(IRelativeLocation location1, IRelativeLocation location2) {
                    return location1.toString().compareTo(location2.toString());
                }
            });
            IRelativeLocation previous = null;
            boolean isNested = false;
            IRelativeLocation[] iRelativeLocationArray = allSharePaths;
            int n = allSharePaths.length;
            int n2 = 0;
            while (n2 < n) {
                IRelativeLocation location = iRelativeLocationArray[n2];
                if (previous == null) {
                    previous = location;
                } else if (previous.isPrefixOf(location)) {
                    isNested = true;
                } else {
                    previous = location;
                    isNested = false;
                }
                if (location.equals(shareableLocation)) {
                    boolean bl = isNested;
                    return bl;
                }
                ++n2;
            }
            return false;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static boolean isNestedShare(ILocation root, IRelativeLocation shareableLocation) throws FileSystemException {
        AbstractLock lock = CFALockUtil.createAndLockForReading(root, true, (IProgressMonitor)new NullProgressMonitor());
        if (lock == null) {
            return false;
        }
        try {
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(root);
            IRelativeLocation[] allSharePaths = cfa.allSharePaths();
            Arrays.sort(allSharePaths, new Comparator<IRelativeLocation>(){

                @Override
                public int compare(IRelativeLocation location1, IRelativeLocation location2) {
                    return location1.toString().compareTo(location2.toString());
                }
            });
            IRelativeLocation previous = null;
            boolean isNested = false;
            IRelativeLocation[] iRelativeLocationArray = allSharePaths;
            int n = allSharePaths.length;
            int n2 = 0;
            while (n2 < n) {
                IRelativeLocation location = iRelativeLocationArray[n2];
                if (previous == null) {
                    previous = location;
                } else if (previous.isPrefixOf(location)) {
                    isNested = true;
                } else {
                    previous = location;
                    isNested = false;
                }
                if (location.equals(shareableLocation)) {
                    boolean bl = isNested;
                    return bl;
                }
                ++n2;
            }
            return false;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static boolean hasNestedShareRoots(IShareable shareable) throws FileSystemException {
        return CopyFileAreaUtil.getNestedShares(shareable).size() > 1;
    }

    public static boolean hasNestedShareRoots(IShareable[] shareables) throws FileSystemException {
        IShareable[] iShareableArray = shareables;
        int n = shareables.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable shareable = iShareableArray[n2];
            if (CopyFileAreaUtil.hasNestedShareRoots(shareable)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isShareRoot(IRelativeLocation location, ILocation sanboxRoot) throws FileSystemException {
        CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(sanboxRoot);
        if (cfa == null) {
            return false;
        }
        return CopyFileAreaUtil.isShareRoot(location, cfa);
    }

    public static boolean isShareRoot(IShareable shareable) throws FileSystemException {
        return CopyFileAreaUtil.isShareRoot(shareable.getLocalPath(), shareable.getSandbox().getRoot());
    }

    public static boolean isShareRoot(IRelativeLocation location, CopyFileAreaStore cfa) throws FileSystemException {
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfa.getRoot(), true, (IProgressMonitor)new NullProgressMonitor());
        if (lock == null) {
            return false;
        }
        try {
            IRelativeLocation[] iRelativeLocationArray = cfa.allSharePaths();
            int n = iRelativeLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRelativeLocation path = iRelativeLocationArray[n2];
                if (path.equals(location)) {
                    return true;
                }
                ++n2;
            }
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)new NullProgressMonitor());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isShareRoot(IResource resource) throws FileSystemException {
        try {
            if (resource.getPersistentProperty(TeamPlugin.PROVIDER_PROP_KEY) != null) {
                return true;
            }
        }
        catch (CoreException e) {
            throw new FileSystemException(e);
        }
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        if (shareable == null) {
            return false;
        }
        ILocation sandboxRoot = shareable.getSandbox().getRoot();
        AbstractLock lock = CFALockUtil.createAndLockForReading(sandboxRoot, true, (IProgressMonitor)new NullProgressMonitor());
        if (lock == null) {
            return false;
        }
        try {
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(sandboxRoot);
            if (cfa == null) {
                return false;
            }
            for (IShare share : cfa.allShares()) {
                ILocation sharePath = sandboxRoot.append(share.getPath());
                PathLocation resourcePath = new PathLocation(resource.getLocation());
                if (!resourcePath.equals(sharePath)) continue;
                return true;
            }
            return false;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

