/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.validator;

import com.ibm.team.filesystem.client.internal.copyfileareas.ChangedInfosValue;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.WCChangedInfoKey;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.validator.HeapValidator;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import com.ibm.team.repository.common.UUID;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class ChangedInfosMapValidator
extends DiskBackedHashMapEntriesValidator {
    private static final int METADATA_VERSION = 0;
    protected static final String SCM_CHANGED_INFOS_PREFIX = ".changedinfos";
    protected static final String SCM_CHANGED_INFOS_SEPARATOR = "_";
    protected static final String SCM_CHANGED_INFOS_SUFFIX = ".dat";
    protected static final int UUID_LENGTH = 23;
    protected String componentId;
    protected String connectionId;
    protected File cfaRoot;

    public ChangedInfosMapValidator(File rootPath, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootPath;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        this.componentId = null;
        this.connectionId = null;
        boolean valid = false;
        String fn = this.hv.getHeapFile().getName();
        if (fn.length() == SCM_CHANGED_INFOS_PREFIX.length() + 23 + SCM_CHANGED_INFOS_SEPARATOR.length() + 23 + SCM_CHANGED_INFOS_SUFFIX.length()) {
            this.componentId = fn.substring(SCM_CHANGED_INFOS_PREFIX.length(), SCM_CHANGED_INFOS_PREFIX.length() + 23);
            this.connectionId = fn.substring(SCM_CHANGED_INFOS_PREFIX.length() + 23 + SCM_CHANGED_INFOS_SEPARATOR.length(), SCM_CHANGED_INFOS_PREFIX.length() + 23 + SCM_CHANGED_INFOS_SEPARATOR.length() + 23);
            if (this.isValidUUID(this.componentId) && this.isValidUUID(this.connectionId) && fn.startsWith(SCM_CHANGED_INFOS_PREFIX) && fn.endsWith(SCM_CHANGED_INFOS_SUFFIX) && fn.substring(SCM_CHANGED_INFOS_PREFIX.length() + 23, SCM_CHANGED_INFOS_PREFIX.length() + 23 + SCM_CHANGED_INFOS_SEPARATOR.length()).equals(SCM_CHANGED_INFOS_SEPARATOR)) {
                valid = true;
            }
        }
        if (!valid) {
            this.log.append("Invalid change infos map file name: " + fn + "\n");
        }
        if (!this.hv.getHeapFile().getParentFile().equals(this.cfaRoot)) {
            this.log.append("Invalid changed infos map location " + this.hv.getHeapFile() + " relative to root " + this.cfaRoot + "\n");
        }
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on changed infos key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on changed infos value of entry at " + entryOffset + "\n");
        }
        ChangedInfosKey k = this.validateKey(entryOffset, keyOffset, hash, raf);
        ChangedInfosValue v = this.validateValue(entryOffset, valueOffset, k, raf);
        if (k != null && v != null && this.componentId != null && this.connectionId != null) {
            WCChangedInfoKey wccik = new WCChangedInfoKey(this.componentId, this.connectionId, k.uuid, v.getType());
            this.gv.addModifiedInfo(wccik, v);
        }
    }

    protected ChangedInfosKey validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset >= this.hv.getWorkingAreaSize()) {
            this.log.append("The changed infos key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        try {
            String uuid = this.validateUUID("changed infos key", keyOffset, "item id", raf);
            if (uuid == null) {
                return null;
            }
            int uuidHashCode = UUID.valueOf((String)uuid).hashCode();
            if (hashCode != uuidHashCode) {
                this.log.append("The entry at " + entryOffset + " contains a hash code (" + hashCode + ") for changed infos key at " + keyOffset + " with UUID \"" + uuid + "\" whose hash code is " + uuidHashCode + "\n");
            }
            ChangedInfosKey result = new ChangedInfosKey(uuid);
            this.addKey(result, entryOffset, keyOffset, "changed infos");
            ChangedInfosKey changedInfosKey = result;
            return changedInfosKey;
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Changed Infos key"));
        }
    }

    protected ChangedInfosValue validateValue(long entryOffset, long valueOffset, ChangedInfosKey k, RAFWrapper raf) throws IOException {
        if (valueOffset < 0L || valueOffset > 2L) {
            this.log.append("The changed infos value offset is at an impossible value " + valueOffset + " at " + entryOffset + "\n");
            return null;
        }
        return new ChangedInfosValue((int)valueOffset);
    }

    @Override
    public boolean validateCustomMetadata(DataInputStream in) throws IOException {
        int v = in.readInt();
        if (v != 0) {
            this.log.append("Metadata version mismatch for inverse item info map: " + v + " != " + 0);
            return false;
        }
        return true;
    }

    public static class ChangedInfosKey
    implements Serializable {
        private static final long serialVersionUID = -8702641957280124528L;
        protected String uuid;

        public ChangedInfosKey(String uuid) {
            this.uuid = uuid;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ChangedInfosKey)) {
                return false;
            }
            return ((ChangedInfosKey)obj).uuid.equals(this.uuid);
        }

        public String toString() {
            return this.uuid;
        }
    }
}

