/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.operations.LoadedFileVisitor;
import com.ibm.team.filesystem.client.internal.utils.ExclusiveFileLockPatternUtil;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LockAndLoadFileVisitor
extends LoadedFileVisitor {
    private Map<UUID, Map<UUID, Set<UUID>>> workspaceToComponentToLockedByUserMap = new HashMap<UUID, Map<UUID, Set<UUID>>>();
    private Map<UUID, List<StringMatcher>> workspaceToPatternsMap = new HashMap<UUID, List<StringMatcher>>();

    @Override
    public void visitLoadedFiles(IConnection connection, IComponent component, List<IShareable> shareables, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)(shareables.size() + 2));
        if (shareables.isEmpty()) {
            return;
        }
        List<StringMatcher> matchers = this.getPatterns(connection, (IProgressMonitor)subProgress.newChild(1));
        if (matchers.size() == 0) {
            return;
        }
        Set<UUID> versionablesLockedByUser = this.getIdsOfVersionablesLockedByUser(connection, component, (IProgressMonitor)subProgress.newChild(1));
        for (IShareable shareable : shareables) {
            if (shareable == null) {
                subProgress.worked(1);
                continue;
            }
            if (versionablesLockedByUser.contains(shareable.getVersionable((IProgressMonitor)subProgress.newChild(1)).getItemId())) continue;
            ExclusiveFileLockPatternUtil.makeFileReadOnly(shareable, matchers);
        }
        subProgress.done();
    }

    private List<StringMatcher> getPatterns(IConnection connection, IProgressMonitor monitor) {
        List<StringMatcher> patterns = this.workspaceToPatternsMap.get(connection.getContextHandle().getItemId());
        if (patterns == null) {
            patterns = ExclusiveFileLockPatternUtil.getPatternsToMatch(connection, monitor);
            this.workspaceToPatternsMap.put(connection.getContextHandle().getItemId(), patterns);
        }
        return patterns;
    }

    private Set<UUID> getIdsOfVersionablesLockedByUser(IConnection connection, IComponent component, IProgressMonitor monitor) throws TeamRepositoryException {
        Set<UUID> lockedVersionables;
        Map<UUID, Set<UUID>> componentToVersionablesLockedByUser = this.workspaceToComponentToLockedByUserMap.get(connection.getContextHandle().getItemId());
        if (componentToVersionablesLockedByUser == null) {
            componentToVersionablesLockedByUser = ExclusiveFileLockPatternUtil.getLocksHeldByUser((IWorkspaceConnection)connection, monitor);
            this.workspaceToComponentToLockedByUserMap.put(connection.getContextHandle().getItemId(), componentToVersionablesLockedByUser);
        }
        if ((lockedVersionables = componentToVersionablesLockedByUser.get(component.getItemId())) == null) {
            return Collections.emptySet();
        }
        return lockedVersionables;
    }

    @Override
    public boolean isEnabledFor(IConnection connection, IProgressMonitor monitor) {
        List<StringMatcher> matchers = this.getPatterns(connection, monitor);
        return !matchers.isEmpty();
    }
}

