/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.load.loadRules.LoadRequest;
import com.ibm.team.filesystem.client.internal.load.loadRules.RelativeLoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.LoadRuleSerializationDilemmaHandler;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemLoadRequest
extends LoadRequest {
    private String[] repositoryPath;
    private String alternateName;
    private IVersionableHandle versionableToLoad;

    public ItemLoadRequest(IConnection connection, IComponent component, RelativeLoadLocation relativeLoadLocation, String[] repositoryPath, String alternateName) {
        super(connection, component, relativeLoadLocation);
        this.repositoryPath = repositoryPath;
        this.versionableToLoad = null;
        this.alternateName = alternateName;
    }

    public ItemLoadRequest(IConnection connection, IComponent component, RelativeLoadLocation relativeLoadLocation, IVersionableHandle versionableToLoad, String[] repositoryPath, String alternateName) {
        super(connection, component, relativeLoadLocation);
        this.repositoryPath = repositoryPath;
        this.versionableToLoad = versionableToLoad;
        this.alternateName = alternateName;
    }

    public ItemLoadRequest(IConnection connection, IComponent component, RelativeLoadLocation relativeLoadLocation, IVersionableHandle versionableToLoad, String alternateName) {
        super(connection, component, relativeLoadLocation);
        this.repositoryPath = null;
        this.versionableToLoad = versionableToLoad;
        this.alternateName = alternateName;
    }

    private IRelativeLocation getResolvedRelativeLoadLocation(IProgressMonitor progress) throws TeamRepositoryException {
        RelativeLoadLocation relativeLoadLocation = this.getRelativeLoadLocation();
        if (relativeLoadLocation != null) {
            return relativeLoadLocation.getResolvedRelativeLoadLocation(this.getComponent(), this.getFolderRepositoryPath(progress));
        }
        return RelativeLocation.EMPTY_LOCATION;
    }

    @Override
    public void toRule(Document document, Element parent, LoadRuleSerializationDilemmaHandler preferences, IProgressMonitor progress) throws TeamRepositoryException {
        RelativeLoadLocation relativeLoadLocation;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Element element = document.createElement("itemLoadRule");
        parent.appendChild(element);
        this.addComponentToRule(document, element, preferences, (IProgressMonitor)monitor.newChild(10));
        this.addVersionableToRule(this.getRepositoryPath((IProgressMonitor)monitor.newChild(10)), this.getVersionableToLoad((IProgressMonitor)monitor.newChild(10)), document, element, "item", preferences, progress);
        if (this.alternateName == null && this.isComponentRoot()) {
            this.alternateName = this.getComponentName();
        }
        if (this.alternateName != null) {
            element.setAttribute("alternateName", this.alternateName);
        }
        if ((relativeLoadLocation = this.getRelativeLoadLocation()) != null) {
            relativeLoadLocation.toRule(document, element, preferences, (IProgressMonitor)monitor.newChild(70));
        }
    }

    private boolean isComponentRoot() {
        if (this.repositoryPath != null) {
            return this.repositoryPath.length == 0;
        }
        return this.getComponent().getRootFolder().sameItemId((IItemHandle)this.versionableToLoad);
    }

    @Override
    public IStatus configureLoad(ILoadOperation loadOp, ISandbox sandbox, boolean allowsNestedShares, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IConnection connection = this.getConnection();
        IVersionableHandle versionable = null;
        try {
            if (connection instanceof IWorkspaceConnection) {
                IConfiguration config = ((IWorkspaceConnection)connection).configuration((IComponentHandle)this.getComponent());
            } else {
                IConfiguration config = ((IBaselineConnection)connection).configuration();
                if (!config.component().sameItemId((IItemHandle)this.getComponent())) {
                    throw new ComponentNotInWorkspaceException(NLS.bind((String)Messages.ItemLoadRequest_0, (Object)this.getComponentName(), (Object[])new Object[]{((IBaselineConnection)connection).getId(), ((IBaselineConnection)connection).getName()}));
                }
            }
            versionable = this.getVersionableToLoad((IProgressMonitor)progress.newChild(1));
            IRelativeLocation relativeLoadPath = this.getResolvedRelativeLoadLocation((IProgressMonitor)progress.newChild(1));
            if (this.alternateName != null) {
                loadOp.requestLoadAs(sandbox, relativeLoadPath, this.alternateName, (IWorkspaceConnection)connection, (IComponentHandle)this.getComponent(), versionable, allowsNestedShares);
            } else {
                loadOp.requestLoad(sandbox, relativeLoadPath, (IWorkspaceConnection)connection, (IComponentHandle)this.getComponent(), Collections.singletonList(versionable), allowsNestedShares);
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.ItemLoadRequest_4, (Object)this.getRepoPathForErrorMsg(), (Object[])new Object[]{this.getComponentName(), sandbox.getRoot().toOSString()}));
        }
        catch (TeamRepositoryException e) {
            String niceRepositoryPath = this.getNiceRepoPath(this.repositoryPath);
            return FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.ItemLoadRequest_1, (Object)niceRepositoryPath, (Object[])new Object[]{this.getComponentName(), sandbox.getRoot().toOSString()}), e);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus configureLoad(ILoadOperation loadOp, ISandbox sandbox, IProgressMonitor monitor) {
        return this.configureLoad(loadOp, sandbox, false, monitor);
    }

    private String getRepoPathForErrorMsg() {
        if (this.repositoryPath != null) {
            return this.getNiceRepoPath(this.repositoryPath);
        }
        if (this.versionableToLoad != null) {
            return NLS.bind((String)Messages.ParentLoadRequest_5, (Object)this.versionableToLoad.getItemId(), (Object[])new Object[0]);
        }
        return this.getNiceRepoPath(this.repositoryPath);
    }

    private IVersionableHandle getVersionableToLoad(IProgressMonitor progress) throws TeamRepositoryException, ItemNotFoundException, FileSystemException {
        if (this.versionableToLoad == null) {
            IConfiguration config = this.getConfiguration();
            this.versionableToLoad = config.resolvePath(this.getComponent().getRootFolder(), this.repositoryPath, progress);
            if (this.versionableToLoad == null) {
                throw new ItemNotFoundException(NLS.bind((String)Messages.ItemLoadRequest_2, (Object)this.getNiceRepoPath(this.repositoryPath), (Object[])new Object[]{this.getComponentName()}));
            }
        }
        return this.versionableToLoad;
    }

    private String[] getRepositoryPath(IProgressMonitor progress) throws TeamRepositoryException {
        if (this.repositoryPath == null) {
            IAncestorReport ancestors = (IAncestorReport)this.getConfiguration().locateAncestors(Collections.singletonList(this.versionableToLoad), progress).get(0);
            this.setRepoPath(ancestors);
        }
        return this.repositoryPath;
    }

    @Override
    public IVersionableHandle requireRepoPath() {
        if (this.repositoryPath == null && this.getRelativeLoadLocation() != null && this.getRelativeLoadLocation().includeRepositoryPath()) {
            return this.versionableToLoad;
        }
        return null;
    }

    @Override
    public void setRepoPath(IAncestorReport ancestors) throws FileSystemException {
        if (ancestors.getNameItemPairs().isEmpty()) {
            throw new FileSystemException(NLS.bind((String)Messages.ItemLoadRequest_3, (Object)this.getComponentName(), (Object[])new Object[]{this.getConnection().getName(), this.versionableToLoad.getItemId().getUuidValue()}));
        }
        this.repositoryPath = new String[ancestors.getNameItemPairs().size() - 1];
        Iterator i = ancestors.getNameItemPairs().iterator();
        i.next();
        int j = 0;
        while (i.hasNext()) {
            INameItemPair pair = (INameItemPair)i.next();
            this.repositoryPath[j] = pair.getName();
            ++j;
        }
    }

    private String[] getFolderRepositoryPath(IProgressMonitor progress) throws TeamRepositoryException {
        String[] repositoryPath = this.getRepositoryPath(progress);
        if (repositoryPath.length > 0) {
            String[] parentPath = new String[repositoryPath.length - 1];
            int i = 0;
            while (i < repositoryPath.length - 1) {
                parentPath[i] = repositoryPath[i];
                ++i;
            }
            return parentPath;
        }
        return repositoryPath;
    }
}

