/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IApplyAcceptedOperation;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ResolveConflictsOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolution2;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LogicalConflict;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ApplyAcceptedOperation
extends ResolveConflictsOperation
implements IApplyAcceptedOperation {
    private HashMap<UUID, ConflictResolution2> parentForResolution;
    private Collection<ILogicalChange> changes;
    private final ApplyAcceptedDilemmaHandler problemHandler;

    public ApplyAcceptedOperation(ApplyAcceptedDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? ApplyAcceptedDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? ApplyAcceptedDilemmaHandler.getDefault() : dilemmaHandler;
        this.parentForResolution = new HashMap();
        this.changes = new ArrayList<ILogicalChange>();
    }

    private boolean changeNeedsParentSpecification(ILogicalConflict conflict) {
        if (conflict.conflictType() == 2) {
            if (!this.isBeingUndone((IVersionableHandle)conflict.parent())) {
                return !this.parentForResolution.containsKey(((LogicalConflict)conflict).getId());
            }
        } else {
            if (conflict.conflictType() == 10) {
                return !this.parentForResolution.containsKey(((LogicalConflict)conflict).getId());
            }
            if (conflict.conflictType() == 8) {
                for (IVersionableHandle conflictingItem : conflict.conflictingItems()) {
                    if (!conflictingItem.sameItemId((IItemHandle)conflict.parent()) || this.isBeingUndone((IVersionableHandle)conflict.parent())) continue;
                    return !this.parentForResolution.containsKey(((LogicalConflict)conflict).getId());
                }
            }
        }
        return false;
    }

    private boolean destinationInUse(ILogicalConflict conflict) {
        IVersionableHandle item;
        if (this.parentForResolution.containsKey(((LogicalConflict)conflict).getId())) {
            return false;
        }
        if (conflict.conflictType() == 7) {
            return this.isBeingUndone((IVersionableHandle)conflict.conflictingItems().iterator().next());
        }
        if (conflict.conflictType() == 1 && conflict.conflictingItems().size() == 1 && !(item = (IVersionableHandle)conflict.conflictingItems().iterator().next()).sameItemId((IItemHandle)conflict.item())) {
            return this.isBeingUndone(item);
        }
        return false;
    }

    private boolean changeBlockedByContent(ILogicalConflict conflict) {
        if (conflict.conflictType() == 3) {
            for (IVersionableHandle itemInTheWay : conflict.conflictingItems()) {
                if (this.isBeingUndone(itemInTheWay)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBeingUndone(IVersionableHandle itemInTheWay) {
        for (ILogicalChange changeBeingOverridden : this.changes) {
            if (!changeBeingOverridden.item().sameItemId((IItemHandle)itemInTheWay) || !changeBeingOverridden.isChangeType(11)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setParentForResolution(ILogicalConflict conflict, IFolderHandle parentFolder, String name) {
        if (conflict == null || !this.changeNeedsParentSpecification(conflict)) {
            throw new IllegalArgumentException();
        }
        if (parentFolder == null) {
            throw new IllegalArgumentException();
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        ConflictResolution2 resolution = FilesystemDTOFactory.eINSTANCE.createConflictResolution2();
        resolution.setComponent(conflict.component());
        resolution.setItem(conflict.item());
        resolution.setParent(parentFolder);
        resolution.setName(name);
        if (this.parentForResolution.put(((LogicalConflict)conflict).getId(), resolution) != null) {
            throw new IllegalArgumentException(Messages.ApplyAcceptedOperation_0);
        }
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (this.changes.isEmpty()) {
            return;
        }
        if (!this.isContextSet()) {
            throw new IllegalStateException("Caller must configure the connection that has the conflicts");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        Collection<ILogicalChange> missingChanges = this.getRequiredChanges();
        if (missingChanges.size() > 0) {
            switch (this.problemHandler.missingRequiredChanges(missingChanges)) {
                case 2: {
                    this.changes.clear();
                    throw new FileSystemException(NLS.bind((String)Messages.ApplyAcceptedOperation_1, (Object)missingChanges.size()));
                }
                case 1: {
                    this.changes.clear();
                    throw new OperationCanceledException();
                }
                case 0: {
                    this.changes.addAll(missingChanges);
                    break;
                }
                case 3: {
                    this.changes.clear();
                    return;
                }
                default: {
                    this.changes.clear();
                    throw new FileSystemException(NLS.bind((String)Messages.ApplyAcceptedOperation_1, (Object)missingChanges.size()));
                }
            }
        }
        Iterator<ILogicalChange> i = this.changes.iterator();
        while (i.hasNext()) {
            ILogicalChange change = i.next();
            if (change.kind() != 3) continue;
            i.remove();
        }
        HashSet<ConfigurationFacade> configurationsToLock = new HashSet<ConfigurationFacade>();
        for (ILogicalChange change : this.changes) {
            ILogicalConflict conflict;
            verifyOp.addToVerify((IConnection)this.connection, change.component());
            configurationsToLock.add(new ConfigurationFacade((IConnection)this.connection, change.component()));
            if (!(change instanceof ILogicalConflict) || !this.changeNeedsParentSpecification(conflict = (ILogicalConflict)change)) continue;
            throw new FileSystemException(NLS.bind((String)Messages.ApplyAcceptedOperation_2, (Object)PathUtils.getString(change.getPathHint())));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(configurationsToLock, (IProgressMonitor)progress.newChild(1));
        try {
            List updateReports;
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                verifyOp.run((IProgressMonitor)progress.newChild(4));
            }
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            IFileSystemManager fsm = FileSystemCore.getFileSystemManager(this.connection.teamRepository());
            FileSystemServiceProxy fss = ((FileSystemManager)fsm).getFileSystemService();
            try {
                updateReports = fss.applyAccepted(this.connection, this.changes, this.parentForResolution.values(), (IProgressMonitor)progress.newChild(45));
            }
            catch (TeamRepositoryException e) {
                if (e.getData() instanceof ConflictResolutionReport) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, e.getMessage(), (Throwable)((Object)new FileSystemException(e))));
                    this.updateCopyFileArea((ConflictResolutionReport)e.getData(), (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)progress.newChild(50));
                }
                throw e;
            }
            if (!updateReports.isEmpty()) {
                this.updateCopyFileArea(updateReports, (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)progress.newChild(50));
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    @Override
    public Collection<ILogicalConflict> needParentForResolution() {
        ArrayList<ILogicalConflict> missingResolutions = new ArrayList<ILogicalConflict>();
        for (ILogicalChange change : this.changes) {
            if (!(change instanceof ILogicalConflict)) continue;
            ILogicalConflict conflict = (ILogicalConflict)change;
            if (this.changeNeedsParentSpecification(conflict)) {
                missingResolutions.add(conflict);
                continue;
            }
            if (!this.destinationInUse(conflict)) continue;
            missingResolutions.add(conflict);
        }
        return missingResolutions;
    }

    public Collection needContentToRemoved() {
        ArrayList<ILogicalChange> blockedByContent = new ArrayList<ILogicalChange>();
        for (ILogicalChange change : this.changes) {
            ILogicalConflict conflict;
            if (!(change instanceof ILogicalConflict) || !this.destinationInUse(conflict = (ILogicalConflict)change) && !this.changeBlockedByContent(conflict)) continue;
            blockedByContent.add(change);
        }
        return blockedByContent;
    }

    @Override
    public void addChangesToResolve(Collection<? extends ILogicalChange> moreChanges) throws FileSystemException {
        for (ILogicalChange iLogicalChange : moreChanges) {
            if (!iLogicalChange.isChangeType(32) && (iLogicalChange.kind() != 1 || ((ILogicalConflict)iLogicalChange).conflictType() != 11)) continue;
            throw new FileSystemException(NLS.bind((String)Messages.ApplyAcceptedOperation_3, (Object)PathUtils.getPath(iLogicalChange.getPathHint())));
        }
        this.changes.addAll(moreChanges);
    }

    @Override
    protected Collection<ILogicalChange> getChanges() {
        return this.changes;
    }

    @Override
    public int numChangesResolved() {
        return this.changes.size();
    }
}

