/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IApplyAcceptedOperation;
import com.ibm.team.filesystem.client.IMarkAsMergedOperation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.checkin.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FailedAutoResolveRequest;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.ProducesOrphansInConfigurationException;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class AutoResolveOperation
extends FileSystemOperation
implements IAutoResolveConflictsOperation {
    private final AutoResolveConflictsDilemmaHandler problemHandler;
    private ApplyAcceptedDilemmaHandler applyAcceptedDilemmaHandler;
    private MarkAsMergedDilemmaHandler markAsMergedDilemmaHandler;
    private OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
    private int conflictsResolvedCount;
    private Shed shed;
    private final HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> contentConflicts;
    private final HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> autoMergeableConflicts;
    private final HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> evilTwinConflicts;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;
    private final IRepositoryResolver resolver;

    public AutoResolveOperation(AutoResolveConflictsDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        super(dilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : dilemmaHandler);
        this.resolver = resolver;
        this.problemHandler = dilemmaHandler == null ? AutoResolveConflictsDilemmaHandler.getDefault() : dilemmaHandler;
        this.applyAcceptedDilemmaHandler = this.problemHandler.getWrappingApplyAcceptedDilemmaHandler();
        this.markAsMergedDilemmaHandler = this.problemHandler.getMarkAsMergedDilemmaHandler();
        if (this.markAsMergedDilemmaHandler == null) {
            this.markAsMergedDilemmaHandler = MarkAsMergedDilemmaHandler.getDefault();
        }
        this.outOfSyncDilemmaHandler = this.problemHandler.getOutOfSyncDilemmaHandler();
        if (this.outOfSyncDilemmaHandler == null) {
            this.outOfSyncDilemmaHandler = OutOfSyncDilemmaHandler.getDefault();
        }
        this.contentConflicts = new HashMap();
        this.autoMergeableConflicts = new HashMap();
        this.evilTwinConflicts = new HashMap();
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
        this.conflictsResolvedCount = 0;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations();
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        if (AutoResolveOperation.this.verifyInSyncEnabled() && !AutoResolveOperation.this.outOfSyncDilemmaHandler.willIgnoreAllSharesOutOfSync()) {
                            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(AutoResolveOperation.this.outOfSyncDilemmaHandler);
                            for (ConfigurationFacade configuration : affectedConfigurations) {
                                verifyOp.addToVerify(configuration.getConnection(null), configuration.getComponentHandle());
                            }
                            verifyOp.run((IProgressMonitor)progress.newChild(7));
                        }
                        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
                        ICopyFileAreaLockRequest lockRequest = cfaManager.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                        ICopyFileAreasLock lock = cfaManager.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            Map sandboxes = AutoResolveOperation.this.getAffectedCFA(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
                            AutoResolveOperation autoResolveOperation = AutoResolveOperation.this;
                            autoResolveOperation.conflictsResolvedCount = autoResolveOperation.conflictsResolvedCount + AutoResolveOperation.this.performAutoMerge(sandboxes, (IProgressMonitor)progress.newChild(90));
                        }
                        finally {
                            lock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(op, Messages.AutoResolveOperation_2, (IProgressMonitor)progress.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    private Set<ConfigurationFacade> getAffectedConfigurations() throws FileSystemException {
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
        this.getAffectedConfigurations(this.contentConflicts, configurations);
        this.getAffectedConfigurations(this.autoMergeableConflicts, configurations);
        this.getAffectedConfigurations(this.evilTwinConflicts, configurations);
        return configurations;
    }

    private Map<ConfigurationFacade, List<ISandbox>> getAffectedCFA(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)affectedConfigurations.size());
        HashMap<ConfigurationFacade, List<ISandbox>> result = new HashMap<ConfigurationFacade, List<ISandbox>>();
        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
        for (ConfigurationFacade descriptor : affectedConfigurations) {
            ArrayList<Sandbox> sandboxes = new ArrayList<Sandbox>(2);
            result.put(descriptor, sandboxes);
            Collection<ICopyFileArea> cfas = cfaManager.getCopyFileAreasForConfiguration(descriptor, (IProgressMonitor)progress.newChild(1));
            for (ICopyFileArea cfa : cfas) {
                sandboxes.add(new Sandbox(cfa));
            }
        }
        return result;
    }

    private void getAffectedConfigurations(HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> requests, HashSet<ConfigurationFacade> configurations) {
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestByContext : requests.values()) {
            for (List<AutoResolveRequest> requestByReport : requestByContext.values()) {
                for (AutoResolveRequest request : requestByReport) {
                    configurations.add(request.getAffectedConfiguation());
                }
            }
        }
    }

    @Override
    public int numberOfConflictsResolved() {
        return this.conflictsResolvedCount;
    }

    private int performAutoMerge(Map<ConfigurationFacade, List<ISandbox>> affectedCFA, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.contentConflicts.size() + this.autoMergeableConflicts.size() + this.evilTwinConflicts.size() + 1));
        int mergeCount = 0;
        mergeCount += this.performEvilTwinAutoMerge(affectedCFA, progress.newChild(this.evilTwinConflicts.size()));
        mergeCount += this.performStructuralAutoMerge((IProgressMonitor)progress.newChild(this.autoMergeableConflicts.size()));
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestsByContext : this.contentConflicts.values()) {
            SubMonitor contextProgress = progress.newChild(1);
            contextProgress.setWorkRemaining(101);
            ArrayList<IVersionableHandle> itemsToFetch = new ArrayList<IVersionableHandle>();
            IWorkspaceConnection wc = null;
            int workRemaining = 0;
            for (List<AutoResolveRequest> requests : requestsByContext.values()) {
                for (AutoResolveRequest request : requests) {
                    if (wc == null) {
                        wc = request.connection;
                    }
                    boolean stillHasConflict = false;
                    IVersionableHandle one = request.getCommonAncestorState();
                    IUpdateReport conflictReport = wc.conflictReport(request.getAffectedConfiguation().getComponentHandle());
                    Iterator iter = conflictReport.conflicts().iterator();
                    while (!stillHasConflict && iter.hasNext()) {
                        IVersionableHandle iVersionableHandle = ((IItemConflictReport)iter.next()).getCommonAncestorState();
                        if (one != null && iVersionableHandle != null && !one.getItemId().equals((Object)iVersionableHandle.getItemId())) continue;
                        stillHasConflict = true;
                    }
                    if (!stillHasConflict || request.logicalChange.isChangeType(32) || request.logicalChange.kind() == 1 && ((ILogicalConflict)request.logicalChange).conflictType() == 11) continue;
                    if (request.getCommonAncestorState() instanceof IFileItemHandle) {
                        itemsToFetch.add(request.getCommonAncestorState());
                    } else if (request.getCommonAncestorState() instanceof ISymbolicLinkHandle) {
                        itemsToFetch.add(request.getCommonAncestorState());
                    } else if (request.getCommonAncestorState() instanceof IFolderHandle) {
                        itemsToFetch.add(request.getCommonAncestorState());
                    }
                    if (request.getProposedContributorState() instanceof IFileItemHandle) {
                        itemsToFetch.add(request.getProposedContributorState());
                    } else if (request.getProposedContributorState() instanceof ISymbolicLinkHandle) {
                        itemsToFetch.add(request.getProposedContributorState());
                    } else if (request.getProposedContributorState() instanceof IFolderHandle) {
                        itemsToFetch.add(request.getProposedContributorState());
                    }
                    if (this.isSameFolderAddAddConflict(request.logicalChange)) {
                        IFolderHandle handle = (IFolderHandle)request.getCommonAncestorState();
                        if (handle != null) {
                            itemsToFetch.add((IVersionableHandle)handle);
                        }
                        if ((handle = (IFolderHandle)request.getProposedContributorState()) != null) {
                            itemsToFetch.add((IVersionableHandle)handle);
                        }
                        if ((handle = (IFolderHandle)request.getSelectedContributorState()) != null) {
                            itemsToFetch.add((IVersionableHandle)handle);
                        }
                    }
                    ++workRemaining;
                }
            }
            Map<UUID, IVersionable> fetched = AutoResolveOperation.fetchItems(wc, itemsToFetch, (IProgressMonitor)contextProgress.newChild(25));
            ArrayList<FailedAutoResolveRequest> unknownTypes = new ArrayList<FailedAutoResolveRequest>();
            ArrayList<FailedAutoResolveRequest> itemsWithNoHandlers = new ArrayList<FailedAutoResolveRequest>();
            HashMap<ILogicalConflictReport, List<ILogicalChange>> resolvedConflicts = new HashMap<ILogicalConflictReport, List<ILogicalChange>>();
            SubMonitor subProgress = contextProgress.newChild(25).setWorkRemaining(workRemaining);
            for (Map.Entry<ILogicalConflictReport, List<AutoResolveRequest>> requests : requestsByContext.entrySet()) {
                ArrayList<ILogicalChange> resolvedItems = new ArrayList<ILogicalChange>();
                resolvedConflicts.put(requests.getKey(), resolvedItems);
                for (AutoResolveRequest autoResolveRequest : requests.getValue()) {
                    IVersionable proposedItem;
                    IVersionableHandle commonAncestor = autoResolveRequest.getCommonAncestorState();
                    IVersionableHandle proposed = autoResolveRequest.getProposedContributorState();
                    if (proposed == null) continue;
                    IVersionable commonAncestorItem = null;
                    if (commonAncestor != null) {
                        commonAncestorItem = fetched.get(commonAncestor.getStateId());
                    }
                    if ((proposedItem = fetched.get(proposed.getStateId())) == null) continue;
                    try {
                        List<ISandbox> sandboxes = affectedCFA.get((Object)autoResolveRequest.configurationDescriptor);
                        SubMonitor itemProgress = subProgress.newChild(1).setWorkRemaining(sandboxes.size());
                        for (ISandbox sandbox : sandboxes) {
                            File file;
                            SubMonitor sandboxItemProgress = itemProgress.newChild(1).setWorkRemaining(100);
                            Shareable shareable = (Shareable)sandbox.findShareable(autoResolveRequest.connection.getContextHandle(), autoResolveRequest.configurationDescriptor.getComponentHandle(), autoResolveRequest.logicalChange.item(), (IProgressMonitor)sandboxItemProgress.newChild(2));
                            if (shareable == null) {
                                Shareable parent = (Shareable)sandbox.findShareable(autoResolveRequest.connection.getContextHandle(), autoResolveRequest.configurationDescriptor.getComponentHandle(), (IVersionableHandle)autoResolveRequest.logicalChange.parent(), (IProgressMonitor)sandboxItemProgress.newChild(2));
                                if (parent != null) continue;
                                continue;
                            }
                            ResourceType type = shareable.getResourceType((IProgressMonitor)sandboxItemProgress.newChild(1));
                            IVersionableHandle shareableVersionable = shareable.getVersionable((IProgressMonitor)sandboxItemProgress.newChild(1));
                            AutoResolveState resolveState = new AutoResolveState(autoResolveRequest.logicalChange.item());
                            if (!autoResolveRequest.logicalChange.isChangeType(1)) {
                                resolveState.addMerged = true;
                            }
                            resolveState.userPropertiesMerged = this.isSameItemAddAddChange(autoResolveRequest.logicalChange) ? this.isSameProperties(proposedItem, shareable, (IProgressMonitor)sandboxItemProgress.newChild(3)) : this.performUserPropertyAutoMerge(commonAncestorItem, proposedItem, shareable, (IProgressMonitor)sandboxItemProgress.newChild(3));
                            if (type == ResourceType.FOLDER && ResourceType.getResourceType(shareableVersionable) == ResourceType.FOLDER) {
                                IVersionable selectedItem;
                                if (this.isSameFolderAddAddConflict(autoResolveRequest.logicalChange) && (selectedItem = fetched.get(autoResolveRequest.getSelectedContributorState().getStateId())) != null && selectedItem.getName().equals(proposedItem.getName()) && shareable.getLocalPath().getName().equals(proposedItem.getName()) && selectedItem.getParent().sameItemId((IItemHandle)proposedItem.getParent())) {
                                    if (!shareable.isShare((IProgressMonitor)sandboxItemProgress.newChild(49))) {
                                        if (proposedItem.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)sandboxItemProgress.newChild(48)))) {
                                            resolveState.addMerged = true;
                                        }
                                    } else {
                                        resolveState.addMerged = true;
                                    }
                                }
                            } else if (type == ResourceType.FILE && ResourceType.getResourceType(shareableVersionable) == ResourceType.FILE) {
                                resolveState.executableMerged = this.performExecutablePropertyMerge((IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, (IProgressMonitor)sandboxItemProgress.newChild(1));
                                resolveState.propertiesMerged = this.performFilePropertyAutoMerge((IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, sandboxItemProgress.newChild(3));
                                if (autoResolveRequest.logicalChange.isChangeType(4) && !autoResolveRequest.logicalChange.isModificationChange(4)) {
                                    resolveState.contentMerged = true;
                                }
                                if (!(!resolveState.propertiesMerged || resolveState.contentMerged && resolveState.addMerged)) {
                                    boolean resetToReadOnly = false;
                                    file = (File)shareable.getAdapter(File.class);
                                    try {
                                        IFileContentMerger fileContentMerger;
                                        IStatus status;
                                        if (file.exists() && !file.canWrite()) {
                                            resetToReadOnly = file.setWritable(true);
                                        }
                                        if ((status = (fileContentMerger = SharingManager.getInstance().getFileContentMerger()).performAutoMerge(wc.teamRepository(), (IFileItem)commonAncestorItem, (IFileItem)proposedItem, shareable, null, this.shed, (IProgressMonitor)sandboxItemProgress.newChild(89))).isOK()) {
                                            resolveState.contentMerged = true;
                                        } else if (status.getCode() == 1002) {
                                            unknownTypes.add(new FailedAutoResolveRequest(autoResolveRequest, shareable, true, resolveState));
                                        } else if (status.getCode() == 1001) {
                                            itemsWithNoHandlers.add(new FailedAutoResolveRequest(autoResolveRequest, shareable, true, resolveState));
                                        }
                                    }
                                    finally {
                                        if (resetToReadOnly) {
                                            file.setWritable(false);
                                        }
                                    }
                                }
                                if (this.isSameItemAddAddChange(autoResolveRequest.logicalChange) && proposedItem.getName().equals(shareable.getLocalPath().getName())) {
                                    if (shareable.isShare((IProgressMonitor)sandboxItemProgress.newChild(2))) {
                                        if (proposedItem.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)sandboxItemProgress.newChild(1)))) {
                                            resolveState.addMerged = true;
                                        }
                                    } else {
                                        resolveState.addMerged = true;
                                    }
                                }
                            } else if (type == ResourceType.SYMBOLIC_LINK && ResourceType.getResourceType(shareableVersionable) == ResourceType.SYMBOLIC_LINK) {
                                if (autoResolveRequest.logicalChange.isChangeType(4) && !autoResolveRequest.logicalChange.isModificationChange(4)) {
                                    resolveState.contentMerged = true;
                                }
                                if (!(!resolveState.userPropertiesMerged || resolveState.contentMerged && resolveState.addMerged)) {
                                    boolean resetToReadOnly = false;
                                    file = (File)shareable.getAdapter(File.class);
                                    try {
                                        boolean localIsDirectoryLink;
                                        if (file.exists() && !file.canWrite()) {
                                            resetToReadOnly = file.setWritable(true);
                                        }
                                        ISymbolicLink remoteLink = (ISymbolicLink)proposedItem;
                                        String remoteTarget = remoteLink.getTarget();
                                        remoteTarget = shareable.getFileStorage().convertTargetIntoLocalForm(remoteTarget);
                                        boolean remoteIsDirectoryLink = remoteLink.isDirectoryLink();
                                        LinkInfo info = shareable.getFileStorage().getLinkInfo(null);
                                        String localTarget = info.getTarget();
                                        boolean bl = info.getType() == LinkType.NONE ? shareable.getFileItemInfo(null).isDirectoryLink() : (localIsDirectoryLink = info.getType() == LinkType.DIRECTORY);
                                        if (remoteTarget.equals(localTarget) && remoteIsDirectoryLink == localIsDirectoryLink) {
                                            resolveState.contentMerged = true;
                                        }
                                    }
                                    finally {
                                        if (resetToReadOnly) {
                                            file.setWritable(false);
                                        }
                                    }
                                }
                                if (this.isSameItemAddAddChange(autoResolveRequest.logicalChange) && proposedItem.getName().equals(shareable.getLocalPath().getName())) {
                                    if (shareable.isShare((IProgressMonitor)sandboxItemProgress.newChild(2))) {
                                        if (proposedItem.getParent().sameItemId((IItemHandle)shareable.getParent().getRemote((IProgressMonitor)sandboxItemProgress.newChild(1)))) {
                                            resolveState.addMerged = true;
                                        }
                                    } else {
                                        resolveState.addMerged = true;
                                    }
                                }
                            }
                            if (!resolveState.isMerged()) continue;
                            resolvedItems.add(autoResolveRequest.logicalChange);
                        }
                    }
                    catch (Exception e) {
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                    }
                }
            }
            int directive = 0;
            if (!itemsWithNoHandlers.isEmpty() || !unknownTypes.isEmpty()) {
                subProgress = contextProgress.newChild(25).setWorkRemaining(100);
                directive = this.problemHandler.missingStorageMerger(Collections.unmodifiableCollection(unknownTypes), Collections.unmodifiableCollection(itemsWithNoHandlers), (IProgressMonitor)subProgress.newChild(5));
                if (directive == 0) {
                    FailedAutoResolveRequest failedRequest;
                    SubMonitor itemProgress;
                    ITeamRepository teamRepository = wc.teamRepository();
                    subProgress.setWorkRemaining(unknownTypes.size() + itemsWithNoHandlers.size());
                    for (IFailedAutoResolveRequest iFailedAutoResolveRequest : unknownTypes) {
                        itemProgress = subProgress.newChild(1).setWorkRemaining(100);
                        failedRequest = (FailedAutoResolveRequest)iFailedAutoResolveRequest;
                        if (!failedRequest.isRetryMerge()) continue;
                        this.retryFileContentMerge(teamRepository, failedRequest, fetched, resolvedConflicts, (IProgressMonitor)itemProgress);
                    }
                    for (IFailedAutoResolveRequest iFailedAutoResolveRequest : itemsWithNoHandlers) {
                        itemProgress = subProgress.newChild(1).setWorkRemaining(100);
                        failedRequest = (FailedAutoResolveRequest)iFailedAutoResolveRequest;
                        if (!failedRequest.isRetryMerge()) continue;
                        this.retryFileContentMerge(teamRepository, failedRequest, fetched, resolvedConflicts, (IProgressMonitor)itemProgress);
                    }
                }
            }
            contextProgress.setWorkRemaining(resolvedConflicts.size());
            for (Map.Entry entry : resolvedConflicts.entrySet()) {
                try {
                    IMarkAsMergedOperation mergedOp = IOperationFactory.instance.getMarkAsMergedOperation(this.markAsMergedDilemmaHandler);
                    mergedOp.setContext(wc, (ILogicalConflictReport)entry.getKey());
                    mergedOp.addChangesToResolve((Collection)entry.getValue());
                    this.disableVerifyInSync(mergedOp);
                    if (this.nonAtomicCommitIsAnOption) {
                        mergedOp.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                    } else {
                        mergedOp.disableNonAtomicCommit();
                    }
                    mergedOp.run((IProgressMonitor)contextProgress.newChild(1));
                    mergeCount += ((List)entry.getValue()).size();
                }
                catch (Exception e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                }
            }
            if (directive == 1) {
                throw new OperationCanceledException();
            }
            if (directive != 2) continue;
            throw new FileSystemException(Messages.AutoResolveOperation_0);
        }
        return mergeCount;
    }

    private int performEvilTwinAutoMerge(Map<ConfigurationFacade, List<ISandbox>> affectedCFA, SubMonitor monitor) throws TeamRepositoryException {
        monitor.setWorkRemaining(this.evilTwinConflicts.size() * 3);
        int merged = 0;
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestsByContext : this.evilTwinConflicts.values()) {
            SubMonitor contextProgress = monitor.newChild(1);
            ArrayList<IVersionableHandle> itemsToFetch = new ArrayList<IVersionableHandle>();
            IWorkspaceConnection wc = null;
            contextProgress.setWorkRemaining(requestsByContext.size());
            for (List<AutoResolveRequest> requests : requestsByContext.values()) {
                SubMonitor reqProgress = contextProgress.newChild(1);
                reqProgress.setWorkRemaining(requests.size());
                for (AutoResolveRequest request : requests) {
                    if (wc == null) {
                        wc = request.connection;
                    }
                    ILogicalConflict log = (ILogicalConflict)request.logicalChange;
                    itemsToFetch.add(log.afterState());
                    List<ILogicalChange> dependentChanges = request.computeFlattenedDependencies();
                    for (ILogicalChange dep : dependentChanges) {
                        if (dep.afterState() != null) {
                            itemsToFetch.add(dep.afterState());
                        }
                        if (dep.beforeState() == null) continue;
                        itemsToFetch.add(dep.beforeState());
                    }
                    IVersionableHandle local = (IVersionableHandle)log.conflictingItems().iterator().next();
                    List<ISandbox> sandboxes = affectedCFA.get((Object)request.configurationDescriptor);
                    SubMonitor sbMonitor = reqProgress.newChild(1);
                    sbMonitor.setWorkRemaining(sandboxes.size() * 2);
                    for (ISandbox sb : sandboxes) {
                        IShareable shareable = sb.findShareable(request.configurationDescriptor.getConnectionHandle(), request.configurationDescriptor.getComponentHandle(), local, (IProgressMonitor)sbMonitor.newChild(1));
                        if (shareable == null) continue;
                        itemsToFetch.add(shareable.getRemote((IProgressMonitor)sbMonitor.newChild(1)));
                    }
                }
                reqProgress.done();
            }
            Map<UUID, IVersionable> fetched = AutoResolveOperation.fetchItems(wc, itemsToFetch, (IProgressMonitor)monitor.newChild(1));
            contextProgress = monitor.newChild(1);
            contextProgress.setWorkRemaining(requestsByContext.size());
            for (Map.Entry<ILogicalConflictReport, List<AutoResolveRequest>> requests : requestsByContext.entrySet()) {
                SubMonitor reqProgress = contextProgress.newChild(1);
                reqProgress.setWorkRemaining(requests.getValue().size());
                for (AutoResolveRequest conflict : requests.getValue()) {
                    List<ISandbox> sandboxes = affectedCFA.get((Object)conflict.configurationDescriptor);
                    SubMonitor sbProgress = reqProgress.newChild(1);
                    sbProgress.setWorkRemaining(sandboxes.size());
                    for (ISandbox sandbox : sandboxes) {
                        merged += this.mergeEvilTwinFolderConflict(conflict, sandbox, fetched, sbProgress.newChild(1));
                    }
                }
            }
        }
        return merged;
    }

    protected boolean isEvilTwinResolvable(AutoResolveRequest conflict) {
        if (!(conflict.logicalChange instanceof ILogicalConflict)) {
            return false;
        }
        ILogicalConflict lc = (ILogicalConflict)conflict.logicalChange;
        Collection others = lc.conflictingItems();
        if (lc.conflictType() == 1 && conflict.logicalChange.item() instanceof IFolderHandle && others.size() == 1 && !lc.item().sameItemId((IItemHandle)others.iterator().next())) {
            return others.iterator().next() instanceof IFolderHandle;
        }
        return false;
    }

    private int mergeEvilTwinFolderConflict(AutoResolveRequest conflict, ISandbox sandbox, Map<UUID, IVersionable> fetched, SubMonitor monitor) throws TeamRepositoryException {
        monitor.setWorkRemaining(10);
        IFolderHandle current = (IFolderHandle)((ILogicalConflict)conflict.logicalChange).conflictingItems().iterator().next();
        if (current.getStateId() == null) {
            IShareable shareable = SharingManager.getInstance().findShareable(sandbox.getRoot(), conflict.configurationDescriptor.getConnectionHandle(), conflict.configurationDescriptor.getComponentHandle(), (IVersionableHandle)current, (IProgressMonitor)monitor.newChild(1));
            current = (IFolderHandle)shareable.getRemote((IProgressMonitor)monitor.newChild(1));
        } else {
            monitor.worked(2);
        }
        IFolderHandle proposed = (IFolderHandle)conflict.conflict.getProposedContributorState();
        if (!this.isMergeableWithEvilTwin((IFolder)fetched.get(current.getStateId()), (IFolder)fetched.get(proposed.getStateId()))) {
            return 0;
        }
        ChangeSetChooser chooser = new ChangeSetChooser(conflict.connection, null, Messages.MarkAsMergedOperation_ChangeSetDefaultComment);
        int resolved = this.mergeEvilTwinHierarchy(conflict, sandbox, current, proposed, fetched, chooser, monitor.newChild(1));
        IUpdateReport updateReport = null;
        try {
            updateReport = chooser.commit((IProgressMonitor)monitor.newChild(1));
        }
        catch (ProducesOrphansInConfigurationException producesOrphansInConfigurationException) {
            return 0;
        }
        UpdateOperation op = new UpdateOperation(conflict.connection, Collections.singletonList(updateReport), 3, this.applyAcceptedDilemmaHandler, null);
        this.disableVerifyInSync(op);
        monitor.setWorkRemaining(1);
        op.run((IProgressMonitor)monitor.newChild(1));
        return resolved;
    }

    private boolean chooseEvilTwinWinner(AutoResolveRequest conflict, IVersionableHandle current, IVersionableHandle proposed, SubMonitor monitor) throws TeamRepositoryException {
        ITeamRepository targetRepo;
        IContextHandle targetCtx;
        monitor.setWorkRemaining(3);
        IWorkspaceConnection wsConn = conflict.connection;
        ConnectionDescriptor desc = FlowTableUtil.getCurrentCollaborationDescriptor(wsConn, conflict.configurationDescriptor.getComponentHandle());
        if (desc == null) {
            IWorkspaceConnection target = FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)wsConn, (IProgressMonitor)monitor.newChild(1));
            if (target == null) {
                return true;
            }
            targetCtx = target.getContextHandle();
            targetRepo = wsConn.teamRepository();
        } else {
            targetCtx = desc.connectionHandle;
            targetRepo = this.resolver.getRepoFor(desc.uri, desc.id);
        }
        IChangeSetSearchCriteria crit = IChangeSetSearchCriteria.FACTORY.newInstance();
        crit.setItem(proposed);
        crit.setContext(targetCtx);
        List targetChangeSets = SCMPlatform.getWorkspaceManager((ITeamRepository)targetRepo).findChangeSets(crit, 1, (IProgressMonitor)monitor.newChild(1));
        return targetChangeSets.isEmpty();
    }

    private int mergeEvilTwinHierarchy(AutoResolveRequest req, ISandbox sandbox, IFolderHandle current, IFolderHandle proposedHandle, Map<UUID, IVersionable> fetched, ChangeSetChooser chooser, SubMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection.IConfigurationOpFactory opFactory = req.connection.configurationOpFactory();
        DeferredReparentingOperands reparenting = new DeferredReparentingOperands();
        HashMap<UUID, IFolderHandle> parentMapping = new HashMap<UUID, IFolderHandle>();
        IFolderHandle parent = fetched.get(current.getStateId()).getParent();
        parentMapping.put(parent.getItemId(), parent);
        int fixed = 0;
        HashSet<UUID> processedItems = new HashSet<UUID>();
        LinkedList<ILogicalChange> toProcess = new LinkedList<ILogicalChange>();
        toProcess.add(req.logicalChange);
        boolean useCurrent = this.chooseEvilTwinWinner(req, (IVersionableHandle)current, (IVersionableHandle)proposedHandle, monitor);
        while (!toProcess.isEmpty()) {
            IShareable shareable;
            ILogicalChange chg = (ILogicalChange)toProcess.remove(0);
            if (processedItems.contains(chg.item().getItemId())) continue;
            processedItems.add(chg.item().getItemId());
            IVersionableHandle afterState = chg.afterState();
            if (afterState == null) continue;
            IVersionable remoteItem = fetched.get(afterState.getStateId());
            if (remoteItem == null) {
                if (fetched.containsKey(afterState.getStateId())) continue;
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Progamming error - failed to fetch " + afterState.getItemId() + "/" + afterState.getStateId()));
                continue;
            }
            IItemConflictReport rpt = this.findItemConflictReport(req, (IVersionableHandle)remoteItem);
            IFolderHandle mappedParent = (IFolderHandle)parentMapping.get(remoteItem.getParent().getItemId());
            IVersionableHandle localVer = null;
            if (mappedParent != null && (shareable = this.localChildEntryShareable(req, sandbox, mappedParent, remoteItem.getName(), monitor.newChild(1))) != null && (localVer = shareable.getRemote((IProgressMonitor)monitor.newChild(1))) != null && (!remoteItem.getItemType().equals(localVer.getItemType()) || !this.isSameProperties(remoteItem, shareable, (IProgressMonitor)monitor.newChild(1)))) continue;
            if (useCurrent) {
                if (localVer == null) {
                    if (mappedParent == null) {
                        mappedParent = remoteItem.getParent();
                    }
                    IVersionable toReparent = (IVersionable)remoteItem.getWorkingCopy();
                    toReparent.setParent(mappedParent);
                    this.saveAndMerge(req, opFactory, rpt, toReparent, chooser, reparenting, monitor);
                } else {
                    IWorkspaceConnection.IMarkAsMergedOp mergeOp = opFactory.markAsMerged((IVersionableHandle)remoteItem, rpt.getOriginalSelectedContributorState(), rpt.getProposedContributorState());
                    chooser.toCommit(req.configurationDescriptor.getComponentHandle(), (IVersionableHandle)remoteItem, (IWorkspaceConnection.IConfigurationOp)mergeOp, (IProgressMonitor)monitor.newChild(1));
                    if (localVer instanceof IFolderHandle) {
                        parentMapping.put(remoteItem.getItemId(), (IFolderHandle)localVer);
                    }
                }
            } else if (localVer == null) {
                if (mappedParent == null) {
                    mappedParent = remoteItem.getParent();
                }
                this.saveAndMerge(req, opFactory, rpt, (IVersionable)remoteItem.getWorkingCopy(), chooser, reparenting, monitor);
            } else if (remoteItem.sameItemId(localVer)) {
                this.saveAndMerge(req, opFactory, rpt, (IVersionable)remoteItem.getWorkingCopy(), chooser, reparenting, monitor);
            } else {
                IWorkspaceConnection.IDeleteOp delOp = opFactory.delete(localVer);
                chooser.toCommit(req.configurationDescriptor.getComponentHandle(), (IVersionableHandle)remoteItem, (IWorkspaceConnection.IConfigurationOp)delOp, (IProgressMonitor)monitor.newChild(1));
                reparenting.exclude(localVer);
                if (localVer instanceof IFolderHandle && remoteItem instanceof IFolderHandle) {
                    reparenting.add((IFolderHandle)localVer, (IFolderHandle)remoteItem);
                    parentMapping.put(remoteItem.getItemId(), (IFolderHandle)localVer);
                }
            }
            ++fixed;
            toProcess.addAll(req.conflictReport.getDependentChanges(chg));
        }
        reparenting.run(req, sandbox, chooser, monitor.newChild(1));
        return fixed;
    }

    protected void saveAndMerge(AutoResolveRequest req, IWorkspaceConnection.IConfigurationOpFactory opFactory, IItemConflictReport rpt, IVersionable toSave, ChangeSetChooser chooser, DeferredReparentingOperands reparenting, SubMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection.IMergeOp mergeOp = opFactory.merge((IWorkspaceConnection.IMergeResultOp)opFactory.save(toSave), rpt.getOriginalSelectedContributorState(), rpt.getProposedContributorState());
        chooser.toCommit(req.configurationDescriptor.getComponentHandle(), (IVersionableHandle)toSave, (IWorkspaceConnection.IConfigurationOp)mergeOp, (IProgressMonitor)monitor.newChild(1));
        reparenting.exclude((IVersionableHandle)toSave);
    }

    protected void addConflictsToQueue(AutoResolveRequest req, List<ILogicalChange> toProcess, ILogicalChange chg) {
        toProcess.addAll(req.conflictReport.getDependentChanges(chg));
    }

    private IShareable localChildEntryShareable(AutoResolveRequest conflict, ISandbox sandbox, IFolderHandle parentToUse, String name, SubMonitor monitor) throws FileSystemException {
        monitor.setWorkRemaining(10);
        Shareable shareable = (Shareable)sandbox.findShareable(conflict.configurationDescriptor.getConnectionHandle(), conflict.configurationDescriptor.getComponentHandle(), (IVersionableHandle)parentToUse, (IProgressMonitor)monitor.newChild(1));
        if (shareable == null) {
            return null;
        }
        IFileStorage storage = shareable.getFileStorage();
        IFileStorage child = storage.getChild(name, (IProgressMonitor)monitor.newChild(1));
        if (child == null) {
            return null;
        }
        return child.getShareable();
    }

    protected boolean isMergeableEvilTwinFolder(AutoResolveRequest conflict, ISandbox sandbox, IVersionable remote, IItemConflictReport rpt, IVersionableHandle local, SubMonitor monitor) throws FileSystemException {
        if (remote instanceof IFolderHandle && local instanceof IFolderHandle) {
            Shareable s = (Shareable)sandbox.findShareable(conflict.configurationDescriptor.getConnectionHandle(), conflict.configurationDescriptor.getComponentHandle(), local, (IProgressMonitor)monitor.newChild(1));
            if (s == null) {
                throw new IllegalStateException("Missing " + rpt);
            }
            return this.isSameProperties(remote, s, (IProgressMonitor)monitor.newChild(1));
        }
        return false;
    }

    private IItemConflictReport findItemConflictReport(AutoResolveRequest conflict, IVersionableHandle toParent) {
        for (IItemConflictReport report : conflict.conflictReport.conflictReport().getConflictsForComponent(conflict.configurationDescriptor.getComponentHandle())) {
            if (!report.item().sameItemId((IItemHandle)toParent)) continue;
            return report;
        }
        return null;
    }

    private boolean isMergeableWithEvilTwin(IFolder current, IFolder proposed) {
        return current != null && proposed != null && current.getName().equals(proposed.getName()) && MetadataProperties.calcPropertyChanges(current.getUserProperties(), proposed.getUserProperties()).isEmpty();
    }

    private boolean isSameProperties(IVersionable proposedItem, IShareable shareable, IProgressMonitor progress) {
        Map<String, String> current;
        Map proposed = proposedItem.getUserProperties();
        try {
            current = shareable.getMetadataProperties(progress).getCurrentProperties();
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
        if (proposed.size() != current.size()) {
            return false;
        }
        return MetadataProperties.calcPropertyChanges(current, proposed).isEmpty();
    }

    private boolean performUserPropertyAutoMerge(IVersionable commonAncestorItem, IVersionable proposedItem, Shareable shareable, IProgressMonitor progress) throws TeamRepositoryException {
        HashMap<String, String> currentProperties;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Map commonProperties = commonAncestorItem == null ? Collections.EMPTY_MAP : commonAncestorItem.getUserProperties();
        Map proposedProperties = proposedItem.getUserProperties();
        try {
            currentProperties = new HashMap<String, String>(shareable.getMetadataProperties((IProgressMonitor)monitor.newChild(5)).getCurrentProperties());
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
        MetadataProperties proposedDelta = new MetadataProperties((Map<String, String>)commonProperties, proposedProperties);
        boolean unmergedChanges = false;
        boolean changeProperties = false;
        for (Map.Entry<String, String> proposedEntry : proposedDelta.getChangedProperties().entrySet()) {
            String currentValue;
            String propertyName = proposedEntry.getKey();
            String proposedValue = proposedEntry.getValue();
            if (proposedValue.equals(currentValue = (String)currentProperties.get(propertyName))) continue;
            String commonValue = (String)commonProperties.get(propertyName);
            if (commonValue == null && currentValue == null) {
                currentProperties.put(propertyName, proposedValue);
                changeProperties = true;
                continue;
            }
            if (commonValue != null && commonValue.equals(currentValue)) {
                currentProperties.put(propertyName, proposedValue);
                changeProperties = true;
                continue;
            }
            unmergedChanges = true;
        }
        for (String propertyName : proposedDelta.getRemovedProperties()) {
            String currentValue = (String)currentProperties.get(propertyName);
            if (currentValue == null) continue;
            String commonValue = (String)commonProperties.get(propertyName);
            if (!currentValue.equals(commonValue)) {
                unmergedChanges = true;
                continue;
            }
            currentProperties.remove(propertyName);
            changeProperties = true;
        }
        if (changeProperties) {
            ChangePropertiesDilemmaHandler dilemmaHandler = new ChangePropertiesDilemmaHandler(){

                @Override
                public int invalidContentTypes(List<? extends IChangePropertiesRequest> invalidContentTypeChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                    return 0;
                }

                @Override
                public BackupDilemmaHandler getBackupDilemmaHandler() {
                    return AutoResolveOperation.this.problemHandler.getBackupDilemmaHandler();
                }
            };
            IChangePropertiesOperation changePropertiesOp = IOperationFactory.instance.getChangePropertiesOperation(dilemmaHandler);
            changePropertiesOp.setProperties(shareable, currentProperties);
            this.disableVerifyInSync(changePropertiesOp);
            changePropertiesOp.run((IProgressMonitor)monitor.newChild(95));
        }
        return !unmergedChanges;
    }

    private boolean isSameFolderAddAddConflict(ILogicalChange change) {
        return change.item() instanceof IFolderHandle && this.isSameItemAddAddChange(change);
    }

    private boolean isSameItemAddAddChange(ILogicalChange change) {
        IVersionableHandle versionableConflictedWith;
        ILogicalConflict conflict;
        return change.kind() == 1 && ((ILogicalConflict)change).conflictType() == 1 && (conflict = (ILogicalConflict)change).conflictingItems().size() == 1 && (versionableConflictedWith = (IVersionableHandle)conflict.conflictingItems().iterator().next()).sameItemId((IItemHandle)conflict.item());
    }

    private boolean performExecutablePropertyMerge(IFileItem commonAncestorItem, IFileItem proposedItem, IShareable selectedItem, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (proposedItem.isExecutable() == ((Shareable)selectedItem).getFileStorage().isExecutable((IProgressMonitor)monitor.newChild(30))) {
            return true;
        }
        if (commonAncestorItem == null) {
            return false;
        }
        if (proposedItem.isExecutable() == commonAncestorItem.isExecutable()) {
            return true;
        }
        boolean merged = ((Shareable)selectedItem).getFileStorage().setExecutable(proposedItem.isExecutable(), (IProgressMonitor)monitor.newChild(65));
        if (merged) {
            LocalChangeManager.getInstance().computeChanges(selectedItem, (IProgressMonitor)monitor.newChild(5));
        }
        return merged;
    }

    private void retryFileContentMerge(ITeamRepository teamRepository, FailedAutoResolveRequest request, Map<UUID, IVersionable> fetched, HashMap<ILogicalConflictReport, List<ILogicalChange>> resolvedConflicts, IProgressMonitor progress) {
        SubMonitor itemProgress = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        AutoResolveRequest modModConflict = request.getRequest();
        IVersionableHandle commonAncestor = modModConflict.getCommonAncestorState();
        IVersionableHandle proposed = modModConflict.getProposedContributorState();
        if (!(modModConflict.logicalChange.item() instanceof IFileItemHandle)) {
            return;
        }
        IFileItem commonAncestorItem = (IFileItem)fetched.get(commonAncestor.getStateId());
        IFileItem proposedItem = (IFileItem)fetched.get(proposed.getStateId());
        if (proposedItem == null) {
            return;
        }
        try {
            IFileContentMerger fileContentMerger;
            IStatus status;
            IShareable shareable = request.getConflictedShareable();
            ResourceType type = shareable.getResourceType((IProgressMonitor)itemProgress.newChild(1));
            if (type == ResourceType.FILE && (status = (fileContentMerger = SharingManager.getInstance().getFileContentMerger()).performAutoMerge(teamRepository, commonAncestorItem, proposedItem, shareable, request.getDefaultContentTypeMerger(), this.shed, (IProgressMonitor)itemProgress.newChild(94))).isOK()) {
                request.getResolveState().contentMerged = true;
                LocalChangeManager.getInstance().computeChanges(shareable, (IProgressMonitor)itemProgress.newChild(5));
                if (request.getResolveState().isMerged()) {
                    List<ILogicalChange> resolvedItems = resolvedConflicts.get(modModConflict.conflictReport);
                    resolvedItems.add(modModConflict.logicalChange);
                }
            }
        }
        catch (Exception e) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
        }
    }

    private int performStructuralAutoMerge(IProgressMonitor progress) {
        int mergeCount = 0;
        for (HashMap<ILogicalConflictReport, List<AutoResolveRequest>> requestByContext : this.autoMergeableConflicts.values()) {
            IWorkspaceConnection wc = null;
            for (Map.Entry<ILogicalConflictReport, List<AutoResolveRequest>> autoMergeable : requestByContext.entrySet()) {
                ILogicalConflictReport conflictReport = autoMergeable.getKey();
                ArrayList<ILogicalChange> conflictsToAutoResolve = new ArrayList<ILogicalChange>();
                for (AutoResolveRequest request : autoMergeable.getValue()) {
                    if (wc == null) {
                        wc = request.connection;
                    }
                    conflictsToAutoResolve.add(request.logicalChange);
                }
                try {
                    IApplyAcceptedOperation op = IOperationFactory.instance.getApplyAcceptedOperation(this.applyAcceptedDilemmaHandler);
                    op.setContext(wc, conflictReport);
                    op.addChangesToResolve(conflictsToAutoResolve);
                    this.disableVerifyInSync(op);
                    op.run(progress);
                    mergeCount += op.numChangesResolved();
                }
                catch (Exception e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, Messages.AutoResolveOperation_1, e));
                }
            }
        }
        return mergeCount;
    }

    private static Map<UUID, IVersionable> fetchItems(IWorkspaceConnection wc, List<IVersionableHandle> toFetch, IProgressMonitor progress) throws TeamRepositoryException {
        HashMap<UUID, IVersionable> result = new HashMap<UUID, IVersionable>();
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)wc.teamRepository());
        if (!toFetch.isEmpty()) {
            List fetched = manager.versionableManager().fetchCompleteStates(toFetch, progress);
            for (IVersionable item : fetched) {
                if (item == null) continue;
                result.put(item.getStateId(), item);
            }
        }
        return result;
    }

    private boolean performFilePropertyAutoMerge(IFileItem commonAncestorItem, IFileItem proposedItem, Shareable shareable, SubMonitor progress) throws FileSystemException, TeamRepositoryException {
        final boolean[] success = new boolean[]{true};
        ChangePropertiesDilemmaHandler changePropertiesDilemmaHandler = new ChangePropertiesDilemmaHandler(){

            @Override
            public int invalidContentTypes(List<? extends IChangePropertiesRequest> invalidContentTypeChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                return 0;
            }

            @Override
            public int inconsistentLineDelimiters(List<? extends IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemException {
                success[0] = false;
                return AutoResolveOperation.this.problemHandler.getChangePropertiesDilemmaHandler().inconsistentLineDelimiters(inconsistentDelimiters, monitor);
            }

            @Override
            public int invalidProperties(List<? extends IChangePropertiesRequest> invalidPropertyChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                success[0] = false;
                return AutoResolveOperation.this.problemHandler.getChangePropertiesDilemmaHandler().invalidProperties(invalidPropertyChangeRequests, monitor);
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return AutoResolveOperation.this.problemHandler.getBackupDilemmaHandler();
            }
        };
        IChangePropertiesOperation op = null;
        IFileContent proposedContent = proposedItem.getContent();
        IFileContent commonAncestorContent = null;
        if (commonAncestorItem != null) {
            commonAncestorContent = commonAncestorItem.getContent();
        }
        progress.setWorkRemaining(100);
        String currentContentType = shareable.getContentType((IProgressMonitor)progress.newChild(10));
        String proposedContentType = proposedItem.getContentType();
        String commonAncestorContentType = "";
        if (commonAncestorItem != null) {
            commonAncestorContentType = commonAncestorItem.getContentType();
        }
        if (!commonAncestorContentType.equals(proposedContentType)) {
            if (currentContentType == null || currentContentType.equals(commonAncestorContentType)) {
                op = IOperationFactory.instance.getChangePropertiesOperation(changePropertiesDilemmaHandler);
                op.setContentType(shareable, proposedContentType);
            } else if (!currentContentType.equals(proposedContentType)) {
                success[0] = false;
            }
        }
        FileLineDelimiter currentLineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(10));
        FileLineDelimiter proposedLineDelimiter = proposedContent.getLineDelimiter();
        FileLineDelimiter commonAncestorLineDelimiter = null;
        if (commonAncestorContent != null) {
            commonAncestorLineDelimiter = commonAncestorContent.getLineDelimiter();
        }
        if (success[0] && commonAncestorLineDelimiter != proposedLineDelimiter) {
            if (currentLineDelimiter == null || currentLineDelimiter == commonAncestorLineDelimiter) {
                if (op == null) {
                    op = IOperationFactory.instance.getChangePropertiesOperation(changePropertiesDilemmaHandler);
                }
                op.setLineDelimiter(shareable, proposedLineDelimiter);
            } else if (currentLineDelimiter != proposedLineDelimiter) {
                success[0] = false;
            }
        }
        if (success[0] && op != null) {
            this.disableVerifyInSync(op);
            op.run((IProgressMonitor)progress.newChild(80));
        }
        return success[0];
    }

    @Override
    public void autoResolveConflict(IWorkspaceConnection connection, ILogicalConflictReport conflictReport, ILogicalChange logicalChange) {
        if (conflictReport == null) {
            throw new IllegalArgumentException();
        }
        if (logicalChange == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        IUpdateReport report = conflictReport.conflictReport();
        IItemConflictReport conflictFound = null;
        for (IItemConflictReport conflictedItem : report.conflicts()) {
            if (!conflictedItem.item().sameItemId((IItemHandle)logicalChange.item())) continue;
            conflictFound = conflictedItem;
            break;
        }
        if (conflictFound == null) {
            ++this.conflictsResolvedCount;
        } else {
            AutoResolveRequest request = new AutoResolveRequest(connection, conflictReport, logicalChange, conflictFound);
            if (this.isEvilTwinResolvable(request)) {
                this.addRequest(this.evilTwinConflicts, request);
            } else if (request.isContentConflict()) {
                this.addRequest(this.contentConflicts, request);
            } else if (request.isAutoMergeable()) {
                this.addRequest(this.autoMergeableConflicts, request);
            }
        }
    }

    private void addRequest(HashMap<UUID, HashMap<ILogicalConflictReport, List<AutoResolveRequest>>> requests, AutoResolveRequest request) {
        List<AutoResolveRequest> requestsForReport;
        IContextHandle context = request.getAffectedConfiguation().getConnectionHandle();
        HashMap<Object, List<AutoResolveRequest>> requestsForContext = requests.get(context.getItemId());
        if (requestsForContext == null) {
            requestsForContext = new HashMap();
            requests.put(context.getItemId(), requestsForContext);
            requestsForReport = new ArrayList<AutoResolveRequest>();
            requestsForContext.put(request.conflictReport, requestsForReport);
        } else {
            requestsForReport = requestsForContext.get(request.conflictReport);
            if (requestsForReport == null) {
                requestsForReport = new ArrayList<AutoResolveRequest>();
                requestsForContext.put(request.conflictReport, requestsForReport);
            }
        }
        requestsForReport.add(request);
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    public final class AutoResolveRequest {
        private final IItemConflictReport conflict;
        private final ILogicalChange logicalChange;
        private final ILogicalConflictReport conflictReport;
        private IWorkspaceConnection connection;
        private final ConfigurationFacade configurationDescriptor;
        private List<ILogicalChange> dependencyTree = null;

        public AutoResolveRequest(IWorkspaceConnection workspaceConnection, ILogicalConflictReport conflictReport, ILogicalChange logicalChange, IItemConflictReport conflict) {
            this.conflict = conflict;
            this.logicalChange = logicalChange;
            this.conflictReport = conflictReport;
            this.connection = workspaceConnection;
            this.configurationDescriptor = new ConfigurationFacade((IConnection)workspaceConnection, logicalChange.component());
        }

        public ConfigurationFacade getAffectedConfiguation() {
            return this.configurationDescriptor;
        }

        public IVersionableHandle getProposedContributorState() {
            return this.conflict.getProposedContributorState();
        }

        public IVersionableHandle getCommonAncestorState() {
            return this.conflict.getCommonAncestorState();
        }

        public IVersionableHandle getSelectedContributorState() {
            return this.conflict.getSelectedContributorState();
        }

        public boolean isContentConflict() {
            ILogicalConflict logicalConflict;
            int conflictType;
            return this.logicalChange != null && this.logicalChange.kind() == 1 && ((conflictType = (logicalConflict = (ILogicalConflict)this.logicalChange).conflictType()) == 1 || conflictType == 9);
        }

        public boolean isAutoMergeable() {
            return this.logicalChange != null && this.logicalChange.kind() == 2;
        }

        public List<ILogicalChange> computeFlattenedDependencies() {
            if (this.dependencyTree == null) {
                ArrayList<ILogicalChange> toReturn = new ArrayList<ILogicalChange>();
                LinkedList<ILogicalChange> depsToProcess = new LinkedList<ILogicalChange>();
                HashSet<UUID> seenUuids = new HashSet<UUID>();
                depsToProcess.addAll(this.conflictReport.getDependentChanges(this.logicalChange));
                while (depsToProcess.size() > 0) {
                    ILogicalChange current = (ILogicalChange)depsToProcess.removeFirst();
                    if (seenUuids.contains(current.item().getItemId())) continue;
                    if (!this.logicalChange.item().sameItemId((IItemHandle)current.item())) {
                        toReturn.add(current);
                    }
                    seenUuids.add(current.item().getItemId());
                    List deps = this.conflictReport.getDependentChanges(current);
                    toReturn.ensureCapacity(toReturn.size() + deps.size());
                    for (ILogicalChange change : deps) {
                        if (seenUuids.contains(change.item().getItemId())) continue;
                        depsToProcess.add(change);
                    }
                }
                this.dependencyTree = toReturn;
            }
            return this.dependencyTree;
        }
    }

    public final class AutoResolveState {
        boolean executableMerged = false;
        boolean propertiesMerged = false;
        boolean userPropertiesMerged = false;
        boolean contentMerged = false;
        boolean addMerged = false;
        ResourceType mergeType;

        public AutoResolveState(IVersionableHandle type) {
            this.mergeType = type instanceof IFileItemHandle ? ResourceType.FILE : (type instanceof IFolderHandle ? ResourceType.FOLDER : ResourceType.SYMBOLIC_LINK);
        }

        boolean isMerged() {
            if (this.mergeType == ResourceType.FILE) {
                return this.executableMerged && this.propertiesMerged && this.contentMerged && this.addMerged && this.userPropertiesMerged;
            }
            if (this.mergeType == ResourceType.SYMBOLIC_LINK) {
                return this.userPropertiesMerged && this.contentMerged && this.addMerged;
            }
            if (this.mergeType == ResourceType.FOLDER) {
                return this.userPropertiesMerged && this.addMerged;
            }
            return false;
        }
    }

    private static class DeferredReparentingOperands {
        ArrayList<IFolderHandle> oldParents = new ArrayList();
        ArrayList<IFolderHandle> newParents = new ArrayList();
        HashSet<UUID> doNotReparent = new HashSet();

        private DeferredReparentingOperands() {
        }

        public void add(IFolderHandle oldParent, IFolderHandle newParent) {
            this.oldParents.add(oldParent);
            this.newParents.add(newParent);
        }

        public void exclude(IVersionableHandle v) {
            this.doNotReparent.add(v.getItemId());
        }

        public void run(AutoResolveRequest req, ISandbox sandbox, ChangeSetChooser chooser, SubMonitor monitor) throws TeamRepositoryException {
            monitor.setWorkRemaining(3);
            monitor.beginTask("Adjusting parent hierarchy", 3);
            IWorkspaceConnection.IConfigurationOpFactory opFactory = req.connection.configurationOpFactory();
            IConfiguration config = req.connection.configuration(req.configurationDescriptor.getComponentHandle());
            List children = config.childEntries(this.oldParents, (IProgressMonitor)monitor.newChild(1));
            ArrayList toFetch = new ArrayList();
            for (Map family : children) {
                toFetch.addAll(family.values());
            }
            IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)req.connection.teamRepository());
            List fetched = manager.versionableManager().fetchCompleteStates(toFetch, (IProgressMonitor)monitor.newChild(1));
            HashMap<UUID, IVersionable> kids = new HashMap<UUID, IVersionable>(fetched.size());
            for (IVersionable v : fetched) {
                kids.put(v.getItemId(), v);
            }
            monitor.setWorkRemaining(this.oldParents.size());
            int i = 0;
            while (i < this.oldParents.size()) {
                IFolderHandle newParent = this.newParents.get(i);
                SubMonitor childMonitor = monitor.newChild(1);
                childMonitor.setWorkRemaining(kids.size());
                for (IVersionableHandle child : ((Map)children.get(i)).values()) {
                    if (this.doNotReparent.contains(child.getItemId())) continue;
                    IVersionable full = (IVersionable)kids.get(child.getItemId());
                    IVersionable workingCopy = (IVersionable)full.getWorkingCopy();
                    workingCopy.setParent(newParent);
                    IWorkspaceConnection.ISaveOp op = opFactory.save(workingCopy);
                    chooser.toCommit(req.configurationDescriptor.getComponentHandle(), child, (IWorkspaceConnection.IConfigurationOp)op, (IProgressMonitor)childMonitor.newChild(1));
                }
                childMonitor.done();
                ++i;
            }
        }
    }
}

