/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client;

public class ProxyHelper {
    protected static final String HTTP_PROTOCOL = "http:";
    protected static final String HTTPS_PROTOCOL = "https:";

    public static String getProxyHost(String repositoryAddress) {
        if (repositoryAddress.startsWith(HTTPS_PROTOCOL)) {
            return System.getProperty("https.proxyHost");
        }
        return System.getProperty("http.proxyHost");
    }

    public static String getProxyType(String repositoryAddress) {
        if (repositoryAddress.startsWith(HTTPS_PROTOCOL)) {
            return "https";
        }
        if (repositoryAddress.startsWith(HTTP_PROTOCOL)) {
            return "http";
        }
        return null;
    }

    public static int getProxyPort(String repositoryAddress) {
        int port = 0;
        String portString = null;
        portString = repositoryAddress.startsWith(HTTPS_PROTOCOL) ? System.getProperty("https.proxyPort", "443") : System.getProperty("http.proxyPort", "80");
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException numberFormatException) {}
        return port;
    }

    public static String getProxyUser(String repositoryAddress, String defaultUsername) {
        String proxyUser = defaultUsername;
        String propertyKey = "https.proxyUser";
        if (repositoryAddress.startsWith(HTTP_PROTOCOL)) {
            propertyKey = "http.proxyUser";
        }
        if ((proxyUser = defaultUsername != null ? System.getProperty(propertyKey, defaultUsername) : System.getProperty(propertyKey)) != null && proxyUser.length() == 0) {
            proxyUser = null;
        }
        return proxyUser;
    }

    public static String getProxyPassword(String repositoryAddress, String defaultPassword) {
        String proxyPassword = defaultPassword;
        String propertyKey = "https.proxyPassword";
        if (repositoryAddress.startsWith(HTTP_PROTOCOL)) {
            propertyKey = "http.proxyPassword";
        }
        if ((proxyPassword = defaultPassword != null ? System.getProperty(propertyKey, defaultPassword) : System.getProperty(propertyKey)) != null && proxyPassword.length() == 0) {
            proxyPassword = null;
        }
        return proxyPassword;
    }
}

