/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.rest;

import java.text.MessageFormat;

public class InteropClientException
extends Exception {
    private static final long serialVersionUID = -8985643912400025395L;
    private static final String messageFormat = "{0}\nStack Trace:\n{1}\n";

    public InteropClientException() {
    }

    public InteropClientException(String message) {
        super(message);
    }

    public InteropClientException(Throwable cause) {
        super(cause);
    }

    public InteropClientException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getCompleteMessage() {
        StringBuffer buf = new StringBuffer();
        InteropClientException.getCompleteMessage(this, buf, 0);
        return buf.toString();
    }

    private static void getCompleteMessage(Throwable ex, StringBuffer buf, int indent) {
        int i = 0;
        while (i < indent) {
            buf.append(' ');
            ++i;
        }
        buf.append(MessageFormat.format(messageFormat, ex.getMessage(), InteropClientException.stackTraceToString(ex, indent)));
        Throwable cause = ex.getCause();
        if (cause != null) {
            InteropClientException.getCompleteMessage(cause, buf, indent + 4);
        }
    }

    private static String stackTraceToString(Throwable ex, int indent) {
        if (ex.getStackTrace() == null) {
            return new String();
        }
        StringBuffer buf = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = ex.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement elem = stackTraceElementArray[n2];
            int i = 0;
            while (i < indent) {
                buf.append(' ');
                ++i;
            }
            buf.append(MessageFormat.format("{0}\n", elem.toString()));
            ++n2;
        }
        return buf.toString();
    }
}

