/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Enumeration<T extends ILiteral>
implements IEnumeration<T> {
    private List<T> fLiterals;
    private T fDefaultLiteral;
    private T fNullLiteral;
    private boolean fIsPersisted;

    public Enumeration(List<T> literals, boolean isPersisted) {
        this.fLiterals = Collections.unmodifiableList(literals);
        this.fIsPersisted = isPersisted;
        for (ILiteral literal : this.fLiterals) {
            if (!((ConfigurationItem)literal).isDefault()) continue;
            this.fDefaultLiteral = literal;
            break;
        }
        for (ILiteral literal : this.fLiterals) {
            if (!((ConfigurationItem)literal).isNull()) continue;
            this.fNullLiteral = literal;
            break;
        }
    }

    @Override
    public T findEnumerationLiteral(Identifier<? extends ILiteral> identifier) {
        return this.findEnumerationLiteral(identifier, true);
    }

    @Override
    public T findEnumerationLiteral(Identifier<? extends ILiteral> identifier, boolean includeArchived) {
        for (ILiteral literal : this.fLiterals) {
            if (!includeArchived && ((ConfigurationItem)literal).isArchived() || !literal.getIdentifier2().equals(identifier)) continue;
            return (T)literal;
        }
        return null;
    }

    @Override
    public List<T> getEnumerationLiterals() {
        return this.getEnumerationLiterals(true);
    }

    @Override
    public List<T> getEnumerationLiterals(boolean includeArchived) {
        if (includeArchived) {
            return this.fLiterals;
        }
        ArrayList<ILiteral> nonArchivedLiterals = new ArrayList<ILiteral>(this.fLiterals.size());
        for (ILiteral literal : this.fLiterals) {
            if (((ConfigurationItem)literal).isArchived()) continue;
            nonArchivedLiterals.add(literal);
        }
        return nonArchivedLiterals;
    }

    @Override
    public T findDefaultEnumerationLiteral() {
        return this.fDefaultLiteral;
    }

    @Override
    public T findNullEnumerationLiteral() {
        return this.fNullLiteral;
    }

    @Override
    public boolean isPersisted() {
        return this.fIsPersisted;
    }
}

