/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QueryableReferenceAttribute
extends QueryableAttribute {
    public static final String ITEM_REF_ATTR_ID = "referencedItem";
    public static final String URI_REF_ATTR_ID = "uri";
    public static final String COMMENT_ATTR_ID = "comment";
    private final IEndPointDescriptor fEndPoint;
    private final IQueryableAttribute fReferenceAttribute;

    public QueryableReferenceAttribute(QueryableAttributeDescriptor descriptor, IEndPointDescriptor endPoint) {
        super(descriptor);
        this.fEndPoint = endPoint;
        this.fReferenceAttribute = this.fEndPoint.isItemReference() ? new QueryableAttribute(new QueryableAttributeDescriptor(ITEM_REF_ATTR_ID, "", "item")) : new QueryableAttribute(new QueryableAttributeDescriptor(URI_REF_ATTR_ID, "", "smallString"));
    }

    @Override
    public List<IQueryableAttribute> getChildAttributes() {
        ArrayList<IQueryableAttribute> childAttributes = new ArrayList<IQueryableAttribute>(super.getChildAttributes());
        return Collections.unmodifiableList(this.removeReferenceAttribute(childAttributes));
    }

    @Override
    public IQueryableAttribute getChildAttribute(String identifier) {
        if (this.fEndPoint.isItemReference() ? ITEM_REF_ATTR_ID.equals(identifier) : URI_REF_ATTR_ID.equals(identifier)) {
            return null;
        }
        return super.getChildAttribute(identifier);
    }

    @Override
    public void setChildAttributes(List<IQueryableAttribute> childAttributes) {
        List<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>(childAttributes);
        attributes = this.removeReferenceAttribute(attributes);
        attributes.add(this.fReferenceAttribute);
        super.setChildAttributes(Collections.unmodifiableList(attributes));
    }

    private List<IQueryableAttribute> removeReferenceAttribute(List<IQueryableAttribute> childAttributes) {
        ArrayList<IQueryableAttribute> attributes = new ArrayList<IQueryableAttribute>();
        for (IQueryableAttribute child : childAttributes) {
            if (this.fEndPoint.isItemReference()) {
                if (ITEM_REF_ATTR_ID.equals(child.getIdentifier())) continue;
                attributes.add(child);
                continue;
            }
            if (URI_REF_ATTR_ID.equals(child.getIdentifier())) continue;
            attributes.add(child);
        }
        return attributes;
    }

    public IQueryableAttribute getReferenceAttribute() {
        return this.fReferenceAttribute;
    }
}

