/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Attribute;
import com.ibm.team.workitem.common.model.IAttribute;

public class AttributeBuilder
extends AbstractArtifactBuilder<IAttribute> {
    protected static final ValueKey<String> IDENTIFIER = new ValueKey(String.valueOf(AttributeBuilder.class.getName()) + ".identifier");
    protected static final ValueKey<String> DISPLAY_NAME = new ValueKey(String.valueOf(AttributeBuilder.class.getName()) + ".displayName");
    protected static final ValueKey<String> ATTRIBUTE_TYPE = new ValueKey(String.valueOf(AttributeBuilder.class.getName()) + ".type");
    protected static final ValueKey<IProjectAreaHandle> PROJECT_AREA = new ValueKey(String.valueOf(AttributeBuilder.class.getName()) + ".projectArea");
    protected static final ValueKey<Object> ORIGIN = new ValueKey(String.valueOf(AttributeBuilder.class.getName()) + ".origin");
    protected static final ValueKey<Boolean> ARCHIVED = new ValueKey(String.valueOf(AttributeBuilder.class.getName()) + ".archived");
    protected static final ValueKey<Boolean> BUILT_IN = new ValueKey(String.valueOf(AttributeBuilder.class.getName()) + ".builtIn");
    protected static final ValueKey<Boolean> INTERNAL = new ValueKey(String.valueOf(AttributeBuilder.class.getName()) + ".internal");

    public AttributeBuilder(IArtifactBuilderContext context) {
        super(context);
    }

    public AttributeBuilder projectArea(IProjectAreaHandle projectArea) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        if (!this.isBuilderValueSet(ORIGIN)) {
            this.origin(projectArea);
        }
        return this;
    }

    public AttributeBuilder origin(Object origin) {
        this.setBuilderValue(ORIGIN, origin);
        return this;
    }

    public AttributeBuilder identifier(String identifier) {
        this.setBuilderValue(IDENTIFIER, identifier);
        return this;
    }

    public AttributeBuilder displayName(String displayName) {
        this.setBuilderValue(DISPLAY_NAME, displayName);
        return this;
    }

    public AttributeBuilder attributeType(String type) {
        this.setBuilderValue(ATTRIBUTE_TYPE, type);
        return this;
    }

    public AttributeBuilder archived(boolean archived) {
        this.setBuilderValue(ARCHIVED, archived);
        return this;
    }

    public AttributeBuilder builtIn(boolean builtIn) {
        this.setBuilderValue(BUILT_IN, builtIn);
        return this;
    }

    public AttributeBuilder internal(boolean internal) {
        this.setBuilderValue(INTERNAL, internal);
        return this;
    }

    protected IAttribute doBuild(BuildContext buildContext) {
        Attribute attribute = (Attribute)this.artifact(IAttribute.ITEM_TYPE);
        attribute.setProjectArea((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA, buildContext.isPropertySet(BuildContext.PROJECT_AREA) ? (IProjectAreaHandle)buildContext.getProperty(BuildContext.PROJECT_AREA) : attribute.getProjectArea()));
        attribute.setOrigin(this.getBuilderValue(ORIGIN, buildContext.isPropertySet(BuildContext.PROJECT_AREA) ? buildContext.getProperty(BuildContext.PROJECT_AREA) : attribute.getOrigin()));
        attribute.setDisplayName((String)this.chooseValue(DISPLAY_NAME, attribute.getDisplayName(), "Test Attribute"));
        attribute.setIdentifier((String)this.chooseValue(IDENTIFIER, attribute.getIdentifier(), "test-attribute-" + UUID.generate().getUuidValue()));
        attribute.setAttributeType((String)this.chooseValue(ATTRIBUTE_TYPE, attribute.getAttributeType()));
        attribute.setArchived((Boolean)this.chooseValue(ARCHIVED, attribute.isArchived()));
        attribute.setBuiltIn((Boolean)this.chooseValue(BUILT_IN, attribute.isBuiltIn()));
        attribute.setInternal((Boolean)this.chooseValue(INTERNAL, attribute.isInternal()));
        return attribute;
    }

    protected IAttribute doSave(BuildContext saveContext) throws TeamRepositoryException {
        IAttribute attribute;
        if (!(this.artifactExists() || this.isBuilderValueSet(PROJECT_AREA) || saveContext.isPropertySet(BuildContext.PROJECT_AREA))) {
            throw new IllegalStateException("Cannot create an attribute without setting the project area via projectArea() call or saveContext");
        }
        IWorkItemCommon workItemCommon = (IWorkItemCommon)this.getContext().getLibrary(IWorkItemCommon.class);
        IAuditableCommon auditableCommon = (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class);
        if (this.artifactExists()) {
            attribute = this.doBuild(saveContext);
            workItemCommon.saveAttribute(attribute, null);
        } else {
            attribute = workItemCommon.createAttribute((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA), (String)this.getBuilderValue(IDENTIFIER), (String)this.getBuilderValue(ATTRIBUTE_TYPE), (String)this.getBuilderValue(DISPLAY_NAME), null);
        }
        return auditableCommon.resolveAuditable(attribute, IAttribute.FULL_PROFILE, null);
    }
}

