/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Deliverable;
import com.ibm.team.workitem.common.model.IDeliverable;
import java.sql.Timestamp;

public class DeliverableBuilder
extends AbstractArtifactBuilder<IDeliverable> {
    protected static final ValueKey<IProjectAreaHandle> PROJECT_AREA = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".projectArea");
    protected static final ValueKey<String> NAME = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".displayName");
    protected static final ValueKey<XMLString> DESCRIPTION = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".description");
    protected static final ValueKey<UUID> CONTEXT_ID = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".contextId");
    protected static final ValueKey<UUID> STATE_ID = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".stateId");
    protected static final ValueKey<Timestamp> CREATION_DATE = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".creationDate");
    protected static final ValueKey<Boolean> ARCHIVED = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".archived");
    protected static final ValueKey<Boolean> FILTERED = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".filtered");
    protected static final ValueKey<Integer> SEQUENCE_VALUE = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".sequenceValue");
    protected static final ValueKey<IIterationHandle> ITERATION = new ValueKey(String.valueOf(DeliverableBuilder.class.getName()) + ".iteration");

    public DeliverableBuilder(IArtifactBuilderContext context) {
        super(context);
    }

    public DeliverableBuilder contextId(UUID contextId) {
        this.setBuilderValue(CONTEXT_ID, contextId);
        return this;
    }

    public DeliverableBuilder stateId(UUID stateId) {
        this.setBuilderValue(STATE_ID, stateId);
        return this;
    }

    public DeliverableBuilder projectArea(IProjectAreaHandle projectArea) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        return this;
    }

    public DeliverableBuilder iteration(IIterationHandle iterationHandle) {
        this.setBuilderValue(ITERATION, iterationHandle);
        return this;
    }

    public DeliverableBuilder name(String name) {
        this.setBuilderValue(NAME, name);
        return this;
    }

    public DeliverableBuilder description(String description) {
        return this.description(XMLString.createFromPlainText((String)description));
    }

    public DeliverableBuilder description(XMLString description) {
        this.setBuilderValue(DESCRIPTION, description);
        return this;
    }

    public DeliverableBuilder archived(boolean archived) {
        this.setBuilderValue(ARCHIVED, archived);
        return this;
    }

    public DeliverableBuilder filtered(boolean filtered) {
        this.setBuilderValue(FILTERED, filtered);
        return this;
    }

    public DeliverableBuilder sequenceValue(int sequenceValue) {
        this.setBuilderValue(SEQUENCE_VALUE, sequenceValue);
        return this;
    }

    public DeliverableBuilder creationDate(Timestamp creationDate) {
        this.setBuilderValue(CREATION_DATE, creationDate);
        return this;
    }

    protected IDeliverable doBuild(BuildContext buildContext) {
        Deliverable deliverable = (Deliverable)this.artifact(IDeliverable.ITEM_TYPE);
        deliverable.setProjectArea((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA, deliverable.getProjectArea()));
        deliverable.setContextId((UUID)this.getBuilderValue(CONTEXT_ID, deliverable.getContextId()));
        deliverable.setStateId((UUID)this.chooseValue(STATE_ID, deliverable.getStateId(), UUID.generate()));
        return this.setDeliverableFields(deliverable);
    }

    protected IDeliverable doSave(BuildContext saveContext) throws TeamRepositoryException {
        if (!(this.artifactExists() || this.isBuilderValueSet(PROJECT_AREA) || saveContext.isPropertySet(BuildContext.PROJECT_AREA))) {
            throw new IllegalStateException("Cannot create a deliverable without setting the project area via projectArea() call or the saveContext");
        }
        if (this.isBuilderValueSet(STATE_ID)) {
            throw new IllegalArgumentException("Cannot specify stateId when item is saved in repository.");
        }
        IAuditableCommon auditableCommon = (IAuditableCommon)this.getContext().getLibrary(IAuditableCommon.class);
        IWorkItemCommon workItemCommon = (IWorkItemCommon)this.getContext().getLibrary(IWorkItemCommon.class);
        IDeliverable deliverable = this.artifactExists() ? (IDeliverable)this.artifact(IDeliverable.ITEM_TYPE) : workItemCommon.createDeliverable((IProjectAreaHandle)this.getBuilderValue(PROJECT_AREA, (IProjectAreaHandle)saveContext.getProperty(BuildContext.PROJECT_AREA)), (String)this.getBuilderValue(NAME, "Deliverable " + UUID.generate().getUuidValue()), null);
        workItemCommon.saveDeliverable(this.setDeliverableFields((Deliverable)deliverable), null);
        return auditableCommon.resolveAuditable(deliverable, IDeliverable.FULL_PROFILE, null);
    }

    protected IDeliverable setDeliverableFields(Deliverable deliverable) {
        deliverable.setName((String)this.chooseValue(NAME, deliverable.getName(), "Deliverable " + UUID.generate()));
        deliverable.setHTMLDescription((XMLString)this.chooseValue(DESCRIPTION, deliverable.getHTMLDescription(), XMLString.createFromPlainText((String)"some description")));
        deliverable.setArchived((Boolean)this.chooseValue(ARCHIVED, deliverable.isArchived(), false));
        deliverable.setFiltered((Boolean)this.chooseValue(FILTERED, deliverable.isFiltered(), false));
        deliverable.setCreationDate((Timestamp)this.chooseValue(CREATION_DATE, deliverable.getCreationDate(), null));
        deliverable.setSequenceValue((Integer)this.chooseValue(SEQUENCE_VALUE, deliverable.getSequenceValue(), -1));
        deliverable.setIteration((IIterationHandle)this.getBuilderValue(ITERATION, deliverable.getIteration()));
        deliverable.setStateId((UUID)this.chooseValue(STATE_ID, deliverable.getStateId(), UUID.generate()));
        return deliverable;
    }
}

