/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.internal.dto2.CurrentPatchOperationDescriptor;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;

public interface ICurrentPatchOperationDescriptor {
    public static final int NONE = 0;
    public static final int FORCE = 1;
    public static final int BEST_EFFORT = 2;
    public static final int CHANGE_DETAIL_TYPE = 2;
    public static final int RESOLVE_WITH_PROPOSED = 1;
    public static final int MARK_AS_RESOLVED = 2;
    public static final int MARK_AS_UNRESOLVED = 3;
    public static final int AUTO_RESOLVE = 4;
    public static final int UNDO_CHANGE = 5;
    public static final int REPARENT_VERSIONABLE = 6;
    public static final ICurrentPatchOperationDescriptorFactory FACTORY = new ICurrentPatchOperationDescriptorFactory(){

        private ICurrentPatchOperationDescriptor create(int kind, int flags, UUID versionableChangeId, UUID changeDetailId) {
            if (versionableChangeId == null) {
                throw new IllegalArgumentException();
            }
            if (kind < 1 || kind > 6) {
                throw new IllegalArgumentException();
            }
            CurrentPatchOperationDescriptor result = ScmDto2Factory.eINSTANCE.createCurrentPatchOperationDescriptor();
            result.setKind(kind);
            result.setChangeId(versionableChangeId);
            result.setChangeDetailId(changeDetailId);
            result.setFlags(flags);
            return result;
        }

        @Override
        public ICurrentPatchOperationDescriptor resolveWithProposed(UUID versionableChangeId, boolean force) {
            return this.create(1, force ? 1 : 0, versionableChangeId, null);
        }

        @Override
        public ICurrentPatchOperationDescriptor resolveWithProposed(UUID versionableChangeId, UUID changeDetailId, boolean force) {
            return this.create(1, force ? 1 : 0, versionableChangeId, changeDetailId);
        }

        @Override
        public ICurrentPatchOperationDescriptor markAsResolved(UUID versionableChangeId, boolean force) {
            return this.create(2, force ? 1 : 0, versionableChangeId, null);
        }

        @Override
        public ICurrentPatchOperationDescriptor markAsResolved(UUID versionableChangeId, UUID changeDetailId, boolean force) {
            return this.create(2, force ? 1 : 0, versionableChangeId, changeDetailId);
        }

        @Override
        public ICurrentPatchOperationDescriptor autoResolve(UUID versionableChangeId, UUID changeDetailId, boolean bestEffort) {
            return this.create(4, bestEffort ? 2 : 0, versionableChangeId, changeDetailId);
        }

        @Override
        public ICurrentPatchOperationDescriptor autoResolve(UUID versionableChangeId, boolean bestEffort) {
            return this.create(4, bestEffort ? 2 : 0, versionableChangeId, null);
        }

        @Override
        public ICurrentPatchOperationDescriptor undo(UUID versionableChangeId, boolean force) {
            return this.create(5, force ? 1 : 0, versionableChangeId, null);
        }

        @Override
        public ICurrentPatchOperationDescriptor undo(UUID versionableChangeId, UUID changeDetailId, boolean force) {
            return this.create(5, force ? 1 : 0, versionableChangeId, changeDetailId);
        }

        @Override
        public ICurrentPatchOperationDescriptor markAsUnresolved(UUID versionableChangeId) {
            return this.create(3, 0, versionableChangeId, null);
        }

        @Override
        public ICurrentPatchOperationDescriptor markAsUnresolved(UUID versionableChangeId, UUID changeDetailId) {
            return this.create(3, 0, versionableChangeId, changeDetailId);
        }

        @Override
        public ICurrentPatchOperationDescriptor setParent(UUID versionableId, IFolderHandle folder) {
            return this.create(6, 0, versionableId, folder.getItemId());
        }
    };

    public int getKind();

    public UUID getChangeId();

    public UUID getChangeDetailId();

    public boolean isForce();

    public int getFlags();

    public static interface ICurrentPatchOperationDescriptorFactory {
        public ICurrentPatchOperationDescriptor autoResolve(UUID var1, boolean var2);

        public ICurrentPatchOperationDescriptor autoResolve(UUID var1, UUID var2, boolean var3);

        public ICurrentPatchOperationDescriptor resolveWithProposed(UUID var1, boolean var2);

        public ICurrentPatchOperationDescriptor resolveWithProposed(UUID var1, UUID var2, boolean var3);

        public ICurrentPatchOperationDescriptor markAsResolved(UUID var1, boolean var2);

        public ICurrentPatchOperationDescriptor markAsResolved(UUID var1, UUID var2, boolean var3);

        public ICurrentPatchOperationDescriptor markAsUnresolved(UUID var1);

        public ICurrentPatchOperationDescriptor markAsUnresolved(UUID var1, UUID var2);

        public ICurrentPatchOperationDescriptor undo(UUID var1, boolean var2);

        public ICurrentPatchOperationDescriptor undo(UUID var1, UUID var2, boolean var3);

        public ICurrentPatchOperationDescriptor setParent(UUID var1, IFolderHandle var2);
    }
}

