/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.web.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.air.property.web.param.PropSheetParam;
import com.urbancode.air.property.web.rest.PropSheetDefResource;
import com.urbancode.air.property.web.rest.PropValueResource;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.webext.exception.UIException;
import com.urbancode.commons.webext.util.AbstractResource;
import com.urbancode.commons.webext.util.JSONOutputType;
import com.urbancode.commons.webext.util.JSONUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="propSheet")
public class PropSheetResource
extends AbstractResource<PropSheet> {
    public static final String HTTP_SELECT_LABEL = "HTTP_SELECT_LABEL";
    private static PropSheetResource instance = new PropSheetResource();

    public static PropSheetResource getInstance() {
        return instance;
    }

    protected JSONObject getBasicJSON(PropSheet propSheet) throws Exception {
        JSONObject result = new JSONObject();
        result.put("id", (Object)propSheet.getId());
        result.put("name", (Object)propSheet.getName());
        if (propSheet.isVersioned()) {
            result.put("path", (Object)propSheet.getPersistenceData().getPath());
            result.put("version", propSheet.getPersistenceData().getRelativeVersion());
            result.put("versionCount", propSheet.getPersistenceData().getVersionCount());
            result.put("commit", propSheet.getPersistenceData().getCommit());
            result.put("versioned", true);
        } else {
            result.put("versioned", false);
        }
        return result;
    }

    protected JSONObject getLinkedJSON(PropSheet propSheet) throws Exception {
        JSONObject result = new JSONObject();
        result.put("propSheetDef", (Object)PropSheetDefResource.getInstance().toJSON((Object)propSheet.getPropSheetDef(), new JSONOutputType[0]));
        return result;
    }

    protected JSONObject getExtendedJSON(PropSheet propSheet) throws Exception {
        JSONObject result = new JSONObject();
        result.put("properties", (Object)this.getPropSheetPropValues(new PropSheetParam(propSheet)));
        return result;
    }

    protected JSONObject getExportJSON(PropSheet propSheet) throws Exception {
        JSONObject result = new JSONObject();
        result.put("name", (Object)propSheet.getName());
        result.put("properties", (Object)PropValueResource.getInstance().toJSON(propSheet.getDirectPropValueList(), new JSONOutputType[]{JSONOutputType.EXPORT}));
        return result;
    }

    @GET
    @Path(value="/{propSheet}")
    @Produces(value={"application/json"})
    public JSONObject getPropSheet(@PathParam(value="propSheet") PropSheetParam propSheetParam) throws Exception {
        PropSheet propSheet = (PropSheet)((Object)propSheetParam.getValue());
        return this.toJSON((Object)propSheet, new JSONOutputType[]{JSONOutputType.ALL});
    }

    @PUT
    @Path(value="{propSheet}/propValues")
    @Produces(value={"application/json"})
    public Response createPropValue(@PathParam(value="propSheet") PropSheetParam propSheetParam, @HeaderParam(value="version") int version, String input) throws Exception {
        Response response;
        PropSheet propSheet = (PropSheet)((Object)propSheetParam.getValue());
        if (!this.isCurrentVersion(propSheet, version)) {
            response = Response.status((Response.StatusType)ClientResponse.Status.CONFLICT).build();
        } else {
            JSONObject submittedJson = new JSONObject(input);
            response = Response.ok((Object)this.createPropValue(propSheetParam, submittedJson)).build();
        }
        return response;
    }

    public JSONObject createPropValue(PropSheetParam propSheetParam, JSONObject submittedJson) throws Exception {
        PropSheet propSheet = (PropSheet)((Object)propSheetParam.getValue());
        String name = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"name");
        name = name.trim();
        PropValue propValue = new PropValue(name, "");
        propSheet.addPropValue(propValue);
        PropValueResource.getInstance().setValuesFromJSON(propValue, submittedJson);
        return PropValueResource.getInstance().toJSON(propValue, new JSONOutputType[0]);
    }

    @GET
    @Path(value="/{propSheet}/propValues")
    @Produces(value={"application/json"})
    public JSONArray getPropSheetPropValues(@PathParam(value="propSheet") PropSheetParam propSheetParam) throws Exception {
        PropSheet propSheet = (PropSheet)((Object)propSheetParam.getValue());
        JSONArray result = new JSONArray();
        List<PropValue> directPropValueList = propSheet.getDirectPropValueList();
        for (PropValue propValue : propSheet.getPropValueList()) {
            JSONObject propValueJson = PropValueResource.getInstance().toJSON(propValue, new JSONOutputType[0]);
            if (directPropValueList.contains(propValue)) {
                propValueJson.put("inherited", false);
            } else {
                propValueJson.put("inherited", true);
            }
            result.put((Object)propValueJson);
        }
        return result;
    }

    @GET
    @Path(value="{propSheet}/compare/{otherPropSheet}")
    @Produces(value={"application/json"})
    public JSONArray getPropSheetPropValues(@PathParam(value="propSheet") String propSheetParamString, @PathParam(value="otherPropSheet") String otherPropSheetParamString) throws Exception {
        PropSheet propSheet = null;
        try {
            propSheet = (PropSheet)((Object)new PropSheetParam(propSheetParamString).getValue());
        }
        catch (WebApplicationException e) {
            // empty catch block
        }
        PropSheet otherPropSheet = null;
        try {
            otherPropSheet = (PropSheet)((Object)new PropSheetParam(otherPropSheetParamString).getValue());
        }
        catch (WebApplicationException e) {
            // empty catch block
        }
        JSONArray result = new JSONArray();
        ArrayList<String> allPropertyNames = new ArrayList<String>();
        if (propSheet != null) {
            for (PropValue propValue : propSheet.getPropValueList()) {
                allPropertyNames.add(propValue.getName());
            }
        }
        if (otherPropSheet != null) {
            for (PropValue propValue : otherPropSheet.getPropValueList()) {
                if (allPropertyNames.contains(propValue.getName())) continue;
                allPropertyNames.add(propValue.getName());
            }
        }
        Collections.sort(allPropertyNames);
        for (String propertyName : allPropertyNames) {
            String otherPropValue;
            String value = propSheet == null ? null : propSheet.getPropValue(propertyName);
            if (StringUtils.equals((String)value, (String)(otherPropValue = otherPropSheet == null ? null : otherPropSheet.getPropValue(propertyName)))) continue;
            JSONObject propertyJson = new JSONObject();
            propertyJson.put("name", (Object)propertyName);
            if (propSheet != null) {
                propertyJson.put("value", (Object)PropValueResource.getInstance().toJSON(propSheet.getPropValueObject(propertyName), new JSONOutputType[0]));
            }
            if (otherPropSheet != null) {
                propertyJson.put("otherValue", (Object)PropValueResource.getInstance().toJSON(otherPropSheet.getPropValueObject(propertyName), new JSONOutputType[0]));
            }
            result.put((Object)propertyJson);
        }
        return result;
    }

    public JSONArray getPropValues(PropSheet propSheet) throws Exception {
        JSONArray result = new JSONArray();
        for (PropValue propValue : propSheet.getPropValueList()) {
            result.put((Object)PropValueResource.getInstance().toJSON(propValue, new JSONOutputType[]{JSONOutputType.BASIC}));
        }
        return result;
    }

    @PUT
    @Path(value="{propSheet}/propValues/{propName}")
    @Produces(value={"application/json"})
    public Response updatePropValue(@PathParam(value="propSheet") PropSheetParam propSheetParam, @PathParam(value="propName") String propName, @HeaderParam(value="version") int version, String input) throws Exception {
        Response response;
        PropSheet propSheet = (PropSheet)((Object)propSheetParam.getValue());
        if (!this.isCurrentVersion(propSheet, version)) {
            response = Response.status((Response.StatusType)ClientResponse.Status.CONFLICT).build();
        } else {
            JSONObject submittedJson = new JSONObject(input);
            response = Response.ok((Object)this.updatePropValue(propSheetParam, propName, submittedJson)).build();
        }
        return response;
    }

    public JSONObject updatePropValue(PropSheetParam propSheetParam, String propName, JSONObject submittedJson) throws UIException, Exception {
        PropSheet propSheet = (PropSheet)((Object)propSheetParam.getValue());
        PropValue propValue = propSheet.getPropValueObject(propName);
        if (propValue == null) {
            throw new TranslatableException("No property value named '%s' was found to update.", new Object[]{propName});
        }
        PropValueResource.getInstance().setValuesFromJSON(propValue, submittedJson);
        return PropValueResource.getInstance().toJSON(propValue, new JSONOutputType[0]);
    }

    @PUT
    @Path(value="/{propSheet}/allPropValues")
    public Response updateAllPropValues(@PathParam(value="propSheet") PropSheetParam propSheetParam, @HeaderParam(value="version") int version, String input) throws Exception {
        Response response;
        PropSheet propSheet = (PropSheet)((Object)propSheetParam.getValue());
        if (!this.isCurrentVersion(propSheet, version)) {
            response = Response.status((Response.StatusType)ClientResponse.Status.CONFLICT).build();
        } else {
            JSONObject submittedJson = new JSONObject(input);
            this.setPropSheetValuesFromJson(propSheet, submittedJson);
            response = Response.status((Response.StatusType)ClientResponse.Status.OK).build();
        }
        return response;
    }

    public void setTemplateBasedPropSheetValuesFromJson(PropSheet propSheet, PropSheetDef templatePropSheetDef, JSONObject submittedJson) {
        String templatePropSheetName = propSheet.getName();
        if (templatePropSheetDef != null) {
            for (PropDef propDef : templatePropSheetDef.getPropDefList()) {
                String propName = propDef.getName();
                String value = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)(templatePropSheetName + "/" + propName));
                if (value == null) {
                    value = propDef.getDefaultValue();
                }
                PropValue propValue = propSheet.setPropValue(propName, value);
                if (!propDef.getType().isHttpBased()) continue;
                String httpSelectLabel = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)(templatePropSheetName + "/" + propName + "/" + HTTP_SELECT_LABEL));
                propValue.setLabel(httpSelectLabel);
            }
        }
    }

    public void setPropSheetValuesFromJson(PropSheet propSheet, JSONObject submittedJson) {
        PropSheetDef propSheetDef = propSheet.getPropSheetDef();
        if (propSheetDef != null) {
            for (PropDef propDef : propSheetDef.getPropDefList()) {
                String name = propDef.getName();
                String value = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)name);
                PropValue propValue = propSheet.setPropValue(name, value);
                if (!propDef.getType().isHttpBased()) continue;
                String httpSelectLabel = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)(name + "/" + HTTP_SELECT_LABEL));
                propValue.setLabel(httpSelectLabel);
            }
        } else {
            Iterator keys = submittedJson.keys();
            while (keys.hasNext()) {
                String name = (String)keys.next();
                String value = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)name);
                PropValue propValue = propSheet.setPropValue(name, value);
                String httpSelectLabel = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)(name + "/" + HTTP_SELECT_LABEL));
                propValue.setLabel(httpSelectLabel);
            }
        }
    }

    @PUT
    @Path(value="/{propSheet}/allPropValuesFromBatch")
    public Response updateAllPropValuesFromBatch(@PathParam(value="propSheet") PropSheetParam propSheetParam, @HeaderParam(value="version") int version, String input) throws Exception {
        Response response;
        PropSheet propSheet = (PropSheet)((Object)propSheetParam.getValue());
        if (!this.isCurrentVersion(propSheet, version)) {
            response = Response.status((Response.StatusType)ClientResponse.Status.CONFLICT).build();
        } else {
            JSONObject submittedJson = new JSONObject(input);
            String batchContent = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"properties");
            Properties properties = new Properties();
            properties.load(IO.reader((String)batchContent));
            PropSheetDef propSheetDef = propSheet.getPropSheetDef();
            if (propSheetDef != null) {
                for (PropDef propDef : propSheetDef.getPropDefList()) {
                    String name = propDef.getName();
                    String value = properties.getProperty(name);
                    name = this.sanitizePropNames(name);
                    value = this.sanitizePropValues(value);
                    propSheet.setPropValue(name, value);
                }
            } else {
                for (PropValue propValue : propSheet.getPropValueList()) {
                    if (properties.containsKey(propValue.getName())) continue;
                    propSheet.removePropValue(propValue);
                }
                Enumeration<?> e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    String value = properties.getProperty(name);
                    name = this.sanitizePropNames(name);
                    value = this.sanitizePropValues(value);
                    propSheet.setPropValue(name, value);
                }
            }
            response = Response.status((Response.StatusType)ClientResponse.Status.OK).build();
        }
        return response;
    }

    @DELETE
    @Path(value="/{propSheet}/propValues/{propName}")
    @Produces(value={"application/json"})
    public Response deletePropValue(@PathParam(value="propSheet") PropSheetParam propSheetParam, @PathParam(value="propName") String propName, @HeaderParam(value="version") int version) throws Exception {
        Response response;
        PropSheet propSheet = (PropSheet)((Object)propSheetParam.getValue());
        if (!this.isCurrentVersion(propSheet, version)) {
            response = Response.status((Response.StatusType)ClientResponse.Status.CONFLICT).build();
        } else {
            PropValue propValue = propSheet.getPropValueObject(propName);
            propSheet.removePropValue(propValue);
            response = Response.status((Response.StatusType)ClientResponse.Status.OK).build();
        }
        return response;
    }

    @Deprecated
    public void importProperties(PropSheet propSheet, JSONArray propJson, boolean isUpgrade) throws Exception {
        this.importProperties(propSheet, propJson);
    }

    public void importProperties(PropSheet propSheet, JSONArray propJson) throws Exception {
        this.importProperties(propSheet, propJson, new ArrayList<String>());
    }

    @Deprecated
    public void importProperties(PropSheet propSheet, JSONArray propJson, boolean isUpgrade, List<String> excludes) throws Exception {
        this.importProperties(propSheet, propJson, excludes);
    }

    public void importProperties(PropSheet propSheet, JSONArray propJson, List<String> excludes) throws Exception {
        for (PropValue propVal : propSheet.getDirectPropValueList()) {
            if (excludes.contains(propVal.getName())) continue;
            propSheet.removePropValue(propVal);
        }
        for (int i = 0; i < propJson.length(); ++i) {
            JSONObject prop = propJson.getJSONObject(i);
            String propName = JSONUtilities.getStringFromJsonObject((JSONObject)prop, (String)"name");
            if (excludes.contains(propName)) continue;
            PropValue propValue = new PropValue(propName, "");
            PropValueResource.getInstance().setValuesFromJSON(propValue, prop);
            propSheet.addPropValue(propValue);
        }
    }

    @Deprecated
    public void importPropSheet(PropSheet sheet, JSONObject sheetJson, boolean isUpgrade) throws Exception {
        String name = JSONUtilities.getStringFromJsonObject((JSONObject)sheetJson, (String)"name");
        JSONArray props = JSONUtilities.getJsonArrayFromJsonObject((JSONObject)sheetJson, (String)"properties");
        sheet.setName(name);
        this.importProperties(sheet, props);
    }

    public void importPropSheet(PropSheet sheet, JSONObject sheetJson) throws Exception {
        String name = JSONUtilities.getStringFromJsonObject((JSONObject)sheetJson, (String)"name");
        JSONArray props = JSONUtilities.getJsonArrayFromJsonObject((JSONObject)sheetJson, (String)"properties");
        sheet.setName(name);
        this.importProperties(sheet, props);
    }

    private boolean isCurrentVersion(PropSheet propSheet, int version) {
        boolean result = true;
        PersistenceData persistenceData = propSheet.getPersistenceData();
        if (propSheet.isVersioned() && version < persistenceData.getVersionCount()) {
            result = false;
        }
        return result;
    }

    private String sanitizePropNames(String inputString) {
        inputString = inputString.replaceAll("\n", "");
        inputString = inputString.replaceAll("\r", "");
        inputString = inputString.replaceAll("\t", "");
        inputString = inputString.replaceAll("\f", "");
        return inputString;
    }

    private String sanitizePropValues(String inputString) {
        inputString = inputString.replaceAll("\f", "");
        return inputString;
    }
}

