/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.OutputStream;

public class RangeOutputStream
extends OutputStream {
    protected final OutputStream out;
    protected long bytesUntilStart;
    protected boolean started;
    protected long toWrite;

    public RangeOutputStream(OutputStream out, long start, long length) {
        if (start < 0L) {
            throw new IllegalArgumentException();
        }
        if (length < 0L) {
            throw new IllegalArgumentException();
        }
        this.out = out;
        this.bytesUntilStart = start;
        this.toWrite = length;
    }

    protected void startingWrite() throws IOException {
    }

    protected void finishedWrite() throws IOException {
    }

    protected void resetRange(long start, long length) {
        this.started = false;
        this.bytesUntilStart = start;
        this.toWrite = length;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bytesUntilStart != 0L) {
            --this.bytesUntilStart;
            return;
        }
        if (!this.started) {
            this.startingWrite();
            if (this.bytesUntilStart != 0L) {
                return;
            }
            this.started = true;
        }
        if (this.toWrite != 0L) {
            this.out.write(b);
            --this.toWrite;
            if (this.toWrite == 0L) {
                this.finishedWrite();
            }
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (true) {
            if (this.bytesUntilStart != 0L) {
                int toSkip = (int)Math.min(this.bytesUntilStart, (long)len);
                this.bytesUntilStart -= (long)toSkip;
                if (this.bytesUntilStart != 0L) {
                    return;
                }
                len -= toSkip;
                off += toSkip;
            }
            if (len == 0) {
                return;
            }
            if (!this.started) {
                this.startingWrite();
                this.started = true;
                continue;
            }
            if (this.toWrite == 0L) break;
            int writeLen = (int)Math.min((long)len, this.toWrite);
            this.out.write(b, off, writeLen);
            this.toWrite -= (long)writeLen;
            off += writeLen;
            len -= writeLen;
            if (this.toWrite != 0L) continue;
            this.finishedWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

