/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.MarshallingExceptionReasonCode;
import com.ibm.team.repository.common.internal.marshal.impl.WebServicesMarshaller;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.internal.util.ComponentConfigurationRegistry;
import com.ibm.team.repository.common.serialize.IDeserializer2;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.transport.AbstractTeamServer;
import com.ibm.team.repository.common.transport.ComponentConfiguration;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import com.ibm.team.repository.common.transport.HostUtil;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.common.transport.ITeamRestService;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.InsecureProtocolException;
import com.ibm.team.repository.common.transport.ServiceNotAvailableException;
import com.ibm.team.repository.common.transport.TeamServerConfiguration;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.transport.UriUtil;
import com.ibm.team.repository.common.transport.VersionMismatchException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.auth.TransportAuthException;
import com.ibm.team.repository.transport.client.AdaptedSPNegoSchemeFactory;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.BearerSchemeProvider;
import com.ibm.team.repository.transport.client.ClientCertificateNotAcceptedException;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.InsufficientRightsException;
import com.ibm.team.repository.transport.client.InterruptableSocketFactory2;
import com.ibm.team.repository.transport.client.InvalidUserCredentialsException;
import com.ibm.team.repository.transport.client.KerberosInvalidTicketException;
import com.ibm.team.repository.transport.client.LogUtil;
import com.ibm.team.repository.transport.client.NoKerberosTargetException;
import com.ibm.team.repository.transport.client.NoResponseException;
import com.ibm.team.repository.transport.client.NoUserCredentialsAcceptedException;
import com.ibm.team.repository.transport.client.RemoteTeamRestService;
import com.ibm.team.repository.transport.client.RemoteTeamService;
import com.ibm.team.repository.transport.client.RepositoryJobSchedulingRule;
import com.ibm.team.repository.transport.client.RequestResponsePair;
import com.ibm.team.repository.transport.client.SecureInterruptableSocketFactory2;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.KeyManager;
import org.apache.commons.httpclient.Header;
import org.apache.http.Consts;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.RequestLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class RemoteTeamServer
extends AbstractTeamServer {
    private static final boolean DO_NOT_STRIP_PORT_FOR_KERBEROS = Boolean.getBoolean("com.ibm.team.repository.client.kerberos.donotstripport");
    private static final String NLS_REMOTE_TEAM_SERVER_CLOSING_CONNECTIONS = "_NoId.RemoteTeamServer.ClosingConnections";
    public static final String SPNEGO_ENABLED = " spnego-enabled";
    private static final String JAZZ_NATIVE_CLIENT = "Jazz Native Client spnego-enabled";
    private static final String BACK_SLASH_REGEXP = "\\\\";
    private static final String OS_NAME_PROP = "os.name";
    private static final String OS_WINDOWS = "WINDOWS";
    private static final String COMPUTER_NAME_EV = "ComputerName";
    private static final String EMPTY_STRING = "";
    private static final String BEARER_CHALLENGE_NAME = "bearer";
    private static final String NEGOTIATE_CHALLENGE_NAME = "negotiate";
    private static final String BASIC_CHALLENGE_NAME = "basic";
    private static final String AuthSchemeBearer = "Bearer";
    private static final Collection<String> authSchemePreferences = Arrays.asList("Bearer", "negotiate", "Basic");
    private volatile CloseableHttpClient _httpClient;
    private volatile CookieStore _cookieStore;
    private volatile CredentialsProvider _credsProvider;
    private volatile SecureInterruptableSocketFactory2 _secureSocketFactory;
    private volatile PoolingHttpClientConnectionManager _connectionMgr;
    private volatile AuthenticationType _authenticationType = AuthenticationType.USERIDPASSWD;
    private volatile String _repoPath;
    private volatile HttpHost _targetHost;
    private volatile HttpHost _idpHost;
    private volatile HttpHost _proxy;
    private volatile KeyManager[] _keyManagers;
    private volatile int _socketTimeout = 0;
    private volatile int _connectTimeout = 0;
    private volatile IOAuthHandler _oauthHandler;
    private final ICertificateValidator _certificateValidator;
    private static final LogUtil _logger = new LogUtil(RemoteTeamServer.class);
    private static final int MAXIMUM_REPLAY_ATTEMPTS = 10;
    private static final String OAUTH_AUTHORIZE_PREFIX = "/oauth-authorize";
    private static final String AUTHORIZATION_REDIRECT_URL_HEADER = "X-JSA-AUTHORIZATION-REDIRECT";
    private static final String AUTHORIZATION_LOGIN_REQUIRED_HEADER = "X-JSA-LOGIN-REQUIRED";
    private static final String SERVICE_CONTEXT = String.valueOf(RemoteTeamServer.class.getCanonicalName()) + ".TeamService";
    public static final String PROXY_URI_PARM = "uri";
    public static final String PROXY_CONTEXT_SEGMENT = "proxy";
    private static final String FROM_WEBUI_PROXY_HEADER = "X-net-jazz-ajax-proxy";
    public static final String FORM_AUTH_HEADER = "X-com-ibm-team-repository-web-auth-msg";
    public static final String FORM_AUTH_REQUIRED_MSG = "authrequired";
    public static final String FORM_AUTH_FAILED_MSG = "authfailed";
    public static final String FORM_AUTH_FAILED_URI = "/auth/authfailed";
    public static final String FORM_AUTH_REQUESTED_URI = "/auth/authrequired";
    private static final String VIA_PROXY_HEADER = "X-Via-Jazz-Proxy";
    private static final String NLS_HTTP_ERROR = "ClientHttpUtil.HttpError";
    private static final String NLS_HTTP_ERROR_SERVICE = "ClientHttpUtil.HttpError.Service";
    private static final String NLS_HTTP_ERROR_TIMEOUT = "ClientHttpUtil.HttpError.Timeout";
    private static final String NLS_HTTP_ERROR_NO_RESPONSE = "ClientHttpUtil.HttpError.NoResponse";
    private static final String NLS_HTTP_ERROR_SOCKET = "ClientHttpUtil.HttpError.Socket";
    private static final String NLS_HTTP_ERROR_INVALID = "ClientHttpUtil.HttpError.Invalid";
    private static final String NLS_HTTP_ERROR_UNKNOWN_HOST = "ClientHttpUtil.HttpError.UnknownHost";
    private static final String NLS_GENERAL_ERROR = "ClientHttpUtil.GeneralError";
    private static final String NLS_GENERAL_ERROR_UNKNOWN_SERVICE = "ClientHttpUtil.GeneralErrorUnknownService";
    private static final String NLS_UNAVAILABLE_ERROR = "ClientHttpUtil.UnavailableError";
    private static final String NLS_NOT_IMPLEMENTED_ERROR = "ClientHttpUtil.NotImplementedError";
    private static final String NLS_FORBIDDEN_ERROR = "ClientHttpUtil.ForbiddenError";
    private static final String NLS_UNAUTHORIZED_ERROR = "ClientHttpUtil.UnauthorizedError";
    private static final String NLS_KERBEROS_TICKET_INVALID = "ClientHttpUtil.KerberosTicketInvalid";
    private static final String NLS_NO_TARGET_KERBEROS = "ClientHttpUtil.NoTargetKerberos";
    private static final String NLS_USERCREDENTIALS_NOT_POSSIBLE = "ClientHttpUtil.UserCredentialsNotPossible";
    private static final String NLS_CLIENTCERTIFICATE_NOT_ACCEPTED = "ClientHttpUtil.ClientCertificateNotAccepted";
    public static final String X_NO_RETRY_HEADER = "X-com-ibm-team-repository.common.remoteaccess.noRetry";
    private static final String FORM_AUTH_URI = "j_security_check";
    private static final String FORM_AUTH_USER_FIELD = "j_username";
    private static final String FORM_AUTH_PASSWORD_FIELD = "j_password";
    public static final String FORM_AUTH = "FORM";
    public static final String BASIC_AUTH = "BASIC";
    public static final String LOCATION = "Location";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded; charset=utf-8";
    public static final String SLASH = "/";
    private static final String NLS_UNEXPECTED_LOGIN_ERROR = "TransportAuthUtil.UnexpectedLoginError";
    private static final String NLS_UNEXPECTED_STATUS = "TransportAuthUtil.UnexpectedStatus";
    private static final String NLS_INVALID_CREDENTIALS = "TransportAuthUtil.InvalidCredentials";
    private static final String NLS_SERVLET_ERROR = "TransportAuthUtil.ServletError";
    private static final String NLS_SERVER_CONFIG_ERROR = "TransportAuthUtil.ServerConfigError";

    public RemoteTeamServer(String urlString) {
        this(urlString, null);
    }

    public RemoteTeamServer(String urlString, ICertificateValidator validator) {
        super(urlString);
        this.setRepositoryURLUnsafe(urlString);
        this._certificateValidator = validator;
    }

    public synchronized void setRepositoryURL(String urlString) {
        _logger.debug("Entering setRepositoryURL", new Object[0]);
        this.setRepositoryURLUnsafe(urlString);
        this.closeConnections();
    }

    private void setRepositoryURLUnsafe(String urlString) {
        super.setRepositoryURL(urlString);
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Invalid URL \"%s\" given to setRepositoryURL: %s", urlString, e));
        }
        String host = url.getHost();
        if (host == null) {
            throw new IllegalArgumentException("Repository URL missing host");
        }
        int port = url.getPort();
        if (-1 == port) {
            port = url.getDefaultPort();
        }
        if (-1 == port) {
            throw new IllegalStateException("No port available or specified in repository URL");
        }
        this._targetHost = new HttpHost(host, port, url.getProtocol());
        this._repoPath = url.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getHttpClient() {
        CloseableHttpClient result = this._httpClient;
        if (result == null) {
            RemoteTeamServer remoteTeamServer = this;
            synchronized (remoteTeamServer) {
                result = this._httpClient;
                if (result == null) {
                    result = this._httpClient = this.buildHttpClient();
                }
            }
        }
        _logger.debug("Entering getHttpClient: returning %s", result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CookieStore getCookieStore() {
        CookieStore result = this._cookieStore;
        if (result == null) {
            RemoteTeamServer remoteTeamServer = this;
            synchronized (remoteTeamServer) {
                result = this._cookieStore;
                if (result == null) {
                    result = this._cookieStore = new BasicCookieStore();
                }
            }
        }
        _logger.debug("Entering getCookieStore: returning %s", result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CredentialsProvider getCredsProvider() {
        CredentialsProvider result = this._credsProvider;
        if (result == null) {
            RemoteTeamServer remoteTeamServer = this;
            synchronized (remoteTeamServer) {
                result = this._credsProvider;
                if (result == null) {
                    result = this._credsProvider = new BasicCredentialsProvider();
                }
            }
        }
        return result;
    }

    private synchronized CloseableHttpClient buildHttpClient() {
        _logger.debug("Entering buildHttpClient", new Object[0]);
        HttpClientBuilder builder = HttpClients.custom();
        this._secureSocketFactory = this._keyManagers == null ? new SecureInterruptableSocketFactory2(this._certificateValidator) : new SecureInterruptableSocketFactory2(this._keyManagers, this._certificateValidator);
        Registry connectionRegistry = RegistryBuilder.create().register("http", (Object)new InterruptableSocketFactory2()).register("https", (Object)this._secureSocketFactory).build();
        this._connectionMgr = new PoolingHttpClientConnectionManager(connectionRegistry);
        this._connectionMgr.setDefaultSocketConfig(SocketConfig.custom().setSoLinger(-1).setTcpNoDelay(true).build());
        this._connectionMgr.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(8192).build());
        this._connectionMgr.setDefaultMaxPerRoute(1000);
        this._connectionMgr.setMaxTotal(1000);
        builder.setConnectionManager((HttpClientConnectionManager)this._connectionMgr);
        RegistryBuilder authSchemeRegistryBuilder = RegistryBuilder.create();
        authSchemeRegistryBuilder.register(AuthSchemeBearer, (Object)new BearerSchemeProvider());
        switch (this._authenticationType) {
            case KERBEROSSPNEGO: {
                authSchemeRegistryBuilder.register(NEGOTIATE_CHALLENGE_NAME, (Object)new AdaptedSPNegoSchemeFactory(!DO_NOT_STRIP_PORT_FOR_KERBEROS));
                break;
            }
            case USERIDPASSWD: {
                authSchemeRegistryBuilder.register("Basic", (Object)new BasicSchemeFactory(Charset.forName("UTF-8")));
                break;
            }
        }
        Registry authSchemeRegistry = authSchemeRegistryBuilder.build();
        builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        if (this._proxy != null) {
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(this._proxy);
            builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        builder.setDefaultRequestConfig(this.getRequestConfigBuilder().build());
        builder.setRedirectStrategy((RedirectStrategy)new AuthRedirectStrategy());
        builder.setDefaultCredentialsProvider(this.getCredsProvider());
        builder.setUserAgent(JAZZ_NATIVE_CLIENT);
        return builder.build();
    }

    private synchronized RequestConfig.Builder getRequestConfigBuilder() {
        int[] timeouts = this.getTimeouts();
        return RequestConfig.custom().setConnectionRequestTimeout(timeouts[0]).setConnectTimeout(timeouts[1]).setCookieSpec("compatibility").setSocketTimeout(timeouts[1]).setStaleConnectionCheckEnabled(true).setAuthenticationEnabled(true).setCircularRedirectsAllowed(true).setTargetPreferredAuthSchemes(authSchemePreferences).setRedirectsEnabled(true);
    }

    public synchronized void setCredentials() {
        super.setCredentials(EMPTY_STRING, EMPTY_STRING);
        _logger.debug("Entering setCredentials()", new Object[0]);
        this.closeHttpClient(false);
        this._authenticationType = AuthenticationType.KERBEROSSPNEGO;
        this.setInternalCredentials(true);
    }

    public synchronized void setCredentials(String userid, String password) {
        super.setCredentials(userid, password != null ? password : EMPTY_STRING);
        _logger.debug("Entering setCredentials(userid=%s, password=%s)", userid, password);
        this.closeHttpClient(false);
        this._authenticationType = AuthenticationType.USERIDPASSWD;
        this.setInternalCredentials(!RemoteTeamServer.isBlank(userid));
    }

    private void resetInternalCredentials() {
        this.closeHttpClient(true);
        switch (this._authenticationType) {
            case KERBEROSSPNEGO: {
                _logger.debug("Resetting internal credentials for SPNEGO", new Object[0]);
                this.setInternalCredentials(true);
                break;
            }
            default: {
                _logger.debug("Resetting internal credentials", new Object[0]);
                this.setInternalCredentials(!RemoteTeamServer.isBlank(this.getUserid()));
            }
        }
    }

    private void setInternalCredentials(boolean setTargetCredentials) {
        Credentials proxyCreds;
        BasicCredentialsProvider newCredsProvider = new BasicCredentialsProvider();
        String userId = this.getUserid();
        String password = this.getPassword();
        if (setTargetCredentials) {
            if (this._idpHost != null) {
                AuthScope idpScope = new AuthScope(this._idpHost.getHostName(), -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
                newCredsProvider.setCredentials(idpScope, (Credentials)new UsernamePasswordCredentials(userId, password));
            } else {
                AuthScope targetScope = new AuthScope(this._targetHost.getHostName(), -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
                newCredsProvider.setCredentials(targetScope, (Credentials)new UsernamePasswordCredentials(userId, password));
            }
        }
        if (this._proxy != null && (proxyCreds = this._credsProvider.getCredentials(new AuthScope(this._proxy))) != null) {
            newCredsProvider.setCredentials(new AuthScope(this._proxy), (Credentials)new UsernamePasswordCredentials(proxyCreds.getUserPrincipal().getName(), proxyCreds.getPassword()));
        }
        this._credsProvider = newCredsProvider;
    }

    public synchronized void setCredentials(KeyManager[] keyManagers) {
        _logger.debug("Entering setCredentials(keyManagers)", new Object[0]);
        super.setCredentials(EMPTY_STRING, EMPTY_STRING);
        this.closeHttpClient(false);
        this._authenticationType = AuthenticationType.CLIENTCERTS;
        this._keyManagers = keyManagers;
    }

    @Deprecated
    public synchronized String[] getHttpCredentials() {
        _logger.debug("Entering getHttpCredentials", new Object[0]);
        String[] result = new String[2];
        UsernamePasswordCredentials storedCredentials = null;
        if (this._credsProvider != null) {
            AuthScope scope = new AuthScope(this._targetHost.getHostName(), -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
            storedCredentials = (UsernamePasswordCredentials)this._credsProvider.getCredentials(scope);
        }
        if (storedCredentials == null) {
            return result;
        }
        result[0] = storedCredentials.getUserName();
        result[1] = storedCredentials.getPassword();
        if (result[0] == null) {
            result[0] = EMPTY_STRING;
        }
        if (result[1] == null) {
            result[1] = EMPTY_STRING;
        }
        return result;
    }

    private static Credentials buildProxyCredentials(String userName, String password) {
        _logger.debug("Entering getHttpCredentials", new Object[0]);
        UsernamePasswordCredentials credentials = null;
        if (System.getProperty(OS_NAME_PROP).toUpperCase(Locale.ROOT).startsWith(OS_WINDOWS)) {
            String hostName;
            String domainName = EMPTY_STRING;
            String[] s = userName.split(BACK_SLASH_REGEXP);
            if (s.length == 2) {
                domainName = s[0];
                userName = s[1];
            }
            if ((hostName = System.getenv(COMPUTER_NAME_EV)) == null) {
                hostName = EMPTY_STRING;
            }
            credentials = new NTCredentials(userName, password, hostName, domainName);
            _logger.debug("Using NTCredentials", new Object[0]);
        } else {
            credentials = new UsernamePasswordCredentials(userName, password);
            _logger.debug("Using UsernamePasswordCredentials", new Object[0]);
        }
        return credentials;
    }

    public synchronized void setProxy(String host, String type, int port, String userName, String password) {
        _logger.debug("setProxy() - host: %s - type: %s - port: %d - userName: %s - password: %s", host, type, port, userName, password);
        this.closeConnections();
        if (host == null || port < 1) {
            _logger.debug("empty host or negative port given to setProxy", new Object[0]);
            return;
        }
        this._proxy = new HttpHost(host, port, type);
        this.getCredsProvider().setCredentials(new AuthScope(this._proxy), RemoteTeamServer.buildProxyCredentials(userName, password));
    }

    public synchronized void setProxy(String host, int port, String userName, String password) {
        this.setProxy(host, null, port, userName, password);
    }

    public synchronized void setConfiguration(TeamServerConfiguration configuration) {
        super.setConfiguration(configuration);
        _logger.debug("Entering setConfiguration", new Object[0]);
        this.closeConnections();
        this._connectTimeout = configuration.getSocketTimeout();
        this._socketTimeout = configuration.getSocketTimeout();
    }

    private synchronized int[] getTimeouts() {
        int[] retval = new int[2];
        if (this._connectTimeout != 0 && this._socketTimeout != 0) {
            retval[0] = this._connectTimeout;
            retval[1] = this._socketTimeout;
        } else {
            TeamServerConfiguration config = new TeamServerConfiguration();
            retval[0] = retval[1] = config.getSocketTimeout();
        }
        return retval;
    }

    public ITeamService createTeamService(Class<?> serviceClass, Object implementation, String version, List<ComponentConfiguration> componentConfigurations) {
        _logger.debug("Entering createTeamService", new Object[0]);
        if (serviceClass == null) {
            throw new IllegalArgumentException("serviceClass must not be null");
        }
        if (implementation != null) {
            throw new IllegalArgumentException(NLS.bind((String)"{0} implementation must be null", serviceClass, (Object[])new Object[0]));
        }
        ClassLoader serviceClassLoader = serviceClass.getClassLoader();
        if (ITeamRestService.class.isAssignableFrom(serviceClass)) {
            _logger.debug("creating RemoteTeamRestService from %s", serviceClass.getName());
            return new RemoteTeamRestService(this, serviceClass, serviceClassLoader, version);
        }
        _logger.debug("creating RemoteTeamService from %s", serviceClass.getName());
        return new RemoteTeamService(this, serviceClass, serviceClassLoader, version, componentConfigurations);
    }

    protected Object buildServiceImplementation(Class<?> serviceClass) {
        return null;
    }

    public boolean isLocal() {
        return false;
    }

    public void closeConnections() {
        this.closeHttpClient(false);
    }

    public void closeConnections(boolean savePrefs) {
        this.closeConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeHttpClient(boolean preserveCookieStore) {
        PoolingHttpClientConnectionManager connectionManager;
        _logger.debug("Entering closeHttpClient", new Object[0]);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Value of _httpclient: %s", this._httpClient);
        }
        RemoteTeamServer remoteTeamServer = this;
        synchronized (remoteTeamServer) {
            connectionManager = this._connectionMgr;
            this._httpClient = null;
            if (!preserveCookieStore) {
                this._cookieStore = null;
            }
            this._secureSocketFactory = null;
            this._connectionMgr = null;
            this._keyManagers = null;
            this._authenticationType = AuthenticationType.USERIDPASSWD;
        }
        long delay = 5000L;
        String testType = System.getProperty("com.ibm.team.core.tests.repo");
        if ("local".equalsIgnoreCase(testType)) {
            delay = 40000L;
        }
        Job job = new Job(Messages.getClientString(NLS_REMOTE_TEAM_SERVER_CLOSING_CONNECTIONS)){

            protected IStatus run(IProgressMonitor arg0) {
                _logger.debug("Starting HttpClient background close", new Object[0]);
                connectionManager.shutdown();
                _logger.debug("Finished HttpClient background close", new Object[0]);
                return Status.OK_STATUS;
            }
        };
        job.setRule(RepositoryJobSchedulingRule.getWriteAccessRule(this.getRepositoryURL()));
        job.setPriority(40);
        if (connectionManager != null) {
            _logger.debug("Started eclipse background job to close the client", new Object[0]);
            job.schedule(delay);
        } else {
            _logger.debug("httpclient already closed", new Object[0]);
        }
    }

    public String getRepositoryPath() {
        return this._repoPath;
    }

    public X509Certificate[] getServerCertificatePath() {
        SecureInterruptableSocketFactory2 factory = this._secureSocketFactory;
        if (factory == null) {
            return null;
        }
        return factory.getLastKnownServerCertificatePath();
    }

    public void setOAuthHandler(IOAuthHandler handler) {
        _logger.debug("Entering setOAuthHandler - handler:%s", handler);
        this._oauthHandler = handler;
    }

    public IOAuthHandler getOAuthHandler() {
        return this._oauthHandler;
    }

    public int executeMethod(RemoteTeamService service, RequestResponsePair method, boolean handle404, boolean wrapIOException) throws IOException, TeamServiceException {
        return this.executeMethod(service, method, handle404, wrapIOException, true);
    }

    public int executeMethod(RemoteTeamService service, RequestResponsePair method, boolean handle404, boolean wrapIOException, boolean decodeExceptions) throws IOException, TeamServiceException {
        _logger.debug("Entering executeMethod - decodeExceptions == %s", Boolean.toString(decodeExceptions));
        if (method.getRequest().getConfig() != null) {
            throw new IllegalStateException("Callers of executeMethod are not allowed to set a RequestConfig on the request");
        }
        HttpClientContext httpContext = HttpClientContext.create();
        method.setContext(httpContext);
        httpContext.setCookieStore(this.getCookieStore());
        httpContext.setAttribute(SERVICE_CONTEXT, (Object)service);
        RequestConfig requestConfig = this.getRequestConfigBuilder().setSocketTimeout(this.getConfiguration().getSocketTimeout()).build();
        httpContext.setRequestConfig(requestConfig);
        this.executeWithAuthHandling(method, httpContext, wrapIOException, 0);
        int statusCode = method.getResponse().getStatusLine().getStatusCode();
        _logger.debug("Execute with authHandler returned " + statusCode, new Object[0]);
        if (RemoteTeamServer.isResponseFromProxyTarget((HttpRequest)method.getRequest())) {
            _logger.debug("Response from JFAM proxy - exiting", new Object[0]);
            return statusCode;
        }
        switch (statusCode) {
            case 401: {
                AuthenticationException exp;
                _logger.debug("Handling SC_UNAUTHORIZED", new Object[0]);
                ChallengeType challengeType = method.getChallengeType();
                block7 : switch (this._authenticationType) {
                    case KERBEROSSPNEGO: {
                        switch (challengeType) {
                            case SPNEGO: {
                                String message = NLS.bind((String)Messages.getClientString(NLS_KERBEROS_TICKET_INVALID), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                                exp = new KerberosInvalidTicketException(message, statusCode);
                                break block7;
                            }
                        }
                        String message = NLS.bind((String)Messages.getClientString(NLS_NO_TARGET_KERBEROS), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                        exp = new NoKerberosTargetException(message, statusCode);
                        break;
                    }
                    case USERIDPASSWD: {
                        switch (challengeType) {
                            case BASIC: {
                                String message = NLS.bind((String)Messages.getClientString(NLS_INVALID_CREDENTIALS), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                                exp = new InvalidUserCredentialsException(message, statusCode);
                                break block7;
                            }
                        }
                        String message = NLS.bind((String)Messages.getClientString(NLS_USERCREDENTIALS_NOT_POSSIBLE), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                        exp = new NoUserCredentialsAcceptedException(message, statusCode);
                        break;
                    }
                    case CLIENTCERTS: {
                        String message = NLS.bind((String)Messages.getClientString(NLS_CLIENTCERTIFICATE_NOT_ACCEPTED), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                        exp = new ClientCertificateNotAcceptedException(message, statusCode);
                        break;
                    }
                    default: {
                        String message = NLS.bind((String)Messages.getClientString(NLS_UNAUTHORIZED_ERROR), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                        exp = new AuthenticationException(message, statusCode);
                    }
                }
                exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)httpContext));
                exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)httpContext));
                throw exp;
            }
            case 403: {
                _logger.debug("Handling SC_FORBIDDEN", new Object[0]);
                String message = NLS.bind((String)Messages.getClientString(NLS_FORBIDDEN_ERROR), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                InsufficientRightsException exp = new InsufficientRightsException(message, statusCode);
                exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)httpContext));
                exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)httpContext));
                throw exp;
            }
            case 501: {
                _logger.debug("Handling SC_NOT_IMPLEMENTED", new Object[0]);
                String message = NLS.bind((String)Messages.getClientString(NLS_NOT_IMPLEMENTED_ERROR), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                ServiceNotAvailableException exp = new ServiceNotAvailableException(message, statusCode);
                exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)httpContext));
                exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)httpContext));
                throw exp;
            }
            case 503: {
                _logger.debug("Handling SC_SERVICE_UNAVAILABLE", new Object[0]);
                String message = NLS.bind((String)Messages.getClientString(NLS_UNAVAILABLE_ERROR), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                ServiceNotAvailableException exp = new ServiceNotAvailableException(message, statusCode);
                exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)httpContext));
                exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)httpContext));
                throw exp;
            }
            case 302: {
                _logger.debug("Handling SC_MOVED_TEMPORARILY", new Object[0]);
                String protocol = this._targetHost.getSchemeName();
                if (protocol.compareToIgnoreCase("http") == 0) {
                    String message = NLS.bind((String)Messages.getClientString("ClientHttpUtil.ErrorInsecureHttpConnection"), (Object)method.getRequest().getURI(), (Object[])new Object[]{"http", "https"});
                    throw new InsecureProtocolException(message, statusCode);
                }
                this.throwHttpClientError((HttpContext)httpContext, decodeExceptions);
                throw new RuntimeException("Should never happen, above call to throwHttpClientError will always throw an exception");
            }
        }
        if (!handle404 && 404 == statusCode) {
            _logger.debug("Immediately returning 404", new Object[0]);
            return statusCode;
        }
        if (statusCode >= 300) {
            _logger.debug("Other > 300 status: " + statusCode, new Object[0]);
            this.throwHttpClientError((HttpContext)httpContext, decodeExceptions);
        }
        return statusCode;
    }

    private void handleAuthorizationServerChallenge(HttpHost opHost, HttpGet authorizationRequest, RequestResponsePair method, HttpClientContext httpContext, boolean wrapIOException) throws TeamServiceException, IOException {
        this._idpHost = opHost;
        this.resetInternalCredentials();
        _logger.debug("OIDC resending authorization request without prompt = none", new Object[0]);
        CloseableHttpResponse closeableResponse = this.executePrimitiveRequest((HttpRequest)authorizationRequest, opHost, httpContext, wrapIOException, false);
        method.setResponse(closeableResponse);
        if (closeableResponse.getStatusLine().getStatusCode() == 401) {
            ChallengeType challengeType = this.getChallengeType(method);
            _logger.debug("OIDC challenge type is %s", new Object[]{challengeType});
            if (challengeType == ChallengeType.SPNEGO && this._authenticationType != AuthenticationType.KERBEROSSPNEGO) {
                this.handleSpnegoChallengeForNonSpnegoConnection(method, httpContext, wrapIOException);
            }
        }
        if (closeableResponse.getStatusLine().getStatusCode() == 200) {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)closeableResponse);
            this._idpHost = httpContext.getTargetHost();
            this.resetInternalCredentials();
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(this._idpHost, (AuthScheme)new BasicScheme(Charset.forName("UTF-8")));
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            AuthScope idpScope = new AuthScope(this._idpHost.getHostName(), -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
            credentialsProvider.setCredentials(idpScope, (Credentials)new UsernamePasswordCredentials(this.getUserid(), this.getPassword()));
            httpContext.setAuthCache((AuthCache)authCache);
            httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            httpContext.setAttribute("http.auth.target-scope", (Object)new AuthState());
            closeableResponse = this.executePrimitiveRequest((HttpRequest)authorizationRequest, opHost, httpContext, wrapIOException, true);
            method.setResponse(closeableResponse);
            httpContext.removeAttribute("http.auth.auth-cache");
        }
    }

    private void handleBearerChallenge(RequestResponsePair method, HttpClientContext httpContext, boolean wrapIOException) throws TeamServiceException, IOException {
        CloseableHttpResponse response = method.getResponse();
        org.apache.http.Header opAuthorizationRequestHeader = response.getFirstHeader(AUTHORIZATION_REDIRECT_URL_HEADER);
        if (opAuthorizationRequestHeader == null) {
            _logger.debug("Bearer challenge received but target not developed with OIDC SDK", new Object[0]);
            return;
        }
        try {
            URIBuilder authorizationRequestUriBuilder = new URIBuilder(opAuthorizationRequestHeader.getValue());
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            URI authorizationRequestUri = authorizationRequestUriBuilder.build();
            _logger.debug("OIDC Authorization uri: %s", authorizationRequestUri);
            URIBuilder authorizationRequestUriBuilderWithNoPrompt = authorizationRequestUriBuilder.addParameter("prompt", "none");
            HttpHost opHost = new HttpHost(authorizationRequestUriBuilder.getHost(), authorizationRequestUriBuilder.getPort(), authorizationRequestUriBuilder.getScheme());
            _logger.debug("OIDC OP Host: %s", opHost);
            HttpGet noPromptAuthorizationRequest = new HttpGet(authorizationRequestUriBuilderWithNoPrompt.build());
            _logger.debug("OIDC Authorization uri with prompt is none : %s", noPromptAuthorizationRequest.getURI());
            CloseableHttpResponse closeableResponse = this.executePrimitiveRequest((HttpRequest)noPromptAuthorizationRequest, opHost, httpContext, wrapIOException, false);
            method.setResponse(closeableResponse);
            if (closeableResponse.getStatusLine().getStatusCode() == 200) {
                _logger.debug("OIDC Authorization request with prompt is none returned 200", new Object[0]);
                org.apache.http.Header login_required_header = closeableResponse.getFirstHeader(AUTHORIZATION_LOGIN_REQUIRED_HEADER);
                if (login_required_header != null) {
                    _logger.debug("OIDC login required header returned", new Object[0]);
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)closeableResponse);
                    HttpGet authorizationRequest = new HttpGet(authorizationRequestUri);
                    this.handleAuthorizationServerChallenge(opHost, authorizationRequest, method, httpContext, wrapIOException);
                }
                _logger.debug("OIDC auth sequence reached protected resource", new Object[0]);
            } else {
                _logger.debug("OIDC Authorization request with prompt is none returned %s", closeableResponse.getStatusLine().getStatusCode());
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private void handleSpnegoChallengeForNonSpnegoConnection(RequestResponsePair method, HttpClientContext httpContext, boolean wrapIOException) throws TeamServiceException, IOException {
        _logger.debug("Handling SPNEGO challenge for non-SPNEGO connection type", new Object[0]);
        HttpRequestBase originalRequest = method.getRequest();
        CloseableHttpResponse closeableResponse = method.getResponse();
        HttpClientUtils.closeQuietly((CloseableHttpResponse)closeableResponse);
        originalRequest.setHeader("Authorization", NEGOTIATE_CHALLENGE_NAME);
        _logger.debug("Resending request %s with authorization header %s", originalRequest.getURI(), NEGOTIATE_CHALLENGE_NAME);
        closeableResponse = this.executePrimitiveRequest((HttpRequest)originalRequest, this._targetHost, httpContext, wrapIOException, true);
        method.setResponse(closeableResponse);
        int status = closeableResponse.getStatusLine().getStatusCode();
        if (status == 403) {
            switch (this._authenticationType) {
                case USERIDPASSWD: {
                    String message = NLS.bind((String)Messages.getClientString(NLS_USERCREDENTIALS_NOT_POSSIBLE), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                    NoUserCredentialsAcceptedException exp = new NoUserCredentialsAcceptedException(message, 403);
                    exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)httpContext));
                    exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)httpContext));
                    throw exp;
                }
                case CLIENTCERTS: {
                    String message = NLS.bind((String)Messages.getClientString(NLS_CLIENTCERTIFICATE_NOT_ACCEPTED), (Object)method.getRequest().getURI(), (Object[])new Object[0]);
                    ClientCertificateNotAcceptedException exp = new ClientCertificateNotAcceptedException(message, 403);
                    exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)httpContext));
                    exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)httpContext));
                    throw exp;
                }
            }
            throw new TeamServiceException("Unexpected authentication type leading to a 403 : " + (Object)((Object)this._authenticationType));
        }
        if (status == 401) {
            ChallengeType challengeType = this.getChallengeType(method);
            _logger.debug("Challenge type is %s ", new Object[]{challengeType});
            switch (challengeType) {
                case BASIC: {
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)closeableResponse);
                    BasicAuthCache authCache = new BasicAuthCache();
                    authCache.put(this._targetHost, (AuthScheme)new BasicScheme(Charset.forName("UTF-8")));
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    AuthScope idpScope = new AuthScope(this._targetHost.getHostName(), -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
                    credentialsProvider.setCredentials(idpScope, (Credentials)new UsernamePasswordCredentials(this.getUserid(), this.getPassword()));
                    httpContext.setAuthCache((AuthCache)authCache);
                    httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                    httpContext.setAttribute("http.auth.target-scope", (Object)new AuthState());
                    originalRequest.removeHeaders("Authorization");
                    _logger.debug("Pro-actively set basic credentials and re-executed original request", new Object[0]);
                    closeableResponse = this.executePrimitiveRequest((HttpRequest)originalRequest, this._targetHost, httpContext, wrapIOException, true);
                    httpContext.removeAttribute("http.auth.auth-cache");
                    method.setResponse(closeableResponse);
                    break;
                }
            }
        }
    }

    private void executeWithAuthHandling(RequestResponsePair method, HttpClientContext httpContext, boolean wrapIOException, int attempts) throws TeamServiceException, IOException {
        HttpRequestBase originalRequest = method.getRequest();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Value of originalRequest URI: %s", originalRequest.getRequestLine());
            _logger.debug("Value of originalRequest headers:\n%s", new StringAdaptor(originalRequest.getAllHeaders()));
        }
        CloseableHttpResponse closeableResponse = this.executePrimitiveRequest((HttpRequest)originalRequest, this._targetHost, httpContext, wrapIOException, true);
        _logger.debug("Finished executing primitive request", new Object[0]);
        method.setResponse(closeableResponse);
        int status = closeableResponse.getStatusLine().getStatusCode();
        if (status == 401) {
            ChallengeType challengeType = this.getChallengeType(method);
            _logger.debug("ChallengeType is " + (Object)((Object)challengeType), new Object[0]);
            switch (challengeType) {
                case BEARER: {
                    this.handleBearerChallenge(method, httpContext, wrapIOException);
                    break;
                }
                case SPNEGO: {
                    if (this._authenticationType != AuthenticationType.KERBEROSSPNEGO) {
                        this.handleSpnegoChallengeForNonSpnegoConnection(method, httpContext, wrapIOException);
                        break;
                    }
                    return;
                }
                default: {
                    return;
                }
            }
        }
        this.handleAuthentication(method, httpContext, wrapIOException, attempts);
    }

    private static void debug(String msg, HttpClientContext httpContext) {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        HttpResponse contextResponse = httpContext.getResponse();
        HttpRequest finalRequest = httpContext.getRequest();
        HttpHost contextHost = httpContext.getTargetHost();
        RouteInfo httpRoute = httpContext.getHttpRoute();
        RequestConfig requestConfig = httpContext.getRequestConfig();
        if (msg != null) {
            _logger.debug(msg, new Object[0]);
        }
        if (finalRequest != null) {
            _logger.debug("Value of request: %s", finalRequest.getRequestLine());
        }
        if (contextResponse != null) {
            _logger.debug("Value of context response headers:\n%s", new StringAdaptor(contextResponse.getAllHeaders()));
        }
        if (contextHost != null) {
            _logger.debug("Value of context host: %s", contextHost);
        }
        if (httpRoute != null) {
            _logger.debug("Value of route info: %s", httpRoute);
        }
        if (requestConfig != null) {
            _logger.debug("Value of request config: %s", requestConfig);
        }
    }

    private ChallengeType getChallengeType(RequestResponsePair method) {
        org.apache.http.Header[] wwwAuthHeaders;
        ChallengeType challengeType = ChallengeType.NA;
        CloseableHttpResponse response = method.getResponse();
        org.apache.http.Header[] headerArray = wwwAuthHeaders = response.getHeaders("WWW-Authenticate");
        int n = wwwAuthHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            org.apache.http.Header wwwAuthHeader = headerArray[n2];
            String challenge = wwwAuthHeader.getValue().toLowerCase(Locale.ENGLISH);
            if (challenge.startsWith(NEGOTIATE_CHALLENGE_NAME)) {
                challengeType = ChallengeType.SPNEGO;
                break;
            }
            if (challenge.startsWith(BEARER_CHALLENGE_NAME)) {
                challengeType = ChallengeType.BEARER;
                break;
            }
            if (challenge.startsWith(BASIC_CHALLENGE_NAME)) {
                challengeType = ChallengeType.BASIC;
            }
            ++n2;
        }
        method.setChallengeType(challengeType);
        return challengeType;
    }

    private void handleAuthentication(RequestResponsePair method, HttpClientContext httpContext, boolean wrapIOException, int attempts) throws TeamServiceException, IOException {
        _logger.debug("Entering handleAuthentication", new Object[0]);
        HttpRequest lastRequest = httpContext.getRequest();
        HttpHost lastHost = httpContext.getTargetHost();
        CloseableHttpResponse response = method.getResponse();
        int statusCode = method.getResponse().getStatusLine().getStatusCode();
        _logger.debug("Replay initially set to false", new Object[0]);
        boolean replay = false;
        if (statusCode == 200 && RemoteTeamServer.hasAuthRequiredHeader((HttpResponse)response)) {
            _logger.debug("Handling form-based authentication", new Object[0]);
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            switch (this._authenticationType) {
                case KERBEROSSPNEGO: {
                    NoKerberosTargetException exp = new NoKerberosTargetException(NLS.bind((String)Messages.getClientString(NLS_NO_TARGET_KERBEROS), (Object)method.getRequest().getURI().toString(), (Object[])new Object[0]));
                    exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)httpContext));
                    exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)httpContext));
                    throw exp;
                }
                case CLIENTCERTS: {
                    ClientCertificateNotAcceptedException exp = new ClientCertificateNotAcceptedException(NLS.bind((String)Messages.getClientString(NLS_CLIENTCERTIFICATE_NOT_ACCEPTED), (Object)method.getRequest().getURI().toString(), (Object[])new Object[0]));
                    exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)httpContext));
                    exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)httpContext));
                    throw exp;
                }
            }
            String lastPath = this.getContextPath(lastRequest);
            AuthScope scope = new AuthScope(this._targetHost.getHostName(), -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
            UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)this.getCredsProvider().getCredentials(scope);
            this.formBasedAuthenticate(lastPath, lastHost, this.getHttpClient(), credentials, httpContext);
            boolean isTomcat = this.isTomcat(response);
            if (isTomcat) {
                _logger.debug("Running on tomcat requires us to re-execute the last request %s" + lastRequest.getRequestLine().getUri(), new Object[0]);
                response = this.executePrimitiveRequest(lastRequest, lastHost, httpContext, wrapIOException, true);
                method.setResponse(response);
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            }
            _logger.debug("Setting replay to true", new Object[0]);
            replay = true;
        }
        String methodName = method.getRequest().getMethod();
        statusCode = response.getStatusLine().getStatusCode();
        boolean nonGet = methodName.equalsIgnoreCase("post") || methodName.equalsIgnoreCase("put") || methodName.equalsIgnoreCase("delete");
        _logger.debug("Last request was a nonGet: " + nonGet, new Object[0]);
        replay = replay || nonGet && lastRequest.getRequestLine().getMethod().equalsIgnoreCase("get") && statusCode < 300;
        _logger.debug("Setting replay to " + replay, new Object[0]);
        if (replay) {
            if (attempts > 10) {
                _logger.debug("Replaying has reached more than maximum attempts: " + attempts, new Object[0]);
                throw new TeamServiceException("Replaying the original POST/PUT/DELETE request on a redirection sequence more than 10 times");
            }
            if (!RemoteTeamServer.isPostToOAuthAuthorize((HttpRequest)method.getRequest())) {
                _logger.debug("Replaying the original POST/PUT/DELETE request on a redirection sequence, attempt " + attempts, new Object[0]);
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                this.executeWithAuthHandling(method, httpContext, wrapIOException, attempts + 1);
                return;
            }
            _logger.debug("a post to oauth authorize is exempt from replaying. Request was %s", method.getRequest().getURI());
        }
        _logger.debug("No further authentication required", new Object[0]);
    }

    private static boolean isPostToOAuthAuthorize(HttpRequest request) {
        URI requestURI;
        String path;
        int indexOfSecondSlash;
        RequestLine line = request.getRequestLine();
        boolean isPost = line.getMethod().equalsIgnoreCase("post");
        if (isPost && (indexOfSecondSlash = (path = (requestURI = URI.create(line.getUri())).getPath()).indexOf(47, 1)) > 0) {
            String servletPath = path.substring(indexOfSecondSlash);
            return servletPath.toLowerCase(Locale.ENGLISH).startsWith(OAUTH_AUTHORIZE_PREFIX);
        }
        return false;
    }

    private String getContextPath(HttpRequest request) {
        URI requestURI = URI.create(request.getRequestLine().getUri());
        String contextPath = requestURI.getPath();
        int index = contextPath.indexOf(47, 1);
        if (index > 0) {
            contextPath = contextPath.substring(0, index);
        }
        return contextPath;
    }

    private boolean isTomcat(CloseableHttpResponse response) {
        boolean isTomcat = false;
        org.apache.http.Header serverHeader = response.getFirstHeader("Server");
        if (serverHeader != null && serverHeader.getValue().startsWith("Apache-Coyote")) {
            isTomcat = true;
        }
        return isTomcat;
    }

    private CloseableHttpResponse executePrimitiveRequest(HttpRequest request, HttpHost targetHost, HttpClientContext context, boolean wrapIOException, boolean addComponentInformation) throws TeamServiceException, IOException {
        _logger.debug("Entering executePrimitiveRequest", new Object[0]);
        try {
            if (addComponentInformation) {
                RemoteTeamServer.addComponentConfigurationHeaders(request);
            }
            RemoteTeamServer.debug("PRIOR REQUEST EXECUTION CONTEXT", context);
            org.apache.http.Header userAgent = request.getFirstHeader("User-Agent");
            if (userAgent != null) {
                String newUserAgent = String.valueOf(userAgent.getValue()) + SPNEGO_ENABLED;
                _logger.debug("Adjusted user agent to: " + newUserAgent, new Object[0]);
                request.setHeader("User-Agent", newUserAgent);
            }
            CloseableHttpResponse response = this.getHttpClient().execute(targetHost, request, (HttpContext)context);
            RemoteTeamServer.debug("AFTER REQUEST EXECUTION CONTEXT", context);
            return response;
        }
        catch (ClientProtocolException e) {
            TeamServiceException ex = new TeamServiceException(this.httpErrorMessage(NLS_HTTP_ERROR_SERVICE, (HttpContext)context, (Exception)((Object)e)), (Throwable)e);
            ex.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)context));
            ex.setRequestUri(RemoteTeamServer.getRequestUri((HttpContext)context));
            _logger.debug("executePrimitiveRequest - Throwing HttpException", new Object[0]);
            throw ex;
        }
        catch (ConnectTimeoutException e) {
            ConnectionException ex = new ConnectionException(this.httpErrorMessage(NLS_HTTP_ERROR_TIMEOUT, (HttpContext)context, (Exception)((Object)e)), (Throwable)e);
            ex.setRequestUri(RemoteTeamServer.getRequestUri((HttpContext)context));
            _logger.debug("executePrimitiveRequest - Throwing ConnectTimeoutException", new Object[0]);
            throw ex;
        }
        catch (NoHttpResponseException e) {
            NoResponseException ex = new NoResponseException(this.httpErrorMessage(NLS_HTTP_ERROR_NO_RESPONSE, (HttpContext)context, (Exception)((Object)e)), e);
            ex.setRequestUri(RemoteTeamServer.getRequestUri((HttpContext)context));
            _logger.debug("executePrimitiveRequest - Throwing NoHttpResponseException", new Object[0]);
            throw ex;
        }
        catch (SocketException e) {
            ConnectionException c = new ConnectionException(this.httpErrorMessage(NLS_HTTP_ERROR_SOCKET, (HttpContext)context, e), (Throwable)e);
            c.setRequestUri(RemoteTeamServer.getRequestUri((HttpContext)context));
            _logger.debug("executePrimitiveRequest - Throwing SocketException", new Object[0]);
            throw c;
        }
        catch (UnresolvedAddressException e) {
            HostUnknownException ex = new HostUnknownException(this.httpErrorMessage(NLS_HTTP_ERROR_INVALID, (HttpContext)context, e), (Throwable)e);
            ex.setRequestUri(RemoteTeamServer.getRequestUri((HttpContext)context));
            _logger.debug("executePrimitiveRequest - Throwing UnresolvedAddressException", new Object[0]);
            throw ex;
        }
        catch (UnknownHostException e) {
            _logger.debug("Handling UnknownHostException", new Object[0]);
            HostUnknownException ex = new HostUnknownException(this.httpErrorMessage(NLS_HTTP_ERROR_UNKNOWN_HOST, (HttpContext)context, e), (Throwable)e);
            ex.setRequestUri(RemoteTeamServer.getRequestUri((HttpContext)context));
            _logger.debug("executePrimitiveRequest - Throwing UnknownHostException", new Object[0]);
            throw ex;
        }
        catch (IOException e) {
            if (wrapIOException) {
                TeamServiceException ex = new TeamServiceException(this.httpErrorMessage(NLS_HTTP_ERROR, (HttpContext)context, e), (Throwable)e);
                ex.setRequestUri(RemoteTeamServer.getRequestUri((HttpContext)context));
                _logger.debug("executePrimitiveRequest - Throwing TeamServiceException", new Object[0]);
                throw ex;
            }
            _logger.debug("executePrimitiveRequest - Throwing catch-all IOException", new Object[0]);
            throw e;
        }
    }

    private static String getRequestUri(HttpContext context) {
        URI requestUri;
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        HttpHost host = clientContext.getTargetHost();
        try {
            requestUri = URIUtils.rewriteURI((URI)URI.create(request.getRequestLine().getUri()), (HttpHost)host);
        }
        catch (URISyntaxException e) {
            _logger.debug("Error determining request Uri: %s", e.getMessage());
            return EMPTY_STRING;
        }
        return requestUri.toString();
    }

    private static Header[] getHttp3ResponseHeaders(HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpResponse response = clientContext.getResponse();
        if (response == null) {
            return null;
        }
        org.apache.http.Header[] headers = response.getAllHeaders();
        if (headers == null) {
            return null;
        }
        Header[] newHeaders = new Header[headers.length];
        int i = 0;
        while (i < headers.length) {
            newHeaders[i] = new Header(headers[i].getName(), headers[i].getValue());
            ++i;
        }
        return newHeaders;
    }

    private String httpErrorMessage(String messageKey, HttpContext context, Exception e) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        String msg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
        String uri = EMPTY_STRING;
        HttpRequest request = clientContext.getRequest();
        if (request != null) {
            uri = request.getRequestLine().getUri();
        }
        String s = NLS.bind((String)Messages.getServerString(messageKey), (Object)msg, (Object[])new Object[]{uri});
        return s;
    }

    private static void addComponentConfigurationHeaders(HttpRequest request) {
        if (request == null) {
            _logger.debug("addComponentConfigurations - null method argument", new Object[0]);
            return;
        }
        org.apache.http.Header requestHeader = request.getFirstHeader("X-com-ibm-team-configuration-versions");
        if (requestHeader != null) {
            _logger.debug("addComponentConfigurations - component configuration header present", new Object[0]);
            return;
        }
        List componentConfigurations = ComponentConfigurationRegistry.INSTANCE.getComponentConfigurations();
        if (componentConfigurations.size() < 1) {
            _logger.debug("addComponentConfigurations - null component configuration", new Object[0]);
            return;
        }
        String headerValue = ComponentConfigurationRegistry.formatConfigurationsForHttpHeader((List)componentConfigurations);
        request.setHeader("X-com-ibm-team-configuration-versions", headerValue);
        _logger.debug("addComponentConfigurations - component configuration header added", new Object[0]);
    }

    private String getAppropriateRequestURL(HttpContext context) {
        org.apache.http.Header[] headers;
        URI u = URI.create(RemoteTeamServer.getRequestUri(context));
        if (!this.isProxyUri(u)) {
            return u.toString();
        }
        HttpResponse response = HttpClientContext.adapt((HttpContext)context).getResponse();
        if (response == null) {
            return u.toString();
        }
        if (response.getStatusLine().getStatusCode() == 401 && ((headers = response.getHeaders(FROM_WEBUI_PROXY_HEADER)) == null || headers.length == 0)) {
            return u.toString();
        }
        Map parms = UriUtil.parseQueryParameters((String)u.getQuery());
        String[] uriParm = (String[])parms.get(PROXY_URI_PARM);
        if (uriParm == null || uriParm.length == 0) {
            return u.toString();
        }
        return uriParm[0];
    }

    private boolean isProxyUri(URI requestUri) {
        URI proxyUri = null;
        try {
            proxyUri = new URI(this.buildProxyUri());
        }
        catch (URISyntaxException e) {
            _logger.error("Error resolving proxy URI: %s", e.getMessage());
            return false;
        }
        if (!HostUtil.authorityEquiv((URI)requestUri, (URI)proxyUri)) {
            return false;
        }
        return UriUtil.startsWithPath((URI)proxyUri, (URI)requestUri);
    }

    private String buildProxyUri() {
        String repoUri = this.getRepositoryURL();
        String proxyUri = String.valueOf(repoUri) + PROXY_CONTEXT_SEGMENT;
        return proxyUri;
    }

    private void throwHttpClientError(HttpContext context, boolean decodeExceptions) throws TeamServiceException {
        Throwable cause;
        String template;
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpResponse response = clientContext.getResponse();
        RemoteTeamService service = (RemoteTeamService)((Object)clientContext.getAttribute(SERVICE_CONTEXT));
        String decodedStatusText = URLDecoder.decode(response.getStatusLine().getReasonPhrase());
        int statusCode = response.getStatusLine().getStatusCode();
        String message = null;
        if (service == null) {
            template = Messages.getServerString(NLS_GENERAL_ERROR_UNKNOWN_SERVICE);
            message = NLS.bind((String)template, (Object)statusCode, (Object[])new Object[]{decodedStatusText});
        } else {
            template = Messages.getServerString(NLS_GENERAL_ERROR);
            message = NLS.bind((String)template, (Object)service.toString(), (Object[])new Object[]{statusCode, decodedStatusText});
        }
        TeamServiceException exp = new TeamServiceException(message, statusCode);
        exp.setRequestUri(this.getAppropriateRequestURL(context));
        exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)clientContext));
        if (decodeExceptions) {
            if (service == null) {
                RemoteTeamServer.appendReadException(exp, context);
            } else {
                this.appendNestedException(exp, context);
            }
        }
        if ((cause = exp.getCause()) instanceof VersionMismatchException) {
            exp = new VersionMismatchException(cause.getMessage(), (Throwable)exp, statusCode);
        }
        throw exp;
    }

    private static void appendReadException(TeamServiceException exp, HttpContext context) {
        Throwable cause;
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpResponse response = clientContext.getResponse();
        org.apache.http.Header responseHeader = response.getFirstHeader(CONTENT_TYPE_HEADER);
        String encoding = HttpUtil.CharsetEncoding.ISO8859.toString();
        if (responseHeader != null) {
            HeaderElement[] elements = responseHeader.getElements();
            if (elements.length != 1) {
                return;
            }
            String type = elements[0].getName();
            if (!HttpUtil.MediaType.JSON.toString().equals(type)) {
                return;
            }
            NameValuePair nvp = elements[0].getParameterByName("charset");
            if (nvp != null) {
                encoding = nvp.getValue();
            }
        }
        HttpEntity entity = null;
        try {
            entity = response.getEntity();
            if (entity == null) {
                return;
            }
            byte[] body = EntityUtils.toByteArray((HttpEntity)entity);
            response.setEntity((HttpEntity)new ByteArrayEntity(body));
            Charset charset = Charset.forName(encoding);
            ByteArrayInputStream stream = new ByteArrayInputStream(body);
            InputStreamReader r = new InputStreamReader((InputStream)stream, charset);
            IDeserializer2 deserializer = IDeserializer2.FACTORY.newInstance(HttpUtil.MediaType.JSON, null);
            cause = deserializer.deserializeException((Reader)r, RemoteTeamServer.class.getClassLoader(), null);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (SerializeException serializeException) {
            return;
        }
        Throwable walker = exp;
        while (walker.getCause() != null) {
            walker = walker.getCause();
        }
        walker.initCause(cause);
    }

    private void appendNestedException(TeamServiceException exception, HttpContext context) {
        WebServicesMarshaller webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        try {
            Throwable throwable;
            Fault fault;
            Envelope envelope = RemoteTeamServer.demarshallEnvelope(webServicesMarshaller, context);
            Body body = envelope.getBody();
            if (body != null && (fault = body.getFault()) != null && (throwable = this.constructExceptionFromFault(fault, context)) != null) {
                exception.initCause(throwable);
                exception.setFromServer(true);
            }
        }
        catch (Throwable e) {
            _logger.debug("Exception thrown during the marshalling of appendNestedException: %s", e.getMessage());
        }
    }

    private Throwable constructExceptionFromFault(Fault fault, HttpContext context) {
        RemoteTeamService service = (RemoteTeamService)((Object)context.getAttribute(SERVICE_CONTEXT));
        Throwable result = MarshallerUtil.decodeFault((Fault)fault, (ClassLoader)service.getServiceClassLoader());
        return result;
    }

    private static Envelope demarshallEnvelope(WebServicesMarshaller webServicesMarshaller, HttpContext context) throws IOException, MarshallingException {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpResponse response = clientContext.getResponse();
        HttpRequest request = clientContext.getRequest();
        org.apache.http.Header[] headers = response.getHeaders("Content-Encoding");
        if (headers == null) {
            headers = new org.apache.http.Header[]{};
        }
        boolean gzipped = false;
        int i = 0;
        while (i < headers.length) {
            if (headers[i].getValue().equalsIgnoreCase("gzip")) {
                gzipped = true;
            }
            ++i;
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            String message = NLS.bind((String)Messages.getServerString("ClientHttpUtil.EmptyResponse"), (Object)request.getRequestLine(), (Object[])new Object[0]);
            throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, message);
        }
        byte[] content = EntityUtils.toByteArray((HttpEntity)entity);
        response.setEntity((HttpEntity)new ByteArrayEntity(content));
        InputStream responseStream = new ByteArrayInputStream(content);
        if (gzipped) {
            responseStream = new GZIPInputStream(responseStream, 8192);
        }
        return (Envelope)webServicesMarshaller.demarshalInputStreamToObject(responseStream);
    }

    private static boolean isResponseFromProxyTarget(HttpRequest request) {
        org.apache.http.Header proxyHeader = request.getFirstHeader(VIA_PROXY_HEADER);
        boolean retVal = proxyHeader != null && Boolean.parseBoolean(proxyHeader.getValue());
        _logger.debug("isResponseFromProxyTarget - return = %s", retVal);
        return retVal;
    }

    protected static boolean hasAuthRequiredHeader(HttpResponse response) {
        org.apache.http.Header formAuthMsg = response.getFirstHeader(FORM_AUTH_HEADER);
        boolean retval = formAuthMsg != null && formAuthMsg.getValue().equals(FORM_AUTH_REQUIRED_MSG);
        return retval;
    }

    private void formBasedAuthenticate(String repoPath, HttpHost targetHost, CloseableHttpClient httpClient, UsernamePasswordCredentials storedCredentials, HttpClientContext context) throws AuthenticationException {
        _logger.debug("Entering formBasedAuthenticate", new Object[0]);
        if (!repoPath.endsWith(SLASH)) {
            repoPath = String.valueOf(repoPath) + SLASH;
        }
        String formAuthURI = String.valueOf(repoPath) + FORM_AUTH_URI;
        _logger.debug("formAuthURI: %s", formAuthURI);
        HttpPost postMethod = new HttpPost(formAuthURI);
        if (storedCredentials == null) {
            storedCredentials = new UsernamePasswordCredentials(EMPTY_STRING, EMPTY_STRING);
        }
        ArrayList<BasicNameValuePair> parms = new ArrayList<BasicNameValuePair>();
        parms.add(new BasicNameValuePair(FORM_AUTH_USER_FIELD, storedCredentials.getUserName() != null ? storedCredentials.getUserName() : EMPTY_STRING));
        parms.add(new BasicNameValuePair(FORM_AUTH_PASSWORD_FIELD, storedCredentials.getPassword() != null ? storedCredentials.getPassword() : EMPTY_STRING));
        CloseableHttpResponse response = null;
        try {
            try {
                int rc;
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parms, Consts.UTF_8);
                postMethod.setEntity((HttpEntity)entity);
                RequestConfig oldConfig = context.getRequestConfig();
                RequestConfig newConfig = this.getRequestConfigBuilder().setRedirectsEnabled(false).build();
                context.setRequestConfig(newConfig);
                try {
                    RemoteTeamServer.debug("CONTEXT PRIOR TO EXECUTION: ", context);
                    response = httpClient.execute(targetHost, (HttpRequest)postMethod, (HttpContext)context);
                    RemoteTeamServer.debug("CONTEXT AFTER EXECUTION: ", context);
                    rc = response.getStatusLine().getStatusCode();
                    _logger.debug("statusCode: %d", rc);
                }
                finally {
                    context.setRequestConfig(oldConfig);
                }
                org.apache.http.Header authHeader = response.getFirstHeader(FORM_AUTH_HEADER);
                if (authHeader != null) {
                    if (authHeader.getValue().equals(FORM_AUTH_REQUIRED_MSG)) {
                        throw new AuthenticationException(MessageFormat.format(Messages.getClientString(NLS_SERVER_CONFIG_ERROR), FORM_AUTH_URI));
                    }
                    if (authHeader.getValue().equals(FORM_AUTH_FAILED_MSG)) {
                        InvalidUserCredentialsException exp = new InvalidUserCredentialsException(Messages.getClientString(NLS_INVALID_CREDENTIALS));
                        exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)context));
                        exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)context));
                        throw exp;
                    }
                    throw new AuthenticationException(MessageFormat.format(Messages.getClientString(NLS_SERVLET_ERROR), FORM_AUTH_REQUIRED_MSG, FORM_AUTH_FAILED_MSG, authHeader.getValue()));
                }
                if (rc == 302) {
                    String redirectURI = response.getFirstHeader(LOCATION).getValue();
                    if (redirectURI.matches("^.*/auth/authfailed.*$")) {
                        InvalidUserCredentialsException exp = new InvalidUserCredentialsException(Messages.getClientString(NLS_INVALID_CREDENTIALS));
                        exp.setRequestUri(this.getAppropriateRequestURL((HttpContext)context));
                        exp.addHeaders(RemoteTeamServer.getHttp3ResponseHeaders((HttpContext)context));
                        throw exp;
                    }
                } else if (rc != 200) {
                    String msg = MessageFormat.format(Messages.getClientString(NLS_UNEXPECTED_STATUS), formAuthURI, 302, rc);
                    throw new AuthenticationException(msg);
                }
            }
            catch (ClientProtocolException e) {
                String msg = MessageFormat.format(Messages.getClientString(NLS_UNEXPECTED_LOGIN_ERROR), e.getMessage());
                _logger.trace("formBasedAuthenticate - throwing AuthenticationException - %s", msg);
                throw new AuthenticationException(msg, e);
            }
            catch (IOException e) {
                String msg = MessageFormat.format(Messages.getClientString(NLS_UNEXPECTED_LOGIN_ERROR), e.getMessage());
                _logger.trace("formBasedAuthenticate - throwing AuthenticationException - %s", msg);
                throw new AuthenticationException(msg, e);
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                HttpClientUtils.closeQuietly(response);
            }
            throw throwable;
        }
        if (response != null) {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
    }

    public static int visitAuthenticatedURL(String repoPath, HttpHost targetHost, CloseableHttpClient httpClient, HttpContext context) throws TransportAuthException {
        _logger.debug("Entering visitAuthenticatedUrl: repoPath=%s; targetHost=%s", repoPath, targetHost);
        if (!repoPath.endsWith(SLASH)) {
            repoPath = String.valueOf(repoPath) + SLASH;
        }
        HttpGet authenticatedURL = new HttpGet(String.valueOf(repoPath) + "authenticated/identity");
        _logger.debug("Path: %s", authenticatedURL.getURI().getPath());
        CloseableHttpResponse response = null;
        int statusCode = 0;
        try {
            try {
                response = httpClient.execute(targetHost, (HttpRequest)authenticatedURL, context);
                statusCode = response.getStatusLine().getStatusCode();
            }
            catch (Exception e) {
                String msg = MessageFormat.format(Messages.getClientString(NLS_UNEXPECTED_LOGIN_ERROR), e.getMessage());
                _logger.trace("visitAuthenticatedURL - throwning TransportAuthException: %s", msg);
                throw new TransportAuthException(msg, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                HttpClientUtils.closeQuietly(response);
            }
            throw throwable;
        }
        if (response != null) {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
        _logger.debug("HTTP status code after touching \"%s\": %d", authenticatedURL.getURI().getPath(), statusCode);
        return statusCode;
    }

    protected static boolean credDefined(UsernamePasswordCredentials storedCredentials) {
        String storedUsername = null;
        String storedPassword = null;
        if (storedCredentials != null) {
            storedUsername = storedCredentials.getUserName();
            storedPassword = storedCredentials.getPassword();
        }
        boolean retval = !RemoteTeamServer.isBlank(storedUsername) && !RemoteTeamServer.isBlank(storedPassword);
        return retval;
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static class AuthRedirectStrategy
    extends DefaultRedirectStrategy {
        private static String[] METHODS = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT"};

        private AuthRedirectStrategy() {
        }

        protected boolean isRedirectable(String method) {
            _logger.debug("Entering isRedirectable: %s", method);
            String[] stringArray = METHODS;
            int n = METHODS.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equalsIgnoreCase(method)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            int statusCode = response.getStatusLine().getStatusCode();
            String method = request.getRequestLine().getMethod();
            org.apache.http.Header locationHeader = response.getFirstHeader("location");
            _logger.debug("Entering isRedirected: statusCode=%d; method=%s; locationHeader=%s", statusCode, method, locationHeader);
            switch (statusCode) {
                case 302: {
                    URI redirectTarget;
                    HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                    if (targetHost != null && "http".equalsIgnoreCase(targetHost.getSchemeName()) && locationHeader != null && "https".equalsIgnoreCase((redirectTarget = URI.create(locationHeader.getValue())).getScheme())) {
                        return false;
                    }
                    return this.isRedirectable(method) && locationHeader != null;
                }
                case 307: {
                    return this.isRedirectable(method);
                }
                case 303: {
                    return true;
                }
            }
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            org.apache.http.Header[] originalHeaders = request instanceof HttpRequestWrapper ? ((HttpRequestWrapper)request).getOriginal().getAllHeaders() : request.getAllHeaders();
            HttpUriRequest redirectRequest = super.getRedirect(request, response, context);
            redirectRequest.setHeaders(originalHeaders);
            org.apache.http.Header serviceVersionHeader = redirectRequest.getFirstHeader("X-com-ibm-team-service-version");
            if (serviceVersionHeader != null) {
                redirectRequest.removeHeader(serviceVersionHeader);
            }
            return redirectRequest;
        }
    }

    public static enum AuthenticationType {
        USERIDPASSWD,
        KERBEROSSPNEGO,
        CLIENTCERTS;

    }

    public static enum ChallengeType {
        SPNEGO,
        BEARER,
        BASIC,
        NA;

    }

    private static class StringAdaptor {
        org.apache.http.Header[] _headers;

        public StringAdaptor(org.apache.http.Header[] headers) {
            this._headers = headers;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            org.apache.http.Header[] headerArray = this._headers;
            int n = this._headers.length;
            int n2 = 0;
            while (n2 < n) {
                org.apache.http.Header header = headerArray[n2];
                builder.append(header);
                builder.append('\n');
                ++n2;
            }
            return builder.toString();
        }
    }
}

