/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.client;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternPathFilter {
    private static int MATCH_ALL = 0;
    private static int MATCH_CURRENT = 1;
    private static int MATCH_EXACT = 2;
    private static int DIRECTORY = 3;
    private final PatternNodeListList includes = new PatternNodeListList();
    private final PatternNodeListList excludes = new PatternNodeListList();

    public PatternPathFilter(String[] includePatterns, String[] excludePatterns) {
        if (includePatterns != null) {
            for (String includePattern : includePatterns) {
                this.includes.add(new PatternNodeList(includePattern));
            }
        }
        if (excludePatterns != null) {
            for (String excludePattern : excludePatterns) {
                this.excludes.add(new PatternNodeList(excludePattern));
            }
        }
    }

    public PatternPathFilter(List<String> includePatterns, List<String> excludePatterns) {
        if (includePatterns != null) {
            for (String includePattern : includePatterns) {
                this.includes.add(new PatternNodeList(includePattern));
            }
        }
        if (excludePatterns != null) {
            for (String excludePattern : excludePatterns) {
                this.excludes.add(new PatternNodeList(excludePattern));
            }
        }
    }

    public boolean includes(String path) {
        path = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        String pattern = null;
        pattern = File.separatorChar == '\\' ? "(\\\\)\\\\+" : "(/)/+";
        path = path.toString().replaceAll(pattern, "$1");
        boolean included = true;
        if (!this.includes.isEmpty()) {
            included = this.includes.match(path);
        }
        if (included && !this.excludes.isEmpty()) {
            included = !this.excludes.match(path);
        }
        return included;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatternNodeListList
    extends ArrayList<PatternNodeList> {
        private static final long serialVersionUID = 1L;

        private PatternNodeListList() {
        }

        private boolean match(String path) {
            for (PatternNodeList include : this) {
                try {
                    if (!include.match(path)) continue;
                    return true;
                }
                catch (Exception e) {
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatternNodeList
    extends ArrayList<PatternNode> {
        private static final long serialVersionUID = 1L;

        private PatternNodeList(String pattern) {
            pattern = pattern.replace('\\', File.separatorChar);
            pattern = pattern.replace('/', File.separatorChar);
            StringTokenizer tokenizer = new StringTokenizer(pattern, File.separator, true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("**")) {
                    this.add(new PatternNode(null, MATCH_ALL));
                    continue;
                }
                if (token.indexOf("*") >= 0) {
                    StringTokenizer subtokenizer = new StringTokenizer(token, "*", true);
                    while (subtokenizer.hasMoreTokens()) {
                        String subtoken = subtokenizer.nextToken();
                        if (subtoken.equals("*")) {
                            this.add(new PatternNode(null, MATCH_CURRENT));
                            continue;
                        }
                        this.add(new PatternNode(subtoken, MATCH_EXACT));
                    }
                    continue;
                }
                if (token.equals(File.separator)) {
                    this.add(new PatternNode(token, DIRECTORY));
                    continue;
                }
                this.add(new PatternNode(token, MATCH_EXACT));
            }
        }

        private boolean match(String name) throws Exception {
            return this.match(name, 0, 0);
        }

        private boolean match(String name, int nameIndex, int nodeIndex) throws Exception {
            PatternNode currentNode = (PatternNode)this.get(nodeIndex);
            if (currentNode.getType() == MATCH_ALL) {
                PatternNode nextNode;
                if ((nextNode = (PatternNode)this.get(++nodeIndex)) == null || nextNode.getType() != DIRECTORY) {
                    throw new Exception("Matching statement not formatted correctly.");
                }
                boolean test = this.match(name, nameIndex, ++nodeIndex);
                while (!test && name.indexOf(nextNode.getMatch(), nameIndex) >= 0) {
                    nameIndex = name.indexOf(nextNode.getMatch(), nameIndex) + nextNode.getMatch().length();
                    test = this.match(name, nameIndex, nodeIndex);
                }
                return test;
            }
            if (currentNode.getType() == MATCH_CURRENT) {
                PatternNode nextNode;
                if (nodeIndex == this.size() - 1) {
                    return name.indexOf(File.separator, nameIndex) < 0 && name.length() > nameIndex;
                }
                ++nameIndex;
                if ((nextNode = (PatternNode)this.get(++nodeIndex)).getType() == DIRECTORY) {
                    nameIndex = name.indexOf(nextNode.getMatch(), nameIndex);
                    if (nameIndex > 0) {
                        return this.match(name, nameIndex, nodeIndex);
                    }
                    return false;
                }
                if (nextNode.getType() == MATCH_EXACT) {
                    int limitIndex = name.indexOf(File.separator, nameIndex);
                    if (limitIndex < 0) {
                        limitIndex = name.length();
                    }
                    if ((nameIndex = name.indexOf(nextNode.getMatch(), nameIndex)) > 0 && nameIndex < limitIndex) {
                        boolean test = this.match(name, nameIndex, nodeIndex);
                        while (!test && name.indexOf(nextNode.getMatch(), ++nameIndex) >= 0 && name.indexOf(nextNode.getMatch(), nameIndex) < limitIndex) {
                            nameIndex = name.indexOf(nextNode.getMatch(), nameIndex);
                            test = this.match(name, nameIndex, nodeIndex);
                        }
                        return test;
                    }
                    return false;
                }
                throw new Exception("Matching statement not formatted correctly.");
            }
            if (currentNode.getType() == DIRECTORY) {
                if (name.substring(nameIndex++, nameIndex).equals(currentNode.getMatch())) {
                    return this.match(name, nameIndex, ++nodeIndex);
                }
                return false;
            }
            if (name.length() < nameIndex + currentNode.getMatch().length()) {
                return false;
            }
            if (name.substring(nameIndex, nameIndex + currentNode.getMatch().length()).equals(currentNode.getMatch())) {
                if (nodeIndex == this.size() - 1) {
                    return nameIndex + currentNode.getMatch().length() == name.length();
                }
                return this.match(name, nameIndex + currentNode.getMatch().length(), ++nodeIndex);
            }
            return false;
        }
    }

    private static class PatternNode {
        private String match;
        private int type;

        private PatternNode(String match, int type) {
            this.match = match;
            this.type = type;
        }

        private String getMatch() {
            return this.match;
        }

        private int getType() {
            return this.type;
        }
    }
}

