/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class EncodingConvertingInputStream
extends InputStream {
    private Reader reader;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    private CharsetEncoder encoder;

    public EncodingConvertingInputStream(InputStream input, String inputEncoding, String outputEncoding) {
        CharsetDecoder decoder = Charset.forName(inputEncoding).newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.reader = new InputStreamReader(input, decoder);
        this.encoder = Charset.forName(outputEncoding).newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPORT);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.charBuffer = CharBuffer.allocate(1000);
        this.charBuffer.limit(0);
        this.byteBuffer = ByteBuffer.allocate(1000);
        this.byteBuffer.limit(0);
    }

    private int ensureByteNonEmpty() throws IOException {
        int remaining = this.byteBuffer.remaining();
        if (remaining == 0) {
            if (this.charBuffer.remaining() == 0) {
                this.charBuffer.limit(this.charBuffer.capacity());
                this.charBuffer.rewind();
                int count = this.reader.read(this.charBuffer);
                if (count == -1) {
                    CoderResult result = this.encoder.encode(this.charBuffer, this.byteBuffer, true);
                    if (result.isError()) {
                        result.throwException();
                    } else if (this.byteBuffer.remaining() == 0) {
                        return -1;
                    }
                }
                this.charBuffer.limit(count);
                this.charBuffer.rewind();
            }
            this.byteBuffer.rewind();
            this.byteBuffer.limit(this.byteBuffer.capacity());
            CoderResult result = this.encoder.encode(this.charBuffer, this.byteBuffer, false);
            this.byteBuffer.limit(this.byteBuffer.position());
            this.byteBuffer.rewind();
            if (result.isError()) {
                result.throwException();
                return -1;
            }
            return this.byteBuffer.remaining();
        }
        return remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        EncodingConvertingInputStream encodingConvertingInputStream = this;
        synchronized (encodingConvertingInputStream) {
            block4: {
                if (this.ensureByteNonEmpty() != -1) break block4;
                return -1;
            }
            return this.byteBuffer.get() & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b) throws IOException {
        EncodingConvertingInputStream encodingConvertingInputStream = this;
        synchronized (encodingConvertingInputStream) {
            int remaining;
            block4: {
                remaining = this.ensureByteNonEmpty();
                if (remaining != -1) break block4;
                return -1;
            }
            int length = Math.min(b.length, remaining);
            this.byteBuffer.get(b, 0, length);
            int newRemaining = this.byteBuffer.remaining();
            return remaining - newRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        EncodingConvertingInputStream encodingConvertingInputStream = this;
        synchronized (encodingConvertingInputStream) {
            int remaining;
            block4: {
                remaining = this.ensureByteNonEmpty();
                if (remaining != -1) break block4;
                return -1;
            }
            int length = Math.min(len, remaining);
            this.byteBuffer.get(b, off, length);
            int newRemaining = this.byteBuffer.remaining();
            return remaining - newRemaining;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        EncodingConvertingInputStream encodingConvertingInputStream = this;
        synchronized (encodingConvertingInputStream) {
            return this.byteBuffer.remaining();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        super.close();
    }
}

