/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal.login;

import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.login.IAliasChooser;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

public class KeyStoreKeyManager
implements X509KeyManager {
    private static IAliasChooser CLIENT_ALIAS_CHOOSER = null;
    private static final Log LOGGER = LogFactory.getLog(KeyStoreKeyManager.class);
    private KeyStore keyStore = null;
    private char[] password = null;

    public static void setClientAliasChooser(IAliasChooser aliasChooser) {
        if (aliasChooser == null) {
            aliasChooser = KeyStoreKeyManager.createDefaultAliasChooser();
        }
        CLIENT_ALIAS_CHOOSER = aliasChooser;
    }

    private static IAliasChooser createDefaultAliasChooser() {
        return new IAliasChooser(){

            @Override
            public String chooseAlias(List<String> aliases) {
                return aliases.get(0);
            }
        };
    }

    public KeyStoreKeyManager(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.password = password;
    }

    private String chooseClientAlias(List<String> aliases) {
        boolean empty = aliases.isEmpty();
        if (empty) {
            return null;
        }
        return CLIENT_ALIAS_CHOOSER.chooseAlias(aliases);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        List<String> list = this.getAllClientAliases(keyTypes, issuers);
        return this.chooseClientAlias(list);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        System.err.println("chooseServerAlias");
        return null;
    }

    private List<String> getAllClientAliases(String[] keyTypes, Principal[] issuers) {
        ArrayList<String> list = new ArrayList<String>(15);
        String[] stringArray = keyTypes;
        int n = keyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String[] aliases;
            String keyType = stringArray[n2];
            String[] stringArray2 = aliases = this.getClientAliases(keyType, issuers);
            int n3 = aliases.length;
            int n4 = 0;
            while (n4 < n3) {
                String alias = stringArray2[n4];
                boolean exists = list.contains(alias);
                if (!exists) {
                    list.add(alias);
                }
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        Certificate[] certChain;
        block4: {
            certChain = this.keyStore.getCertificateChain(alias);
            if (certChain != null) break block4;
            return null;
        }
        try {
            ArrayList<X509Certificate> certChainList = new ArrayList<X509Certificate>(certChain.length);
            int i = 0;
            while (i < certChain.length) {
                certChainList.add((X509Certificate)certChain[i]);
                ++i;
            }
            return certChainList.toArray(new X509Certificate[0]);
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        Vector<String> temp = new Vector<String>();
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String message;
                String pattern;
                String alias = aliases.nextElement();
                if (!this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
                try {
                    KeyStore.PrivateKeyEntry privKey = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, new KeyStore.PasswordProtection(this.password));
                    X509Certificate cert = (X509Certificate)privKey.getCertificate();
                    if (!keyType.equals(cert.getPublicKey().getAlgorithm())) continue;
                    temp.add(alias);
                }
                catch (UnrecoverableEntryException e) {
                    pattern = Messages.getClientString("KeyStoreKeyManager.FailedToGetClientAlias");
                    message = NLS.bind((String)pattern, (Object)alias);
                    LOGGER.error((Object)message, (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    pattern = Messages.getClientString("KeyStoreKeyManager.NoSuchAlgorithmException");
                    message = NLS.bind((String)pattern, (Object)alias);
                    LOGGER.error((Object)message, (Throwable)e);
                }
            }
        }
        catch (KeyStoreException e) {
            String message = Messages.getClientString("KeyStoreKeyManager.FailedToGetClientAliases");
            LOGGER.error((Object)message, (Throwable)e);
        }
        return temp.toArray(new String[0]);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return (PrivateKey)this.keyStore.getKey(alias, this.password);
        }
        catch (UnrecoverableKeyException e) {
            String pattern = Messages.getClientString("KeyStoreKeyManager.FailToGetPrivateKey");
            String message = NLS.bind((String)pattern, (Object)alias);
            LOGGER.error((Object)message, (Throwable)e);
        }
        catch (KeyStoreException e) {
            String pattern = Messages.getClientString("KeyStoreKeyManager.FailToGetPrivateKey");
            String message = NLS.bind((String)pattern, (Object)alias);
            LOGGER.error((Object)message, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            String pattern = Messages.getClientString("KeyStoreKeyManager.NoSuchAlgorithmException");
            String message = NLS.bind((String)pattern, (Object)alias);
            LOGGER.error((Object)message, (Throwable)e);
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        System.err.println("getServerAliases");
        return null;
    }
}

